/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCNullAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCEndlessLoopFinder;
import com.jetbrains.cidr.lang.dfa.OCEscapedValuesChecker;
import com.jetbrains.cidr.lang.dfa.OCInfiniteRecursionFinder;
import com.jetbrains.cidr.lang.dfa.OCInputOutputVariablesFinder;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotInitializedVarChecker;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppTypeidExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCAddElementIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationButInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSendMessageToObjectIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressGCCAttributeFix;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCMethodReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDataFlowAnalyzer {
    private PsiElement[] myCodeFragments;
    private OCControlFlowGraph myGraph;
    private OCControlFlowBuilder myGraphBuilder;
    private OCUnreachableCodeFinder myUnreachableCodeFinder;
    private OCInfiniteRecursionFinder myInfiniteRecursionFinder;
    private OCEndlessLoopFinder myEndlessLoopFinder;
    private OCDataFlowAnalyzer myParentAnalyzer;
    private List<OCDataFlowAnalyzer> myChildAnalyzers;
    private TextRange mySelection;
    private List<OCSymbol> myInputVariables;
    private List<OCSymbol> myOutputVariables;
    private List<OCSymbol> myWrittenVariables;
    private List<OCSymbol> myEscapedDeclarators;
    private Map<OCSymbol, List<PsiReference>> myVariableUsages;
    @NotNull
    private OCAnnotatorSink mySink;
    private static final Key<CachedValue<Map<OCStructSymbol, Boolean>>> TRIVIAL_DTOR_CACHE = Key.create((String)"TRIVIAL_DTOR_CACHE_IN_FILE");

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @NotNull OCAnnotatorSink annotator, @Nullable OCDataFlowAnalyzer parentAnalyzer) {
        if (codeFragment == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(0);
        }
        if (annotator == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(1);
        }
        this(new PsiElement[]{codeFragment}, annotator, parentAnalyzer, parentAnalyzer != null ? parentAnalyzer.mySelection : null);
        if (parentAnalyzer != null) {
            parentAnalyzer.myChildAnalyzers.add(this);
        }
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement[] codeFragments, @Nullable TextRange selection) {
        if (codeFragments == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(2);
        }
        this(codeFragments, OCNullAnnotatorSink.INSTANCE, null, selection);
    }

    public OCDataFlowAnalyzer(@NotNull PsiElement codeFragment, @Nullable TextRange selection) {
        if (codeFragment == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(3);
        }
        this(new PsiElement[]{codeFragment}, OCNullAnnotatorSink.INSTANCE, null, selection);
    }

    private OCDataFlowAnalyzer(@NotNull PsiElement[] codeFragments, @NotNull OCAnnotatorSink sink, @Nullable OCDataFlowAnalyzer parentAnalyzer, @Nullable TextRange selection) {
        if (codeFragments == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(5);
        }
        this.myChildAnalyzers = new ArrayList<OCDataFlowAnalyzer>();
        this.mySink = sink;
        this.myCodeFragments = codeFragments;
        this.mySelection = selection;
        this.myParentAnalyzer = parentAnalyzer;
        this.myInputVariables = new ArrayList<OCSymbol>();
        this.myOutputVariables = new ArrayList<OCSymbol>();
        this.myWrittenVariables = new ArrayList<OCSymbol>();
        this.myEscapedDeclarators = new ArrayList<OCSymbol>();
        this.myVariableUsages = new HashMap<OCSymbol, List<PsiReference>>();
    }

    @NotNull
    public OCAnnotatorSink getSink() {
        OCAnnotatorSink oCAnnotatorSink = this.mySink;
        if (oCAnnotatorSink == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(6);
        }
        return oCAnnotatorSink;
    }

    @NotNull
    public OCControlFlowGraph getGraph() {
        OCControlFlowGraph oCControlFlowGraph = this.myGraph;
        if (oCControlFlowGraph == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(7);
        }
        return oCControlFlowGraph;
    }

    @Nullable
    public OCControlFlowGraph findGraph(@NotNull PsiElement element) {
        if (element == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(8);
        }
        if (!this.myGraph.getCodeFragment().getTextRange().contains(element.getTextOffset())) {
            return null;
        }
        for (OCDataFlowAnalyzer analyzer : this.myChildAnalyzers) {
            OCControlFlowGraph graph = analyzer.findGraph(element);
            if (graph == null) continue;
            return graph;
        }
        return this.myGraph;
    }

    @NotNull
    public OCUnreachableCodeFinder getUnreachableCodeFinder() {
        OCUnreachableCodeFinder oCUnreachableCodeFinder = this.myUnreachableCodeFinder;
        if (oCUnreachableCodeFinder == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(9);
        }
        return oCUnreachableCodeFinder;
    }

    @NotNull
    public List<OCSymbol> getInputVariables() {
        List<OCSymbol> list = this.myInputVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getOutputVariables() {
        List<OCSymbol> list = this.myOutputVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(11);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getWrittenVariables() {
        List<OCSymbol> list = this.myWrittenVariables;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NotNull
    public List<OCSymbol> getEscapedDeclarators() {
        List<OCSymbol> list = this.myEscapedDeclarators;
        if (list == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void buildControlFlowGraph() {
        this.myGraph = new OCControlFlowGraph(this.myCodeFragments[0], this.myParentAnalyzer != null ? this.myParentAnalyzer.getGraph() : null);
        this.myGraphBuilder = new OCControlFlowBuilder(this, this.myGraph, this.mySelection);
        boolean isFirst = true;
        for (PsiElement codeFragment : this.myCodeFragments) {
            if (isFirst) {
                this.myGraphBuilder.processFirstCodeFragment(codeFragment);
            } else {
                this.myGraphBuilder.processNextCodeFragment(codeFragment);
            }
            isFirst = false;
        }
        this.myUnreachableCodeFinder = new OCUnreachableCodeFinder(this.myGraph);
        this.myInfiniteRecursionFinder = new OCInfiniteRecursionFinder(this.myGraph);
        this.myEndlessLoopFinder = new OCEndlessLoopFinder(this.myGraph);
        this.myUnreachableCodeFinder.process();
        this.myInfiniteRecursionFinder.process();
        this.myEndlessLoopFinder.process();
    }

    public void analyze() {
        Annotation annotation;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        PsiElement context = firstCodeFragment.getContext();
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        List<PsiElement> callableIdentifiers = null;
        if (callable instanceof OCMethod) {
            callableIdentifiers = ((OCMethod)callable).getSelectors();
        } else if (callable instanceof OCFunctionDefinition) {
            callableIdentifiers = Collections.singletonList(((OCFunctionDefinition)callable).getNameIdentifier());
        }
        if (callable != null && !callable.getReturnType().resolve(callable).isVoid() && this.myUnreachableCodeFinder.isDeadEndReached()) {
            OCBlockStatement body = callable.getBody();
            boolean isConstructor = false;
            if (body == null) {
                return;
            }
            OCSymbol oCSymbol = callable.getSymbol();
            if (callable.getContainingOCFile().isCpp() && callable instanceof OCFunctionDefinition && oCSymbol != null && oCSymbol.getKind().isConstructorOrDestructor()) {
                isConstructor = true;
            }
            if (oCSymbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)oCSymbol).isMainFunction()) {
                return;
            }
            if (!isConstructor) {
                annotation = null;
                String message = "Control reaches end of non-void " + callable.getKind().toStringLowercase();
                if (callable instanceof OCBlockExpression) {
                    annotation = this.mySink.addErrorAnnotation(body.getClosingBrace(), "err_maybe_falloff_nonvoid_block", message);
                } else {
                    switch (OCCompilerFeatures.getDiagnosticLevel(body.getContainingOCFile(), OCCompilerFeatures.Diagnostic.MISSING_RETURN_FROM_NON_VOID)) {
                        case ERROR: {
                            annotation = this.mySink.addErrorAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message);
                            break;
                        }
                        case WARNING: {
                            annotation = this.mySink.addWarningAnnotation(body.getClosingBrace(), OCInspections.MissingReturn.class, "warn_falloff_nonvoid_function", message);
                            break;
                        }
                    }
                }
                if (annotation != null) {
                    OCResolveContext resolveContext = OCResolveContext.forPsi(body);
                    OCType type = callable.getReturnType().resolve(resolveContext);
                    this.mySink.registerQuickFix(annotation, new OCAddElementIntentionAction("Add return statement", body, OCElementFactory.statementFromText("return " + type.getDefaultValue(resolveContext) + ";", firstCodeFragment)));
                    OCSymbol callableSymbol = callable.getSymbol();
                    if (callableSymbol != null) {
                        this.mySink.registerQuickFix(annotation, new OCChangeTypeIntentionAction(callableSymbol, (OCType)OCVoidType.instance(), true, (OCCompilationContext)resolveContext));
                    }
                }
            }
        }
        for (OCElementsRange range : this.myEndlessLoopFinder.getEndlessLoops()) {
            this.mySink.addWarningAnnotation((PsiElement)firstCodeFragment.getContainingFile(), range.getTextRange(), OCInspections.EndlessLoop.class, "warn_suggest_noreturn_function", "Endless loop", ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        if (callableIdentifiers != null && !this.myInfiniteRecursionFinder.isExitOrDeadEndReached()) {
            ArrayList<PsiElement> elements = new ArrayList<PsiElement>(callableIdentifiers);
            elements.addAll(this.myInfiniteRecursionFinder.getRecursiveCalls());
            this.mySink.addWarningAnnotations(elements, OCInspections.InfiniteRecursion.class, "CIDR", (Object)((Object)callable.getKind()) + " '" + callable.getName() + "' recurses infinitely");
        }
        boolean arcEnabled = !OCCompilerFeatures.isArcDisabled(firstCodeFragment.getContainingFile());
        for (OCSymbol oCSymbol : this.myGraph.getLocalSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotUsed(oCSymbol, context, firstCodeFragment.getProject());
            this.analyzeInputOutput(oCSymbol);
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            if (arcEnabled) continue;
            this.analyzeNotReleased(oCSymbol, new OCNotReleasedVariablesChecker(this.myGraph, oCSymbol), true);
        }
        for (OCSymbol oCSymbol : this.myGraph.getClosureSymbols()) {
            if (oCSymbol.isUnnamed()) continue;
            this.analyzeNotInitialized(oCSymbol, arcEnabled);
            this.analyzeInputOutput(oCSymbol);
        }
        if (!arcEnabled && firstCodeFragment != null) {
            for (Pair pair2 : OCNotReleasedVariablesChecker.getUnreleasedObjects(firstCodeFragment)) {
                OCCallable method;
                OCSymbol symbol;
                annotation = this.mySink.addWarningAnnotation((PsiElement)pair2.getFirst(), OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                PsiElement object = (PsiElement)pair2.getSecond();
                this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(object, "autorelease"));
                if (!(object.getParent() instanceof OCReturnStatement) || !((symbol = (method = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)object, OCCallable.class)) != null ? method.getSymbol() : null) instanceof OCMethodSymbol)) continue;
                this.mySink.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(symbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true, this.createResolveContext()));
            }
        }
        this.analyzeEscapedValue();
        for (OCDataFlowAnalyzer oCDataFlowAnalyzer : this.myChildAnalyzers) {
            oCDataFlowAnalyzer.analyze();
            this.myInputVariables.addAll(oCDataFlowAnalyzer.getInputVariables());
            this.myOutputVariables.addAll(oCDataFlowAnalyzer.getOutputVariables());
            this.myEscapedDeclarators.addAll(oCDataFlowAnalyzer.getEscapedDeclarators());
            this.myWrittenVariables.addAll(oCDataFlowAnalyzer.getWrittenVariables());
            for (OCSymbol symbol : oCDataFlowAnalyzer.myVariableUsages.keySet()) {
                if (this.myVariableUsages.containsKey(symbol)) continue;
                this.myVariableUsages.put(symbol, oCDataFlowAnalyzer.myVariableUsages.get(symbol));
            }
        }
        if (this.mySelection != null) {
            Comparator<OCSymbol> comparator = Comparator.comparingInt(OCSymbol::getOffset);
            Collections.sort(this.myInputVariables, comparator);
            Collections.sort(this.myOutputVariables, comparator);
            Collections.sort(this.myWrittenVariables, comparator);
            Collections.sort(this.myEscapedDeclarators, comparator);
        }
    }

    private void analyzeNotInitialized(@NotNull OCSymbol symbol, boolean arcEnabled) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(14);
        }
        if (symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            return;
        }
        OCResolveContext context = this.createResolveContext();
        OCType resolvedType = symbol.getResolvedType(context);
        if (context.isCpp() && (resolvedType instanceof OCMagicType || resolvedType instanceof OCStructType && ((OCStructType)resolvedType).getSymbol().hasMemberFunctions())) {
            return;
        }
        if (resolvedType instanceof OCStructType) {
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            for (OCStructSymbol struct : ((OCStructType)resolvedType).getStructs()) {
                if (!struct.processConstructors((Processor<? super OCFunctionSymbol>)finder, context)) break;
                if (!((OCStructType)resolvedType).isEmpty(context)) continue;
                return;
            }
            if (finder.isFound()) {
                return;
            }
        }
        if (arcEnabled && resolvedType.isPointerToObjectCompatible()) {
            return;
        }
        if (symbol instanceof OCDeclaratorSymbol) {
            if (symbol.getType() instanceof OCStructuredBindingType) {
                return;
            }
            if (((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
                return;
            }
        }
        OCNotInitializedVarChecker notInitializedChecker = new OCNotInitializedVarChecker(this.myGraph, symbol);
        notInitializedChecker.process();
        for (PsiElement read2 : notInitializedChecker.getNotInitializedReads()) {
            OCDeclarator declarator;
            if (OCDataFlowAnalyzer.isComplicatedCppInstruction(read2) || OCDataFlowAnalyzer.isStaticallyEvaluated(read2)) continue;
            Annotation annotation = this.addWarningAnnotation(read2, symbol, OCInspections.NotInitializedVariable.class, "warn_uninit_var", symbol.getNameWithKindUppercase(OCCompilationContext.create(read2)) + " might not have been initialized");
            OCInstruction declInstruction = this.myGraph.getDeclaratorInstruction(symbol);
            if (declInstruction == null) {
                declInstruction = this.myGraph.getClosureVariableDeclaratorGraph(symbol).getDeclaratorInstruction(symbol);
            }
            if ((declarator = (OCDeclarator)declInstruction.getRValue()) == null) continue;
            this.mySink.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, symbol));
        }
    }

    @NotNull
    private OCResolveContext createResolveContext() {
        OCResolveContext oCResolveContext = OCResolveContext.forPsi(this.myCodeFragments[0]);
        if (oCResolveContext == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(15);
        }
        return oCResolveContext;
    }

    private static boolean isStaticallyEvaluated(@NotNull PsiElement element) {
        if (element == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(16);
        }
        for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof OCSizeofExpression || parent instanceof OCCppTypeidExpression || parent instanceof OCGenericSelectionExpression) {
                return true;
            }
            if (parent instanceof OCCppNamespaceQualifier && OCDataFlowAnalyzer.hasAnyChildOfType(parent, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) {
                return true;
            }
            if (!(parent instanceof OCTypeElement) || !OCDataFlowAnalyzer.hasAnyChildOfType(parent, OCTokenTypes.TYPEOF_KEYWORD, OCTokenTypes.DECLTYPE_CPP_KEYWORD)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasAnyChildOfType(PsiElement parent, IElementType ... types) {
        return Arrays.stream(parent.getNode().getChildren(null)).map(OCElementUtil::getElementType).anyMatch(elementType -> {
            for (IElementType type : types) {
                if (type != elementType) continue;
                return true;
            }
            return false;
        });
    }

    private static boolean isComplicatedCppInstruction(@NotNull PsiElement read2) {
        OCResolveContext context;
        if (read2 == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(17);
        }
        if ((context = OCResolveContext.forPsi(read2)).isCpp() && read2.getParent() instanceof OCQualifiedExpression) {
            PsiElement parent = read2.getParent();
            while (parent instanceof OCQualifiedExpression) {
                OCQualifiedExpression expr = (OCQualifiedExpression)parent;
                if (expr.getResolvedType() instanceof OCMagicType) {
                    return true;
                }
                parent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{OCParenthesizedExpression.class});
            }
        }
        return false;
    }

    private void analyzeNotUsed(@NotNull OCSymbol symbol, @Nullable PsiElement context, @NotNull Project project2) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(18);
        }
        if (project2 == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(19);
        }
        if (this.hasReferenceType(symbol) || project2.getUserData(OCFile.DFA_UNUSED_CHECKS) == OCFile.UnusedChecksMode.DISABLED) {
            return;
        }
        OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(this.myGraph, symbol);
        notUsedChecker.process();
        for (PsiElement write2 : notUsedChecker.getNotUsedWrites()) {
            String text;
            if (OCElementUtil.isPartOfMacroSubstitution(write2.getParent()) || write2.getParent() instanceof OCDeclarator && (!notUsedChecker.isSymbolUsed() || "0".equals(text = OCElementUtil.getTextWithMacros(write2 = ((OCDeclarator)write2.getParent()).getInitializer())) || OCCodeInsightUtil.isLikeNull(text)) || write2 == null) continue;
            Annotation annotation = this.addWarningAnnotation(write2, symbol, OCInspections.UnusedValue.class, "CIDR", "The value is never used", ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            PsiElement element = write2.getContext();
            if (element instanceof OCDeclarator) {
                this.mySink.registerQuickFix(annotation, new OCRemoveInitializerIntentionAction((OCDeclarator)element));
                continue;
            }
            this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction("statement", element, project2));
            this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction("statement", element, project2));
        }
        if (!notUsedChecker.isSymbolUsed() && this.enableUnusedCheck(symbol, context)) {
            String clangID;
            Class inspectionClass;
            String messageSuffix = notUsedChecker.isSymbolAssigned() ? " is only assigned but never accessed" : " is never used";
            PsiElement declaratorElement = this.myGraph.getDeclaratorInstruction(symbol).getRValue();
            if (PsiTreeUtil.getParentOfType((PsiElement)declaratorElement, OCTypeElement.class) != null) {
                return;
            }
            if (declaratorElement instanceof OCDeclarator) {
                declaratorElement = ((OCDeclarator)declaratorElement).getNameIdentifier();
            }
            if (symbol.getKind() == OCSymbolKind.PARAMETER) {
                inspectionClass = OCInspections.UnusedParameter.class;
                clangID = "warn_unused_parameter";
            } else if (symbol.getKind() == OCSymbolKind.LABEL) {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_label";
            } else {
                inspectionClass = OCInspections.UnusedLocalVariable.class;
                clangID = "warn_unused_variable";
            }
            if (declaratorElement != null) {
                Annotation annotation = this.addWarningAnnotation(declaratorElement, symbol, inspectionClass, clangID, symbol.getNameWithKindUppercase(OCCompilationContext.create(declaratorElement)) + messageSuffix, ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, project2));
                this.mySink.registerQuickFix(annotation, new OCRemoveDeclarationButInitializerIntentionAction(symbol, project2));
                this.mySink.registerQuickFix(annotation, (IntentionAction)new OCSuppressGCCAttributeFix(symbol, "unused", "__unused", true, this.createResolveContext()));
            }
        }
    }

    private boolean hasReferenceType(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(20);
        }
        OCType resolvedType = symbol.getType().resolve(this.createResolveContext());
        return resolvedType instanceof OCCppReferenceType;
    }

    private boolean enableUnusedCheck(@NotNull OCSymbol symbol, @Nullable PsiElement context) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(21);
        }
        OCType symbolType = symbol.getType().resolve(this.createResolveContext());
        if (OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(symbol) || OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(symbolType)) {
            return false;
        }
        switch (symbol.getKind()) {
            case PARAMETER: {
                return this.enableUnusedCheckForParameter();
            }
            case LOCAL_VARIABLE: {
                return this.enableUnusedCheckForLocalVariable(symbol);
            }
            case CATCH_EXCEPTION_VARIABLE: {
                return false;
            }
        }
        return true;
    }

    private static boolean specifiedByUsedOrUnusedAttribute(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(22);
        }
        return symbol.hasAttribute("unused") || symbol.hasAttribute("used");
    }

    private static boolean specifiedByUsedOrUnusedAttribute(@NotNull OCType type) {
        if (type == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(23);
        }
        if (type instanceof OCStructType) {
            return OCDataFlowAnalyzer.specifiedByUsedOrUnusedAttribute(((OCStructType)type).getSymbol());
        }
        return false;
    }

    private boolean enableUnusedCheckForParameter() {
        OCSymbol parentSymbol;
        PsiElement firstCodeFragment = this.myCodeFragments[0];
        OCCallable callable = firstCodeFragment instanceof OCCallable ? (OCCallable)firstCodeFragment : null;
        OCSymbol oCSymbol = parentSymbol = callable != null ? callable.getSymbol() : null;
        if (parentSymbol == null || parentSymbol.getKind() == OCSymbolKind.BLOCK || parentSymbol.getKind() == OCSymbolKind.LAMBDA || parentSymbol.hasAttribute("ibaction")) {
            return false;
        }
        if (parentSymbol instanceof OCFunctionSymbol) {
            return !((OCFunctionSymbol)parentSymbol).isMainFunction();
        }
        if (parentSymbol instanceof OCMethodSymbol) {
            OCMethodSymbol method = (OCMethodSymbol)parentSymbol;
            if (((OCClassSymbol)method.getParent()).getKind() != OCSymbolKind.IMPLEMENTATION) {
                return false;
            }
            Project project2 = firstCodeFragment.getProject();
            OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method, project2);
            searchParameters.setAncestors(true);
            if (OCMemberInheritorsSearch.search(searchParameters).findFirst() != null) {
                return false;
            }
            OCMethodSymbol associatedSymbol = method.getAssociatedSymbol(project2);
            if (associatedSymbol != null) {
                method = associatedSymbol;
            }
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(project2);
            Object methodDefinition = method.locateDefinition(project2);
            if (methodDefinition == null) {
                return false;
            }
            ReferencesSearch.SearchParameters parameters = new ReferencesSearch.SearchParameters(methodDefinition, (SearchScope)scope, false);
            return new OCMethodReferencesSearch().execute(parameters, (Processor<PsiReference>)((Processor)psiReference -> !(psiReference.getElement() instanceof OCSelectorExpression) && !(psiReference instanceof OCExternalReference)));
        }
        return false;
    }

    private boolean enableUnusedCheckForLocalVariable(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(24);
        }
        if (!(symbol instanceof OCDeclaratorSymbol)) {
            return true;
        }
        OCDeclaratorSymbol declaratorSymbol = (OCDeclaratorSymbol)symbol;
        OCType declaratorType = declaratorSymbol.getType().resolve(this.createResolveContext());
        if (declaratorType instanceof OCStructType) {
            OCStructSymbol structSymbol = ((OCStructType)declaratorType).getSymbol();
            return this.hasTrivialDestructor(structSymbol);
        }
        return !(declaratorType instanceof OCMagicType);
    }

    private boolean hasTrivialDestructor(@NotNull OCStructSymbol symbol) {
        OCResolveContext context;
        PsiFile file;
        Map<OCStructSymbol, Boolean> cache;
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(25);
        }
        if ((cache = OCDataFlowAnalyzer.getTrivialDtorCache(file = (context = this.createResolveContext()).getFile())) != null && cache.containsKey(symbol)) {
            return cache.get(symbol);
        }
        Boolean hasTrivialDestructor = symbol.hasTrivialDestructor(context);
        if (cache != null) {
            cache.put(symbol, hasTrivialDestructor);
        }
        return hasTrivialDestructor;
    }

    private static Map<OCStructSymbol, Boolean> getTrivialDtorCache(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        SimpleModificationTracker modificationTracker = FileSymbolTablesCache.getInstance(file.getProject()).getOutOfBlockModificationTracker();
        CachedValueProvider provider2 = () -> new CachedValueProvider.Result(OCTypeUtils.newDeepEqualityMap(), new Object[]{modificationTracker});
        return (Map)manager.getCachedValue((UserDataHolder)file, TRIVIAL_DTOR_CACHE, provider2, false);
    }

    public void analyzeNotReleased(@NotNull OCSymbol symbol, @NotNull OCNotReleasedVariablesChecker checker, boolean processReturns) {
        OCCallable callable;
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(26);
        }
        if (checker == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(27);
        }
        if (processReturns) {
            checker.setStartFromReturns(true);
        }
        if (!symbol.getResolvedType(this.createResolveContext()).isPointerToObjectCompatible() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic()) {
            return;
        }
        checker.process();
        HashSet<PsiElement> notReleasedElements = new HashSet<PsiElement>();
        for (PsiElement element : checker.getNotReleasedElements()) {
            notReleasedElements.add(element);
            Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
            this.mySink.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element, this.myCodeFragments[0].getProject()));
            this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
        }
        if (processReturns && this.myCodeFragments[0] instanceof OCCallable && !OCElementUtil.isRetainMethod(callable = (OCCallable)this.myCodeFragments[0])) {
            checker.setStartFromReturns(false);
            checker.process();
            for (PsiElement element : checker.getNotReleasedElements()) {
                if (notReleasedElements.contains(element)) continue;
                Annotation annotation = this.addWarningAnnotation(element, symbol, OCInspections.NotReleasedValue.class, "CIDR", "Retained value may have not been released");
                this.mySink.registerQuickFix(annotation, new OCReleaseVariablesIntentionAction(symbol, element, callable.getProject()));
                this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "autorelease"));
                OCSymbol callableSymbol = callable.getSymbol();
                if (callableSymbol == null) continue;
                this.mySink.registerQuickFix(annotation, new OCChangeGCCAttributeIntentionAction(callableSymbol, "ns_returns_retained", "NS_RETURNS_RETAINED", true, this.createResolveContext()));
            }
        }
    }

    private void analyzeEscapedValue() {
        OCEscapedValuesChecker checker = new OCEscapedValuesChecker(this.myGraph);
        checker.process();
        for (PsiElement element : checker.getEscapedVariables()) {
            this.mySink.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnStackAddr(), "Local value may escape the method/function");
        }
        for (PsiElement element : checker.getEscapedObjects()) {
            String message = (element instanceof OCBlockExpression ? "Block" : "Value") + " escapes the local scope";
            Annotation annotation = this.mySink.addWarningAnnotation(element, OCInspections.LocalValueEscapesScope.class, OCClangMessageFinder.getInstance().getReturnTempAddr(), message);
            if (!(element instanceof OCBlockExpression)) continue;
            this.mySink.registerQuickFix(annotation, new OCSendMessageToObjectIntentionAction(element, "copy"));
        }
    }

    private void analyzeInputOutput(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(28);
        }
        if (this.mySelection == null) {
            return;
        }
        OCInputOutputVariablesFinder finder = new OCInputOutputVariablesFinder(this.myGraph, symbol, this.mySelection);
        finder.process();
        boolean needUsages = false;
        if (finder.isInputVariable()) {
            this.myInputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isOutputVariable()) {
            this.myOutputVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isWrittenVariable()) {
            this.myWrittenVariables.add(symbol);
            needUsages = true;
        }
        if (finder.isEscapedDeclarator()) {
            this.myEscapedDeclarators.add(symbol);
            needUsages = true;
        }
        if (needUsages) {
            this.myVariableUsages.put(symbol, finder.getVariableUsages());
        }
    }

    public List<PsiReference> getVariableUsages(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(29);
        }
        return this.myVariableUsages.get(symbol);
    }

    public boolean hasCrossSelectionJumps() {
        return this.myGraphBuilder.hasCrossSelectionJumps();
    }

    public boolean hasDanglingJumps() {
        return this.myGraphBuilder.hasDanglingJumps();
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        OCMacroRange macroRange;
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(30);
        }
        if (message == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(31);
        }
        if ((macroRange = OCElementUtil.getRangeInMacroCall(element)) != null && !macroRange.mapsToArguments()) {
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (symbol.getOffset() == macroCall.getTextRange().getEndOffset()) {
                return null;
            }
        }
        return this.mySink.addWarningAnnotation(element, inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation addWarningAnnotation(@Nullable PsiElement element, @NotNull OCSymbol symbol, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        if (symbol == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(32);
        }
        if (message == null) {
            OCDataFlowAnalyzer.$$$reportNull$$$0(33);
        }
        return this.addWarningAnnotation(element, symbol, inspectionClass, clangID, message, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragments";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "read";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAnalyzer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSink";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnreachableCodeFinder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenVariables";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedDeclarators";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findGraph";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "analyzeNotInitialized";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isStaticallyEvaluated";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isComplicatedCppInstruction";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "analyzeNotUsed";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "hasReferenceType";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enableUnusedCheck";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "specifiedByUsedOrUnusedAttribute";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "enableUnusedCheckForLocalVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "hasTrivialDestructor";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "analyzeNotReleased";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "analyzeInputOutput";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getVariableUsages";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addWarningAnnotation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

