/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

class OCEndlessLoopFinder
extends OCDataFlowAlgorithm {
    private Stack<OCNode> myTopologicalOrder;
    private List<OCNode> myComponent;
    private List<OCNode> myEndlessLoops;
    private List<OCNode> myUnreachedNodes;
    private boolean myForwardMode;

    public OCEndlessLoopFinder(@NotNull OCControlFlowGraph cfg) {
        if (cfg == null) {
            OCEndlessLoopFinder.$$$reportNull$$$0(0);
        }
        super(cfg);
        this.myTopologicalOrder = new Stack();
        this.myComponent = new ArrayList<OCNode>();
        this.myEndlessLoops = new ArrayList<OCNode>();
        this.myUnreachedNodes = new ArrayList<OCNode>();
    }

    @Override
    public void process() {
        this.myEndlessLoops.clear();
        this.myTopologicalOrder.clear();
        this.myUnreachedNodes.clear();
        this.clearProcessedNodes();
        this.myForwardMode = true;
        this.traverse(this.myCfg.getStartNode(), null, null, true);
        for (OCNode node : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node, null)) continue;
            this.myUnreachedNodes.add(node);
        }
        this.myForwardMode = false;
        this.clearProcessedNodes();
        while (!this.myTopologicalOrder.isEmpty()) {
            OCNode node = this.myTopologicalOrder.pop();
            if (this.isNodeProcessed(node, null)) continue;
            this.myComponent.clear();
            this.traverse(node, null, null, false);
            if (!this.isEndlessLoop(this.myComponent)) continue;
            this.myEndlessLoops.addAll(this.myComponent);
        }
    }

    private boolean isEndlessLoop(@NotNull List<OCNode> component) {
        if (component == null) {
            OCEndlessLoopFinder.$$$reportNull$$$0(1);
        }
        boolean wasJump = false;
        for (OCNode node : component) {
            if (this.myUnreachedNodes.contains(node) || node.getJumpTargets() == null) continue;
            wasJump = true;
            for (OCNode target : node.getJumpTargets()) {
                if (this.myUnreachedNodes.contains(target) || this.isNodeProcessed(target, null)) continue;
                return false;
            }
        }
        return wasJump;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node) {
        if (node == null) {
            OCEndlessLoopFinder.$$$reportNull$$$0(2);
        }
        if (this.myForwardMode) {
            this.myTopologicalOrder.push(node);
        } else {
            this.myComponent.add(node);
        }
    }

    @NotNull
    public List<OCElementsRange> getEndlessLoops() {
        List<OCElementsRange> list = OCEndlessLoopFinder.getRanges(this.myEndlessLoops, true);
        if (list == null) {
            OCEndlessLoopFinder.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCEndlessLoopFinder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEndlessLoops";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEndlessLoop";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "nodeProcessed";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

