/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCMultiSymbolAlgorithm;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCEscapedValuesChecker
extends OCMultiSymbolAlgorithm {
    OCEscapedValuesChecker(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    protected boolean processClosureSymbols() {
        return false;
    }

    @NotNull
    public List<PsiElement> getEscapedVariables() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Pair<OCSymbol, PsiElement> pair2 : this.getReachableElements()) {
            result.add((PsiElement)pair2.getSecond());
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    protected boolean isGoodWrite(@Nullable PsiElement element) {
        if ((element = OCParenthesesUtils.diveIntoParenthesesAndCasts(element)) instanceof OCUnaryExpression) {
            OCUnaryExpression unaryExpr = (OCUnaryExpression)element;
            if (unaryExpr.isGetAddress()) {
                return OCEscapedValuesChecker.isLocalVar(unaryExpr.getOperand());
            }
        } else if (element instanceof OCBlockExpression) {
            return !OCCompilerFeatures.isArcEnabled(element.getContainingFile());
        }
        return false;
    }

    private static boolean isLocalVar(OCExpression operand) {
        if (operand != null) {
            while (operand instanceof OCQualifiedExpression && ((OCQualifiedExpression)operand).getQualifyingTokenKind() == OCTokenTypes.DOT) {
                operand = ((OCQualifiedExpression)operand).getQualifier();
            }
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
            operand.accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (!(symbol == null || visitor.getNumOfDereferences() != 0 || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isFriendOrStatic())) {
                if (symbol.getType() instanceof OCCppReferenceType) {
                    Object declarator = symbol.locateDefinition(operand.getProject());
                    return OCEscapedValuesChecker.isLocalVar(declarator instanceof OCDeclarator ? ((OCDeclarator)declarator).getInitializer() : null);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean treatReferencesAsStartInstructions() {
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(1);
        }
        return super.isEndInstruction(instruction) && OCEscapedValuesChecker.isEscaped(instruction.getRValue(), null);
    }

    @NotNull
    public List<PsiElement> getEscapedObjects() {
        final ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        final PsiElement codeFragment = this.myCfg.getCodeFragment();
        codeFragment.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitBlockExpression(OCBlockExpression blockExpression) {
                PsiElement blockScope;
                if (blockExpression != codeFragment && OCEscapedValuesChecker.this.isGoodWrite(blockExpression) && (blockScope = (PsiElement)ContainerUtil.getFirstItem((List)((List)OCCodeInsightUtil.getScopeAndKind(blockExpression).getFirst()))) != null && OCEscapedValuesChecker.isEscaped(blockExpression, OCSymbolOffsetUtil.getComplexRange(blockScope))) {
                    result.add(blockExpression);
                }
            }

            @Override
            public void visitReferenceExpression(OCReferenceExpression expression) {
                OCSymbol symbol = expression.resolveToSymbol();
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && symbol.getResolvedType(OCResolveContext.forPsi(expression)) instanceof OCArrayType && !((OCDeclaratorSymbol)symbol).isFriendOrStatic() && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }

            @Override
            public void visitUnaryExpression(OCUnaryExpression expression) {
                super.visitUnaryExpression(expression);
                if (OCEscapedValuesChecker.this.isGoodWrite(expression) && OCEscapedValuesChecker.isEscaped(expression, null)) {
                    result.add(expression);
                }
            }
        });
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            OCEscapedValuesChecker.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isEscaped(@Nullable PsiElement element, @Nullable ComplexTextRange scope) {
        OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCCallExpression.class, OCSendMessageExpression.class, OCAssignmentExpression.class, OCStatement.class, OCMacroCallArgument.class, OCTypeElement.class, OCBinaryExpression.class, OCUnaryExpression.class, OCQualifiedExpression.class, OCArraySelectionExpression.class});
        if (parent instanceof OCAssignmentExpression) {
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
            ((OCAssignmentExpression)parent).getReceiverExpression().accept(visitor);
            OCSymbol symbol = visitor.getSymbol();
            if (symbol != null) {
                if (symbol instanceof OCPropertySymbol && ((OCPropertySymbol)symbol).hasAttribute(OCPropertySymbol.PropertyAttribute.COPY)) {
                    return false;
                }
                if (scope != null && !scope.equals(symbol.getScope())) {
                    return true;
                }
                if (scope == null && !symbol.getKind().isLocal()) {
                    return true;
                }
            }
        } else if (parent instanceof OCReturnStatement) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCEscapedValuesChecker";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedVariables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCEscapedValuesChecker";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedObjects";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

