/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCUnreachableCodeFinder
extends OCDataFlowAlgorithm {
    private boolean myExitNodeReached;
    private boolean myDeadEndReached;
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructionsByType;

    public OCUnreachableCodeFinder(@NotNull OCControlFlowGraph cfg) {
        if (cfg == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(0);
        }
        super(cfg);
    }

    @Override
    public void process() {
        this.myDeadEndReached = false;
        this.myInstructionsByType = new MultiMap();
        this.clearProcessedNodes();
        this.traverse(this.myCfg.getStartNode(), null, null, true);
    }

    @Override
    protected void processDeadEnd(@NotNull OCNode node) {
        if (node == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(1);
        }
        this.myDeadEndReached = true;
    }

    public boolean isDeadEndReached() {
        return this.myDeadEndReached;
    }

    public boolean isExitNodeReached() {
        return this.myExitNodeReached;
    }

    @NotNull
    public List<OCElementsRange> getUnreachableRanges(boolean mergeRanges) {
        ArrayList<OCNode> unprocessedNodes = new ArrayList<OCNode>();
        for (OCNode node : this.myCfg.getNodes()) {
            if (this.isNodeProcessed(node, null) || node.isFake()) continue;
            unprocessedNodes.add(node);
        }
        List<OCElementsRange> list = OCUnreachableCodeFinder.getRanges(unprocessedNodes, mergeRanges);
        if (list == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    protected void nodeProcessed(@NotNull OCNode node) {
        if (node == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(3);
        }
        if (this.myCfg.getExitNodes().contains(node)) {
            this.myExitNodeReached = true;
        }
        if (node.getInstructions() != null) {
            for (OCInstruction instruction : node.getInstructions()) {
                this.myInstructionsByType.putValue((Object)instruction.getKind(), (Object)instruction);
            }
        }
    }

    @NotNull
    public Collection<OCInstruction> getReachableInstructions(@NotNull OCInstruction.InstructionKind kind) {
        if (kind == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(4);
        }
        Collection collection = this.myInstructionsByType.get((Object)kind);
        if (collection == null) {
            OCUnreachableCodeFinder.$$$reportNull$$$0(5);
        }
        return collection;
    }

    public void clearInstructions() {
        this.myInstructionsByType.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCUnreachableCodeFinder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnreachableRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processDeadEnd";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nodeProcessed";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReachableInstructions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

