/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCConditionsList;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCNumber;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.symtable.KnownDomainTypes;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.utils.PrettyName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSensitiveControlFlowBuilder
extends OCControlFlowBuilder {
    private static final Logger LOG = Logger.getInstance((String)"com.jetbrains.cidr.lang.dfa.OCContextSensitiveControlFlowBuilder");
    public static final String CONTEXT_SENSITIVITY = "CONTEXT_SENSITIVITY";
    public static final String GLOBAL_ANALYSIS = "GLOBAL_ANALYSIS";
    private static final int MAX_CONTEXTS_CNT = 1000000;
    private final MultiMap<OCNode, Integer> myStatementContexts;
    private final Map<OCCallable, Map<Integer, OCElementsRange>> myRangesMap;
    private Set<PsiElement> myNotUsedWrites;
    private MultiMap<OCNode, Attribute> myVariableWrites;
    private PsiFile myFile;
    private OCResolveContext myResolveContext;
    private final SymbolTable mySymbolTable;
    private boolean myContextSensitivity;
    private boolean myGlobalAnalysis;
    private int myCurContext;
    private Attribute myCallableAttribute;
    private Set<OCType> myProcessedTypes;
    private List<RelationSignature> mySignatures;
    private final TuplesConsumer myConsumer;
    private Map<OCCallable, OCControlFlowGraph> myGraphs;
    private Set<OCNode> myFakeNodes;
    private Map<Integer, Integer> myFakeContexts;
    private MultiMap<OCNode, Pair<RelationSignature, Attribute[]>> myFakeNodeAttributes;
    private Map<PsiElement, BranchConditions> myBranchConditions;
    private Set<OCSymbol> myPrivateFields;
    private Set<OCSymbol> myPrivateParameters;
    private int myVisitorRecursiveCnt;
    private ThreadCallback myThreadCallback;
    private RelationSignature myAssignmentToVar;
    private RelationSignature myAssignmentToConstant;
    private RelationSignature myAssignmentToExpression;
    private RelationSignature myAssignmentToCall;
    private RelationSignature myNonInitializedDeclarator;
    private RelationSignature myVarArgument;
    private RelationSignature myConstArgument;
    private RelationSignature myParameter;
    private RelationSignature myPrivateMethod;
    private RelationSignature myPrivateField;
    private RelationSignature myEqualityToConstConditionalJump;
    private RelationSignature myNonEqualityToConstConditionalJump;
    private RelationSignature myEqualityToVarConditionalJump;
    private RelationSignature myNonEqualityToVarConditionalJump;
    private RelationSignature myInstanceOfConditionalJump;
    private RelationSignature myNonInstanceOfConditionalJump;
    private RelationSignature myUnconditionalJump;
    private RelationSignature myNodeJump;
    private RelationSignature myStartNode;
    private RelationSignature myConditionThenBranch;
    private RelationSignature myConditionElseBranch;
    private RelationSignature myShortCuttedBranch;
    private RelationSignature myContextInfo;
    private RelationSignature myExpressionType;
    private RelationSignature myConstantType;
    private RelationSignature myVariableType;
    private RelationSignature myMethodReturnType;
    private RelationSignature mySubType;
    private RelationSignature myUnknownSubType;
    private RelationSignature myPODType;
    private RelationSignature myPointerTypeVariable;
    private RelationSignature myComplexTypeVariable;
    private RelationSignature myCastExpression;
    private RelationSignature myDynamicCallExpression;
    private RelationSignature myGetReferenceExpression;
    private RelationSignature myDereferenceExpression;
    private RelationSignature myMessageReceiverExpression;
    private RelationSignature myCallStatement;
    private RelationSignature myExternalCallStatement;
    private RelationSignature myReturnVarStatement;
    private RelationSignature myReturnConstStatement;
    private RelationSignature myExitStatement;

    public OCContextSensitiveControlFlowBuilder(@NotNull SymbolTable symbolTable, TuplesConsumer tuplesConsumer) {
        if (symbolTable == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(0);
        }
        this.myStatementContexts = new MultiMap();
        this.myRangesMap = new HashMap<OCCallable, Map<Integer, OCElementsRange>>();
        this.myProcessedTypes = OCTypeUtils.newTypeSet();
        this.mySignatures = new ArrayList<RelationSignature>();
        this.myGraphs = new HashMap<OCCallable, OCControlFlowGraph>();
        this.myFakeNodes = new HashSet<OCNode>();
        this.myFakeContexts = new HashMap<Integer, Integer>();
        this.myFakeNodeAttributes = new MultiMap();
        this.myBranchConditions = new HashMap<PsiElement, BranchConditions>();
        this.myPrivateFields = new HashSet<OCSymbol>();
        this.myPrivateParameters = new HashSet<OCSymbol>();
        this.mySymbolTable = symbolTable;
        this.myConsumer = tuplesConsumer;
        DomainType O = symbolTable.getDomainType(KnownDomainTypes.DOM_OBJECTS);
        DomainType C = symbolTable.getDomainType(KnownDomainTypes.DOM_CONSTANTS);
        DomainType V = symbolTable.getDomainType(KnownDomainTypes.DOM_POINTERS);
        DomainType S = symbolTable.getDomainType(KnownDomainTypes.DOM_BIG_INTEGERS);
        DomainType M = symbolTable.getDomainType(KnownDomainTypes.DOM_METHODS);
        DomainType T = symbolTable.getDomainType(KnownDomainTypes.DOM_TYPES);
        DomainType N = symbolTable.getDomainType(KnownDomainTypes.DOM_INTEGERS);
        this.myAssignmentToVar = new RelationSignature("AssignmentToVar", new DomainType[]{S, V, V});
        this.mySignatures.add(this.myAssignmentToVar);
        this.myAssignmentToConstant = new RelationSignature("AssignmentToConstant", new DomainType[]{S, V, C});
        this.mySignatures.add(this.myAssignmentToConstant);
        this.myAssignmentToExpression = new RelationSignature("AssignmentToExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myAssignmentToExpression);
        this.myAssignmentToCall = new RelationSignature("AssignmentToCall", new DomainType[]{S, V, M});
        this.mySignatures.add(this.myAssignmentToCall);
        this.myNonInitializedDeclarator = new RelationSignature("NonInitializedDeclarator", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myNonInitializedDeclarator);
        this.myEqualityToConstConditionalJump = new RelationSignature("EqualityToConstConditionalJump", new DomainType[]{S, S, V, C});
        this.mySignatures.add(this.myEqualityToConstConditionalJump);
        this.myNonEqualityToConstConditionalJump = new RelationSignature("NonEqualityToConstConditionalJump", new DomainType[]{S, S, V, C});
        this.mySignatures.add(this.myNonEqualityToConstConditionalJump);
        this.myEqualityToVarConditionalJump = new RelationSignature("EqualityToVarConditionalJump", new DomainType[]{S, S, V, V});
        this.mySignatures.add(this.myEqualityToVarConditionalJump);
        this.myNonEqualityToVarConditionalJump = new RelationSignature("NonEqualityToVarConditionalJump", new DomainType[]{S, S, V, V});
        this.mySignatures.add(this.myNonEqualityToVarConditionalJump);
        this.myInstanceOfConditionalJump = new RelationSignature("InstanceOfConditionalJump", new DomainType[]{S, S, V, T});
        this.mySignatures.add(this.myInstanceOfConditionalJump);
        this.myNonInstanceOfConditionalJump = new RelationSignature("NonInstanceOfConditionalJump", new DomainType[]{S, S, V, T});
        this.mySignatures.add(this.myNonInstanceOfConditionalJump);
        this.myUnconditionalJump = new RelationSignature("UnconditionalJump", new DomainType[]{S, S});
        this.mySignatures.add(this.myUnconditionalJump);
        this.myNodeJump = new RelationSignature("NodeJump", new DomainType[]{M, S, S});
        this.mySignatures.add(this.myNodeJump);
        this.myStartNode = new RelationSignature("StartNode", new DomainType[]{M, S});
        this.mySignatures.add(this.myStartNode);
        this.myConditionThenBranch = new RelationSignature("ConditionThenBranch", new DomainType[]{S, O});
        this.mySignatures.add(this.myConditionThenBranch);
        this.myConditionElseBranch = new RelationSignature("ConditionElseBranch", new DomainType[]{S, O});
        this.mySignatures.add(this.myConditionElseBranch);
        this.myShortCuttedBranch = new RelationSignature("ShortCuttedBranch", new DomainType[]{O});
        this.mySignatures.add(this.myShortCuttedBranch);
        this.myContextInfo = new RelationSignature("ContextInfo", new DomainType[]{M, S, S});
        this.mySignatures.add(this.myContextInfo);
        this.myVariableType = new RelationSignature("VariableType", new DomainType[]{V, T});
        this.mySignatures.add(this.myVariableType);
        this.myExpressionType = new RelationSignature("ExpressionType", new DomainType[]{O, T});
        this.mySignatures.add(this.myExpressionType);
        this.myConstantType = new RelationSignature("ConstantType", new DomainType[]{C, O, T});
        this.mySignatures.add(this.myConstantType);
        this.myCastExpression = new RelationSignature("CastExpression", new DomainType[]{S, V, T, O});
        this.mySignatures.add(this.myCastExpression);
        this.myDynamicCallExpression = new RelationSignature("DynamicCallExpression", new DomainType[]{S, V, T, O});
        this.mySignatures.add(this.myDynamicCallExpression);
        this.myGetReferenceExpression = new RelationSignature("GetReferenceExpression", new DomainType[]{S, V});
        this.mySignatures.add(this.myGetReferenceExpression);
        this.myDereferenceExpression = new RelationSignature("DereferenceExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myDereferenceExpression);
        this.myMessageReceiverExpression = new RelationSignature("MessageReceiverExpression", new DomainType[]{S, V, O});
        this.mySignatures.add(this.myMessageReceiverExpression);
        this.mySubType = new RelationSignature("SubType", new DomainType[]{T, T});
        this.mySignatures.add(this.mySubType);
        this.myUnknownSubType = new RelationSignature("UnknownSubType", new DomainType[]{T, T});
        this.mySignatures.add(this.myUnknownSubType);
        this.myPODType = new RelationSignature("PODType", new DomainType[]{T});
        this.mySignatures.add(this.myPODType);
        this.myPointerTypeVariable = new RelationSignature("PointerTypeVariable", new DomainType[]{V});
        this.mySignatures.add(this.myPointerTypeVariable);
        this.myComplexTypeVariable = new RelationSignature("ComplexTypeVariable", new DomainType[]{V});
        this.mySignatures.add(this.myComplexTypeVariable);
        this.myCallStatement = new RelationSignature("CallStatement", new DomainType[]{S, M});
        this.mySignatures.add(this.myCallStatement);
        this.myExternalCallStatement = new RelationSignature("ExternalCallStatement", new DomainType[]{S});
        this.mySignatures.add(this.myExternalCallStatement);
        this.myReturnVarStatement = new RelationSignature("ReturnVarStatement", new DomainType[]{S, V, M});
        this.mySignatures.add(this.myReturnVarStatement);
        this.myReturnConstStatement = new RelationSignature("ReturnConstStatement", new DomainType[]{S, C, M});
        this.mySignatures.add(this.myReturnConstStatement);
        this.myExitStatement = new RelationSignature("ExitStatement", new DomainType[]{S, M});
        this.mySignatures.add(this.myExitStatement);
        this.myVarArgument = new RelationSignature("VarArgument", new DomainType[]{S, M, N, V});
        this.mySignatures.add(this.myVarArgument);
        this.myConstArgument = new RelationSignature("ConstArgument", new DomainType[]{S, M, N, C});
        this.mySignatures.add(this.myConstArgument);
        this.myParameter = new RelationSignature("Parameter", new DomainType[]{M, N, V});
        this.mySignatures.add(this.myParameter);
        this.myPrivateMethod = new RelationSignature("PrivateMethod", new DomainType[]{M});
        this.mySignatures.add(this.myPrivateMethod);
        this.myPrivateField = new RelationSignature("PrivateField", new DomainType[]{V});
        this.mySignatures.add(this.myPrivateField);
        this.myMethodReturnType = new RelationSignature("MethodReturnType", new DomainType[]{M, T});
        this.mySignatures.add(this.myMethodReturnType);
    }

    public RelationSignature[] getOutputRelations() {
        return this.mySignatures.toArray(new RelationSignature[0]);
    }

    @Nullable
    public OCControlFlowGraph getControlFlowGraph(@NotNull OCCallable callable) {
        if (callable == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(1);
        }
        return this.myGraphs.get(callable);
    }

    @NotNull
    public Collection<OCControlFlowGraph> getAllControlFlowGraphs() {
        Collection<OCControlFlowGraph> collection = this.myGraphs.values();
        if (collection == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @Nullable
    public OCElementsRange getRange(@NotNull OCCallable callable, int nodeIndex) {
        if (callable == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(3);
        }
        return this.myRangesMap.containsKey(callable) ? this.myRangesMap.get(callable).get(nodeIndex) : null;
    }

    @NotNull
    private Attribute getAttribute(@NotNull String name2, @Nullable PsiElement element, @Nullable String domainTypeName) {
        if (name2 == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(4);
        }
        int srcPos = element != null ? element.getTextRange().getStartOffset() : 0;
        int srcLength = element != null ? element.getTextLength() : 0;
        String path = element != null ? element.getContainingFile().getVirtualFile().getPath() : "";
        DomainType domainType = domainTypeName != null ? this.mySymbolTable.getDomainType(domainTypeName) : null;
        Attribute attribute = new Attribute(name2, domainType, path, srcPos, srcLength, new PrettyName(name2));
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(5);
        }
        return attribute;
    }

    @NotNull
    private Attribute getPsiElementAttribute(@NotNull PsiElement element) {
        if (element == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(6);
        }
        Attribute attribute = this.getAttribute(element.getClass() + ":" + element.getTextOffset() + ":" + element.getTextLength(), element, null);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(7);
        }
        return attribute;
    }

    @NotNull
    private Attribute getIntegerAttribute(int num) {
        Attribute attribute = this.getAttribute(String.valueOf(num), null, KnownDomainTypes.DOM_INTEGERS);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(8);
        }
        return attribute;
    }

    @NotNull
    private Attribute getContextAttribute(int context) {
        Attribute attribute = this.getAttribute(String.valueOf(context), null, KnownDomainTypes.DOM_BIG_INTEGERS);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(9);
        }
        return attribute;
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull OCExpression expression, @NotNull OCType targetType) {
        if (expression == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(10);
        }
        if (targetType == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(11);
        }
        Attribute attribute = this.getConstantAttribute(OCExpressionEvaluator.evaluate(expression, targetType), expression);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(12);
        }
        return attribute;
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull OCExpression expression) {
        if (expression == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(13);
        }
        Attribute attribute = this.getConstantAttribute(OCExpressionEvaluator.evaluate(expression), expression);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(14);
        }
        return attribute;
    }

    @NotNull
    private Attribute getUnknownConstAttribute() {
        Attribute attribute = this.getAttribute("unknown const", null, null);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(15);
        }
        return attribute;
    }

    @NotNull
    private Attribute getUnknownExpressionAttribute() {
        Attribute attribute = this.getAttribute("unknown expression", null, null);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(16);
        }
        return attribute;
    }

    @NotNull
    private Attribute getConstantAttribute(@NotNull Number constant, @Nullable PsiElement element) {
        if (constant == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(17);
        }
        Attribute attribute = this.getAttribute(String.valueOf(constant), element, KnownDomainTypes.DOM_CONSTANTS);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(18);
        }
        return attribute;
    }

    @NotNull
    private Attribute getTypeAttribute(@NotNull OCType type, @NotNull PsiElement context) {
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(19);
        }
        if (context == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(20);
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        Attribute attribute = this.getAttribute(type.resolve(resolveContext).getCanonicalName(resolveContext), null, KnownDomainTypes.DOM_TYPES);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(21);
        }
        return attribute;
    }

    @NotNull
    private Attribute getUnknownSubtypeAttribute(@NotNull OCType type, @NotNull PsiElement context) {
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(22);
        }
        if (context == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(23);
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        Attribute attribute = this.getAttribute("Unknown subtype of " + type.resolve(resolveContext).getCanonicalName(resolveContext), null, KnownDomainTypes.DOM_TYPES);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(24);
        }
        return attribute;
    }

    @NotNull
    private Attribute getSymbolAttribute(@NotNull OCSymbol symbol, @NotNull String domainType) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(25);
        }
        if (domainType == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(26);
        }
        Object element = symbol.locateDefinition(this.getProject());
        element = symbol instanceof OCFunctionSymbol && element != null ? element.getParent() : element;
        Attribute attribute = this.getAttribute(symbol.getName() + ":" + symbol.getComplexOffset(), (PsiElement)element, domainType);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(27);
        }
        return attribute;
    }

    @NotNull
    private Attribute getVariableAttribute(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(28);
        }
        Attribute attribute = this.getSymbolAttribute(symbol, KnownDomainTypes.DOM_POINTERS);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(29);
        }
        return attribute;
    }

    @NotNull
    private Attribute getCallableAttribute(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(30);
        }
        Attribute attribute = this.getSymbolAttribute(symbol, KnownDomainTypes.DOM_METHODS);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(31);
        }
        return attribute;
    }

    @NotNull
    private Attribute getVariableAttribute(PsiElement expression) {
        OCReferenceElement element = ((OCReferenceExpression)expression).getReferenceElement();
        LOG.assertTrue(element != null);
        OCSymbol symbol = element.resolveToSymbol();
        LOG.assertTrue(symbol != null);
        Attribute attribute = this.getVariableAttribute(symbol);
        if (attribute == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(32);
        }
        return attribute;
    }

    @Override
    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCSymbol symbol) {
        return OCDFAUtils.isLocalVariable(symbol, this.myGraph) || this.myPrivateFields.contains(symbol);
    }

    @Contract(value="null -> false")
    protected boolean isSymbolInScope(@Nullable OCExpression operand) {
        if (operand instanceof OCReferenceExpression && ((OCReferenceExpression)operand).getSelfSuperToken() == null) {
            OCReferenceElement element = ((OCReferenceExpression)operand).getReferenceElement();
            return this.isSymbolInScope(element != null ? element.resolveToSymbol() : null);
        }
        return false;
    }

    public void processCallable(@NotNull OCCallable callable, @NotNull Map options, ThreadCallback threadCallback) {
        if (callable == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(33);
        }
        if (options == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(34);
        }
        OCSymbol symbol = callable.getSymbol();
        this.myThreadCallback = threadCallback;
        if (symbol != null && callable.getBody() != null) {
            this.init(new OCControlFlowGraph(callable, null));
            this.myContextSensitivity = !OCDFAUtils.hasGotos(callable) && options.get(CONTEXT_SENSITIVITY) != Boolean.FALSE;
            this.myGlobalAnalysis = options.get(GLOBAL_ANALYSIS) == Boolean.TRUE;
            this.myFile = callable.getContainingFile();
            this.myResolveContext = OCResolveContext.forPsi(callable);
            Pair<Set<PsiElement>, OCControlFlowGraph> pair2 = OCDFAUtils.getNotUsedWrites(callable);
            this.myNotUsedWrites = (Set)pair2.getFirst();
            this.myGraphs.put(callable, (OCControlFlowGraph)pair2.getSecond());
            this.myVariableWrites = new MultiMap();
            this.myStatementContexts.clear();
            this.myCallableAttribute = this.getCallableAttribute(symbol);
            if (this.myGlobalAnalysis) {
                this.processReturnType(callable);
                this.processParameters(symbol);
                this.processPrivateFields(symbol);
            }
            this.processFirstCodeFragment(callable);
            this.addContextInfos();
            this.processDeadEnds();
        }
    }

    private void processReturnType(OCCallable callable) {
        OCType returnType = this.simplifyType(callable.getReturnType().resolve(this.myResolveContext));
        Attribute typeAttr = this.getTypeAttribute(returnType, callable);
        this.myConsumer.addTuple(this.myMethodReturnType, this.myCallableAttribute, typeAttr);
        this.processType(returnType);
    }

    private void processParameters(OCSymbol callableSymbol) {
        boolean isPrivateCallable = OCDFAUtils.isPrivateCallable(callableSymbol, this.getProject());
        if (isPrivateCallable) {
            this.myConsumer.addTuple(this.myPrivateMethod, this.myCallableAttribute);
        }
        List<OCDeclaratorSymbol> parameterSymbols = null;
        if (callableSymbol instanceof OCFunctionSymbol) {
            parameterSymbols = ((OCFunctionSymbol)callableSymbol).getParameterSymbols();
        } else if (callableSymbol instanceof OCMethodSymbol) {
            parameterSymbols = ((OCMethodSymbol)callableSymbol).getParameterSymbols();
        }
        if (parameterSymbols != null) {
            for (int i = 0; i < parameterSymbols.size(); ++i) {
                OCDeclaratorSymbol parameter = parameterSymbols.get(i);
                if (parameter == null) continue;
                this.myConsumer.addTuple(this.myParameter, this.myCallableAttribute, this.getIntegerAttribute(i + 1), this.getVariableAttribute(parameter));
                if (!isPrivateCallable) continue;
                this.myPrivateParameters.add(parameter);
            }
        }
    }

    @NotNull
    private Project getProject() {
        Project project2 = this.myResolveContext.getProject();
        if (project2 == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(35);
        }
        return project2;
    }

    protected void processDeadEnds() {
        new OCUnreachableCodeFinder(this.myGraph){

            @Override
            protected void processDeadEnd(@NotNull OCNode node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                Collection contexts = OCContextSensitiveControlFlowBuilder.this.myStatementContexts.get((Object)node);
                for (Integer context : contexts) {
                    OCContextSensitiveControlFlowBuilder.this.myConsumer.addTuple(OCContextSensitiveControlFlowBuilder.this.myExitStatement, OCContextSensitiveControlFlowBuilder.this.getContextAttribute(context), OCContextSensitiveControlFlowBuilder.this.myCallableAttribute);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder$1", "processDeadEnd"));
            }
        }.process();
    }

    private void processPrivateFields(OCSymbol callableSymbol) {
        OCSymbolWithQualifiedName parent = null;
        if (callableSymbol instanceof OCMethodSymbol) {
            parent = (OCSymbolWithQualifiedName)((OCSymbolWithParent)callableSymbol).getParent();
        } else if (callableSymbol instanceof OCFunctionSymbol) {
            parent = ((OCFunctionSymbol)callableSymbol).getResolvedOwner(this.myResolveContext);
        }
        if (parent instanceof OCImplementationSymbol) {
            OCType type = parent.getResolvedType(this.myResolveContext);
            if (type instanceof OCObjectType) {
                ((OCObjectType)type).processMembers(OCInstanceVariableSymbol.class, symbol -> {
                    if (symbol.getVisibility().ordinal() >= OCVisibility.PROTECTED.ordinal()) {
                        this.myConsumer.addTuple(this.myPrivateField, this.getVariableAttribute((OCSymbol)symbol));
                        this.myPrivateFields.add((OCSymbol)symbol);
                        this.processDeclarator(symbol.getResolvedType(this.myResolveContext), (OCSymbol)symbol, (PsiElement)this.myFile);
                    }
                    return true;
                });
            }
        } else if (parent instanceof OCStructSymbol) {
            ((OCStructSymbol)parent).processFields((Processor<OCDeclaratorSymbol>)((Processor)symbol -> {
                if (symbol.getVisibility() == OCVisibility.PRIVATE && !symbol.isFriendOrStatic()) {
                    this.myConsumer.addTuple(this.myPrivateField, this.getVariableAttribute((OCSymbol)symbol));
                    this.myPrivateFields.add((OCSymbol)symbol);
                    this.processDeclarator(symbol.getResolvedType(this.myResolveContext), (OCSymbol)symbol, (PsiElement)this.myFile);
                }
                return true;
            }));
        }
    }

    private void processDeclarator(@NotNull OCType type, @NotNull OCSymbol symbol, @NotNull PsiElement context) {
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(36);
        }
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(37);
        }
        if (context == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(38);
        }
        Attribute typeAttribute = this.getTypeAttribute(type, context);
        this.processType(type);
        this.myConsumer.addTuple(this.myVariableType, this.getVariableAttribute(symbol), typeAttribute);
        this.myConsumer.addTuple(this.myExpressionType, this.getPsiElementAttribute(context), typeAttribute);
        this.processVariableType(type, symbol);
    }

    private void processVariableType(@NotNull OCType type, @NotNull OCSymbol symbol) {
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(39);
        }
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(40);
        }
        Attribute attribute = this.getVariableAttribute(symbol);
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCPointerType && !(type instanceof OCArrayType)) {
            this.myConsumer.addTuple(this.myPointerTypeVariable, attribute);
        } else if (type instanceof OCRealType || type instanceof OCMagicType || type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT || type instanceof OCArrayType) {
            this.myConsumer.addTuple(this.myComplexTypeVariable, attribute);
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        OCSymbol symbol = declarator.getSymbol();
        PsiElement identifier = declarator.getNameIdentifier();
        if (this.isSymbolInScope(symbol) && identifier != null) {
            this.processDeclarator(this.simplifyType(declarator.getResolvedType()), symbol, identifier);
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        OCDeclaratorSymbol symbol = (OCDeclaratorSymbol)part.getSymbol();
        PsiElement identifier = part.getNameIdentifier();
        if (this.isSymbolInScope(symbol) && identifier != null) {
            this.processDeclarator(this.simplifyType(part.getType().resolve((PsiElement)this.myFile)), symbol, identifier);
        }
    }

    @Override
    protected void processNonInitializedDeclarator(@NotNull OCSymbol symbol, @Nullable PsiElement lValue) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(41);
        }
        super.processNonInitializedDeclarator(symbol, lValue);
        if (this.myPrivateParameters.contains(symbol)) {
            return;
        }
        Attribute varAttribute = this.getVariableAttribute(symbol);
        this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)varAttribute);
        if (lValue != null) {
            Attribute constAttr = this.getConstantAttribute(OCNumber.valueOf(0L), null);
            this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), lValue, KnownDomainTypes.DOM_OBJECTS), this.getTypeAttribute(symbol.getResolvedType(this.myResolveContext), lValue));
            if (OCCompilerFeatures.isArcEnabled(this.myFile) && symbol.getKind() == OCSymbolKind.LOCAL_VARIABLE && symbol.getResolvedType(this.myResolveContext).isPointerToObjectCompatible()) {
                this.addStatement(this.myAssignmentToConstant, varAttribute, constAttr);
            } else {
                this.addStatement(this.myNonInitializedDeclarator, varAttribute, this.getPsiElementAttribute(lValue));
            }
        }
    }

    @Override
    protected void addStartNode(@NotNull OCNode node) {
        if (node == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(42);
        }
        super.addStartNode(node);
        this.myStatementContexts.putValue((Object)node, (Object)this.myCurContext);
        this.myConsumer.addTuple(this.myStartNode, this.myCallableAttribute, this.getContextAttribute(this.myCurContext));
        ++this.myCurContext;
    }

    private void addStatement(@NotNull RelationSignature relation, Attribute ... attrs) {
        OCNode node;
        if (relation == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(43);
        }
        if (attrs == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(44);
        }
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        if (this.myFakeNodes.contains(node = this.myGraph.getLastAddedNode())) {
            this.myFakeNodeAttributes.putValue((Object)node, (Object)Pair.create((Object)relation, (Object)attrs));
        } else {
            Collection contexts = this.myStatementContexts.get((Object)node);
            for (Integer context : contexts) {
                if (this.myThreadCallback != null) {
                    this.myThreadCallback.checkCancelled();
                }
                this.myConsumer.addTuple(relation, (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(context)}, (Object[])attrs));
            }
        }
    }

    private boolean needSplitContexts(@Nullable List<PsiElement> modifiedValues) {
        return modifiedValues == null || this.myContextSensitivity && OCDFAUtils.areValuesUsed(modifiedValues, this.myNotUsedWrites);
    }

    @Override
    @NotNull
    protected MyNodeState addBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable OCControlFlowBuilder.NodeState oldFromState) {
        if (fromNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(45);
        }
        if (toNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(46);
        }
        super.addBranch(fromNode, toNode, modifiedValues, oldFromState);
        this.addJump(new OCConditionsList.Conditions(null, null, this.myUnconditionalJump, new Attribute[0]), fromNode, toNode, this.needSplitContexts(modifiedValues) && oldFromState == null, false, (MyNodeState)oldFromState);
        MyNodeState myNodeState = new MyNodeState(toNode);
        if (myNodeState == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(47);
        }
        return myNodeState;
    }

    @Override
    @Nullable
    protected OCControlFlowBuilder.NodeState addUnstructuralBranch(@NotNull OCNode fromNode, @NotNull OCNode toNode) {
        if (fromNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(48);
        }
        if (toNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(49);
        }
        super.addUnstructuralBranch(fromNode, toNode);
        this.addJump(new OCConditionsList.Conditions(null, null, this.myUnconditionalJump, new Attribute[0]), fromNode, toNode, false, true, null);
        return new MyNodeState(toNode);
    }

    @Override
    protected OCNode getLoopBodyEndNode() {
        OCNode bodyEndNode = super.getLoopBodyEndNode();
        if (this.myStatementContexts.containsKey((Object)bodyEndNode)) {
            return bodyEndNode;
        }
        for (OCNode node : this.myContinueNodes) {
            if (!this.myStatementContexts.containsKey((Object)node)) continue;
            return node;
        }
        return bodyEndNode;
    }

    private void splitNode() {
        if (this.myGraph.isSplitNodesAllowed()) {
            OCNode prevNode = this.myGraph.getLastAddedNode();
            this.addBranch(prevNode, this.myGraph.addNode());
        }
    }

    @Override
    @NotNull
    protected MyNodeState addConditionalBranch(@NotNull OCElement condition, boolean branch, @NotNull OCNode fromNode, @NotNull OCNode toNode, @Nullable List<PsiElement> modifiedValues, @Nullable OCControlFlowBuilder.NodeState oldFromState) {
        if (condition == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(50);
        }
        if (fromNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(51);
        }
        if (toNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(52);
        }
        super.addBranch(fromNode, toNode, modifiedValues, oldFromState);
        boolean splitContexts = this.needSplitContexts(modifiedValues) && oldFromState == null;
        OCConditionsList conditionsList = branch ? this.myBranchConditions.get(condition).getTrueConditions() : this.myBranchConditions.get(condition).getFalseConditions();
        for (OCConditionsList.Conditions conditions : conditionsList.getConditions()) {
            this.addJump(conditions, fromNode, toNode, splitContexts, false, (MyNodeState)oldFromState);
        }
        MyNodeState myNodeState = new MyNodeState(toNode);
        if (myNodeState == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(53);
        }
        return myNodeState;
    }

    private void processType(@NotNull OCType type) {
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(54);
        }
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        Attribute typeAttribute = this.getTypeAttribute(type, (PsiElement)this.myFile);
        this.myConsumer.addTuple(this.myConstantType, this.getUnknownConstAttribute(), this.getUnknownConstAttribute(), typeAttribute);
        this.myConsumer.addTuple(this.myExpressionType, this.getUnknownExpressionAttribute(), typeAttribute);
        if (OCDFAUtils.processTypeHierarchy(type, (PsiElement)this.myFile, this.myProcessedTypes, (Processor<Pair<OCType, OCType>>)((Processor)pair2 -> {
            OCType superType = (OCType)pair2.getSecond();
            if (superType != null) {
                this.myConsumer.addTuple(this.mySubType, this.getTypeAttribute((OCType)pair2.getFirst(), (PsiElement)this.myFile), this.getTypeAttribute(superType, (PsiElement)this.myFile));
            }
            return true;
        }))) {
            this.myConsumer.addTuple(this.myUnknownSubType, this.getUnknownSubtypeAttribute(type, (PsiElement)this.myFile), typeAttribute);
        } else {
            this.myConsumer.addTuple(this.myPODType, typeAttribute);
        }
    }

    @NotNull
    private OCType simplifyType(@NotNull OCType type) {
        OCObjectType objectType;
        if (type == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(55);
        }
        while (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type.isPointerToObject() && !(objectType = (OCObjectType)type.getTerminalType()).getAllProtocols().isEmpty()) {
            type = type.isPointerToID() ? OCIdType.pointerToID(this.getProject()) : OCPointerType.to(new OCObjectType(objectType.getInterface(), objectType.getSuperType()));
        }
        OCType oCType = type.cloneWithoutConstModifier(this.getProject());
        if (oCType == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(56);
        }
        return oCType;
    }

    private void addJump(@NotNull OCConditionsList.Conditions conditions, @NotNull OCNode fromNode, @NotNull OCNode toNode, boolean splitContexts, boolean unstructural, @Nullable MyNodeState oldFromState) {
        int fromStartContext;
        if (conditions == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(57);
        }
        if (fromNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(58);
        }
        if (toNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(59);
        }
        if (this.myThreadCallback != null) {
            this.myThreadCallback.checkCancelled();
        }
        List fromContexts = (List)this.myStatementContexts.get((Object)fromNode);
        List<Integer> toContexts = (List<Integer>)this.myStatementContexts.get((Object)toNode);
        int n = fromStartContext = oldFromState != null ? oldFromState.myContextsCnt : 0;
        if (!splitContexts && !fromContexts.isEmpty() && toContexts.isEmpty()) {
            this.myStatementContexts.putValue((Object)toNode, (Object)this.myCurContext);
            toContexts = Collections.singletonList(this.myCurContext);
            ++this.myCurContext;
        }
        for (int i = fromStartContext; i < fromContexts.size(); ++i) {
            int toContext;
            if (this.myThreadCallback != null) {
                this.myThreadCallback.checkCancelled();
            }
            int fromContext = (Integer)fromContexts.get(i);
            if (unstructural) {
                for (int toContext2 : toContexts) {
                    this.addJump(conditions, fromNode, toNode, fromContext, toContext2);
                }
                continue;
            }
            if (splitContexts && fromNode != toNode) {
                ++this.myCurContext;
                this.myStatementContexts.putValue((Object)toNode, (Object)toContext);
                if (this.myCurContext >= 1000000) {
                    throw new OCDFAUtils.DFAException("Too many DFA contexts used: " + this.myCurContext);
                }
            } else {
                int index = (i - fromStartContext) * toContexts.size() / (fromContexts.size() - fromStartContext);
                if (index < 0 || index >= toContexts.size()) {
                    throw new OCDFAUtils.DFAException("Too many DFA contexts used: " + this.myCurContext);
                }
                toContext = toContexts.get(index);
            }
            this.addJump(conditions, fromNode, toNode, fromContext, toContext);
        }
    }

    private void addJump(@NotNull OCConditionsList.Conditions conditions, @NotNull OCNode fromNode, @NotNull OCNode toNode, int fromContext, int toContext) {
        if (conditions == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(60);
        }
        if (fromNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(61);
        }
        if (toNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(62);
        }
        List<OCConditionsList.Condition> list = conditions.getConditions();
        int nextContext = fromContext;
        OCNode nextNode = fromNode;
        for (int j = 0; j < list.size(); ++j) {
            int n;
            if (this.myThreadCallback != null) {
                this.myThreadCallback.checkCancelled();
            }
            OCConditionsList.Condition condition = list.get(j);
            OCNode fakeNode = condition.getFakeNode();
            if (j < list.size() - 1) {
                int n2 = this.myCurContext;
                n = n2;
                this.myCurContext = n2 + 1;
            } else {
                n = toContext;
            }
            int tempContext = n;
            OCNode tempNode = j < list.size() - 1 ? fakeNode : toNode;
            this.addTuplesForJump(nextContext, tempContext, condition);
            if (tempNode != null) {
                this.myConsumer.addTuple(this.myNodeJump, this.myCallableAttribute, this.getContextAttribute(this.getNodeId(nextNode, nextContext)), this.getContextAttribute(this.getNodeId(tempNode, tempContext)));
            }
            nextContext = tempContext;
            nextNode = tempNode;
            if (fakeNode == null || conditions.getSkipEvaluationIndices() != null && conditions.getSkipEvaluationIndices().contains(j + 1)) continue;
            this.myStatementContexts.putValue((Object)fakeNode, (Object)nextContext);
            for (Pair pair2 : this.myFakeNodeAttributes.get((Object)fakeNode)) {
                this.myConsumer.addTuple((RelationSignature)pair2.getFirst(), (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(nextContext)}, (Object[])((Object[])pair2.getSecond())));
            }
        }
    }

    private int getNodeId(@NotNull OCNode node, int context) {
        if (node == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(63);
        }
        if (node.isFake()) {
            if (this.myFakeContexts.containsKey(context)) {
                return this.myFakeContexts.get(context);
            }
            int id = this.myGraph.getNextNodeId();
            this.myFakeContexts.put(context, id);
            return id;
        }
        return node.getId();
    }

    private void addTuplesForJump(int fromContext, int toContext, @NotNull OCConditionsList.Condition condition) {
        if (condition == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(64);
        }
        this.myConsumer.addTuple(condition.getRelation(), (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(fromContext), this.getContextAttribute(toContext)}, (Object[])condition.getAttributes()));
        for (OCConditionsList.BranchInfo branch : condition.getBranches()) {
            RelationSignature relation = branch.isTrueBranch() ? this.myConditionThenBranch : this.myConditionElseBranch;
            Attribute conditionAttr = this.getPsiElementAttribute((PsiElement)(branch.getCondition() != null ? branch.getCondition() : this.myFile));
            this.myConsumer.addTuple(relation, (Attribute[])ArrayUtil.mergeArrays((Object[])new Attribute[]{this.getContextAttribute(toContext)}, (Object[])new Attribute[]{conditionAttr}));
            if (!branch.isCanBeShortCutted()) continue;
            this.myConsumer.addTuple(this.myShortCuttedBranch, conditionAttr);
        }
    }

    @Override
    protected OCNode acceptCondition(@Nullable OCElement condition, @NotNull OCControlFlowBuilder.KidIterator itr, boolean isLoop) {
        if (itr == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(65);
        }
        itr.skip(condition);
        itr.skipLeaves();
        if (!isLoop) {
            this.splitNode();
        }
        OCNode node = this.myGraph.getLastAddedNode();
        this.myGraph.forbidSplittingNodes();
        this.myBranchConditions.put(condition, this.doHandleConditionalBranch(condition));
        this.myGraph.allowSplittingNodes();
        this.removeFakeNodes(node);
        return node;
    }

    @Override
    protected void addCaseStatement(@NotNull OCCaseStatement stmt, @NotNull OCNode caseNode, @NotNull OCControlFlowBuilder.SwitchInfo info) {
        if (stmt == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(66);
        }
        if (caseNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(67);
        }
        if (info == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(68);
        }
        OCNode node = this.myGraph.getLastAddedNode();
        BranchConditions conditions = null;
        OCExpression caseExpression = stmt.getExpression();
        info.addCaseExpression(caseExpression);
        OCElement conditionElement = null;
        if (stmt.isDefault()) {
            OCConditionsList unconditional = OCConditionsList.singleton(null, null, this.myUnconditionalJump, new Attribute[0]);
            conditions = new BranchConditions(unconditional, unconditional);
            conditionElement = stmt;
            for (OCExpression expression : info.getCaseExpressions()) {
                BranchConditions conds = this.addEquality(info.getExpression(), expression, expression, false, false);
                OCConditionsList.BranchInfo branch = new OCConditionsList.BranchInfo(null, false, false);
                if (conds == null) continue;
                conditions = new BranchConditions(conditions.getTrueConditions().combine(conds.getFalseConditions(), branch), conditions.getFalseConditions());
            }
            conditions.getTrueConditions().clearBranches();
        } else if (caseExpression != null) {
            conditions = this.addEquality(info.getExpression(), caseExpression, caseExpression, false, false);
            conditionElement = caseExpression;
        }
        if (conditions != null) {
            this.removeFakeNodes(node);
            this.myBranchConditions.put(conditionElement, conditions);
            this.addConditionalBranch(conditionElement, true, info.getNode(), caseNode);
        } else {
            super.addCaseStatement(stmt, caseNode, info);
        }
    }

    private void removeFakeNodes(OCNode node) {
        while (this.myGraph.getLastAddedNode() != node) {
            this.myGraph.removeNode(this.myGraph.getLastAddedNode(), true);
        }
    }

    @Nullable
    private static BranchConditions negate(@Nullable BranchConditions conditions) {
        return conditions != null ? new BranchConditions(conditions.getFalseConditions(), conditions.getTrueConditions()) : null;
    }

    @NotNull
    private BranchConditions doHandleConditionalBranch(@Nullable OCElement condition) {
        BranchConditions branchConditions = this.doHandleConditionalBranch(condition, condition, false, false);
        if (branchConditions == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(69);
        }
        return branchConditions;
    }

    @NotNull
    private BranchConditions doHandleConditionalBranch(@Nullable OCElement cuttedCondition, @Nullable OCElement uncuttedCondition, boolean negate, boolean canBeShortCutted) {
        BranchConditions result = null;
        OCConditionsList.BranchInfo trueBranch = new OCConditionsList.BranchInfo(uncuttedCondition, true, canBeShortCutted);
        OCConditionsList.BranchInfo falseBranch = new OCConditionsList.BranchInfo(uncuttedCondition, false, canBeShortCutted);
        if ((cuttedCondition = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(cuttedCondition)) instanceof OCCondition) {
            OCCondition condition = (OCCondition)cuttedCondition;
            cuttedCondition = condition.getExpression();
            result = this.doHandleConditionalBranch(cuttedCondition, uncuttedCondition, negate, canBeShortCutted);
        } else if (cuttedCondition instanceof OCUnaryExpression && ((OCUnaryExpression)cuttedCondition).getOperationSign() == OCTokenTypes.EXCL) {
            OCUnaryExpression unaryExpression = (OCUnaryExpression)cuttedCondition;
            result = OCContextSensitiveControlFlowBuilder.negate(this.doHandleConditionalBranch(unaryExpression.getOperand(), uncuttedCondition, !negate, canBeShortCutted));
        } else if (cuttedCondition instanceof OCBinaryExpression) {
            OCBinaryExpression binary = (OCBinaryExpression)cuttedCondition;
            OCElementType sign = binary.getOperationSign();
            if (sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR || sign == OCTokenTypes.XOR) {
                BranchConditions left = this.doHandleConditionalBranch(binary.getLeft(), binary.getLeft(), false, canBeShortCutted);
                BranchConditions right = this.doHandleConditionalBranch(binary.getRight(), binary.getRight(), false, true);
                OCConditionsList a = left.getTrueConditions();
                OCConditionsList notA = left.getFalseConditions();
                OCConditionsList b = right.getTrueConditions();
                OCConditionsList notB = right.getFalseConditions();
                if (sign == OCTokenTypes.ANDAND) {
                    result = new BranchConditions(a.combine(b, trueBranch), a.combine(notB, falseBranch).merge(notA.skipEvaluation(falseBranch)));
                } else if (sign == OCTokenTypes.OROR) {
                    result = new BranchConditions(notA.combine(b, trueBranch).merge(a.skipEvaluation(trueBranch)), notA.combine(notB, falseBranch));
                } else if (sign == OCTokenTypes.XOR) {
                    result = new BranchConditions(notA.combine(b, trueBranch).merge(a.combine(notB, trueBranch)), notA.combine(notB, falseBranch).merge(a.combine(b, falseBranch)));
                }
            } else {
                ++this.myVisitorRecursiveCnt;
                cuttedCondition.accept(this);
                --this.myVisitorRecursiveCnt;
                if (sign == OCTokenTypes.EQEQ) {
                    result = this.addEquality(binary.getLeft(), binary.getRight(), uncuttedCondition, negate, canBeShortCutted);
                } else if (sign == OCTokenTypes.EXCLEQ) {
                    result = OCContextSensitiveControlFlowBuilder.negate(this.addEquality(binary.getLeft(), binary.getRight(), uncuttedCondition, !negate, canBeShortCutted));
                }
            }
        } else if (cuttedCondition != null) {
            OCDFAUtils.InstanceOf instanceOf;
            OCAssignmentExpression assignmentExpression;
            ++this.myVisitorRecursiveCnt;
            cuttedCondition.accept(this);
            --this.myVisitorRecursiveCnt;
            Attribute attribute = null;
            if (cuttedCondition instanceof OCAssignmentExpression && (assignmentExpression = (OCAssignmentExpression)cuttedCondition).getOperationSign() == OCTokenTypes.EQ) {
                attribute = this.getExpressionAttribute(assignmentExpression.getReceiverExpression());
            }
            if (attribute == null) {
                attribute = this.getExpressionAttribute(cuttedCondition);
            }
            if (attribute != null) {
                result = OCContextSensitiveControlFlowBuilder.negate(this.addEqualityToConst(cuttedCondition, attribute, this.getConstantAttribute(OCNumber.valueOf(0L), null), !negate, canBeShortCutted, OCIntType.BOOL, uncuttedCondition));
            } else if (cuttedCondition instanceof OCExpression && (instanceOf = OCDFAUtils.getInstanceofPair((OCExpression)cuttedCondition)) != null && this.isSymbolInScope(instanceOf.symbol)) {
                OCNode node = this.addFakeNode();
                Attribute varAttribute = this.getVariableAttribute(instanceOf.symbol);
                Attribute typeAttribute = this.getTypeAttribute(this.simplifyType(instanceOf.type), (PsiElement)this.myFile);
                result = OCContextSensitiveControlFlowBuilder.getBranchConditions(uncuttedCondition, negate, canBeShortCutted, node, this.myInstanceOfConditionalJump, this.myNonInstanceOfConditionalJump, varAttribute, typeAttribute);
                this.addModifiedValue(instanceOf.variable);
                this.processType(instanceOf.type);
            }
        }
        if (result != null) {
            BranchConditions branchConditions = result;
            if (branchConditions == null) {
                OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(70);
            }
            return branchConditions;
        }
        OCConditionsList singleton = OCConditionsList.singleton(null, null, this.myUnconditionalJump, new Attribute[0]);
        BranchConditions branchConditions = new BranchConditions(singleton, singleton);
        if (branchConditions == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(71);
        }
        return branchConditions;
    }

    @Override
    protected boolean doEnlargeNodes() {
        return this.myVisitorRecursiveCnt == 0;
    }

    @Nullable
    private BranchConditions addEquality(@Nullable OCExpression left, @Nullable OCExpression right, @Nullable OCElement condition, boolean negate, boolean canBeShortCutted) {
        left = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(left);
        right = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(right);
        Attribute leftAttr = this.getExpressionAttribute(left);
        Attribute rightAttr = this.getExpressionAttribute(right);
        if (OCDFAUtils.isConstant(left) && rightAttr != null) {
            return this.addEqualityToConst(right, rightAttr, this.getConstantAttribute(left), negate, canBeShortCutted, this.simplifyType(left.getType().getGuessedType()), condition);
        }
        if (OCDFAUtils.isConstant(right) && leftAttr != null) {
            return this.addEqualityToConst(left, leftAttr, this.getConstantAttribute(right), negate, canBeShortCutted, this.simplifyType(right.getType().getGuessedType()), condition);
        }
        if (leftAttr != null && rightAttr != null) {
            OCNode node = this.addFakeNode();
            return OCContextSensitiveControlFlowBuilder.getBranchConditions(condition, negate, canBeShortCutted, node, this.myEqualityToVarConditionalJump, this.myNonEqualityToVarConditionalJump, leftAttr, rightAttr);
        }
        return null;
    }

    private BranchConditions addEqualityToConst(@NotNull OCElement expression, @NotNull Attribute exprAttr, @NotNull Attribute constAttr, boolean negate, boolean canBeShortCutted, @NotNull OCType constType, @Nullable OCElement condition) {
        if (expression == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(72);
        }
        if (exprAttr == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(73);
        }
        if (constAttr == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(74);
        }
        if (constType == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(75);
        }
        if (constAttr.getKey().equals("0") && expression instanceof OCReferenceExpression) {
            this.addModifiedValue(expression);
        }
        this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), null, KnownDomainTypes.DOM_OBJECTS), this.getTypeAttribute(constType, expression));
        this.processType(constType);
        OCNode node = this.addFakeNode();
        return OCContextSensitiveControlFlowBuilder.getBranchConditions(condition, negate, canBeShortCutted, node, this.myEqualityToConstConditionalJump, this.myNonEqualityToConstConditionalJump, exprAttr, constAttr);
    }

    @Contract(value="null -> null")
    @Nullable
    private Attribute getExpressionAttribute(@Nullable PsiElement expression) {
        if (expression instanceof OCExpression) {
            OCSymbol callSymbol;
            if (this.isSymbolInScope((OCExpression)expression)) {
                return this.getVariableAttribute(expression);
            }
            if (this.myGlobalAnalysis && (callSymbol = OCDFAUtils.getCallSymbol(expression)) != null) {
                Attribute attribute = this.getPsiElementAttribute(expression);
                this.addStatement(this.myAssignmentToCall, attribute, this.getCallableAttribute(callSymbol));
                OCType type = this.simplifyType(((OCExpression)expression).getResolvedType().getGuessedType());
                Attribute typeAttribute = this.getTypeAttribute(type, expression);
                this.myConsumer.addTuple(this.myVariableType, attribute, typeAttribute);
                this.splitNode();
                return attribute;
            }
        }
        return null;
    }

    @NotNull
    private OCNode addFakeNode() {
        OCNode node = this.myGraph.addNode(true);
        this.myFakeNodes.add(node);
        OCNode oCNode = node;
        if (oCNode == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(76);
        }
        return oCNode;
    }

    private static BranchConditions getBranchConditions(@Nullable OCElement condition, boolean negate, boolean canBeShortCutted, @Nullable OCNode node, @NotNull RelationSignature trueRelation, @NotNull RelationSignature falseRelation, Attribute ... attributes) {
        if (trueRelation == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(77);
        }
        if (falseRelation == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(78);
        }
        if (attributes == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(79);
        }
        return new BranchConditions(OCConditionsList.singleton(new OCConditionsList.BranchInfo(condition, !negate, canBeShortCutted), node, trueRelation, attributes), OCConditionsList.singleton(new OCConditionsList.BranchInfo(condition, negate, canBeShortCutted), node, falseRelation, attributes));
    }

    @Override
    protected void processAssignment(@NotNull OCSymbol symbol, @Nullable PsiElement lValue, @Nullable OCExpression rValue, boolean complexAssignment, boolean shortCircuitEvaluation) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(80);
        }
        super.processAssignment(symbol, lValue, rValue, complexAssignment, shortCircuitEvaluation);
        Attribute left = null;
        rValue = OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts(rValue);
        if (this.isSymbolInScope(symbol)) {
            left = this.getVariableAttribute(symbol);
        }
        if (left != null) {
            Collection writes = this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode());
            if (writes.contains(left) || this.isSymbolInScope(rValue) && writes.contains(this.getVariableAttribute(rValue))) {
                this.splitNode();
            }
            this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)left);
            Attribute expressionAttr = null;
            Attribute constAttr = null;
            if (rValue == null) {
                this.addStatement(this.myAssignmentToExpression, left, this.getUnknownExpressionAttribute());
            } else if (complexAssignment) {
                expressionAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
            } else if (OCDFAUtils.isConstant(rValue)) {
                constAttr = this.getConstantAttribute(rValue, symbol.getResolvedType(this.myResolveContext));
                this.addStatement(this.myAssignmentToConstant, left, constAttr);
            } else if (rValue instanceof OCCppNewExpression && !((OCCppNewExpression)rValue).isNoThrow()) {
                constAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToConstant, left, constAttr);
            } else if (this.isSymbolInScope(rValue)) {
                this.addStatement(this.myAssignmentToVar, left, this.getVariableAttribute(rValue));
            } else if (this.myGlobalAnalysis) {
                Attribute callableAttr;
                OCSymbol callSymbol = OCDFAUtils.getCallSymbol(rValue);
                Attribute attribute = callableAttr = callSymbol != null ? this.getCallableAttribute(callSymbol) : null;
                if (callableAttr != null) {
                    this.addStatement(this.myAssignmentToCall, left, callableAttr);
                } else {
                    expressionAttr = this.getPsiElementAttribute(rValue);
                    this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
                }
            } else {
                expressionAttr = this.getPsiElementAttribute(rValue);
                this.addStatement(this.myAssignmentToExpression, left, expressionAttr);
            }
            if (expressionAttr != null || constAttr != null) {
                OCType type = this.simplifyType(rValue.getType().getGuessedType());
                if (expressionAttr != null) {
                    this.myConsumer.addTuple(this.myExpressionType, expressionAttr, this.getTypeAttribute(type, rValue));
                } else {
                    this.myConsumer.addTuple(this.myConstantType, constAttr, this.getAttribute(constAttr.getKey(), rValue, KnownDomainTypes.DOM_OBJECTS), this.getTypeAttribute(type, rValue));
                }
                this.processType(type);
            }
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        super.visitCastExpression(expression);
        OCExpression operand = expression.getOperand();
        if (this.isSymbolInScope(operand)) {
            OCType type = this.simplifyType(expression.getCastType().resolve(OCResolveContext.forPsi(expression)));
            Attribute variable = this.getVariableAttribute(operand);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myCastExpression, variable, this.getTypeAttribute(type, expression), this.getPsiElementAttribute(expression));
            this.processType(type);
        }
    }

    private void doProcessReference(@NotNull OCSymbol symbol) {
        OCSymbolKind symbolKind;
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(81);
        }
        if ((symbolKind = symbol.getKind()).isLocal()) {
            Attribute variable = this.getVariableAttribute(symbol);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.myVariableWrites.putValue((Object)this.myGraph.getLastAddedNode(), (Object)variable);
            this.addStatement(this.myGetReferenceExpression, variable);
        }
    }

    @Override
    protected void processReference(@NotNull PsiElement element, @NotNull OCSymbol symbol) {
        if (element == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(82);
        }
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(83);
        }
        super.processReference(element, symbol);
        this.doProcessReference(symbol);
    }

    @Override
    protected void processReferenceFromBlock(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(84);
        }
        super.processReferenceFromBlock(symbol);
        this.doProcessReference(symbol);
    }

    @Override
    protected void processDereference(@NotNull OCReferenceExpression expression) {
        if (expression == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(85);
        }
        super.processDereference(expression);
        if (this.isSymbolInScope(expression)) {
            Attribute variable = this.getVariableAttribute(expression);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myDereferenceExpression, variable, this.getPsiElementAttribute(expression));
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        if (this.myGlobalAnalysis) {
            OCExpression funExpr = expression.getFunctionReferenceExpression();
            OCExpression receiver = null;
            OCSymbol function = null;
            if (funExpr instanceof OCReferenceExpression) {
                function = ((OCReferenceExpression)funExpr).resolveToSymbol();
            } else if (funExpr instanceof OCQualifiedExpression) {
                function = ((OCQualifiedExpression)funExpr).resolveToSymbol();
                receiver = ((OCQualifiedExpression)funExpr).getQualifier();
            }
            this.processCall(function, receiver, expression.getArguments());
        }
        super.visitCallExpression(expression);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        OCExpression receiver = OCParenthesesUtils.diveIntoParenthesesAndCasts(expression.getReceiverExpression());
        if (this.myGlobalAnalysis) {
            this.processCall(expression.getProbableResponders().getKnownResponder(), expression.getReceiverExpression(), expression.getArgumentExpressions());
        }
        if (receiver != null && this.isSymbolInScope(receiver)) {
            OCSendMessageExpression.ProbableResponders responders = expression.getProbableResponders();
            Attribute variable = this.getVariableAttribute(receiver);
            if (this.myVariableWrites.get((Object)this.myGraph.getLastAddedNode()).contains(variable)) {
                this.splitNode();
            }
            this.addStatement(this.myMessageReceiverExpression, variable, this.getPsiElementAttribute(receiver));
            if (responders.getKnownResponder() == null && !responders.getAllResponders().isEmpty()) {
                for (OCMethodSymbol method : responders.getAllResponders()) {
                    OCType type = this.simplifyType(OCPointerType.to(((OCClassSymbol)method.getParent()).getResolvedType(this.myResolveContext)));
                    this.addStatement(this.myDynamicCallExpression, variable, this.getTypeAttribute(type, expression), this.getPsiElementAttribute(expression));
                    this.processType(type);
                }
            }
        }
        super.visitSendMessageExpression(expression);
    }

    private void processCall(@Nullable OCSymbol callable, @Nullable OCExpression receiver, @NotNull List<OCExpression> arguments) {
        if (arguments == null) {
            OCContextSensitiveControlFlowBuilder.$$$reportNull$$$0(86);
        }
        if (OCDFAUtils.isGoodCallable(this.myFile, callable)) {
            this.splitNode();
            Attribute callableAttr = this.getCallableAttribute(callable);
            Attribute attribute = this.getExpressionAttribute(receiver);
            this.addStatement(this.myCallStatement, callableAttr);
            if (attribute != null) {
                this.addStatement(this.myVarArgument, callableAttr, this.getIntegerAttribute(0), attribute);
            } else if (OCDFAUtils.isConstant(receiver)) {
                this.addStatement(this.myConstArgument, callableAttr, this.getIntegerAttribute(0), this.getConstantAttribute(receiver));
            }
            for (int i = 0; i < arguments.size(); ++i) {
                OCExpression argument = arguments.get(i);
                attribute = this.getExpressionAttribute(argument);
                if (attribute != null) {
                    this.addStatement(this.myVarArgument, callableAttr, this.getIntegerAttribute(i + 1), attribute);
                    continue;
                }
                if (!OCDFAUtils.isConstant(argument)) continue;
                this.addStatement(this.myConstArgument, callableAttr, this.getIntegerAttribute(i + 1), this.getConstantAttribute(argument));
            }
        } else {
            this.addStatement(this.myExternalCallStatement, new Attribute[0]);
        }
    }

    private static OCElement diveIntoParenthesesAndCasts(@Nullable OCElement element) {
        if (element instanceof OCExpression) {
            return OCContextSensitiveControlFlowBuilder.diveIntoParenthesesAndCasts((OCExpression)element);
        }
        return element;
    }

    private static OCExpression diveIntoParenthesesAndCasts(@Nullable OCExpression expression) {
        OCCastKind[] acceptableCasts = (OCCastKind[])ArrayUtil.remove((Object[])OCCastKind.values(), (Object)((Object)OCCastKind.DYNAMIC_CAST));
        return OCParenthesesUtils.diveIntoParenthesesAndCasts(expression, acceptableCasts);
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        if (this.myGlobalAnalysis) {
            OCSymbol callableSymbol;
            OCExpression expression = stmt.getExpression();
            Attribute attribute = this.getExpressionAttribute(expression);
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCCallable.class);
            OCSymbol oCSymbol = callableSymbol = callable != null ? callable.getSymbol() : null;
            if (callableSymbol != null) {
                Attribute callableAttr = this.getCallableAttribute(callableSymbol);
                this.addStatement(this.myExitStatement, callableAttr);
                if (attribute != null) {
                    this.addStatement(this.myReturnVarStatement, attribute, callableAttr);
                } else if (OCDFAUtils.isConstant(expression)) {
                    this.addStatement(this.myReturnConstStatement, this.getConstantAttribute(expression), callableAttr);
                }
            }
        }
        super.visitReturnStatement(stmt);
    }

    public void addContextInfos() {
        OCCallable callable = (OCCallable)this.myGraph.getCodeFragment();
        Document document = PsiDocumentManager.getInstance((Project)callable.getProject()).getDocument(callable.getContainingFile());
        HashMap<Integer, OCElementsRange> map2 = new HashMap<Integer, OCElementsRange>();
        this.myRangesMap.put(callable, map2);
        if (document != null) {
            for (OCNode node : this.myStatementContexts.keySet()) {
                OCElementsRange range = node.getRange();
                if (range != null && !node.isFake()) {
                    map2.put(node.getId(), range);
                }
                Iterator iterator = this.myStatementContexts.get((Object)node).iterator();
                while (iterator.hasNext()) {
                    int context = (Integer)iterator.next();
                    if (this.myThreadCallback != null) {
                        this.myThreadCallback.checkCancelled();
                    }
                    this.myConsumer.addTuple(this.myContextInfo, this.myCallableAttribute, this.getContextAttribute(this.getNodeId(node, context)), this.getContextAttribute(context));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 47: 
            case 53: 
            case 56: 
            case 69: 
            case 70: 
            case 71: 
            case 76: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 47: 
            case 53: 
            case 56: 
            case 69: 
            case 70: 
            case 71: 
            case 76: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolTable";
                break;
            }
            case 1: 
            case 3: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 47: 
            case 53: 
            case 56: 
            case 69: 
            case 70: 
            case 71: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: 
            case 13: 
            case 72: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 19: 
            case 22: 
            case 36: 
            case 39: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 28: 
            case 30: 
            case 37: 
            case 40: 
            case 41: 
            case 80: 
            case 81: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainType";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 42: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relation";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrs";
                break;
            }
            case 45: 
            case 48: 
            case 51: 
            case 58: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 46: 
            case 49: 
            case 52: 
            case 59: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 50: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conditions";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itr";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseNode";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exprAttr";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constAttr";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constType";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trueRelation";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "falseRelation";
                break;
            }
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllControlFlowGraphs";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElementAttribute";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntegerAttribute";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextAttribute";
                break;
            }
            case 12: 
            case 14: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstantAttribute";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownConstAttribute";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownExpressionAttribute";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAttribute";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnknownSubtypeAttribute";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolAttribute";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableAttribute";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallableAttribute";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "addBranch";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "addConditionalBranch";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "simplifyType";
                break;
            }
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "doHandleConditionalBranch";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "addFakeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getControlFlowGraph";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 47: 
            case 53: 
            case 56: 
            case 69: 
            case 70: 
            case 71: 
            case 76: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPsiElementAttribute";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getConstantAttribute";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTypeAttribute";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getUnknownSubtypeAttribute";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolAttribute";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getVariableAttribute";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCallableAttribute";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processCallable";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarator";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processVariableType";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processNonInitializedDeclarator";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "addStartNode";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addStatement";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addBranch";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addUnstructuralBranch";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addConditionalBranch";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "processType";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "simplifyType";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addJump";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getNodeId";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "addTuplesForJump";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "acceptCondition";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "addCaseStatement";
                break;
            }
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "addEqualityToConst";
                break;
            }
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "getBranchConditions";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "processAssignment";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "doProcessReference";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "processReference";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processReferenceFromBlock";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "processDereference";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 32: 
            case 35: 
            case 47: 
            case 53: 
            case 56: 
            case 69: 
            case 70: 
            case 71: 
            case 76: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class BranchConditions {
        OCConditionsList myTrueConditions;
        OCConditionsList myFalseConditions;

        BranchConditions(@NotNull OCConditionsList trueConditions, @NotNull OCConditionsList falseConditions) {
            if (trueConditions == null) {
                BranchConditions.$$$reportNull$$$0(0);
            }
            if (falseConditions == null) {
                BranchConditions.$$$reportNull$$$0(1);
            }
            this.myTrueConditions = trueConditions;
            this.myFalseConditions = falseConditions;
        }

        @NotNull
        OCConditionsList getTrueConditions() {
            OCConditionsList oCConditionsList = this.myTrueConditions;
            if (oCConditionsList == null) {
                BranchConditions.$$$reportNull$$$0(2);
            }
            return oCConditionsList;
        }

        @NotNull
        OCConditionsList getFalseConditions() {
            OCConditionsList oCConditionsList = this.myFalseConditions;
            if (oCConditionsList == null) {
                BranchConditions.$$$reportNull$$$0(3);
            }
            return oCConditionsList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "trueConditions";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "falseConditions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder$BranchConditions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder$BranchConditions";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTrueConditions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFalseConditions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class MyNodeState
    implements OCControlFlowBuilder.NodeState {
        private final int myContextsCnt;

        private MyNodeState(OCNode node) {
            if (node == null) {
                MyNodeState.$$$reportNull$$$0(0);
            }
            this.myContextsCnt = OCContextSensitiveControlFlowBuilder.this.myStatementContexts.get((Object)node).size();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/cidr/lang/dfa/contextSensitive/OCContextSensitiveControlFlowBuilder$MyNodeState", "<init>"));
        }
    }

    @FunctionalInterface
    public static interface TuplesConsumer {
        public void addTuple(RelationSignature var1, Attribute ... var2);
    }
}

