/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa.contextSensitive;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.dfa.OCControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNotUsedValueChecker;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCGotoStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAUtils {
    @Contract(value="null->false")
    public static boolean isConstant(@Nullable OCExpression expression) {
        return OCExpressionEvaluator.evaluate(expression) != null;
    }

    @Contract(value="null, _ -> false")
    public static boolean isLocalVariable(@Nullable OCSymbol symbol, OCControlFlowGraph graph) {
        return symbol != null && graph.getLocalSymbols().contains(symbol) && (!(symbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)symbol).isFriendOrStatic());
    }

    @Contract(value="null -> null")
    @Nullable
    public static OCSymbol getCallSymbol(@Nullable PsiElement expression) {
        OCSymbol<PsiElement> symbol = null;
        if (expression instanceof OCCallExpression) {
            OCExpression receiver = ((OCCallExpression)expression).getFunctionReferenceExpression();
            if (receiver instanceof OCReferenceExpression) {
                symbol = ((OCReferenceExpression)receiver).resolveToSymbol();
            } else if (receiver instanceof OCQualifiedExpression) {
                symbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
            }
        } else if (expression instanceof OCSendMessageExpression) {
            symbol = ((OCSendMessageExpression)expression).getProbableResponders().getKnownResponder();
        }
        return expression != null && OCDFAUtils.isGoodCallable(expression.getContainingFile(), symbol) ? symbol : null;
    }

    @Contract(value="_, null -> false")
    public static boolean isGoodCallable(@NotNull PsiFile file, @Nullable OCSymbol symbol) {
        if (file == null) {
            OCDFAUtils.$$$reportNull$$$0(0);
        }
        return symbol != null && symbol.isCallable() && file.getVirtualFile() != null && file.getVirtualFile().equals(symbol.getContainingFile());
    }

    public static boolean isPrivateCallable(OCSymbol symbol, @NotNull Project project2) {
        Object element;
        if (project2 == null) {
            OCDFAUtils.$$$reportNull$$$0(1);
        }
        PsiFile file = (element = symbol.locateDefinition(project2)) != null ? element.getContainingFile() : null;
        return file != null && ReferencesSearch.search(element).forEach(reference -> reference.getElement().getContainingFile().equals(file));
    }

    public static boolean processTypeHierarchy(@NotNull OCType type, @NotNull PsiElement context, @NotNull Set<OCType> processed, @NotNull Processor<Pair<OCType, OCType>> processor2) {
        if (type == null) {
            OCDFAUtils.$$$reportNull$$$0(2);
        }
        if (context == null) {
            OCDFAUtils.$$$reportNull$$$0(3);
        }
        if (processed == null) {
            OCDFAUtils.$$$reportNull$$$0(4);
        }
        if (processor2 == null) {
            OCDFAUtils.$$$reportNull$$$0(5);
        }
        ProgressManager.checkCanceled();
        OCType resolvedType = type.resolve(context);
        if (processed.contains(resolvedType)) {
            return true;
        }
        processed.add(resolvedType);
        OCType counterpart = OCTollFreeBridges.getCounterpart(type, context);
        if (counterpart != null) {
            processor2.process((Object)Pair.create((Object)resolvedType, (Object)counterpart));
            processor2.process((Object)Pair.create((Object)counterpart, (Object)resolvedType));
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (resolvedType.isPointerToObject() && !resolvedType.isPointerToID() && !resolvedType.getName().equals("NSData *") && !resolvedType.getName().equals("NSNull *")) {
            OCType superType = ((OCObjectType)resolvedType.getTerminalType()).getSuperType();
            if (superType != null) {
                superType = OCPointerType.to(superType);
                processor2.process((Object)Pair.create((Object)resolvedType, (Object)superType));
                OCDFAUtils.processTypeHierarchy(superType, context, processed, processor2);
            } else {
                processor2.process((Object)new Pair((Object)resolvedType, null));
            }
            return true;
        }
        if (resolvedType.isCppStructType(resolveContext) || resolvedType.isPointerToCppStructType(resolveContext)) {
            OCType terminalType = resolvedType.getTerminalType();
            if (!(terminalType instanceof OCStructType)) {
                return false;
            }
            ((OCStructType)terminalType).getSymbol().processAllBaseClasses((symbol, visibility) -> {
                if (processor2 == null) {
                    OCDFAUtils.$$$reportNull$$$0(11);
                }
                if (context == null) {
                    OCDFAUtils.$$$reportNull$$$0(12);
                }
                if (processed == null) {
                    OCDFAUtils.$$$reportNull$$$0(13);
                }
                if (symbol instanceof OCStructSymbol) {
                    OCType superType = resolvedType.isPointer() ? OCPointerType.to(symbol.getType()) : symbol.getType();
                    processor2.process((Object)Pair.create((Object)resolvedType, (Object)superType));
                    OCDFAUtils.processTypeHierarchy(superType, context, processed, processor2);
                }
                return true;
            }, resolveContext);
            return true;
        }
        return false;
    }

    @Nullable
    public static InstanceOf getInstanceofPair(@Nullable OCExpression expression) {
        OCSendMessageExpression messageExpr;
        OCExpression receiver;
        if (expression instanceof OCSendMessageExpression && (receiver = (messageExpr = (OCSendMessageExpression)expression).getReceiverExpression()) instanceof OCReferenceExpression && messageExpr.getMessageSelector().equals("isKindOfClass:")) {
            OCReferenceElement receiverElement = ((OCReferenceExpression)receiver).getReferenceElement();
            OCExpression typeExpr = messageExpr.getArgumentExpressions().get(0);
            if (typeExpr instanceof OCSendMessageExpression && receiverElement != null) {
                OCSymbol symbol;
                OCReferenceElement typeElement;
                OCSendMessageExpression typeMessageExpr = (OCSendMessageExpression)typeExpr;
                OCExpression typeReceiver = typeMessageExpr.getReceiverExpression();
                if (typeMessageExpr.getMessageSelector().equals("class") && typeReceiver instanceof OCReferenceExpression && (typeElement = ((OCReferenceExpression)typeReceiver).getReferenceElement()) != null && (symbol = receiverElement.resolveToSymbol()) != null) {
                    return new InstanceOf((OCReferenceExpression)receiver, symbol, OCPointerType.to(OCReferenceType.resolvedFromText(typeElement.getName(), expression)));
                }
            }
        }
        return null;
    }

    @NotNull
    public static Pair<Set<PsiElement>, OCControlFlowGraph> getNotUsedWrites(@NotNull OCCallable callable) {
        if (callable == null) {
            OCDFAUtils.$$$reportNull$$$0(6);
        }
        OCControlFlowGraph graph = new OCControlFlowGraph(callable, null);
        OCControlFlowBuilder builder = new OCControlFlowBuilder(null, graph, null);
        builder.processFirstCodeFragment(callable);
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        for (OCSymbol symbol : graph.getLocalSymbols()) {
            OCNotUsedValueChecker notUsedChecker = new OCNotUsedValueChecker(graph, symbol){

                @Override
                protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
                    PsiElement element;
                    if (instruction == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((element = instruction.getRValue()) instanceof OCReferenceExpression && this.isGoodParent(element)) {
                        return super.isStartInstruction(instruction);
                    }
                    return false;
                }

                @Override
                protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return true;
                }

                @Override
                protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return instruction.getRValue();
                }

                private boolean isGoodParent(PsiElement element) {
                    OCElementType sign;
                    PsiElement parent = element.getParent();
                    if (parent instanceof OCCastExpression) {
                        return true;
                    }
                    if (parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getSourceExpression() == element) {
                        return true;
                    }
                    if (parent instanceof OCIfStatement && ((OCIfStatement)parent).getCondition() == element) {
                        return true;
                    }
                    if (parent instanceof OCSwitchStatement && ((OCSwitchStatement)parent).getExpression() == element) {
                        return true;
                    }
                    if (parent instanceof OCCondition || parent instanceof OCExpression && OCDFAUtils.getInstanceofPair((OCExpression)parent) != null) {
                        return this.isGoodParent(parent);
                    }
                    if (parent instanceof OCSendMessageExpression || parent instanceof OCQualifiedExpression || parent instanceof OCArraySelectionExpression) {
                        return true;
                    }
                    if (parent instanceof OCUnaryExpression) {
                        OCElementType sign2 = ((OCUnaryExpression)parent).getOperationSign();
                        if (sign2 == OCTokenTypes.MUL) {
                            return true;
                        }
                        if (sign2 == OCTokenTypes.EXCL) {
                            return this.isGoodParent(parent);
                        }
                    } else if (parent instanceof OCBinaryExpression && ((sign = ((OCBinaryExpression)parent).getOperationSign()) == OCTokenTypes.EQEQ || sign == OCTokenTypes.EXCLEQ || sign == OCTokenTypes.ANDAND || sign == OCTokenTypes.OROR)) {
                        return this.isGoodParent(parent);
                    }
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "instruction";
                    objectArray2[1] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCDFAUtils$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isStartInstruction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "isEndInstruction";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getElementFromInstruction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            notUsedChecker.process();
            result.addAll(notUsedChecker.getNotUsedWrites());
        }
        Pair pair2 = Pair.create(result, (Object)graph);
        if (pair2 == null) {
            OCDFAUtils.$$$reportNull$$$0(7);
        }
        return pair2;
    }

    public static boolean areValuesUsed(@NotNull List<PsiElement> values, @NotNull Set<PsiElement> notUsedValues) {
        if (values == null) {
            OCDFAUtils.$$$reportNull$$$0(8);
        }
        if (notUsedValues == null) {
            OCDFAUtils.$$$reportNull$$$0(9);
        }
        for (PsiElement value : values) {
            if (notUsedValues.contains(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasGotos(@NotNull OCCallable callable) {
        if (callable == null) {
            OCDFAUtils.$$$reportNull$$$0(10);
        }
        final Ref hasGoto = Ref.create((Object)false);
        callable.accept(new OCRecursiveVisitor(){

            @Override
            public void visitGotoStatement(OCGotoStatement stmt) {
                hasGoto.set((Object)true);
            }
        });
        return (Boolean)hasGoto.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processed";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCDFAUtils";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notUsedValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/contextSensitive/OCDFAUtils";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotUsedWrites";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isGoodCallable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isPrivateCallable";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processTypeHierarchy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNotUsedWrites";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "areValuesUsed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasGotos";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTypeHierarchy$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class WorkingTimeMeasurer
    implements Disposable {
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        private volatile boolean myTimedOut = false;

        public WorkingTimeMeasurer(long timeoutInMilliseconds) {
            this.myAlarm.addRequest(() -> {
                this.myTimedOut = true;
            }, timeoutInMilliseconds);
        }

        public boolean isTimeOver() {
            return this.myTimedOut;
        }

        public void dispose() {
        }
    }

    public static class InstanceOf {
        OCReferenceExpression variable;
        OCSymbol symbol;
        OCType type;

        public InstanceOf(OCReferenceExpression variable, OCSymbol symbol, OCType type) {
            this.variable = variable;
            this.symbol = symbol;
            this.type = type;
        }
    }

    public static class DFAException
    extends RuntimeException {
        public DFAException(String message) {
            super(message);
        }
    }
}

