/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeFormatterFacade;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.documentation.DoxygenRender;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCategoryName;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCPolyVariantReference;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeParameterDeclaration;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrDocumentationProvider
implements DocumentationProvider {
    public static final String PSI_LINK_PREFIX_METHOD = "method,";
    @Nullable
    final ExternalProvider myExternalProvider;
    private Map<String, CodeStyleSettings> mySettings = new HashMap();

    public CidrDocumentationProvider() {
        this(null);
    }

    public CidrDocumentationProvider(@Nullable ExternalProvider provider2) {
        this.myExternalProvider = provider2;
    }

    @Nullable
    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        if (element == null) {
            return null;
        }
        String content = this.quickDocContent(element, originalElement, false);
        return content != null ? CidrDocumentationProvider.wrapDocInHtml(content) : null;
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        return null;
    }

    @Nullable
    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        String result;
        if (element == null) {
            return null;
        }
        if (element instanceof OCMethodSelectorPart) {
            element = element.getParent();
        }
        if (element instanceof OCSendMessageExpression && (result = CidrDocumentationProvider.methodCandidates((OCSendMessageExpression)element)) != null) {
            return result;
        }
        String doc = this.generateDocInnerHtml(element, originalElement, false);
        return doc == null ? null : CidrDocumentationProvider.wrapDocInHtml(doc);
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(@Nullable PsiManager psiManager, @Nullable Object object, @Nullable PsiElement element) {
        if (object instanceof OCSymbol && psiManager != null) {
            return ((OCSymbol)object).locateDefinition(psiManager.getProject());
        }
        return null;
    }

    @Nullable
    public PsiElement getDocumentationElementForLink(@Nullable PsiManager psiManager, @Nullable String link, @Nullable PsiElement context) {
        if (link == null || psiManager == null) {
            return null;
        }
        if (link.startsWith(PSI_LINK_PREFIX_METHOD)) {
            List parts = StringUtil.split((String)(link = link.substring(PSI_LINK_PREFIX_METHOD.length())), (String)",");
            if (parts.size() == 3) {
                PsiElement elementAt;
                PsiFile file;
                String path = (String)parts.get(1);
                String offset = (String)parts.get(2);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid() && (elementAt = file.findElementAt(Integer.parseInt(offset))) != null && elementAt.isValid()) {
                    return PsiTreeUtil.getParentOfType((PsiElement)elementAt, OCMethod.class, (boolean)false);
                }
            }
        } else {
            int idx = link.lastIndexOf(35);
            if (idx > -1) {
                PsiFile file;
                String path = link.substring(0, idx);
                String offset = link.substring(idx + 1);
                VirtualFile fileByPath = LocalFileSystem.getInstance().findFileByPath(path);
                if (fileByPath != null && fileByPath.isValid() && (file = psiManager.findFile(fileByPath)) != null && file.isValid()) {
                    int off = Integer.parseInt(offset);
                    PsiElement elementAt = file.findElementAt(off);
                    return TargetElementUtil.getInstance().getNamedElement(elementAt, off);
                }
            }
        }
        return null;
    }

    @Nullable
    private static String buildLinkForMethod(@NotNull OCMethodSymbol symbol) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(0);
        }
        StringBuilder sb = new StringBuilder("psi_element://").append(PSI_LINK_PREFIX_METHOD);
        sb.append(symbol.getName());
        VirtualFile file = symbol.getContainingFile();
        if (file != null) {
            sb.append(',').append(file.getPath()).append(',').append(symbol.getOffset());
            return sb.toString();
        }
        return null;
    }

    @Nullable
    private static String methodCandidates(@NotNull OCSendMessageExpression sme) {
        PsiReference reference;
        if (sme == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(1);
        }
        if ((reference = sme.getReference()) instanceof OCPolyVariantReference) {
            List list = ((OCPolyVariantReference)reference).resolveToSymbols();
            StringBuilder builder = new StringBuilder();
            for (Object o : list) {
                if (!(o instanceof OCMethodSymbol)) continue;
                OCMethodSymbol symbol = (OCMethodSymbol)o;
                OCClassSymbol parent = (OCClassSymbol)symbol.getParent();
                String link = CidrDocumentationProvider.buildLinkForMethod(symbol);
                if (link == null) continue;
                builder.append("<a href=\"").append(link).append("\">").append(symbol.getSignature(sme.getProject())).append(" (").append(parent.getPresentableName()).append(")</a><br>");
            }
            return CodeInsightBundle.message((String)"javadoc.candidates", (Object[])new Object[]{sme.getExpectedMethodSignature(), builder.toString()});
        }
        return null;
    }

    @Nullable
    protected String quickDocContent(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean fullDoc) {
        PsiElement resolved;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (originalElement != null && originalElement.getParent() instanceof OCReferenceElement) {
            originalElement = originalElement.getParent();
        }
        if ((resolved = CidrDocumentationProvider.resolveIfRequired(element)) == null) {
            return null;
        }
        element = resolved;
        Project project2 = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(element);
        if (element instanceof OCMethod) {
            return CidrDocumentationProvider.methodHintDoc((OCMethod)element);
        }
        if (element instanceof OCCppNamespace) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppNamespace)element).getSymbol();
            if (symbol instanceof OCNamespaceSymbol) {
                OCNamespaceSymbol namespaceSymbol = (OCNamespaceSymbol)symbol;
                if (namespaceSymbol.isInlineNamespace()) {
                    answer.append(OCTokenTypes.INLINE_KEYWORD.getName()).append(" ");
                }
                answer.append(symbol.getKindLowercase(context)).append(" ");
                String namespace = OCDocUtil.getNamespace(namespaceSymbol, context);
                if (!namespace.isEmpty()) {
                    answer.append(namespace).append("::");
                }
                return answer.append("<b>").append(symbol.getName()).append("</b>").toString();
            }
            return null;
        }
        if (element instanceof OCClassDeclaration) {
            OCFile file;
            OCInterfaceSymbol anInterface;
            StringBuilder answer = new StringBuilder();
            OCClassDeclaration cd = (OCClassDeclaration)element;
            OCObjectType type = cd.getType();
            if (type != null && (anInterface = type.getInterface()) != null && (file = anInterface.getContainingOCFile(project2)) != null) {
                answer.append(CidrDocumentationProvider.declaredInHint(file));
            }
            return answer.append(CidrDocumentationProvider.classHintDoc(cd)).toString();
        }
        if (element instanceof OCMethodSelectorPart) {
            StringBuilder answer = new StringBuilder();
            CidrDocumentationProvider.appendType(answer, ((OCMethodSelectorPart)element).getRawType(), ((OCMethodSelectorPart)element).getContainingOCFile(), true);
            answer.append(" <b>");
            answer.append(((OCMethodSelectorPart)element).getName());
            answer.append("</b>");
            return answer.toString();
        }
        if (element instanceof OCTypeParameterDeclaration) {
            return CidrDocumentationProvider.typeParameterHintDoc((OCTypeParameterDeclaration)element);
        }
        if (element instanceof OCCategoryName) {
            OCCategoryName category = (OCCategoryName)element;
            PsiElement parent = category.getParent();
            if (parent instanceof OCClassDeclaration) {
                OCClassDeclaration cd = (OCClassDeclaration)parent;
                return fullDoc ? this.generateDocInnerHtml(cd, originalElement, false) : this.quickDocContent(cd, originalElement, false);
            }
            return null;
        }
        if (element instanceof OCDeclarator) {
            PsiReference reference;
            OCDeclarator declarator = (OCDeclarator)element;
            OCSymbol symbol = null;
            PsiReference psiReference = reference = originalElement == null ? null : originalElement.getReference();
            if (reference instanceof OCReference) {
                symbol = ((OCReference)reference).resolveToSymbol();
            }
            if (symbol == null) {
                symbol = declarator.getSymbol();
            }
            return this.getSymbolDoc(element, symbol);
        }
        if (element instanceof OCSymbolHolderVirtualPsiElement) {
            List<OCFunctionSymbol> overloads;
            Object symbol = ((OCSymbolHolderVirtualPsiElement)element).getSymbol();
            if (symbol instanceof OCFunctionGroupSymbol && (overloads = ((OCFunctionGroupSymbol)symbol).getOverloads()).size() == 1) {
                symbol = overloads.get(0);
            }
            return this.getSymbolDoc(element, (OCSymbol)symbol);
        }
        if (element instanceof OCDefineDirective) {
            PsiFile file = element.getContainingFile();
            StringBuilder answer = new StringBuilder();
            answer.append(CidrDocumentationProvider.declaredInHint(file));
            OCMacroSymbol symbol = (OCMacroSymbol)((OCDefineDirective)element).getSymbol();
            if (symbol == null) {
                return "";
            }
            answer.append("#define <b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
            if (symbol.hasParameterList()) {
                answer.append('(');
                answer.append(StringUtil.join(symbol.getParameterNames(), name2 -> CidrDocumentationProvider.escapeHTML(name2), (String)", "));
                answer.append(')');
            }
            answer.append(" ").append(CidrDocumentationProvider.escapeHTML(symbol.getSubstitution()));
            return answer.toString();
        }
        if (element instanceof OCCppUsingStatement) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCSymbol symbol = ((OCCppUsingStatement)element).getSymbol();
            if (symbol instanceof OCAliasUsingSymbol) {
                answer.append("using <b>");
                answer.append(symbol.getName());
                answer.append("</b> = ");
                answer.append(CidrDocumentationProvider.effectiveTypeString(symbol, project2));
            }
            return answer.toString();
        }
        if (element instanceof OCCppNamespaceAlias) {
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            OCCppNamespaceAlias namespaceAliasElement = (OCCppNamespaceAlias)element;
            OCNamespaceAliasSymbol symbol = (OCNamespaceAliasSymbol)namespaceAliasElement.getSymbol();
            if (OCLog.LOG.assertTrue(symbol != null)) {
                OCSymbolKind kind = symbol.getKind();
                OCSymbolReference ref = symbol.getNamespaceReference();
                answer.append(kind.getNameLowercase()).append(" ");
                answer.append("<b>").append(symbol.getName()).append("</b> = ");
                answer.append(ref.getQualifiedName().getFullName(OCResolveContext.forPsi(element)));
            }
            return answer.toString();
        }
        if (element instanceof OCStructLike) {
            OCStructSymbol symbol = (OCStructSymbol)((OCStructLike)element).getSymbol();
            StringBuilder answer = new StringBuilder(CidrDocumentationProvider.declaredInHint(element.getContainingFile()));
            if (symbol == null) {
                return answer.toString();
            }
            CidrDocumentationProvider.addNamespace(symbol, answer, context);
            CidrDocumentationProvider.addVisibility(symbol, answer);
            String canonicalNamePrefix = CidrDocumentationProvider.getCanonicalNamePrefix(symbol, project2);
            String templateParamList = CidrDocumentationProvider.getTemplateParameters(symbol, project2);
            if (symbol.isPredeclaration()) {
                OCDocUtil.extractModifiers(symbol, answer);
            } else {
                answer.append(templateParamList);
            }
            answer.append(symbol.getKindLowercase(context)).append(" ");
            if (symbol.isEnumClass()) {
                answer.append("class ");
            }
            answer.append(canonicalNamePrefix).append("<b>").append(symbol.getName()).append("</b>");
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, project2);
            if (symbol.isFinal()) {
                answer.append(" ").append(OCTokenTypes.FINAL_CPP_KEYWORD.getName());
            }
            answer.append(CidrDocumentationProvider.getBaseClasses(symbol, element));
            return answer.toString().replaceAll("\\s+", " ");
        }
        OCFindUsagesProvider common = new OCFindUsagesProvider();
        if (common.canFindUsagesFor(element)) {
            return CidrDocumentationProvider.declaredInHint(element.getContainingFile()) + common.getType(element) + "  <b>" + common.getDescriptiveName(element) + "</b>";
        }
        return null;
    }

    @NotNull
    private String getSymbolDoc(@NotNull PsiElement element, OCSymbol symbol) {
        String type;
        OCClassDeclaration container;
        PsiElement pp;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(3);
        }
        StringBuilder answer = new StringBuilder();
        Project project2 = element.getProject();
        OCFile containingFile = symbol == null ? null : symbol.getContainingOCFile(project2);
        OCDeclarator declarator = (OCDeclarator)ObjectUtils.tryCast((Object)element, OCDeclarator.class);
        if (containingFile != null && symbol.getKind() != OCSymbolKind.LOCAL_VARIABLE) {
            answer.append(CidrDocumentationProvider.declaredInHint(containingFile));
        }
        if (symbol != null) {
            CidrDocumentationProvider.addNamespace(symbol, answer, OCResolveContext.forPsi(element));
            CidrDocumentationProvider.addVisibility(symbol, answer);
        }
        if ((pp = element.getParent().getParent()) instanceof OCProperty) {
            OCProperty property = (OCProperty)pp;
            String iVarDoc = this.propertyIVarDoc(property);
            if (iVarDoc != null) {
                String string = iVarDoc;
                if (string == null) {
                    CidrDocumentationProvider.$$$reportNull$$$0(4);
                }
                return string;
            }
            OCClassDeclaration container2 = property.getContainingClass();
            if (container2 != null) {
                answer.append(CidrDocumentationProvider.classHintDoc(container2)).append("<br>");
            }
            answer.append("@property ");
            OCPropertyAttributesList attrs = property.getPropertyAttributesList();
            if (attrs != null) {
                String attrsStr = StringUtil.join(attrs.getAttributes(), attribute -> attribute.getText(), (String)", ");
                answer.append("(").append(attrsStr).append(") ");
            }
        } else if (pp instanceof OCInstanceVariablesList && (container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCClassDeclaration.class})) != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        if (symbol != null) {
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                answer.append("ivar ");
            } else if (symbol.getKind() == OCSymbolKind.TYPEDEF) {
                answer.append("typedef ");
            }
        }
        if (symbol instanceof OCFunctionSymbol) {
            OCFunctionSymbol definition;
            OCFunctionSymbol func = (OCFunctionSymbol)symbol;
            if (func.isFriend() && (definition = (OCFunctionSymbol)func.getDefinitionSymbol(project2)) != null) {
                func = definition;
            }
            answer.append(CidrDocumentationProvider.getTemplateParameters(func, project2));
            OCDocUtil.extractModifiers(func, answer);
            if (!func.isCppConstructor() && !func.isCppDestructor()) {
                type = CidrDocumentationProvider.effectiveTypeString(func, project2);
                answer.append(type).append(OCDocUtil.delimiter(type));
            }
            answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(func, project2));
            answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(func.getName())).append("</b>");
            this.extractFunctionSignature(declarator, func, answer, project2);
        } else if (symbol instanceof OCDeclaratorSymbol) {
            answer.append(CidrDocumentationProvider.getTemplateParameters(symbol, project2));
            OCDocUtil.extractModifiers((OCDeclaratorSymbol)symbol, answer);
            boolean isEnumConst = symbol.getKind() == OCSymbolKind.ENUM_CONST;
            type = CidrDocumentationProvider.effectiveTypeString(symbol, project2);
            answer.append(type).append(OCDocUtil.delimiter(type, isEnumConst ? "::" : " "));
            if (!isEnumConst) {
                answer.append(CidrDocumentationProvider.getCanonicalNamePrefix(symbol, project2));
            }
            answer.append("<b>").append(CidrDocumentationProvider.escapeHTML(symbol.getName())).append("</b>");
        } else if (declarator != null) {
            CidrDocumentationProvider.appendType(answer, declarator.getRawType(), element.getContainingFile(), false);
            answer.append(" <b>");
            answer.append(declarator.getName());
            answer.append("</b>");
        }
        if (declarator != null) {
            this.processInitializer(declarator, answer);
        }
        String string = answer.toString();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static String getBaseClasses(@NotNull OCStructSymbol symbol, @NotNull PsiElement element) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(7);
        }
        Project project2 = element.getProject();
        OCResolveContext context = OCResolveContext.forPsi(element);
        Collection<Pair<OCType, OCVisibility>> baseClasses = symbol.getBaseCppClassesWithVisibility(context);
        if (!baseClasses.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, context);
            OCFile containingFile = symbol.getContainingOCFile(project2);
            String baseClassesStr = StringUtil.join(baseClasses, pair2 -> {
                OCVisibility visibility = (OCVisibility)((Object)((Object)pair2.getSecond()));
                String visibilityStr = "";
                if (visibility != null) {
                    visibilityStr = (Object)((Object)visibility) + " ";
                }
                OCType type = (OCType)pair2.getFirst();
                return visibilityStr + OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2);
            }, (String)", ");
            String string = " : " + baseClassesStr;
            if (string == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(8);
            }
            return string;
        }
        if ("" == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(9);
        }
        return "";
    }

    private void processInitializer(@NotNull OCDeclarator declarator, @NotNull StringBuilder answer) {
        OCExpression initializer;
        if (declarator == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(10);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(11);
        }
        if ((initializer = (declarator = this.cleanAndReformat(declarator, OCDeclarator.class)).getInitializer()) != null) {
            answer.append(" =");
        } else {
            initializer = declarator.getInitializerList();
        }
        if (initializer != null) {
            answer.append(" ");
            CidrDocumentationProvider.processExpressionElement(initializer, answer);
        } else {
            OCArgumentList args = declarator.getArgumentList();
            if (args != null) {
                CidrDocumentationProvider.processExpressionElement(args, answer);
            }
        }
    }

    private static void processExpressionElement(@NotNull OCElement initializer, @NotNull StringBuilder answer) {
        String text;
        int idx;
        if (initializer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(12);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(13);
        }
        if ((idx = (text = initializer.getTextWithMacros()).indexOf(10)) != -1) {
            String part = text.substring(0, idx).replaceAll("\\s+", " ");
            answer.append(CidrDocumentationProvider.escapeHTML(part)).append("...");
        } else {
            answer.append(CidrDocumentationProvider.escapeHTML(text));
        }
    }

    private void extractFunctionSignature(@Nullable OCDeclarator declarator, OCFunctionSymbol symbol, StringBuilder answer, Project project2) {
        Collection<OCTypeArgument> substitutionTypes;
        if (declarator != null) {
            declarator = this.cleanAndReformat(declarator, OCDeclarator.class);
        }
        if ((substitutionTypes = symbol.getSubstitution().getSubstitutedTypes()) != null && !substitutionTypes.isEmpty()) {
            answer.append(OCDocUtil.getParametersSignature(symbol, false, project2));
        } else {
            CidrDocumentationProvider.extractTemplateSpecialization(symbol, answer, project2);
            answer.append(OCDocUtil.getParametersSignature(symbol, true, project2));
        }
        OCDocUtil.extractFuncPostModifiers(symbol, answer);
        OCNoexceptSpecifier noexcept = (OCNoexceptSpecifier)PsiTreeUtil.findChildOfType((PsiElement)declarator, OCNoexceptSpecifier.class);
        if (noexcept != null) {
            CidrDocumentationProvider.processExpressionElement(noexcept, answer.append(" "));
        }
    }

    @NotNull
    private static String getTemplateParameters(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(15);
        }
        if (symbol instanceof OCTemplateSymbol && symbol instanceof OCSymbolWithQualifiedName) {
            StringBuilder sb = new StringBuilder();
            OCTemplateSymbol templateSymbol = (OCTemplateSymbol)symbol;
            if (templateSymbol.isTemplateSymbol()) {
                List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)((Object)templateSymbol), OCResolveContext.forSymbol(symbol, project2));
                OCFile containingFile = symbol.getContainingOCFile(project2);
                List<OCTypeParameterSymbol> templateParams = templateSymbol.getTemplateParameters();
                OCDocUtil.wrapTemplateParams(templateParams, contextNamespace, containingFile, sb, project2);
                String string = sb.append("<br>").toString();
                if (string == null) {
                    CidrDocumentationProvider.$$$reportNull$$$0(16);
                }
                return string;
            }
        }
        if ("" == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(17);
        }
        return "";
    }

    @NotNull
    private <T extends PsiElement> T cleanAndReformat(@NotNull OCElement element, Class<T> clazz) {
        Language language;
        CodeFormatterFacade formatterFacade;
        PsiElement result;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(18);
        }
        PsiElement copy = element.copy();
        final ArrayList comments = new ArrayList();
        copy.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            public void visitComment(PsiComment comment) {
                comments.add(comment);
            }
        });
        for (PsiElement comment : comments) {
            comment.delete();
        }
        if (SourceTreeToPsiMap.hasTreeElement((PsiElement)copy) && (result = SourceTreeToPsiMap.treeElementToPsi((ASTNode)(formatterFacade = new CodeFormatterFacade(this.getSettings(language = copy.getLanguage()), language)).processElement(SourceTreeToPsiMap.psiElementToTree((PsiElement)copy)))) != null) {
            PsiElement psiElement = result;
            if (psiElement == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(19);
            }
            return (T)psiElement;
        }
        PsiElement psiElement = copy;
        if (psiElement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(20);
        }
        return (T)psiElement;
    }

    private CodeStyleSettings getSettings(Language lang) {
        String langID = lang.getID();
        if (!this.mySettings.containsKey(langID)) {
            CodeStyleSettings settings = new CodeStyleSettings();
            settings.getCommonSettings((Language)lang).KEEP_LINE_BREAKS = true;
            settings.getCommonSettings((Language)lang).SPACE_WITHIN_BRACES = true;
            ((OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)).DO_NOT_ADD_BREAKS = true;
            this.mySettings.put(langID, settings);
        }
        return this.mySettings.get(langID);
    }

    private static void extractTemplateSpecialization(@NotNull OCSymbolWithQualifiedName symbol, @NotNull StringBuilder sb, @NotNull Project project2) {
        List<OCTypeArgument> specialization;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(21);
        }
        if (sb == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(22);
        }
        if (project2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(23);
        }
        if (symbol instanceof OCTemplateSymbol && (specialization = ((OCTemplateSymbol)((Object)symbol)).getTemplateSpecialization()) != null && !specialization.isEmpty()) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents(symbol, OCResolveContext.forSymbol(symbol, project2));
            OCFile containingFile = symbol.getContainingOCFile(project2);
            OCDocUtil.wrapTemplateArgs(specialization, contextNamespace, containingFile, sb, project2);
        }
    }

    private static void addNamespace(@NotNull OCSymbol symbol, @NotNull StringBuilder answer, @NotNull OCResolveContext context) {
        String namespace;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(24);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(25);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(26);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER && (namespace = OCDocUtil.getNamespace((OCSymbolWithQualifiedName)symbol, context)).length() > 0) {
            answer.append("namespace ").append(namespace).append("<br><br>");
        }
    }

    private static void addVisibility(@NotNull OCSymbol symbol, @NotNull StringBuilder answer) {
        OCVisibility visibility;
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(27);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(28);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && (visibility = ((OCSymbolWithQualifiedName)symbol).getVisibility()) != null && visibility != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC) {
            answer.append(visibility.toString()).append(":<br>");
        }
    }

    @NotNull
    private static String getCanonicalNamePrefix(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(29);
        }
        if (project2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(30);
        }
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() != OCSymbolKind.PARAMETER) {
            String prefix = OCDocUtil.getCanonicalPrefix((OCSymbolWithQualifiedName)symbol, project2);
            String string = prefix.length() > 0 ? prefix + "::" : "";
            if (string == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(31);
            }
            return string;
        }
        if ("" == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(32);
        }
        return "";
    }

    @NotNull
    private static String effectiveTypeString(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(33);
        }
        if (project2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(34);
        }
        OCFile containingFile = symbol.getContainingOCFile(project2);
        OCType effectiveType = symbol.getEffectiveType();
        OCType type = effectiveType.accept(new OCTypeParameterResolveVisitor(containingFile));
        if (type instanceof OCUnknownType || type instanceof OCMagicType) {
            type = effectiveType;
        }
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        if (symbol instanceof OCSymbolWithQualifiedName) {
            List<OCSymbolWithQualifiedName> contextNamespace = OCDocUtil.getParents((OCSymbolWithQualifiedName)symbol, context);
            String string = OCDocUtil.replaceAnonymous(OCDocUtil.getCanonicalName(type, contextNamespace, containingFile, project2));
            if (string == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(35);
            }
            return string;
        }
        String string = OCDocUtil.replaceAnonymous(CidrDocumentationProvider.escapeHTML(type.getBestNameInContext(context)));
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(36);
        }
        return string;
    }

    @Nullable
    private String propertyIVarDoc(@NotNull OCProperty p) {
        PsiElement iVar;
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(37);
        }
        if ((iVar = CidrDocumentationProvider.getPropertyIVar(p)) != null) {
            return this.generateDocInnerHtml(iVar, null, true);
        }
        return null;
    }

    @Nullable
    private static PsiElement getPropertyIVar(@NotNull OCProperty p) {
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(38);
        }
        OCPropertySymbol ps = CidrDocumentationProvider.getPropertySymbol(p);
        OCInstanceVariableSymbol iVar = null;
        Project project2 = p.getProject();
        if (ps != null) {
            iVar = ps.getAssociatedIvar(project2);
        }
        return iVar == null ? null : (PsiElement)iVar.locateDefinition(project2);
    }

    @Nullable
    private static OCPropertySymbol getPropertySymbol(@NotNull OCProperty p) {
        OCDeclaration pd;
        if (p == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(39);
        }
        if ((pd = p.getDeclaration()) == null) {
            return null;
        }
        List<OCDeclarator> ds = pd.getDeclarators();
        if (ds.size() == 0) {
            return null;
        }
        OCSymbol s = ds.get(0).getSymbol();
        return s instanceof OCPropertySymbol ? (OCPropertySymbol)s : null;
    }

    @NotNull
    private static String declaredInHint(@NotNull PsiFile file) {
        if (file == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(40);
        }
        String string = CidrDocumentationProvider.declaredInHint(file.getName());
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    public static String declaredInHint(@NotNull String fileName) {
        if (fileName == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(42);
        }
        String string = "<b>Declared In:</b> " + fileName + "<br><br>";
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Nullable
    private static PsiElement resolveIfRequired(@NotNull PsiElement element) {
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(44);
        }
        Project project2 = element.getProject();
        if (element instanceof OCReferenceElement) {
            OCPropertySymbol property;
            OCSymbol syntheticSymbol = ((OCReferenceElement)element).resolveToSymbol();
            if (syntheticSymbol instanceof OCInstanceVariableSymbol) {
                OCPropertySymbol property2 = ((OCInstanceVariableSymbol)syntheticSymbol).getAssociatedProperty(project2);
                if (property2 != null) {
                    return property2.locateDefinition(project2);
                }
            } else if (syntheticSymbol instanceof OCMethodSymbol && (property = ((OCMethodSymbol)syntheticSymbol).getGeneratedFromProperty()) != null) {
                return property.locateDefinition(project2);
            }
        }
        return element;
    }

    @Nullable
    private static String typeParameterHintDoc(@NotNull OCTypeParameterDeclaration type) {
        if (type == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(45);
        }
        return type.getText();
    }

    @NotNull
    private static String classHintDoc(@NotNull OCClassDeclaration classDeclaration) {
        if (classDeclaration == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(46);
        }
        String string = (classDeclaration instanceof OCProtocol ? "protocol " : "class ") + classDeclaration.getName();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private static String methodHintDoc(@NotNull OCMethod method) {
        if (method == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(48);
        }
        StringBuilder answer = new StringBuilder();
        OCClassDeclaration container = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{OCClassDeclaration.class});
        if (container != null) {
            answer.append(CidrDocumentationProvider.classHintDoc(container)).append("<br>");
        }
        answer.append(method.isInstanceMethod() ? (char)'-' : '+').append(" ");
        CidrDocumentationProvider.appendType(answer, method.getRawReturnType(), method.getContainingFile(), true);
        for (OCMethodSelectorPart part : method.getParameters()) {
            String parameterName;
            answer.append("<b>");
            answer.append(part.getSelectorPart());
            answer.append("</b>");
            OCType type = part.getRawType();
            if (type != OCUnknownType.INSTANCE) {
                CidrDocumentationProvider.appendType(answer, type, method.getContainingFile(), true);
            }
            if ((parameterName = part.getParameterName()) != null) {
                answer.append(parameterName);
            }
            answer.append(" ");
        }
        String string = answer.toString();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(49);
        }
        return string;
    }

    private static void appendType(@NotNull StringBuilder answer, @NotNull OCType type, @NotNull PsiFile context, boolean requiresParens) {
        boolean needParens;
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(50);
        }
        if (type == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(51);
        }
        if (context == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(52);
        }
        String typeText = type.accept(new OCTypeParameterResolveVisitor(context)).getName();
        boolean bl = needParens = requiresParens && !typeText.startsWith("(");
        if (needParens) {
            answer.append("(");
        }
        answer.append(CidrDocumentationProvider.escapeHTML(typeText));
        if (needParens) {
            answer.append(")");
        }
    }

    @Nullable
    public String generateDocInnerHtml(@NotNull PsiElement element, @Nullable PsiElement originalElement, boolean skipQuickDoc) {
        boolean isExternalDocProvided;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(53);
        }
        StringBuilder answer = new StringBuilder();
        if (this.myExternalProvider != null) {
            this.myExternalProvider.addExternalDoc(element, originalElement, answer);
        }
        boolean bl = isExternalDocProvided = answer.length() > 0;
        if (element instanceof PsiFile && !isExternalDocProvided) {
            return null;
        }
        if (element instanceof OCDefineDirective) {
            this.addMacroDoc(originalElement, answer, (OCDefineDirective)element);
        }
        if (!skipQuickDoc && answer.length() == 0) {
            this.addQuickDoc(element, originalElement, answer);
        }
        if (!isExternalDocProvided) {
            this.addCommentDoc(element, answer);
        }
        if (!isExternalDocProvided && element instanceof PsiNamedElement) {
            CidrDocumentationProvider.addManDoc(answer, (PsiNamedElement)element);
        }
        return answer.length() == 0 ? null : answer.toString();
    }

    private void addQuickDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement, @NotNull StringBuilder answer) {
        String quickDoc;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(54);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(55);
        }
        if ((quickDoc = this.quickDocContent(element, originalElement, true)) != null) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            answer.append("<code>").append(quickDoc).append("</code>");
        }
    }

    private static void addManDoc(@NotNull StringBuilder answer, @NotNull PsiNamedElement namedElement) {
        PsiFile psiFile;
        VirtualFile vFile;
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(56);
        }
        if (namedElement == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(57);
        }
        VirtualFile virtualFile = vFile = (psiFile = namedElement.getContainingFile()) != null ? psiFile.getVirtualFile() : null;
        if (vFile == null || !vFile.getPath().contains("/usr/include/")) {
            return;
        }
        String name2 = namedElement.getName();
        if (name2 == null) {
            return;
        }
        String man = CidrDocumentationProvider.getManPage(name2);
        if (man != null && man.length() > 0) {
            CidrDocumentationProvider.addBreakIfRequired(answer);
            if (answer.length() > 0) {
                answer.append("<br>");
            }
            answer.append(CidrDocumentationProvider.man2html(man));
        }
    }

    private void addMacroDoc(@Nullable PsiElement originalElement, @NotNull StringBuilder answer, @NotNull OCDefineDirective define) {
        PsiFile file;
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(58);
        }
        if (define == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(59);
        }
        CidrDocumentationProvider.addBreakIfRequired(answer);
        if (answer.length() == 0 && (file = define.getContainingFile()) != null) {
            answer.append(CidrDocumentationProvider.declaredInHint(file));
        }
        answer.append("<b>Definition:</b><br><br><tt><pre>");
        String defineText = this.cleanAndReformat(define, OCDefineDirective.class).getTextWithMacros().replaceAll("\\s+\\\\", "");
        answer.append(CidrDocumentationProvider.escapeHTML(defineText));
        answer.append("</pre></tt><br>");
        OCMacroCall call = (OCMacroCall)PsiTreeUtil.getContextOfType((PsiElement)originalElement, (Class[])new Class[]{OCMacroCall.class});
        if (call != null) {
            answer.append("<b>Replacement:</b><br><br> <tt><pre>");
            answer.append(CidrDocumentationProvider.escapeHTML(call.getReplacementText()));
            answer.append("</pre></tt>");
        }
    }

    @NotNull
    protected static String escapeHTML(@NotNull String text) {
        if (text == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(60);
        }
        String string = StringUtil.escapeXml((String)text);
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(61);
        }
        return string;
    }

    private static void addBreakIfRequired(@NotNull StringBuilder answer) {
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(62);
        }
        if (answer.length() > 0) {
            answer.append("<br>");
        }
    }

    @Nullable
    private static String getManPage(@NotNull String name2) {
        if (name2 == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(63);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("man");
        cl.addParameter("-S");
        cl.addParameter("2:3");
        cl.addParameter(name2);
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            CapturingProcessHandler handler = new CapturingProcessHandler(cl);
            ProcessOutput result = handler.runProcess(1000);
            if (result.isTimeout()) {
                return null;
            }
            return result.getStdout().trim();
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    @NotNull
    private static String man2html(@NotNull String man) {
        if (man == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(64);
        }
        StringBuilder a = new StringBuilder();
        a.append("<pre>");
        boolean wasBold = false;
        boolean wasUnderscored = false;
        for (int i = 0; i < man.length(); ++i) {
            boolean bold;
            char c = man.charAt(i);
            char next = i + 1 < man.length() ? man.charAt(i + 1) : (char)'\u0000';
            boolean underscored = c == '_' && next == '\b';
            boolean bl = bold = c != '_' && next == '\b';
            if (!bold && wasBold) {
                wasBold = false;
                a.append("</b>");
            }
            if (!underscored && wasUnderscored) {
                wasUnderscored = false;
                a.append("</u>");
            }
            if (!bold && !underscored) {
                CidrDocumentationProvider.appendSymbol(a, c);
                continue;
            }
            if (bold && !wasBold) {
                a.append("<b>");
                wasBold = true;
            }
            if (underscored && !wasUnderscored) {
                a.append("<u>");
                wasUnderscored = true;
            }
            CidrDocumentationProvider.appendSymbol(a, man.charAt(i + 2));
            i += 2;
        }
        a.append("</pre>");
        String string = a.toString();
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(65);
        }
        return string;
    }

    private static void appendSymbol(@NotNull StringBuilder a, char c) {
        if (a == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(66);
        }
        switch (c) {
            case ' ': {
                a.append("&nbsp;");
                break;
            }
            case '\t': {
                a.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                break;
            }
            case '<': {
                a.append("&lt;");
                break;
            }
            case '>': {
                a.append("&gt;");
                break;
            }
            case '\"': {
                a.append("&quot;");
                break;
            }
            default: {
                a.append(c);
            }
        }
    }

    @NotNull
    public static String wrapDocInHtml(@NotNull String doc) {
        if (doc == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(67);
        }
        String string = "<html><head><style type=\"text/css\">p { margin-bottom: 5px; }</style></head><body>" + doc + "</body></html>";
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(68);
        }
        return string;
    }

    private void addCommentDoc(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        boolean added;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(69);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(70);
        }
        if (!(added = this.addCommentDocForElement(element, answer))) {
            List<OCSymbolWithParent> elements = OCDocUtil.getSuperSymbols(element);
            for (OCSymbolWithParent s : elements) {
                int pos = answer.length();
                Object psiElement = s.locateDefinition(element.getProject());
                if (psiElement == null) continue;
                if (psiElement instanceof OCDeclarator) {
                    psiElement = psiElement.getParent();
                }
                if (!this.addCommentDocForElement((PsiElement)psiElement, answer)) continue;
                answer.insert(pos, "<br><br><b>Description copied from: </b>" + OCDocUtil.getLink(s));
                break;
            }
        }
    }

    private boolean addCommentDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(71);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(72);
        }
        int length = answer.length();
        DoxygenRender dxRender = new DoxygenRender(element);
        if (dxRender.hasDoxygenComments()) {
            dxRender.render(answer);
        } else {
            this.addDocForElement(element, answer);
        }
        return answer.length() > length;
    }

    protected void addDocForElement(@NotNull PsiElement element, @NotNull StringBuilder answer) {
        String data;
        if (element == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(73);
        }
        if (answer == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(74);
        }
        ArrayList<String> content = new ArrayList<String>();
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        for (PsiComment comment : this.findCommentsFor(element)) {
            IElementType type = comment.getTokenType();
            comments.add(comment);
            if (type == OCTokenTypes.EOL_COMMENT) continue;
            content.add(this.processComments(comments));
            comments.clear();
        }
        if (!comments.isEmpty()) {
            content.add(this.processComments(comments));
        }
        if (!StringUtil.isEmptyOrSpaces((String)(data = StringUtil.join(content, (String)"\n")))) {
            answer.append("<pre>").append(data).append("</pre>");
        }
    }

    @NotNull
    private String processComments(@NotNull List<PsiComment> comments) {
        if (comments == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(75);
        }
        int commonPaddingIdx = 0x3FFFFFFF;
        ArrayList content = new ArrayList();
        for (PsiComment comment : comments) {
            String text = CidrDocumentationProvider.escapeHTML(this.stripCommentBegin(comment.getText()));
            List lines = StringUtil.split((String)text, (String)"\n", (boolean)true, (boolean)false);
            assert (lines.size() > 0);
            String fistLine = (String)lines.get(0);
            if (!fistLine.isEmpty()) {
                lines.set(0, "  " + fistLine);
            }
            for (String line : lines) {
                int padding = CidrDocumentationProvider.indent(line, comment.getTokenType() != OCTokenTypes.EOL_COMMENT);
                if (padding >= commonPaddingIdx) continue;
                commonPaddingIdx = padding;
            }
            content.addAll(lines);
        }
        int padding = commonPaddingIdx;
        List result = content.stream().map(s -> s.substring(Math.min(s.length(), padding))).collect(Collectors.toList());
        String string = StringUtil.join(result, (String)"\n");
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(76);
        }
        return string;
    }

    private static int indent(@NotNull String line, boolean processAsterisk) {
        int i;
        if (line == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(77);
        }
        if (line.isEmpty()) {
            return 0x3FFFFFFF;
        }
        for (i = 0; i < line.length(); ++i) {
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (!processAsterisk || ch != '*') break;
            processAsterisk = false;
        }
        return i < line.length() ? i : 0x3FFFFFFF;
    }

    @NotNull
    protected String stripCommentBegin(@NotNull String text) {
        if (text == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(78);
        }
        if (text.startsWith("/*") || text.startsWith("//")) {
            text = text.substring(2);
        }
        text = StringUtil.trimEnd((String)text, (String)"*/");
        String string = text = StringUtil.trimTrailing((String)text, (char)' ');
        if (string == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(79);
        }
        return string;
    }

    @NotNull
    protected List<PsiComment> findCommentsFor(@Nullable PsiElement element) {
        List<PsiComment> comments = this.findOCCommentFor(element);
        if (comments.size() == 0 && element instanceof OCSymbolDeclarator) {
            Object associatedElement;
            Object symbol = ((OCSymbolDeclarator)element).getSymbol();
            Project project2 = element.getProject();
            if (symbol != null) {
                symbol = symbol.getAssociatedSymbol(project2);
            }
            if (symbol != null && (associatedElement = symbol.locateDefinition(project2)) != null) {
                comments = this.findOCCommentFor((PsiElement)associatedElement);
            }
        }
        List<PsiComment> list = comments;
        if (list == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(80);
        }
        return list;
    }

    protected boolean acceptDocComment(@NotNull PsiComment comment) {
        if (comment == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(81);
        }
        return !DoxygenFacade.isDoxygenSupported() || !DoxygenFacade.isDoxygenComment(comment);
    }

    @NotNull
    private List<PsiComment> findOCCommentFor(@Nullable PsiElement elt) {
        if (elt instanceof OCDeclarator) {
            elt = elt.getParent();
        }
        if (elt instanceof OCStructLike) {
            elt = PsiTreeUtil.findFirstParent((PsiElement)elt, p -> p instanceof OCDeclaration);
        }
        if (elt == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(82);
            }
            return list;
        }
        if (elt.getParent() instanceof OCProperty) {
            elt = elt.getParent();
        }
        if (elt.getParent() instanceof OCDeclarationStatement) {
            elt = elt.getParent();
        }
        if (elt.getContainingFile() == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                CidrDocumentationProvider.$$$reportNull$$$0(83);
            }
            return list;
        }
        LinkedList<PsiComment> comments = new LinkedList<PsiComment>();
        this.findPrevComments(elt, comments);
        this.findInnerComments(elt, comments);
        this.findPostComments(elt, comments);
        LinkedList<PsiComment> linkedList = comments;
        if (linkedList == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(84);
        }
        return linkedList;
    }

    protected void findPrevComments(@NotNull PsiElement elt, @NotNull List<PsiComment> comments) {
        if (elt == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(85);
        }
        if (comments == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(86);
        }
        for (PsiElement element = elt.getPrevSibling(); element != null; element = element.getPrevSibling()) {
            PsiComment c;
            PsiElement prevSibling;
            if (element instanceof OCMacroCall || element instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)element.getText()) <= 1) continue;
            if (!(element instanceof PsiComment) || (prevSibling = element.getPrevSibling()) != null && (!(prevSibling instanceof PsiWhiteSpace) || StringUtil.countNewLines((CharSequence)prevSibling.getText()) <= 0) || !this.acceptDocComment(c = (PsiComment)element)) break;
            comments.add(0, c);
        }
    }

    protected void findInnerComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        if (elt == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(87);
        }
        Iterator iterator = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)elt, PsiComment.class).iterator();
        while (iterator.hasNext() && this.acceptDocComment(c = (PsiComment)iterator.next())) {
            comments.add(c);
        }
    }

    protected void findPostComments(@NotNull PsiElement elt, List<PsiComment> comments) {
        PsiComment c;
        PsiElement next;
        if (elt == null) {
            CidrDocumentationProvider.$$$reportNull$$$0(88);
        }
        for (next = elt.getNextSibling(); next != null && (next instanceof PsiWhiteSpace && !next.getText().contains("\n") || next instanceof LeafElement && ((LeafElement)next).getElementType() == OCTokenTypes.SEMICOLON); next = next.getNextSibling()) {
        }
        if (next instanceof PsiComment && this.acceptDocComment(c = (PsiComment)next)) {
            comments.add(c);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 49: 
            case 61: 
            case 65: 
            case 68: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 49: 
            case 61: 
            case 65: 
            case 68: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sme";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 18: 
            case 44: 
            case 53: 
            case 54: 
            case 69: 
            case 71: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 49: 
            case 61: 
            case 65: 
            case 68: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 11: 
            case 13: 
            case 25: 
            case 28: 
            case 50: 
            case 55: 
            case 56: 
            case 58: 
            case 62: 
            case 70: 
            case 72: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 15: 
            case 23: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 26: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 45: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 60: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "man";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 75: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 85: 
            case 87: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/documentation/CidrDocumentationProvider";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSymbolDoc";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseClasses";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateParameters";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanAndReformat";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalNamePrefix";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "effectiveTypeString";
                break;
            }
            case 41: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "declaredInHint";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "classHintDoc";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "methodHintDoc";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeHTML";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "man2html";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapDocInHtml";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "processComments";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "stripCommentBegin";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommentsFor";
                break;
            }
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "findOCCommentFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLinkForMethod";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "methodCandidates";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "quickDocContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolDoc";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 49: 
            case 61: 
            case 65: 
            case 68: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getBaseClasses";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processInitializer";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processExpressionElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateParameters";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cleanAndReformat";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "extractTemplateSpecialization";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addNamespace";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addVisibility";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalNamePrefix";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "effectiveTypeString";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "propertyIVarDoc";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIVar";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getPropertySymbol";
                break;
            }
            case 40: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "declaredInHint";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "resolveIfRequired";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "typeParameterHintDoc";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "classHintDoc";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "methodHintDoc";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "appendType";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "generateDocInnerHtml";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "addQuickDoc";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addManDoc";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "addMacroDoc";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "escapeHTML";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addBreakIfRequired";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getManPage";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "man2html";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "appendSymbol";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "wrapDocInHtml";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "addCommentDoc";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "addCommentDocForElement";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "addDocForElement";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "processComments";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "stripCommentBegin";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "acceptDocComment";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "findPrevComments";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "findInnerComments";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "findPostComments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 31: 
            case 32: 
            case 35: 
            case 36: 
            case 41: 
            case 43: 
            case 47: 
            case 49: 
            case 61: 
            case 65: 
            case 68: 
            case 76: 
            case 79: 
            case 80: 
            case 82: 
            case 83: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ExternalProvider {
        public void addExternalDoc(@NotNull PsiElement var1, @Nullable PsiElement var2, @NotNull StringBuilder var3);
    }
}

