/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.documentation.HtmlHelper;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoxygenRender {
    private static Map<String, String> TAG_TABLE = new HashMap();
    private static final Map<String, String> formattingTags;
    @Nullable
    private final DoxygenCommentGroup docComment;

    private static String replaceFormattingTags(@NotNull String text) {
        if (text == null) {
            DoxygenRender.$$$reportNull$$$0(0);
        }
        Pattern p = Pattern.compile("(\\\\|@)(a|b|c|e|em|p)\\s+([^\\\\@&&[\\S]]+)");
        Matcher m = p.matcher(text);
        String result = text;
        while (m.find()) {
            String tag = m.group(2);
            String htmlTag = formattingTags.get(tag);
            String replacement = " <" + htmlTag + ">$3</" + htmlTag + ">";
            result = text.replaceFirst(p.pattern(), replacement);
        }
        return text.equals(result) ? result : DoxygenRender.replaceFormattingTags(result);
    }

    @NotNull
    private static String extractName(@NotNull String name2) {
        if (name2 == null) {
            DoxygenRender.$$$reportNull$$$0(1);
        }
        if (TAG_TABLE.containsKey(name2)) {
            String string = TAG_TABLE.get(name2);
            if (string == null) {
                DoxygenRender.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (!name2.isEmpty()) {
            String string = name2.substring(0, 1).toUpperCase(Locale.ENGLISH) + name2.substring(1);
            if (string == null) {
                DoxygenRender.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            DoxygenRender.$$$reportNull$$$0(4);
        }
        return string;
    }

    public DoxygenRender(@NotNull PsiElement element) {
        if (element == null) {
            DoxygenRender.$$$reportNull$$$0(5);
        }
        this.docComment = DoxygenFacade.getCommentGroup(element);
    }

    public boolean hasDoxygenComments() {
        return this.docComment != null && !this.docComment.isEmpty();
    }

    public void render(@NotNull StringBuilder answer) {
        InfoItem item;
        if (answer == null) {
            DoxygenRender.$$$reportNull$$$0(6);
        }
        if (this.docComment == null) {
            return;
        }
        HtmlHelper.HtmlDoc html = new HtmlHelper.HtmlDoc();
        List<InfoItem> content = this.docComment.getContent();
        boolean containsHeader = false;
        StringBuilder buff = new StringBuilder();
        String options = this.docComment.getOptions();
        if (!options.isEmpty()) {
            buff.append(HtmlHelper.code(options));
        }
        if (!content.isEmpty() && !((item = content.get(0)) instanceof TagItem)) {
            containsHeader = true;
            String text = DoxygenRender.replaceFormattingTags(item.getDescription());
            if (buff.length() > 0 && !text.isEmpty()) {
                buff.append(" ");
            }
            buff.append(text);
        }
        if (buff.length() > 0) {
            html.addText(HtmlHelper.paragraph(buff.toString()));
        }
        List<InfoItem> items = DoxygenRender.squash(containsHeader ? content.subList(1, content.size()) : content);
        for (InfoItem item2 : items) {
            if (item2 instanceof CompositeInfoItem) {
                DoxygenRender.renderCompositeItem(answer, html, (CompositeInfoItem)item2);
                continue;
            }
            DoxygenRender.renderSimpleElement(item2, html);
        }
        answer.append(html.toString());
    }

    private static void renderSimpleElement(@NotNull InfoItem item, @NotNull HtmlHelper.HtmlDoc html) {
        if (item == null) {
            DoxygenRender.$$$reportNull$$$0(7);
        }
        if (html == null) {
            DoxygenRender.$$$reportNull$$$0(8);
        }
        html.addText(HtmlHelper.paragraph(DoxygenRender.replaceFormattingTags(item.getDescription())));
    }

    private static void renderCompositeItem(@NotNull StringBuilder answer, @NotNull HtmlHelper.HtmlDoc html, @NotNull CompositeInfoItem item) {
        if (answer == null) {
            DoxygenRender.$$$reportNull$$$0(9);
        }
        if (html == null) {
            DoxygenRender.$$$reportNull$$$0(10);
        }
        if (item == null) {
            DoxygenRender.$$$reportNull$$$0(11);
        }
        String name2 = item.getName();
        if (DoxygenCmd.BRIEF.toString().equals(name2)) {
            for (TagItem tag : item.getTags()) {
                answer.append(HtmlHelper.newLine(DoxygenRender.replaceFormattingTags(tag.getDescription())));
            }
        } else if (DoxygenCmd.SURROUND_TAGS.containsKey(name2)) {
            for (TagItem tag : item.getTags()) {
                String description = tag.getDescription();
                html.addText(HtmlHelper.pre(HtmlHelper.code(description)));
            }
        } else {
            HtmlHelper.DL descriptionList = new HtmlHelper.DL();
            descriptionList.defineTerm(HtmlHelper.bold(DoxygenRender.extractName(name2)));
            HtmlHelper.Table table = new HtmlHelper.Table();
            for (TagItem tag : item.getTags()) {
                DoxygenRender.renderTagParams(tag, table);
            }
            descriptionList.detailedDescription(table);
            html.addItem(descriptionList);
        }
    }

    private static void renderTagParams(@NotNull TagItem tag, @NotNull HtmlHelper.Table table) {
        if (tag == null) {
            DoxygenRender.$$$reportNull$$$0(12);
        }
        if (table == null) {
            DoxygenRender.$$$reportNull$$$0(13);
        }
        HtmlHelper.TableRow row = HtmlHelper.TableRow.withData(HtmlHelper.code(tag.getOptions()));
        List<String> parameters = tag.getParameters();
        if (!parameters.isEmpty()) {
            row.addData(HtmlHelper.bold(StringUtil.join(parameters, (String)", ")));
        }
        StringBuilder content = new StringBuilder();
        for (InfoItem item : tag.getContent()) {
            String description = item.getDescription();
            String itemInfo = item instanceof TagItem && DoxygenCmd.SURROUND_TAGS.containsKey(((TagItem)item).getName()) ? HtmlHelper.pre(HtmlHelper.code(description)) : DoxygenRender.replaceFormattingTags(description);
            content.append(itemInfo);
        }
        row.addData(content.toString());
        table.addRow(row);
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items) {
        if (items == null) {
            DoxygenRender.$$$reportNull$$$0(14);
        }
        List<InfoItem> list = DoxygenRender.squash(items, 0, null);
        if (list == null) {
            DoxygenRender.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items, int position, @Nullable CompositeInfoItem compositeItem) {
        if (items == null) {
            DoxygenRender.$$$reportNull$$$0(16);
        }
        ArrayList<InfoItem> blocks = new ArrayList<InfoItem>();
        if (position < items.size()) {
            InfoItem item = items.get(position);
            if (item instanceof TagItem) {
                TagItem tag = (TagItem)item;
                String name2 = tag.getName();
                if (!DoxygenCmd.PARAM.toString().equals(name2) || !tag.getParameters().isEmpty()) {
                    if (compositeItem != null && name2.equals(compositeItem.getName())) {
                        compositeItem.addItem(tag);
                    } else {
                        compositeItem = new CompositeInfoItem(tag);
                        blocks.add(compositeItem);
                    }
                }
            } else {
                compositeItem = null;
                blocks.add(item);
            }
            List<InfoItem> result = DoxygenRender.squash(items, ++position, compositeItem);
            blocks.addAll(result);
        }
        ArrayList<InfoItem> arrayList = blocks;
        if (arrayList == null) {
            DoxygenRender.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    static {
        TAG_TABLE.put(DoxygenCmd.ATTENTION.toString(), "Attention");
        TAG_TABLE.put(DoxygenCmd.AUTHOR.toString(), "Author");
        TAG_TABLE.put(DoxygenCmd.AUTHORS.toString(), "Authors");
        TAG_TABLE.put(DoxygenCmd.BUG.toString(), "Bug");
        TAG_TABLE.put(DoxygenCmd.COPYRIGHT.toString(), "Copyright");
        TAG_TABLE.put(DoxygenCmd.DATE.toString(), "Date");
        TAG_TABLE.put(DoxygenCmd.DEPRECATED.toString(), "Deprecated");
        TAG_TABLE.put(DoxygenCmd.INVARIANT.toString(), "Invariant");
        TAG_TABLE.put(DoxygenCmd.PARAM.toString(), "Parameters");
        TAG_TABLE.put(DoxygenCmd.TPARAM.toString(), "Template Parameters");
        TAG_TABLE.put(DoxygenCmd.PRE.toString(), "Precondition");
        TAG_TABLE.put(DoxygenCmd.POST.toString(), "Postcondition");
        TAG_TABLE.put(DoxygenCmd.REMARK.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.REMARKS.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.SA.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SEE.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SINCE.toString(), "Since");
        TAG_TABLE.put(DoxygenCmd.TODO.toString(), "Todo");
        TAG_TABLE.put(DoxygenCmd.VERSION.toString(), "Version");
        TAG_TABLE.put(DoxygenCmd.WARNING.toString(), "Warning");
        TAG_TABLE.put(DoxygenCmd.RETURN.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETURNS.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RESULT.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETVAL.toString(), "Return values");
        TAG_TABLE.put(DoxygenCmd.THROW.toString(), "Exceptions");
        TAG_TABLE.put(DoxygenCmd.THROWS.toString(), "Exceptions");
        TAG_TABLE.put("exception", "Exceptions");
        formattingTags = new HashMap();
        formattingTags.put("a", "em");
        formattingTags.put("b", "b");
        formattingTags.put("c", "tt");
        formattingTags.put("e", "em");
        formattingTags.put("em", "em");
        formattingTags.put("p", "tt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/documentation/DoxygenRender";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/documentation/DoxygenRender";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "extractName";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceFormattingTags";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "renderSimpleElement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderCompositeItem";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "renderTagParams";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "squash";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompositeInfoItem
    implements InfoItem {
        private final String name;
        private final List<TagItem> tags;

        public CompositeInfoItem(@NotNull TagItem item) {
            if (item == null) {
                CompositeInfoItem.$$$reportNull$$$0(0);
            }
            this.tags = new ArrayList<TagItem>();
            this.name = item.getName();
            this.tags.add(item);
        }

        public String getName() {
            return this.name;
        }

        public List<TagItem> getTags() {
            return this.tags;
        }

        public void addItem(@NotNull TagItem item) {
            if (item == null) {
                CompositeInfoItem.$$$reportNull$$$0(1);
            }
            assert (this.name.equals(item.getName()));
            this.tags.add(item);
        }

        @Override
        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "item";
            objectArray2[1] = "com/jetbrains/cidr/lang/documentation/DoxygenRender$CompositeInfoItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

