/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterBetweenBracesNoCommitDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCEnterInDirectiveAndNoncompiledHandler
extends EnterHandlerDelegateAdapter {
    private static final TokenSet WHITE_SPACE_OR_COMMENT = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, OCTokenTypes.BLOCK_COMMENT, OCTokenTypes.EOL_COMMENT});

    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language;
        if (file == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            OCEnterInDirectiveAndNoncompiledHandler.$$$reportNull$$$0(4);
        }
        if (!((language = EnterHandler.getLanguage((DataContext)dataContext)) instanceof OCLanguage) || originalHandler == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        CharSequence documentChars = document.getCharsSequence();
        HighlighterIterator it = EnterBetweenBracesNoCommitDelegate.createBeforeIterator((EditorEx)((EditorEx)editor), (int)caretOffset);
        if (!it.atEnd() && WHITE_SPACE_OR_COMMENT.contains(it.getTokenType()) && !OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), Math.min(it.getEnd(), caretOffset))) {
            if (it.getTokenType() == OCTokenTypes.EOL_COMMENT) {
                return EnterHandlerDelegate.Result.Continue;
            }
            it.retreat();
        }
        while (!it.atEnd() && !OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
            it.retreat();
        }
        if (!it.atEnd()) {
            IElementType maybeDirectiveType;
            it.advance();
            IElementType iElementType = maybeDirectiveType = it.atEnd() ? null : it.getTokenType();
            if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(maybeDirectiveType)) {
                if (OCTokenTypes.END_IF_DIRECTIVES.contains(maybeDirectiveType)) {
                    it.retreat();
                    if (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE && OCLineIndentProvider.containsNewLine(documentChars, it.getStart(), it.getEnd())) {
                        int endOffset = it.getEnd();
                        String ordinalIndent = (String)OCMultilineNodeFormatter.splitIndent((String)documentChars.subSequence((int)it.getStart(), (int)it.getEnd()).toString()).second;
                        String newIndent = OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(it, file, false);
                        if (newIndent != null && !newIndent.equals(ordinalIndent)) {
                            document.replaceString(endOffset - ordinalIndent.length(), endOffset, (CharSequence)newIndent);
                            caretOffset += newIndent.length() - ordinalIndent.length();
                        }
                    }
                }
                Caret caret = editor.getCaretModel().getCurrentCaret();
                caret.moveToOffset(caretOffset);
                originalHandler.execute(editor, caret, dataContext);
                int indentNoCommit = EnterHandler.adjustLineIndentNoCommit((Language)language, (Document)document, (Editor)editor, (int)caret.getOffset());
                if (indentNoCommit >= 0) {
                    caret.moveToOffset(indentNoCommit);
                }
                caretOffsetRef.set((Object)caret.getOffset());
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/OCEnterInDirectiveAndNoncompiledHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

