/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;

public class OCEnterInStringHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Document document;
        CharSequence text;
        Language language;
        if (file == null) {
            OCEnterInStringHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCEnterInStringHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            OCEnterInStringHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            OCEnterInStringHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            OCEnterInStringHandler.$$$reportNull$$$0(4);
        }
        if (!((language = EnterHandler.getLanguage((DataContext)dataContext)) instanceof OCLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        Lexer lexer = OCLineIndentProvider.getLexerAtOffset(caretOffset, text = (document = editor.getDocument()).getCharsSequence());
        IElementType literalType = lexer.getTokenType();
        if (OCTokenTypes.ALL_STRINGS.contains(literalType) || literalType == OCTokenTypes.CHARACTER_LITERAL) {
            HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(caretOffset == 0 ? 0 : caretOffset - 1);
            IElementType tt = iterator.getTokenType();
            if (tt != OCHighlightingLexer.PREFIX_TYPE && (literalType == OCTokenTypes.RAW_STRING_LITERAL && caretOffset < lexer.getTokenEnd() || literalType == OCTokenTypes.WRONG_RAW_STRING_LITERAL)) {
                document.insertString(caretOffset, (CharSequence)"\n");
                editor.getCaretModel().moveToOffset(caretOffset + 1);
                return EnterHandlerDelegate.Result.Stop;
            }
            CharSequence literalText = text.subSequence(lexer.getTokenStart(), lexer.getTokenEnd());
            char lastLiteralChar = literalText.charAt(literalText.length() - 1);
            if (literalType == OCTokenTypes.CHARACTER_LITERAL && lastLiteralChar != '\'' || literalType == OCTokenTypes.STRING_LITERAL && lastLiteralChar != '\"' || caretOffset == lexer.getTokenEnd()) {
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
            if (tt == OCHighlightingLexer.PREFIX_TYPE || literalType == OCTokenTypes.CHARACTER_LITERAL) {
                int pos = lexer.getTokenStart();
                caretOffsetRef.set((Object)pos);
                caretAdvanceRef.set((Object)(caretOffset - pos));
                return EnterHandlerDelegate.Result.DefaultForceIndent;
            }
            if (StringEscapesTokenTypes.STRING_LITERAL_ESCAPES.contains(tt)) {
                caretOffset = iterator.getEnd();
            }
            int lineEnd = CharArrayUtil.shiftForwardUntil((CharSequence)text, (int)caretOffset, (String)"\n");
            if ((lineEnd = CharArrayUtil.shiftBackward((CharSequence)text, (int)(lineEnd - 1), (String)" \t")) <= lexer.getTokenEnd() && text.charAt(lineEnd) == '\\') {
                caretOffset = Math.min(caretOffset, lineEnd);
                document.insertString(caretOffset, (CharSequence)"\\\n");
                editor.getCaretModel().moveToOffset(caretOffset + 2);
                return EnterHandlerDelegate.Result.Stop;
            }
            document.insertString(caretOffset, (CharSequence)"\"\"");
            caretAdvanceRef.set((Object)1);
            caretOffsetRef.set((Object)(caretOffset + 1));
            return EnterHandlerDelegate.Result.DefaultForceIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/OCEnterInStringHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

