/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCArgumentListCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCCompoundInitializerCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallOption;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionCallPlace;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCFunctionParameterInfo;
import com.jetbrains.cidr.lang.editor.parameterInfo.OCParameterListCallPlace;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCDocUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionParameterInfoHandler
implements ParameterInfoHandler<PsiElement, FunctionInfoWrapper> {
    public static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.editor.OCFunctionParameterInfoHandler");
    private static final Condition<String> IS_UNNAMED = s -> "<unnamed>".equals(s);

    public boolean couldShowInLookup() {
        return true;
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        int startOffset;
        int offset;
        PsiFile file;
        OCFunctionCallPlace callPlace;
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(0);
        }
        if ((callPlace = OCFunctionParameterInfoHandler.findCallPlace(file = context.getFile(), offset = context.getOffset(), startOffset = context.getParameterListStart())) != null) {
            ArrayList<OCFunctionCallOption> callOptions = new ArrayList<OCFunctionCallOption>();
            callPlace.collectCallOptions(callOptions);
            Collections.sort(callOptions, (o1, o2) -> Comparing.compare((int)o1.getOffset(), (int)o2.getOffset()));
            ArrayList<FunctionInfoWrapper> overloads = new ArrayList<FunctionInfoWrapper>();
            OCResolveContext resolveContext = OCResolveContext.forNullablePsi((PsiElement)file, context.getProject());
            block0: for (OCFunctionCallOption option : callOptions) {
                OCFunctionParameterInfo info = option.getParameterInfo();
                OCFunctionType funcType = info.getType();
                for (int i = 0; i < overloads.size(); ++i) {
                    FunctionInfoWrapper other = (FunctionInfoWrapper)overloads.get(i);
                    OCFunctionType otherType = other.getInfo().getType();
                    if (!otherType.equalsAfterResolving(funcType, resolveContext)) continue;
                    if (!OCFunctionParameterInfoHandler.hasUnnamedParam(otherType) || OCFunctionParameterInfoHandler.hasUnnamedParam(funcType)) continue block0;
                    overloads.set(i, new FunctionInfoWrapper(info, resolveContext));
                    continue block0;
                }
                overloads.add(new FunctionInfoWrapper(info, resolveContext));
            }
            context.setItemsToShow(overloads.toArray());
        }
        return callPlace == null ? null : (PsiElement)callPlace.getElement();
    }

    private static boolean hasUnnamedParam(@NotNull OCFunctionType funcType) {
        List<String> names;
        if (funcType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if ((names = funcType.getParameterNames()) == null) {
            return funcType.getParameterTypes().size() > 0;
        }
        return ContainerUtil.find(names, IS_UNNAMED) != null;
    }

    @Nullable
    private static OCFunctionCallPlace findCallPlace(PsiFile file, int offset, int startOffset) {
        if (file == null) {
            return null;
        }
        if (startOffset == -1) {
            startOffset = offset;
        }
        PsiElement e1 = file.findElementAt(offset);
        PsiElement e2 = file.findElementAt(startOffset);
        if (e1 == null || e2 == null) {
            return null;
        }
        PsiElement element = PsiTreeUtil.findCommonContext((PsiElement)e1, (PsiElement)e2);
        if (element == null) {
            return null;
        }
        while (element != null) {
            OCFunctionCallPlace<? extends PsiElement> place = OCFunctionParameterInfoHandler.callPlace(element);
            if (place != null) {
                return place;
            }
            if (element instanceof OCBlockExpression || element instanceof OCLambdaExpression) {
                return null;
            }
            element = element.getContext();
        }
        return null;
    }

    @Nullable
    private static OCFunctionCallPlace<? extends PsiElement> callPlace(@NotNull PsiElement element) {
        if (element == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (element instanceof OCArgumentList) {
            return new OCArgumentListCallPlace((OCArgumentList)element);
        }
        if (!(element instanceof OCElement)) {
            return null;
        }
        if (!((OCElement)element).getContainingOCFile().isCpp()) {
            return null;
        }
        if (element instanceof OCParameterList) {
            return new OCParameterListCallPlace((OCParameterList)element);
        }
        if (element instanceof OCCompoundInitializer) {
            return new OCCompoundInitializerCallPlace((OCCompoundInitializer)element);
        }
        return null;
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(4);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.parameterInfo");
        context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        Object[] objectArray;
        Object object = item.getObject();
        if (object instanceof OCFunctionType) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = object;
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    public Object[] getParametersForDocumentation(FunctionInfoWrapper wrapper, ParameterInfoContext context) {
        return wrapper.getInfo().getType().getParameterTypes().toArray();
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace place;
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return (place = OCFunctionParameterInfoHandler.findCallPlace(context.getFile(), context.getOffset(), context.getParameterListStart())) == null ? null : (PsiElement)place.getElement();
    }

    public void updateParameterInfo(@NotNull PsiElement parameterOwner, @NotNull UpdateParameterInfoContext context) {
        OCFunctionCallPlace<? extends PsiElement> callPlace;
        if (parameterOwner == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(7);
        }
        OCLog.LOG.assertTrue((callPlace = OCFunctionParameterInfoHandler.callPlace(parameterOwner)) != null);
        int offset = context.getOffset();
        if (!parameterOwner.getTextRange().contains(offset)) {
            context.removeHint();
            return;
        }
        int index = 0;
        for (ASTNode child = parameterOwner.getNode().getFirstChildNode(); child != null && child.getStartOffset() < offset; child = child.getTreeNext()) {
            if (child.getElementType() != OCTokenTypes.COMMA) continue;
            ++index;
        }
        context.setCurrentParameter(index);
        Object[] methods = context.getObjectsToView();
        List<OCExpression> argExpressions = callPlace.getArgumentExpressions();
        for (int i = 0; i < methods.length; ++i) {
            OCFunctionType funcType = ((FunctionInfoWrapper)methods[i]).getInfo().getType();
            context.setUIComponentEnabled(i, OCFunctionParameterInfoHandler.isApplicableBeforeIndex(funcType, argExpressions, index));
        }
    }

    public static boolean isApplicableBeforeIndex(@NotNull OCFunctionType funcType, @NotNull List<OCExpression> argExpressions, int index) {
        if (funcType == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (argExpressions == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(9);
        }
        List<OCType> paramTypes = funcType.getParameterTypes();
        return (index == 0 || paramTypes.size() > index || funcType.isVararg()) && OCFunctionParameterInfoHandler.isAssignableParametersBeforeGivenIndex(paramTypes, argExpressions, index + 1);
    }

    private static boolean isAssignableParametersBeforeGivenIndex(@NotNull List<? extends OCType> params, @NotNull List<OCExpression> args, int length) {
        if (params == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (args == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(11);
        }
        int min = Math.min(length, Math.min(args.size(), params.size()));
        for (int j = 0; j < min; ++j) {
            OCType argType;
            OCType paramType = params.get(j);
            OCExpression arg = args.get(j);
            if (arg == null || !paramType.checkCompatible(argType = arg.getResolvedType(), arg, arg, OCResolveContext.forPsi(arg)).getState().isError(arg)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public void updateUI(@NotNull FunctionInfoWrapper wrapper, @NotNull ParameterInfoUIContext context) {
        if (wrapper == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if (context == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(13);
        }
        OCFunctionParameterInfoHandler.updateFunctionUI(wrapper.getInfo(), context);
    }

    public static String updateFunctionUI(@NotNull OCFunctionParameterInfo info, ParameterInfoUIContext context) {
        if (info == null) {
            OCFunctionParameterInfoHandler.$$$reportNull$$$0(14);
        }
        StringBuilder buffer = new StringBuilder();
        int currentParameter = context.getCurrentParameterIndex();
        OCFunctionType type = info.getType();
        List<String> defParamValues = info.getDefaultParameterValues();
        List<OCType> paramTypes = type.getParameterTypes();
        List<String> paramNames = type.getParameterNames();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (paramTypes.isEmpty()) {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        } else {
            int numParams = paramTypes.size();
            for (int i = 0; i < numParams; ++i) {
                int startOffset = buffer.length();
                String typeText = paramTypes.get(i).getName();
                String paramName = paramNames == null ? "<unnamed>" : paramNames.get(i);
                String defValue = defParamValues == null ? null : defParamValues.get(i);
                buffer.append(OCDocUtil.parameterSignature(typeText, paramName, defValue));
                int endOffset = buffer.length();
                if (i < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || i != currentParameter && (i != numParams - 1 || !type.isVararg() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        }
        return context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "funcType";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argExpressions";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wrapper";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUnnamedParam";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "callPlace";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableBeforeIndex";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isAssignableParametersBeforeGivenIndex";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "updateFunctionUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class FunctionInfoWrapper {
        @NotNull
        private final OCFunctionParameterInfo myInfo;
        @NotNull
        private final OCResolveContext myContext;

        public FunctionInfoWrapper(@NotNull OCFunctionParameterInfo info, @NotNull OCResolveContext context) {
            if (info == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(0);
            }
            if (context == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(1);
            }
            this.myInfo = info;
            this.myContext = context;
        }

        @NotNull
        public OCFunctionParameterInfo getInfo() {
            OCFunctionParameterInfo oCFunctionParameterInfo = this.myInfo;
            if (oCFunctionParameterInfo == null) {
                FunctionInfoWrapper.$$$reportNull$$$0(2);
            }
            return oCFunctionParameterInfo;
        }

        public int hashCode() {
            return this.myInfo.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof FunctionInfoWrapper && this.myInfo.getType().equals(((FunctionInfoWrapper)obj).getInfo().getType(), this.myContext);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler$FunctionInfoWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCFunctionParameterInfoHandler$FunctionInfoWrapper";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

