/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.HighlighterIteratorWrapper;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.IndentCalculator;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.hash.HashMap;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    private static final HashMap<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = new HashMap();
    private static final IndentCalculator.BaseLineOffsetCalculator STRONG_LINE_BEFORE;

    public static void skipWhiteSpacesInLine(@NotNull HighlighterIterator it, @NotNull CharSequence sequence, boolean forward) {
        if (it == null) {
            OCLineIndentProvider.$$$reportNull$$$0(0);
        }
        if (sequence == null) {
            OCLineIndentProvider.$$$reportNull$$$0(1);
        }
        while (!it.atEnd() && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType()) && !OCLineIndentProvider.hasNewLine(sequence, it)) {
            if (forward) {
                it.advance();
                continue;
            }
            it.retreat();
        }
    }

    static boolean hasNewLine(@NotNull CharSequence sequence, @NotNull HighlighterIterator it) {
        if (sequence == null) {
            OCLineIndentProvider.$$$reportNull$$$0(2);
        }
        if (it == null) {
            OCLineIndentProvider.$$$reportNull$$$0(3);
        }
        return OCLineIndentProvider.containsNewLine(sequence, it.getStart(), it.getEnd());
    }

    @Contract(pure=true)
    static boolean containsNewLine(@NotNull CharSequence text, int start, int end) {
        if (text == null) {
            OCLineIndentProvider.$$$reportNull$$$0(4);
        }
        return StringUtil.contains((CharSequence)text, (int)start, (int)end, (char)'\n');
    }

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            OCLineIndentProvider.$$$reportNull$$$0(5);
        }
        return (SemanticEditorPosition.SyntaxElement)SYNTAX_MAP.get((Object)tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        if (language == null) {
            OCLineIndentProvider.$$$reportNull$$$0(6);
        }
        return language.isKindOf((Language)OCLanguage.getInstance());
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project2, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        CommonCodeStyleSettings commonCodeStyleSettings;
        SemanticEditorPosition beforeStart;
        if (project2 == null) {
            OCLineIndentProvider.$$$reportNull$$$0(7);
        }
        if (blockStartPosition == null) {
            OCLineIndentProvider.$$$reportNull$$$0(8);
        }
        if ((beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace)).isAtEnd()) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.NORMAL);
        }
        EditorEx editor = blockStartPosition.getEditor();
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile((Document)editor.getDocument());
        boolean validSource = file instanceof OCFile && language instanceof OCLanguage;
        OCCodeStyleSettings codeStyleSettings = validSource ? (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class) : null;
        CommonCodeStyleSettings commonCodeStyleSettings2 = commonCodeStyleSettings = validSource ? CodeStyle.getLanguageSettings((PsiFile)file) : null;
        if (validSource && (beforeStart.isAt((IElementType)OCTokenTypes.RBRACKET) || beforeStart.isAt((IElementType)OCTokenTypes.LPAR) || beforeStart.isAt((IElementType)OCTokenTypes.XOR))) {
            return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_INSIDE_CODE_BLOCK);
        }
        if (beforeStart.isAt((IElementType)OCTokenTypes.EQ) || beforeStart.isAt((IElementType)OCTokenTypes.AT)) {
            return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (validSource) {
            OCTypedHandlerDelegate.ContextType blockType = OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(beforeStart));
            switch (blockType) {
                case Namespace: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_NAMESPACE_MEMBERS);
                }
                case ClassCPP: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_CLASS_MEMBERS);
                }
                case StructLike: {
                    return Indent.getSpaceIndent((int)codeStyleSettings.INDENT_C_STRUCT_MEMBERS);
                }
                case SwitchStatement: {
                    return OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonCodeStyleSettings.INDENT_CASE_FROM_SWITCH ? Indent.Type.NORMAL : Indent.Type.NONE));
                }
            }
        }
        return super.getIndentInBlock(project2, language, blockStartPosition);
    }

    protected boolean dropIndentAfterReturnLike(@NotNull SemanticEditorPosition statementBeforeSemicolon) {
        if (statementBeforeSemicolon == null) {
            OCLineIndentProvider.$$$reportNull$$$0(9);
        }
        return statementBeforeSemicolon.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.ReturnLike);
    }

    protected boolean isColonAfterLabelOrCase(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            OCLineIndentProvider.$$$reportNull$$$0(10);
        }
        return OCLineIndentProvider.isSwitchContext(OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position));
    }

    @Contract(pure=true)
    private static boolean isSwitchContext(@NotNull Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context) {
        SemanticEditorPosition editorPosition;
        if (context == null) {
            OCLineIndentProvider.$$$reportNull$$$0(11);
        }
        if ((editorPosition = (SemanticEditorPosition)context.first) == null) {
            return false;
        }
        SemanticEditorPosition.SyntaxElement element = editorPosition.getCurrElement();
        return element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCSElement.Identifier && context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement;
    }

    @NotNull
    public static Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> getColonAfterLabelCaseDefaultPublicContext(@NotNull SemanticEditorPosition finPos) {
        if (finPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(12);
        }
        if (!finPos.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon)) {
            Pair pair2 = Pair.create(null, null);
            if (pair2 == null) {
                OCLineIndentProvider.$$$reportNull$$$0(13);
            }
            return pair2;
        }
        SemanticEditorPosition maybeCaseDefaultPublic = finPos.copy();
        SemanticEditorPosition.SyntaxElement element = maybeCaseDefaultPublic.elementAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault, OCSElement.PublicLike});
        if (element != null) {
            Pair pair3 = Pair.create((Object)maybeCaseDefaultPublic, null);
            if (pair3 == null) {
                OCLineIndentProvider.$$$reportNull$$$0(14);
            }
            return pair3;
        }
        SemanticEditorPosition maybeLabelId = finPos.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment});
        if (maybeLabelId.getCurrElement() == OCSElement.Identifier && maybeLabelId.before().isAtMultiline(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace})) {
            SemanticEditorPosition pos = maybeLabelId.copy();
            pos.moveBeforeParentheses((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
            if (!pos.isAtEnd()) {
                Pair pair4 = Pair.create((Object)maybeLabelId, (Object)((Object)OCTypedHandlerDelegate.getContextTypeFromPosition(OCLineIndentProvider.createEditorIteratorAtPosition(pos))));
                if (pair4 == null) {
                    OCLineIndentProvider.$$$reportNull$$$0(15);
                }
                return pair4;
            }
        }
        Pair pair5 = Pair.create(null, null);
        if (pair5 == null) {
            OCLineIndentProvider.$$$reportNull$$$0(16);
        }
        return pair5;
    }

    @NotNull
    private static HighlighterIterator createEditorIteratorAtPosition(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(17);
        }
        HighlighterIterator highlighterIterator = pos.getEditor().getHighlighter().createIterator(pos.getStartOffset());
        if (highlighterIterator == null) {
            OCLineIndentProvider.$$$reportNull$$$0(18);
        }
        return highlighterIterator;
    }

    @Nullable
    private static OCLanguageKind getLanguageKind(@NotNull SemanticEditorPosition pos) {
        PsiFile file;
        EditorEx editor;
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(19);
        }
        if ((editor = pos.getEditor()).getProject() != null && (file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile((Document)editor.getDocument())) instanceof OCFile) {
            return ((OCFile)file).getKind();
        }
        return null;
    }

    protected boolean isInsideForLikeConstruction(@NotNull SemanticEditorPosition finPos) {
        if (finPos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(20);
        }
        return finPos.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    @NotNull
    protected HighlighterIterator getIteratorAtPosition(final @NotNull EditorEx editor, int offset) {
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(21);
        }
        HighlighterIteratorWrapper highlighterIteratorWrapper = new HighlighterIteratorWrapper(editor.getHighlighter().createIterator(offset)){

            public void advance() {
                super.advance();
                CharSequence sequence = this.getDocument().getCharsSequence();
                while (this.isInDirective()) {
                    while (this.atTheSameLine(sequence)) {
                        super.advance();
                    }
                    super.advance();
                }
            }

            public void retreat() {
                super.retreat();
                CharSequence sequence = this.getDocument().getCharsSequence();
                while (this.isInDirective()) {
                    while (this.atTheSameLine(sequence)) {
                        super.retreat();
                    }
                    super.retreat();
                }
            }

            boolean atTheSameLine(CharSequence sequence) {
                return !this.atEnd() && !StringUtil.contains((CharSequence)sequence, (int)this.getStart(), (int)this.getEnd(), (char)'\n');
            }

            boolean isInDirective() {
                if (this.atEnd()) {
                    return false;
                }
                if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(this.getTokenType())) {
                    return true;
                }
                Document document = this.getDocument();
                int offset = document.getLineStartOffset(document.getLineNumber(this.getStart()));
                if (offset < 0) {
                    return false;
                }
                HighlighterIterator iterator = editor.getHighlighter().createIterator(offset);
                while (!iterator.atEnd() && OCTokenTypes.WHITESPACES.contains(iterator.getTokenType())) {
                    iterator.advance();
                }
                return OCFormatterUtil.FORMAT_DIRECTIVES.contains(iterator.getTokenType());
            }
        };
        if (highlighterIteratorWrapper == null) {
            OCLineIndentProvider.$$$reportNull$$$0(22);
        }
        return highlighterIteratorWrapper;
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        if (position == null) {
            OCLineIndentProvider.$$$reportNull$$$0(23);
        }
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !(!ignoreLabels ? position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{OCSElement.PublicLike, OCSElement.Identifier}) : position.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.PublicLike));
    }

    @Nullable
    protected IndentCalculator getIndent(@NotNull Project project2, @NotNull Editor editor, @Nullable Language language, int offset) {
        IndentCalculator indent;
        if (project2 == null) {
            OCLineIndentProvider.$$$reportNull$$$0(24);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(25);
        }
        if ((indent = super.getIndent(project2, editor, language, offset)) != null) {
            return indent;
        }
        SemanticEditorPosition pos = this.getPosition(editor, offset);
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(OCCodeStyleSettings.class);
        CommonCodeStyleSettings commonSettings = CodeStyle.getSettings((Editor)editor).getCommonSettings(language);
        CommonCodeStyleSettings.IndentOptions options = commonSettings.getIndentOptions();
        Document document = editor.getDocument();
        JavaLikeLangLineIndentProvider.IndentCalculatorFactory myFactory = new JavaLikeLangLineIndentProvider.IndentCalculatorFactory(project2, editor);
        if (pos.matchesRule(position -> position.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace) && position.isAtMultiline())) {
            SemanticEditorPosition lastTokenInLine = pos.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
            if (lastTokenInLine.isAtEnd()) {
                return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
            }
            if (lastTokenInLine.isAt((IElementType)OCTokenTypes.STRING_LITERAL)) {
                SemanticEditorPosition maybeAt = lastTokenInLine.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
                SemanticEditorPosition anchor = maybeAt.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.At) ? maybeAt : lastTokenInLine;
                Lexer lexer = OCLineIndentProvider.getLexerAtOffset(anchor.getStartOffset() + 1, document.getCharsSequence());
                return this.createAbsoluteSpaceIndentCalculator(project2, editor, OCLineIndentProvider.getOffsetInLine(document, lexer.getTokenStart()));
            }
            Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(lastTokenInLine);
            if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                    return this.createInBlockSpaceIndentCalculator(project2, editor, settings.INDENT_CLASS_MEMBERS);
                }
                if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.Identifier && options != null) {
                    SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore((SemanticEditorPosition)context.first);
                    if (element != null) {
                        return myFactory.createIndentCalculator(Indent.Type.NORMAL, IndentCalculator.LINE_BEFORE);
                    }
                    return this.createInBlockSpaceIndentCalculator(project2, editor, options.INDENT_SIZE + (context.second == OCTypedHandlerDelegate.ContextType.SwitchStatement && commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0));
                }
            }
            if (lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.StructLike}) && !lastTokenInLine.copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{OCSElement.Typedef})) {
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            SemanticEditorPosition testEqAnchor = lastTokenInLine;
            SemanticEditorPosition maybeLeft = lastTokenInLine.copy();
            maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket, self -> self.isAtMultiline());
            if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket)) {
                testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
            } else {
                maybeLeft = lastTokenInLine.copy();
                maybeLeft.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, self -> self.isAtMultiline());
                if (maybeLeft.isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace)) {
                    testEqAnchor = maybeLeft.before().beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment, OCSElement.At});
                }
            }
            if (OCLineIndentProvider.getEqLikeOnLineBefore(testEqAnchor) != null) {
                if (maybeLeft.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket}) && commonSettings.ALIGN_MULTILINE_ARRAY_INITIALIZER_EXPRESSION) {
                    HighlighterIterator it = OCLineIndentProvider.createEditorIteratorAtPosition(maybeLeft.after());
                    OCLineIndentProvider.skipWhiteSpacesInLine(it, maybeLeft.getChars(), true);
                    if (!it.atEnd() && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(it.getTokenType())) {
                        return this.createAbsoluteSpaceIndentCalculator(project2, editor, OCLineIndentProvider.getOffsetInLine(document, it.getStart()));
                    }
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
            if (OCLineIndentProvider.getTemplateLikeOnLineBefore(lastTokenInLine) != null) {
                SemanticEditorPosition after2 = lastTokenInLine.after().afterOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
                if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.TemplateLike)) {
                    return myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                if (lastTokenInLine.isAt((IElementType)OCTokenTypes.GT) || lastTokenInLine.isAt((IElementType)OCTokenTypes.GTGT)) {
                    if (after2.isAt((SemanticEditorPosition.SyntaxElement)OCSElement.StructLike)) {
                        return myFactory.createIndentCalculator(settings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    if (OCLineIndentProvider.isLikeFunctionDecl(after2)) {
                        return myFactory.createIndentCalculator(settings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                    }
                    return myFactory.createIndentCalculator(settings.TEMPLATE_DECLARATION_STRUCT_BODY_INDENT && settings.TEMPLATE_DECLARATION_FUNCTION_BODY_INDENT ? Indent.Type.NORMAL : Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
                }
                return myFactory.createIndentCalculator(Indent.Type.CONTINUATION, IndentCalculator.LINE_BEFORE);
            }
        }
        Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(pos.copy());
        if (context.first != null && !((SemanticEditorPosition)context.first).copy().isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment})) {
            if (((SemanticEditorPosition)context.first).getCurrElement() == OCSElement.PublicLike) {
                return this.createInBlockSpaceIndentCalculator(project2, editor, settings.INDENT_VISIBILITY_KEYWORDS);
            }
            if (options != null) {
                SemanticEditorPosition.SyntaxElement element = OCLineIndentProvider.getColonOrSwitchInNonBlockSwitchOnLineBefore(((SemanticEditorPosition)context.first).before());
                if (element != null) {
                    return new IndentCalculator(project2, editor, STRONG_LINE_BEFORE, OCLineIndentProvider.getDefaultIndentFromType((Indent.Type)(commonSettings.INDENT_CASE_FROM_SWITCH && element == OCSElement.Switch ? Indent.Type.NORMAL : Indent.Type.NONE)));
                }
                if (OCLineIndentProvider.isSwitchContext(context)) {
                    return this.createInBlockSpaceIndentCalculator(project2, editor, commonSettings.INDENT_CASE_FROM_SWITCH ? options.INDENT_SIZE : 0);
                }
                return options.LABEL_INDENT_ABSOLUTE ? this.createAbsoluteSpaceIndentCalculator(project2, editor, options.LABEL_INDENT_SIZE) : this.createInBlockSpaceIndentCalculator(project2, editor, options.INDENT_SIZE + options.LABEL_INDENT_SIZE);
            }
        }
        return OCLineIndentProvider.canUseFormatterForIndentProcessing(OCLineIndentProvider.getLanguageKind(pos)) ? null : myFactory.createIndentCalculator(Indent.Type.NONE, IndentCalculator.LINE_BEFORE);
    }

    private static boolean canUseFormatterForIndentProcessing(@Nullable OCLanguageKind kind) {
        if (kind == null || kind.isObjC()) {
            return !Registry.is((String)"cidr.indent.lexer.only.objc");
        }
        return !ApplicationManager.getApplication().isUnitTestMode() && !Registry.is((String)"cidr.indent.lexer.only.cpp");
    }

    private static int getOffsetInLine(@NotNull Document document, int start) {
        if (document == null) {
            OCLineIndentProvider.$$$reportNull$$$0(26);
        }
        return start - document.getLineStartOffset(document.getLineNumber(start));
    }

    private static boolean isLikeFunctionDecl(@NotNull SemanticEditorPosition maybeFuncStart) {
        if (maybeFuncStart == null) {
            OCLineIndentProvider.$$$reportNull$$$0(27);
        }
        if (maybeFuncStart.isAtEnd()) {
            return false;
        }
        CharSequence chars = maybeFuncStart.getChars();
        HighlighterIterator position = OCLineIndentProvider.createEditorIteratorAtPosition(maybeFuncStart);
        while (!position.atEnd() && !OCLineIndentProvider.containsNewLine(chars, position.getStart(), position.getEnd())) {
            IElementType type = position.getTokenType();
            if (type == OCTokenTypes.SEMICOLON || type == OCTokenTypes.RPAR) {
                return false;
            }
            if (type == OCTokenTypes.LPAR) {
                return true;
            }
            position.advance();
        }
        return false;
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getColonOrSwitchInNonBlockSwitchOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(28);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Colon, OCSElement.Switch});
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getEqLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(29);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, OCSElement.EqualLike);
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getTemplateLikeOnLineBefore(@NotNull SemanticEditorPosition pos) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(30);
        }
        return OCLineIndentProvider.getElementsOnLineBefore(pos, OCSElement.TemplateLike);
    }

    @Nullable
    private static SemanticEditorPosition.SyntaxElement getElementsOnLineBefore(@NotNull SemanticEditorPosition pos, SemanticEditorPosition.SyntaxElement ... syntaxElements) {
        if (pos == null) {
            OCLineIndentProvider.$$$reportNull$$$0(31);
        }
        if (syntaxElements == null) {
            OCLineIndentProvider.$$$reportNull$$$0(32);
        }
        SemanticEditorPosition position = pos.beforeOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace});
        position.moveToLeftParenthesisBackwardsSkippingNestedWithPredicate((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace, (SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace, self -> {
            if (syntaxElements == null) {
                OCLineIndentProvider.$$$reportNull$$$0(40);
            }
            return self.isAtAnyOf(syntaxElements) || self.isAtMultiline();
        });
        return position.isAtAnyOf(syntaxElements) ? position.getCurrElement() : null;
    }

    @NotNull
    private IndentCalculator createInBlockSpaceIndentCalculator(@NotNull Project project2, @NotNull Editor editor, int spaces) {
        if (project2 == null) {
            OCLineIndentProvider.$$$reportNull$$$0(33);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(34);
        }
        IndentCalculator indentCalculator = new IndentCalculator(project2, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false));
        if (indentCalculator == null) {
            OCLineIndentProvider.$$$reportNull$$$0(35);
        }
        return indentCalculator;
    }

    @NotNull
    private IndentCalculator createAbsoluteSpaceIndentCalculator(@NotNull Project project2, @NotNull Editor editor, int spaces) {
        if (project2 == null) {
            OCLineIndentProvider.$$$reportNull$$$0(36);
        }
        if (editor == null) {
            OCLineIndentProvider.$$$reportNull$$$0(37);
        }
        IndentCalculator indentCalculator = new IndentCalculator(project2, editor, arg_0 -> ((OCLineIndentProvider)this).getDeepBlockStatementStartOffset(arg_0), Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)spaces, (boolean)false, (boolean)false)){

            @NotNull
            protected String getBaseIndent(@NotNull SemanticEditorPosition currPosition) {
                if (currPosition == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ("" == null) {
                    2.$$$reportNull$$$0(1);
                }
                return "";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "currPosition";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBaseIndent";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getBaseIndent";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (indentCalculator == null) {
            OCLineIndentProvider.$$$reportNull$$$0(38);
        }
        return indentCalculator;
    }

    @NotNull
    public static Lexer getLexerAtOffset(int offset, CharSequence text) {
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault();
        lexer.start(text);
        while (lexer.getTokenEnd() < offset) {
            lexer.advance();
        }
        OCLexerWithDirectives oCLexerWithDirectives = lexer;
        if (oCLexerWithDirectives == null) {
            OCLineIndentProvider.$$$reportNull$$$0(39);
        }
        return oCLexerWithDirectives;
    }

    static {
        SYNTAX_MAP.put((Object)TokenType.WHITE_SPACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace);
        SYNTAX_MAP.put((Object)OCTokenTypes.SEMICOLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon);
        SYNTAX_MAP.put((Object)OCTokenTypes.LBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace);
        SYNTAX_MAP.put((Object)OCTokenTypes.RBRACE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace);
        SYNTAX_MAP.put((Object)OCTokenTypes.LBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket);
        SYNTAX_MAP.put((Object)OCTokenTypes.RBRACKET, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket);
        SYNTAX_MAP.put((Object)OCTokenTypes.RPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis);
        SYNTAX_MAP.put((Object)OCTokenTypes.LPAR, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis);
        SYNTAX_MAP.put((Object)OCTokenTypes.COLON, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon);
        SYNTAX_MAP.put((Object)OCTokenTypes.CASE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase);
        SYNTAX_MAP.put((Object)OCTokenTypes.DEFAULT_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault);
        SYNTAX_MAP.put((Object)OCTokenTypes.IF_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.WHILE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.ELSE_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.FOR_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.DO_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.BLOCK_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.COMMA, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.Comma);
        SYNTAX_MAP.put((Object)OCTokenTypes.EOL_COMMENT, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.TRY_KEYWORD, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword);
        SYNTAX_MAP.put((Object)OCTokenTypes.STRUCT_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.CLASS_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.ENUM_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.UNION_KEYWORD, (Object)OCSElement.StructLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.IDENTIFIER, (Object)OCSElement.Identifier);
        SYNTAX_MAP.put((Object)OCTokenTypes.RETURN_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.BREAK_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.CONTINUE_KEYWORD, (Object)OCSElement.ReturnLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PUBLIC_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PROTECTED_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.PRIVATE_KEYWORD, (Object)OCSElement.PublicLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.EOL_ESCAPE, (Object)JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment);
        SYNTAX_MAP.put((Object)OCTokenTypes.TYPEDEF_KEYWORD, (Object)OCSElement.Typedef);
        SYNTAX_MAP.put((Object)OCTokenTypes.SWITCH_KEYWORD, (Object)OCSElement.Switch);
        for (IElementType type : OCTokenTypes.ASSIGNMENT_OPERATIONS.getTypes()) {
            SYNTAX_MAP.put((Object)type, (Object)OCSElement.EqualLike);
        }
        SYNTAX_MAP.put((Object)OCTokenTypes.TEMPLATE_CPP_KEYWORD, (Object)OCSElement.TemplateLike);
        SYNTAX_MAP.put((Object)OCTokenTypes.AT, (Object)OCSElement.At);
        STRONG_LINE_BEFORE = new IndentCalculator.BaseLineOffsetCalculator(){

            public int getOffsetInBaseIndentLine(@NotNull SemanticEditorPosition currPosition) {
                if (currPosition == null) {
                    3.$$$reportNull$$$0(0);
                }
                DocumentEx document = currPosition.getEditor().getDocument();
                int lineNo = document.getLineNumber(currPosition.getStartOffset());
                return CharArrayUtil.shiftBackward((CharSequence)currPosition.getChars(), (int)document.getLineEndOffset(lineNo == 0 ? 0 : lineNo - 1), (String)" \t\n\r");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currPosition", "com/jetbrains/cidr/lang/editor/OCLineIndentProvider$3", "getOffsetInBaseIndentLine"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 39: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 39: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 7: 
            case 24: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStartPosition";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementBeforeSemicolon";
                break;
            }
            case 10: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finPos";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider";
                break;
            }
            case 17: 
            case 19: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 21: 
            case 25: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeFuncStart";
                break;
            }
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syntaxElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCLineIndentProvider";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getColonAfterLabelCaseDefaultPublicContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorIteratorAtPosition";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getIteratorAtPosition";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createInBlockSpaceIndentCalculator";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "createAbsoluteSpaceIndentCalculator";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getLexerAtOffset";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "skipWhiteSpacesInLine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasNewLine";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsNewLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "mapType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isSuitableForLanguage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIndentInBlock";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "dropIndentAfterReturnLike";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isColonAfterLabelOrCase";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSwitchContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getColonAfterLabelCaseDefaultPublicContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 39: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditorIteratorAtPosition";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageKind";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isInsideForLikeConstruction";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getIteratorAtPosition";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isIndentProvider";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIndent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getOffsetInLine";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isLikeFunctionDecl";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getColonOrSwitchInNonBlockSwitchOnLineBefore";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getEqLikeOnLineBefore";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateLikeOnLineBefore";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getElementsOnLineBefore";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "createInBlockSpaceIndentCalculator";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createAbsoluteSpaceIndentCalculator";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getElementsOnLineBefore$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 22: 
            case 35: 
            case 38: 
            case 39: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OCSElement implements SemanticEditorPosition.SyntaxElement
    {
        StructLike,
        ReturnLike,
        DirectiveLike,
        Identifier,
        PublicLike,
        EqualLike,
        At,
        TemplateLike,
        Switch,
        Typedef;

    }
}

