/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCStringLiteralCopyPasteProcessor
implements CopyPastePreProcessor {
    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        if (file.getLanguage() != OCLanguage.getInstance()) {
            return null;
        }
        boolean isLiteral = true;
        for (int i = 0; i < startOffsets.length && isLiteral; ++i) {
            if (OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file, startOffsets[i], endOffsets[i]) != null) continue;
            isLiteral = false;
        }
        return isLiteral ? StringUtil.unescapeStringCharacters((String)text) : null;
    }

    @NotNull
    public String preprocessOnPaste(Project project2, PsiFile file, Editor editor, String text, RawText rawText) {
        if (file.getLanguage() != OCLanguage.getInstance()) {
            String string = text;
            if (string == null) {
                OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        SelectionModel selectionModel = editor.getSelectionModel();
        int selectionStart = selectionModel.getSelectionStart();
        int selectionEnd = selectionModel.getSelectionEnd();
        IElementType tokenType = OCStringLiteralCopyPasteProcessor.findLiteralTokenType(file, selectionStart, selectionEnd);
        if (tokenType == OCTokenTypes.STRING_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(1);
                }
                return string;
            }
            StringBuilder buffer = new StringBuilder(text.length());
            String breaker = "\\n\"\n \"";
            String[] lines = LineTokenizer.tokenize((char[])text.toCharArray(), (boolean)false, (boolean)true);
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                buffer.append(StringUtil.escapeStringCharacters((String)line));
                if (i == lines.length - 1) continue;
                buffer.append(breaker);
            }
            text = buffer.toString();
        } else if (tokenType == OCTokenTypes.CHARACTER_LITERAL) {
            if (rawText != null && rawText.rawText != null) {
                String string = rawText.rawText;
                if (string == null) {
                    OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = OCStringLiteralCopyPasteProcessor.escapeCharCharacters(text);
            if (string == null) {
                OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    private static IElementType findLiteralTokenType(PsiFile file, int selectionStart, int selectionEnd) {
        PsiElement elementAtSelection = file.findElementAt(selectionStart);
        if (elementAtSelection == null) {
            return null;
        }
        if (elementAtSelection.getNode() == null) {
            OCLog.LOG.error("node is null for " + elementAtSelection + "\n\tin " + file);
            return null;
        }
        IElementType tokenType = elementAtSelection.getNode().getElementType();
        if (tokenType != OCTokenTypes.STRING_LITERAL && tokenType != OCTokenTypes.CHARACTER_LITERAL) {
            return null;
        }
        TextRange textRange = elementAtSelection.getTextRange();
        if (selectionStart <= textRange.getStartOffset() || selectionEnd >= textRange.getEndOffset()) {
            return null;
        }
        return tokenType;
    }

    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(5);
        }
        StringBuilder buffer = new StringBuilder();
        StringUtil.escapeStringCharacters((int)s.length(), (String)s, (String)"'", (StringBuilder)buffer);
        String string = buffer.toString();
        if (string == null) {
            OCStringLiteralCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCStringLiteralCopyPasteProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

