/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.BracePair;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.OCBraceMatcher;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardRepeatDetector;
import com.jetbrains.cidr.lang.editor.typing.OCBackwardStructureDetector;
import com.jetbrains.cidr.lang.editor.typing.OCHighlightingTokenIterator;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCMultilineNodeFormatter;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.ArrayList;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypedHandlerDelegate
extends TypedHandlerDelegate {
    private static boolean DO_STAR_OVERTYPE = false;
    private static boolean DO_COLON_OVERTYPE = false;
    private boolean myMemoSetting;
    private boolean myBalanceOnRightBracket;
    public static final TokenSet STOPSET = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.LBRACE, OCTokenTypes.RBRACE, OCTokenTypes.SEMICOLON});
    private static final TokenSet OUT_OF_PAREN_STOPSET = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.EQ, OCTokenTypes.EQEQ, OCTokenTypes.ANDAND, OCTokenTypes.OROR, OCTokenTypes.LT, OCTokenTypes.LTEQ, OCTokenTypes.GT, OCTokenTypes.GTEQ, OCTokenTypes.PLUS, OCTokenTypes.MINUS, OCTokenTypes.DIV, OCTokenTypes.MUL});
    private static final IElementType[] BLOCK_TYPE_STOP_SET;
    protected static final OCBackwardStructureDetector NUMBER_LITERAL_DETECTOR;
    protected static final OCBackwardStructureDetector STRING_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector ARRAY_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector BRACED_LITERAL_DETECTOR;
    public static final OCBackwardStructureDetector OBJC_LITERAL_DETECTOR;
    private static final TokenSet NON_SEMICOLON_BLOCK_OWNERS;

    public OCTypedHandlerDelegate() {
        ActionManagerEx.getInstanceEx().addAnActionListener((AnActionListener)new AnActionListener.Adapter(){

            public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
                DO_STAR_OVERTYPE = false;
                DO_COLON_OVERTYPE = false;
            }
        });
    }

    public static void overTypeNextStar() {
        DO_STAR_OVERTYPE = true;
    }

    public static void overTypeNextColon() {
        DO_COLON_OVERTYPE = true;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project2 == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(1);
        }
        if (file == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(3);
        }
        if (file.getFileType() != OCFileType.INSTANCE) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                OCTypedHandlerDelegate.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c == '\"') {
            int offset = editor.getCaretModel().getOffset();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project2 == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(32);
                }
                if (editor == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(33);
                }
                PsiDocumentManagerImpl pdm = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
                pdm.performWhenAllCommitted(() -> {
                    if (editor == null) {
                        OCTypedHandlerDelegate.$$$reportNull$$$0(34);
                    }
                    if (project2 == null) {
                        OCTypedHandlerDelegate.$$$reportNull$$$0(35);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        OCType expected;
                        Document document;
                        PsiFile psi;
                        if (editor == null) {
                            OCTypedHandlerDelegate.$$$reportNull$$$0(36);
                        }
                        if (project2 == null) {
                            OCTypedHandlerDelegate.$$$reportNull$$$0(37);
                        }
                        if (!((psi = pdm.getPsiFile(document = editor.getDocument())) instanceof OCFile) || !((OCFile)psi).getKind().isObjC()) {
                            return;
                        }
                        final OCLiteralExpression literal = (OCLiteralExpression)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psi, (int)offset, OCLiteralExpression.class, (boolean)false);
                        if (literal != null && literal.isStringLiteral() && !literal.isNSStringLiteral() && (expected = OCExpectedTypeUtil.getExpectedType(literal)) != null && (expected.isObjCRootType() || expected.isPointerToStringCompatible(true))) {
                            new WriteCommandAction(project2, new PsiFile[]{psi}){

                                protected void run(@NotNull Result result) throws Throwable {
                                    if (result == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    document.insertString(literal.getTextRange().getStartOffset(), (CharSequence)"@");
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/editor/OCTypedHandlerDelegate$2", "run"));
                                }
                            }.execute();
                        }
                    }, project2.getDisposed());
                });
            }, project2.getDisposed());
        } else if (c == ']') {
            boolean autoInsertPairBracket;
            this.myMemoSetting = autoInsertPairBracket = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET;
            int offset = editor.getCaretModel().getOffset();
            if (offset == 0) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(5);
                }
                return result;
            }
            if (!OCTypedHandlerDelegate.isBracketBalancingSupported(file) || autoInsertPairBracket && OCTypedHandlerDelegate.isNext(editor, offset, OCTokenTypes.RBRACKET)) {
                this.myBalanceOnRightBracket = false;
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(6);
                }
                return result;
            }
            this.myBalanceOnRightBracket = true;
            HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset - 1);
            int tokenPassed = 0;
            boolean prevWasWhitespace = false;
            while (!it.atEnd()) {
                IElementType tt = it.getTokenType();
                if (tt == OCTokenTypes.LBRACKET) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                    if (result == null) {
                        OCTypedHandlerDelegate.$$$reportNull$$$0(7);
                    }
                    return result;
                }
                boolean isWs = OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(tt);
                if (!isWs && prevWasWhitespace && tokenPassed >= 2) break;
                it.retreat();
                ++tokenPassed;
                prevWasWhitespace = isWs;
            }
            CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET = false;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(8);
        }
        return result;
    }

    private static boolean isBracketBalancingSupported(@NotNull PsiFile file) {
        if (file == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(9);
        }
        if (!(file instanceof OCFile)) {
            return false;
        }
        OCLanguageKind languageKind = DumbService.getInstance((Project)file.getProject()).isDumb() ? OCLanguageKindCalculator.calculateLanguageKindFast(file) : ((OCFile)file).getKind();
        return languageKind.isObjC();
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        String originalIndent;
        HighlighterIterator it;
        if (project2 == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(11);
        }
        if (file == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(12);
        }
        if (file.getFileType() != OCFileType.INSTANCE) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                OCTypedHandlerDelegate.$$$reportNull$$$0(13);
            }
            return result;
        }
        Document document = editor.getDocument();
        CaretModel caret = editor.getCaretModel();
        if (c == '*' && DO_STAR_OVERTYPE) {
            DO_STAR_OVERTYPE = false;
            int offset = caret.getOffset() - 1;
            CharSequence text = document.getCharsSequence();
            if (text.charAt(offset - 1) == '*') {
                document.deleteString(offset, offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(14);
                }
                return result;
            }
        } else if (c == ':' && DO_COLON_OVERTYPE) {
            int offset = caret.getOffset() - 1;
            CharSequence text = document.getCharsSequence();
            if (text.charAt(offset - 1) == ':' && text.charAt(offset - 2) == ':') {
                document.deleteString(offset, offset + 1);
                DO_COLON_OVERTYPE = false;
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(15);
                }
                return result;
            }
        } else if (c == ';') {
            int offset = caret.getOffset();
            if (OCTypedHandlerDelegate.isNext(editor, offset, OCTokenTypes.SEMICOLON)) {
                document.deleteString(offset, offset + 1);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(16);
                }
                return result;
            }
        } else if (c == ']' && this.myBalanceOnRightBracket) {
            CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET = this.myMemoSetting;
            int offset = caret.getOffset() - 1;
            HighlighterIterator fromStart = ((EditorEx)editor).getHighlighter().createIterator(0);
            int depth = 0;
            int depthBeforeOffset = 0;
            while (!fromStart.atEnd()) {
                IElementType tt;
                int curOffset = fromStart.getStart();
                if (curOffset == offset) {
                    depthBeforeOffset = depth;
                }
                if ((tt = fromStart.getTokenType()) == OCTokenTypes.LBRACKET) {
                    ++depth;
                }
                if (tt == OCTokenTypes.RBRACKET) {
                    --depth;
                }
                fromStart.advance();
            }
            if (depth >= 0) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(17);
                }
                return result;
            }
            HighlighterIterator it2 = ((EditorEx)editor).getHighlighter().createIterator(offset);
            int parBalance = 0;
            int bracketBalance = 0;
            int termsCount = 0;
            if (it2.getTokenType() == OCTokenTypes.RBRACKET) {
                while (true) {
                    if (it2.atEnd()) {
                        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                        if (result == null) {
                            OCTypedHandlerDelegate.$$$reportNull$$$0(18);
                        }
                        return result;
                    }
                    IElementType tt = it2.getTokenType();
                    if (OCTypedHandlerDelegate.skipObjcLiteral(it2)) {
                        if (parBalance != 0 || bracketBalance != true) continue;
                        ++termsCount;
                        continue;
                    }
                    if (tt == OCTokenTypes.LPAR) {
                        if (parBalance == 0) break;
                        --parBalance;
                    } else if (tt == OCTokenTypes.RPAR) {
                        ++parBalance;
                    } else if (tt == OCTokenTypes.LBRACKET) {
                        if (parBalance == 0 && --bracketBalance == 1 && OCTypedHandlerDelegate.checkPosition(editor, it2.getStart(), offset)) {
                            break;
                        }
                    } else if (tt == OCTokenTypes.RBRACKET) {
                        if (parBalance == 0 && bracketBalance == 1) {
                            ++termsCount;
                        }
                        ++bracketBalance;
                    } else if (tt == OCTokenTypes.DOT || tt == OCTokenTypes.DEREF) {
                        if (parBalance == 0 && bracketBalance == 1) {
                            --termsCount;
                        }
                    } else {
                        if (tt == OCTokenTypes.IF_KEYWORD || tt == OCTokenTypes.WHILE_KEYWORD || tt == OCTokenTypes.FOR_KEYWORD) {
                            it2.advance();
                            OCTypedHandlerDelegate.skipWhitespaceForward(it2);
                            parBalance = OCTypedHandlerDelegate.skipBlock(it2, OCTokenTypes.LPAR, OCTokenTypes.RPAR);
                            break;
                        }
                        if (tt == OCTokenTypes.IDENTIFIER && !"in".equals(OCTypedHandlerDelegate.tokenText(editor, it2)) || OCTokenTypes.LITERALS.contains(tt) || tt == OCTokenTypes.AT || tt == OCTokenTypes.SELECTOR_KEYWORD || tt == OCTokenTypes.ENCODE_KEYWORD || tt == OCTokenTypes.TYPEOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_KEYWORD || tt == OCTokenTypes.ALIGNOF_CPP_KEYWORD || tt == OCTokenTypes.AND || tt == OCTokenTypes.TEMPLATE_START_MARK || tt == OCTokenTypes.TEMPLATE_STOP_MARK || tt == OCTokenTypes.SIZEOF_KEYWORD) {
                            if (parBalance == 0 && bracketBalance == 1) {
                                ++termsCount;
                            }
                        } else if ((tt != OCTokenTypes.COLON || bracketBalance != 1 || parBalance != 0 || depthBeforeOffset != 0) && tt != TokenType.WHITE_SPACE && (STOPSET.contains(tt) || parBalance == 0 && bracketBalance == 1 || parBalance == 0 && bracketBalance == 0 && OUT_OF_PAREN_STOPSET.contains(tt))) break;
                    }
                    it2.retreat();
                }
                if (parBalance == 0 && bracketBalance <= 1) {
                    it2.advance();
                    while (!OCTypedHandlerDelegate.checkPosition(editor, it2.getStart(), offset)) {
                        it2.advance();
                    }
                    OCTypedHandlerDelegate.skipWhitespaceForward(it2);
                    char prevChar = document.getCharsSequence().charAt(offset - 1);
                    if (termsCount == 1 || prevChar == ':') {
                        if (prevChar != ' ') {
                            document.insertString(offset, (CharSequence)" ");
                        }
                        caret.moveCaretRelatively(-1, 0, false, false, false);
                    } else if (offset < document.getCharsSequence().length() - 1) {
                        char nextChar = document.getCharsSequence().charAt(offset + 1);
                        if (termsCount > 0 && nextChar == ']') {
                            document.insertString(offset + 1, (CharSequence)" ");
                            caret.moveCaretRelatively(1, 0, false, false, false);
                        }
                    }
                    document.insertString(it2.getStart(), (CharSequence)"[");
                    PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                    OCChangeUtil.reformatTextIfNotInjected(file, it2.getStart(), it2.getStart() + 2);
                }
            }
        } else if (c == '{') {
            HighlighterIterator it3 = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset() - 1);
            it3.retreat();
            if (OCTypedHandlerDelegate.needSemicolonAtContextEnd(it3)) {
                it3 = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset());
                OCTypedHandlerDelegate.eatWhitespaces(it3);
                if (!it3.atEnd() && it3.getTokenType() == OCTokenTypes.RBRACE) {
                    int offset = it3.getEnd();
                    it3.advance();
                    OCTypedHandlerDelegate.eatWhitespaces(it3);
                    if (it3.atEnd() || it3.getTokenType() != OCTokenTypes.SEMICOLON) {
                        document.insertString(offset, (CharSequence)";");
                    }
                }
            }
        } else if (c == '#' && !OCFormatterUtil.FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED.contains((it = ((EditorEx)editor).getHighlighter().createIterator(caret.getOffset() - 1)).getTokenType()) && (originalIndent = OCMultilineNodeFormatter.getIndentAtPosition(it)) != null) {
            int spaceEnd = it.atEnd() ? 0 : it.getEnd();
            String newIndent = OCMultilineNodeFormatter.getDirectiveIndentFromAnchor(it, file, true);
            if (newIndent == null) {
                PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                OCChangeUtil.reformatTextIfNotInjected(file, spaceEnd - originalIndent.length() + 1, caret.getOffset());
            } else if (!newIndent.equals(originalIndent)) {
                document.replaceString(spaceEnd - originalIndent.length(), spaceEnd, (CharSequence)newIndent);
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(19);
        }
        return result;
    }

    private static void eatWhitespaces(HighlighterIterator it) {
        while (!it.atEnd() && it.getTokenType() == TokenType.WHITE_SPACE) {
            it.advance();
        }
    }

    private static boolean skipObjcLiteral(HighlighterIterator it) {
        OCHighlightingTokenIterator iterator = new OCHighlightingTokenIterator(it);
        return OBJC_LITERAL_DETECTOR.tryNext(iterator);
    }

    public static boolean needSemicolonAtContextEnd(@NotNull HighlighterIterator it) {
        if (it == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(20);
        }
        return OCTypedHandlerDelegate.needSemicolonAtContextEnd(OCTypedHandlerDelegate.getContextTypeFromPosition(it));
    }

    @Contract(pure=true)
    private static boolean needSemicolonAtContextEnd(@NotNull ContextType block) {
        if (block == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(21);
        }
        return block == ContextType.ClassCPP || block == ContextType.StructLike || block == ContextType.EqualExpression;
    }

    public static ContextType getContextTypeFromPosition(@NotNull HighlighterIterator it) {
        if (it == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(22);
        }
        int inTemplateBrackets = 0;
        int inParens = 0;
        int inSquareBracket = 0;
        boolean functionImpl = false;
        boolean varDecl = false;
        IElementType prevType = null;
        while (!it.atEnd()) {
            IElementType currType = it.getTokenType();
            if (STOPSET.contains(currType)) {
                if (currType != OCTokenTypes.LBRACE || !varDecl) break;
                it.retreat();
                varDecl = !OCTypedHandlerDelegate.needSemicolonAtContextEnd(it);
                break;
            }
            if (inParens == 0 && inSquareBracket == 0) {
                if (currType == OCTokenTypes.GT) {
                    ++inTemplateBrackets;
                } else if (currType == OCTokenTypes.GTGT) {
                    inTemplateBrackets += 2;
                } else if (currType == OCTokenTypes.LT) {
                    --inTemplateBrackets;
                } else if (currType == OCTokenTypes.LTLT) {
                    inTemplateBrackets -= 2;
                } else if (currType == OCTokenTypes.IDENTIFIER && !functionImpl) {
                    varDecl = true;
                } else if (currType == OCTokenTypes.COLON || currType == OCTokenTypes.COMMA) {
                    functionImpl = false;
                    varDecl = false;
                } else if (inTemplateBrackets == 0 && NON_SEMICOLON_BLOCK_OWNERS.contains(currType)) {
                    if (OCTokenTypes.NAMESPACE_CPP_KEYWORD == currType) {
                        return ContextType.Namespace;
                    }
                    if (OCTokenTypes.SWITCH_KEYWORD == currType) {
                        return ContextType.SwitchStatement;
                    }
                    return ContextType.Statement;
                }
                if (!(currType != OCTokenTypes.COLON && currType != OCTokenTypes.EQ || prevType != OCTokenTypes.AT && prevType != OCTokenTypes.XOR && prevType != OCTokenTypes.LBRACKET)) {
                    return currType == OCTokenTypes.EQ ? ContextType.EqualExpression : ContextType.Expression;
                }
            }
            if (currType == OCTokenTypes.RBRACKET) {
                ++inSquareBracket;
            } else if (currType == OCTokenTypes.LBRACKET) {
                --inSquareBracket;
            }
            if (currType == OCTokenTypes.RPAR) {
                ++inParens;
            } else if (currType == OCTokenTypes.LPAR) {
                if (inTemplateBrackets == 0) {
                    functionImpl = true;
                    varDecl = false;
                }
                --inParens;
            } else if (inParens == 0 && !OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(currType)) {
                prevType = currType;
            }
            if (inTemplateBrackets < 0) {
                inTemplateBrackets = 0;
            }
            if (inParens < 0) {
                inParens = 0;
            }
            if (currType == OCTokenTypes.COLON && inTemplateBrackets > 0) {
                inTemplateBrackets = 0;
            }
            if (inTemplateBrackets == 0 && inParens == 0 && OCTokenTypes.COMPOSITE_TYPE_SPECIFIERS.contains(currType)) {
                return functionImpl ? ContextType.Expression : (currType == OCTokenTypes.CLASS_KEYWORD ? ContextType.ClassCPP : ContextType.StructLike);
            }
            it.retreat();
        }
        return varDecl ? ContextType.EqualExpression : ContextType.Expression;
    }

    private static boolean isAssignment(HighlighterIterator it) {
        while (((LexerEditorHighlighter.HighlighterIteratorImpl)it).currentIndex() >= 0) {
            IElementType currType = it.getTokenType();
            if (currType == OCTokenTypes.EQ) {
                return true;
            }
            if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(currType)) {
                return false;
            }
            it.retreat();
        }
        return false;
    }

    private static int skipBlock(HighlighterIterator it, OCPunctuatorElementType leftBracketType, OCPunctuatorElementType rightBracketType) {
        IElementType ttt;
        int parBalance = 0;
        while (!it.atEnd() && (ttt = it.getTokenType()) != null) {
            if (ttt == leftBracketType) {
                ++parBalance;
            } else if (ttt == rightBracketType) {
                --parBalance;
            }
            if (parBalance == 0) break;
            it.advance();
        }
        return parBalance;
    }

    private static void skipWhitespaceForward(HighlighterIterator it) {
        while (it.getTokenType() == TokenType.WHITE_SPACE) {
            it.advance();
        }
    }

    private static boolean isNext(Editor editor, int offset, OCElementType type) {
        Document document = editor.getDocument();
        if (offset >= document.getTextLength()) {
            return false;
        }
        HighlighterIterator it = ((EditorEx)editor).getHighlighter().createIterator(offset);
        return it.getTokenType() == type;
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project2 == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(23);
        }
        if (editor == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(24);
        }
        if (file == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(25);
        }
        if (c == '#') {
            int offset = editor.getCaretModel().getOffset();
            Document document = editor.getDocument();
            if (OCTypedHandlerDelegate.containsWhitespacesOnly(document.getCharsSequence().subSequence(document.getLineStartOffset(document.getLineNumber(offset)), offset))) {
                AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor, null);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    OCTypedHandlerDelegate.$$$reportNull$$$0(26);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(27);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result beforeSelectionRemoved(char c, @NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        String text;
        if (project2 == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(28);
        }
        if (editor == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(29);
        }
        if (file == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(30);
        }
        if ((CodeInsightSettings.getInstance().SURROUND_SELECTION_ON_QUOTE_TYPED && (c == '[' || c == '\'' || c == '\"') || c == '(') && (text = editor.getSelectionModel().getSelectedText()) != null && text.startsWith("<#") && text.endsWith("#>")) {
            EditorModificationUtil.deleteSelectedText((Editor)editor);
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            OCTypedHandlerDelegate.$$$reportNull$$$0(31);
        }
        return result;
    }

    @Contract(pure=true)
    private static boolean containsWhitespacesOnly(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean checkPosition(Editor editor, int offset, int upToOffset) {
        StringBuilder builder = new StringBuilder(upToOffset - offset + 2);
        Document document = editor.getDocument();
        if (offset >= upToOffset) {
            return true;
        }
        if (offset >= document.getTextLength() || upToOffset >= document.getTextLength()) {
            return true;
        }
        Project project2 = editor.getProject();
        if (project2 == null || !FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            return false;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        builder.append('[').append(document.getCharsSequence().subSequence(offset, upToOffset)).append(']');
        if (!OCTypedHandlerDelegate.hasErrors(builder, file)) {
            return true;
        }
        builder.setLength(builder.length() - 1);
        builder.append(" a]");
        return !OCTypedHandlerDelegate.hasErrors(builder, file);
    }

    private static boolean hasErrors(StringBuilder builder, PsiFile file) {
        OCExpression expression = OCElementFactory.expressionFromText(builder.toString(), (PsiElement)file);
        if (expression == null) {
            return false;
        }
        final boolean[] hasErrors = new boolean[]{false};
        expression.accept(new OCRecursiveVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                hasErrors[0] = true;
            }

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                if (expression.getArguments().size() == 0) {
                    hasErrors[0] = true;
                }
                super.visitSendMessageExpression(expression);
            }
        });
        return hasErrors[0];
    }

    private static String tokenText(Editor editor, HighlighterIterator it) {
        return editor.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString();
    }

    static {
        ArrayList<IElementType> types = new ArrayList<IElementType>();
        types.add(OCTokenTypes.XOR);
        types.add(OCTokenTypes.SEMICOLON);
        for (BracePair bracePair : OCBraceMatcher.PAIRS) {
            types.add(bracePair.getLeftBraceType());
            types.add(bracePair.getRightBraceType());
        }
        BLOCK_TYPE_STOP_SET = types.toArray(IElementType.EMPTY_ARRAY);
        NUMBER_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.token(OCTokenTypes.INTEGER_LITERAL, OCTokenTypes.FLOAT_LITERAL), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        STRING_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.ONE_OR_MORE, OCBackwardRepeatDetector.token(OCTokenTypes.STRING_LITERAL)), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        ARRAY_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.block(OCTokenTypes.LBRACKET, OCTokenTypes.RBRACKET), OCBackwardRepeatDetector.token(OCTokenTypes.AT));
        BRACED_LITERAL_DETECTOR = OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.block(OCTokenTypes.LBRACE, OCTokenTypes.RBRACE), OCBackwardRepeatDetector.or(OCBackwardRepeatDetector.token(OCTokenTypes.AT), OCBackwardRepeatDetector.sequence(OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.MAYBE_ONE, OCBackwardRepeatDetector.block(OCTokenTypes.LPAR, OCTokenTypes.RPAR)), OCBackwardRepeatDetector.repeat(OCBackwardStructureDetector.Cardinality.ZERO_OR_MORE, OCBackwardRepeatDetector.tokenExcept(BLOCK_TYPE_STOP_SET)), OCBackwardRepeatDetector.token(OCTokenTypes.XOR))));
        OBJC_LITERAL_DETECTOR = OCBackwardRepeatDetector.or(NUMBER_LITERAL_DETECTOR, STRING_LITERAL_DETECTOR, ARRAY_LITERAL_DETECTOR, BRACED_LITERAL_DETECTOR);
        NON_SEMICOLON_BLOCK_OWNERS = TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.DO_KEYWORD, OCTokenTypes.ELSE_KEYWORD, OCTokenTypes.FOR_KEYWORD, OCTokenTypes.IF_KEYWORD, OCTokenTypes.SWITCH_KEYWORD, OCTokenTypes.CASE_KEYWORD, OCTokenTypes.DEFAULT_KEYWORD, OCTokenTypes.WHILE_KEYWORD, OCTokenTypes.TRY_KEYWORD, OCTokenTypes.CATCH_KEYWORD, OCTokenTypes.FINALLY_KEYWORD, OCTokenTypes.SYNCHRONIZED_KEYWORD, OCTokenTypes.INTERFACE_KEYWORD, OCTokenTypes.AUTO_RELEASE_POOL_KEYWORD, OCTokenTypes.NAMESPACE_CPP_KEYWORD, OCTokenTypes.IMPLEMENTATION_KEYWORD, OCTokenTypes.PROTOCOL_KEYWORD, OCTokenTypes.LBRACKET});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 24: 
            case 29: 
            case 33: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 25: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/OCTypedHandlerDelegate";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/OCTypedHandlerDelegate";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeSelectionRemoved";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isBracketBalancingSupported";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "needSemicolonAtContextEnd";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getContextTypeFromPosition";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "beforeSelectionRemoved";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$beforeCharTyped$2";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ContextType {
        Namespace,
        ClassCPP,
        StructLike,
        Expression,
        EqualExpression,
        SwitchStatement,
        Statement;

    }
}

