/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCSmartCompletionContributor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCMethodImplementationCompletionContributor
extends OCCompletionContributorBase {
    public static final ElementPattern<PsiElement> SELECTOR_PART_DECLARATION = PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCMethodSelectorPart.class);

    public OCMethodImplementationCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                PsiElement selector;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((selector = parameters.getPosition().getParent()) instanceof OCMethodSelectorPart) {
                    OCMethod method = (OCMethod)selector.getParent();
                    StringBuilder exactSelectorPrefixBuilder = new StringBuilder();
                    for (OCMethodSelectorPart arg : method.getParameters()) {
                        if (arg == selector) break;
                        exactSelectorPrefixBuilder.append(arg.getSelectorPart());
                    }
                    String exactSelectorPrefix = exactSelectorPrefixBuilder.toString();
                    PsiElement parent = method.getParent();
                    if (parent instanceof OCImplementation) {
                        OCType expectedType;
                        OCTypeElement typeElement;
                        OCImplementation impl = (OCImplementation)parent;
                        OCImplementationSymbol implementationSymbol = impl.getSymbol();
                        OCObjectType type = impl.getType();
                        if (type == null) {
                            return;
                        }
                        OCObjectTypeContext receiverContext = new OCObjectTypeContext(!method.isInstanceMethod(), true, type, null);
                        HashSet implemented = new HashSet();
                        Project project2 = parent.getProject();
                        if (implementationSymbol != null) {
                            implementationSymbol.processMembers((String)null, (Processor<OCMemberSymbol>)((Processor)symbol -> {
                                implemented.add(symbol.getSignature(project2));
                                return true;
                            }));
                        }
                        Condition condition = symbol -> !implemented.contains(symbol.getSignature(project2));
                        if (parameters.getCompletionType() == CompletionType.SMART && (typeElement = method.getReturnTypeElement()) != null && (expectedType = typeElement.getType().resolve(method)) != OCUnknownType.INSTANCE) {
                            condition = Conditions.and((Condition)condition, new OCSmartCompletionContributor.TypeMatchingCondition(method.getContainingOCFile(), selector, expectedType, false, null));
                        }
                        MethodSelectorCompletionContributor.Context ctx = new MethodSelectorCompletionContributor.Context(exactSelectorPrefix, null, receiverContext, (Condition<OCMethodSymbol>)condition);
                        OCMethodImplementationCompletionContributor.doAddCompletions(result, parameters, false, ctx);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCMethodImplementationCompletionContributor$1", "addCompletions"));
            }
        };
        this.register(CompletionType.BASIC, SELECTOR_PART_DECLARATION, provider2);
        this.register(CompletionType.SMART, SELECTOR_PART_DECLARATION, provider2);
    }

    private static int doAddCompletions(CompletionResultSet result, OCCompletionParameters parameters, boolean avoidNSObjectMethods, MethodSelectorCompletionContributor.Context context) {
        OCType nsobject;
        int[] addedCnt = new int[]{0};
        Processor<OCMethodSymbol> processor2 = MethodSelectorCompletionContributor.getProcessor(parameters, result, addedCnt, context);
        context.getReceiverContext().getType().processMembers(OCMethodSymbol.class, processor2);
        if (!avoidNSObjectMethods && (nsobject = OCReferenceType.fromText("NSObject").resolve((PsiElement)parameters.getOriginalFile())) instanceof OCObjectType) {
            ((OCObjectType)nsobject).processMembers(OCMethodSymbol.class, processor2);
        }
        return addedCnt[0];
    }
}

