/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.completion.MethodSelectorCompletionContributor;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionContributorBase;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionParameters;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPatterns;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionProvider;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionStatistician;
import com.jetbrains.cidr.lang.editor.completion.SymbolLookupBuilderUtil;
import com.jetbrains.cidr.lang.editor.completion.TemplateInsertHandler;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.resolve.OCSelectorAdHocResolver;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeGuesser;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSmartCompletionContributor
extends OCCompletionContributorBase {
    public static final ElementPattern<PsiElement> INSIDE_EXPRESSION = StandardPatterns.or((ElementPattern[])new ElementPattern[]{((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(OCReferenceElement.class)).withSuperParent(2, OCExpression.class), ((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PsiErrorElement.class)).withSuperParent(2, OCExpression.class)});
    public static final ElementPattern<PsiElement> IN_QUALIFIED_EXPRESSION = PlatformPatterns.psiElement((IElementType)OCTokenTypes.IDENTIFIER).withParent(OCQualifiedExpression.class);

    public OCSmartCompletionContributor() {
        OCCompletionProvider provider2 = new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, final CompletionResultSet result) {
                boolean onlySendMessage;
                OCExpression contextExpression;
                PsiElement position;
                PsiElement refElement;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!((refElement = (position = parameters.getPosition()).getParent()).getParent() instanceof OCExpression)) {
                    MethodSelectorCompletionContributor.addMethodCompletionsIfAppropriate(parameters, result, refElement);
                    return;
                }
                OCExpression expr = (OCExpression)refElement.getParent();
                final Project project2 = expr.getProject();
                PsiElement exprParent = expr.getParent();
                if (exprParent instanceof OCSendMessageExpression) {
                    PsiElement[] children = exprParent.getChildren();
                    if (children.length == 2 && children[0] == expr && children[1] instanceof PsiErrorElement) {
                        contextExpression = (OCExpression)exprParent;
                        onlySendMessage = true;
                    } else {
                        contextExpression = expr;
                        onlySendMessage = false;
                    }
                } else {
                    contextExpression = expr;
                    onlySendMessage = false;
                }
                boolean ifOrWhileCondition = exprParent instanceof OCCondition && (exprParent.getParent() instanceof OCIfStatement || exprParent.getParent() instanceof OCWhileStatement);
                OCDeclarator declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)contextExpression, OCDeclarator.class);
                OCSymbol ownSymbol = declarator != null ? declarator.getSymbol() : null;
                final OCResolveContext resolveContext = OCResolveContext.forPsi(contextExpression);
                final OCType expectedType = OCExpectedTypeUtil.getExpectedType(contextExpression).resolve(resolveContext);
                if (expectedType != OCUnknownType.INSTANCE) {
                    OCObjectType obj;
                    OCInterfaceSymbol symbol2;
                    if (contextExpression.getParent() instanceof OCParenthesizedExpression && position == parameters.getRealPosition()) {
                        LookupElementBuilder element = LookupElementBuilder.create((String)expectedType.getName(resolveContext));
                        PsiElement lastChild = contextExpression.getParent().getLastChild();
                        if (lastChild != null && !lastChild.getText().endsWith(")")) {
                            element = element.withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                                public void handleInsert(InsertionContext context, LookupElement item) {
                                    int tailOffset;
                                    Document document = context.getDocument();
                                    Editor editor = context.getEditor();
                                    CharSequence text = document.getCharsSequence();
                                    if (text.charAt(CharArrayUtil.shiftForward((CharSequence)text, (int)(tailOffset = context.getTailOffset()), (String)" \t")) != ')') {
                                        document.insertString(tailOffset, (CharSequence)")");
                                    }
                                    editor.getCaretModel().moveToOffset(CharArrayUtil.shiftForward((CharSequence)text, (int)(tailOffset + 1), (String)" \t"));
                                }
                            });
                        }
                        result.addElement(OCCompletionPriority.elementWithPriority((LookupElement)element, OCCompletionPriority.HIGH_PRIORITY));
                        if (prefix.isEmpty()) {
                            return;
                        }
                    }
                    if (!onlySendMessage) {
                        boolean supportsObjLiterals = OCCompilerFeatures.supportsObjectLiterals(refElement.getContainingFile());
                        OCPointerType array = OCPointerType.to(OCReferenceType.fromText("NSArray"));
                        OCPointerType dic = OCPointerType.to(OCReferenceType.fromText("NSDictionary"));
                        if (supportsObjLiterals && expectedType.checkCompatible(array, null, refElement, resolveContext).getState() == OCTypeCheckState.OK) {
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("@[ ]", "@[<caret>]"));
                        } else if (supportsObjLiterals && expectedType.checkCompatible(dic, null, refElement, resolveContext).getState() == OCTypeCheckState.OK) {
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("@{ }", "@{<caret>}"));
                        } else if (expectedType.equalsWithAliasName(OCIntType.BOOL, resolveContext)) {
                            if (resolveContext.isObjc()) {
                                result.addElement(OCSmartCompletionContributor.createTemplateElement("YES", "YES"));
                                result.addElement(OCSmartCompletionContributor.createTemplateElement("NO", "NO"));
                            } else {
                                result.addElement(OCSmartCompletionContributor.createTemplateElement("TRUE", "TRUE"));
                                result.addElement(OCSmartCompletionContributor.createTemplateElement("FALSE", "FALSE"));
                            }
                        } else if (OCIntType.isBool(expectedType, resolveContext)) {
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("true", "true"));
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("false", "false"));
                        } else if (expectedType.isPointerToObjectCompatible()) {
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("nil", "nil"));
                        } else if (expectedType instanceof OCPointerType) {
                            result.addElement(OCSmartCompletionContributor.createTemplateElement("NULL", "NULL"));
                        }
                    }
                    CompletionBuilder builder = new CompletionBuilder(result, contextExpression, project2);
                    boolean[] foundEnumConsts = new boolean[]{false};
                    if (!onlySendMessage && expectedType instanceof OCStructType) {
                        for (OCStructSymbol struct : ((OCStructType)expectedType).getStructs()) {
                            if (struct.getKind() != OCSymbolKind.ENUM) continue;
                            struct.processFields((Processor<OCDeclaratorSymbol>)((Processor)field -> {
                                LookupElementBuilder lookup = SymbolLookupBuilderUtil.lookup(field, project2);
                                lookup = lookup.withInsertHandler((InsertHandler)new SymbolLookupBuilderUtil.OCEnumConstInsertHandler((OCDeclaratorSymbol)field, contextExpression));
                                builder.tryAddLookup((OCSymbol)field, (LookupElement)lookup);
                                foundEnumConsts[0] = true;
                                return true;
                            }));
                        }
                    } else if (!onlySendMessage && expectedType instanceof OCIntType) {
                        OCTypeGuesser.processGuessedEnumConsts((OCIntType)expectedType, (Processor<OCSymbol>)((Processor)symbol -> {
                            LookupElementBuilder lookup = SymbolLookupBuilderUtil.lookup(symbol, project2);
                            if (symbol instanceof OCDeclaratorSymbol) {
                                lookup = lookup.withInsertHandler((InsertHandler)new SymbolLookupBuilderUtil.OCEnumConstInsertHandler((OCDeclaratorSymbol)symbol, contextExpression));
                            }
                            builder.tryAddLookup((OCSymbol)symbol, (LookupElement)lookup);
                            foundEnumConsts[0] = true;
                            return true;
                        }), contextExpression);
                    } else if (!onlySendMessage && expectedType instanceof OCBlockPointerType) {
                        result.addElement(OCSmartCompletionContributor.createBlockTemplateElement((OCBlockPointerType)expectedType, contextExpression));
                    } else if (!onlySendMessage && expectedType.getName().equals("SEL")) {
                        OCSmartCompletionContributor.addSelectorCompletions(result, contextExpression);
                    } else if (expectedType.isPointerToObject() && (symbol2 = (obj = (OCObjectType)((OCPointerType)expectedType).getRefType()).getInterface()) != null) {
                        final String className = symbol2.getName();
                        Processor<OCMethodSymbol> constructorProcessor = new Processor<OCMethodSymbol>(){
                            private final Set<String> processed = new HashSet<String>();

                            public boolean process(OCMethodSymbol method) {
                                if (method.isConstructorMethod() && expectedType.isCompatible(method.getReturnType(obj, project2).resolve(resolveContext), resolveContext) && this.processed.add(method.getName())) {
                                    OCMethodSymbol methodNew;
                                    OCType terminalType;
                                    if ("init".equals(method.getName()) && this.processed.add("new") && (terminalType = expectedType.getTerminalType()) instanceof OCObjectType && (methodNew = ((OCObjectType)terminalType).findMember("new", OCMethodSymbol.class)) != null) {
                                        LookupElementBuilder lookup = SymbolLookupBuilderUtil.lookup((OCSymbol)methodNew, onlySendMessage, "[" + className, obj, contextExpression, null, project2);
                                        lookup.putUserData(OCCompletionStatistician.STATISTICIAN_TYPENAME_CONTEXT, (Object)className);
                                        result.addElement((LookupElement)lookup);
                                    }
                                    String qualifier = "[[" + className + " alloc]";
                                    LookupElementBuilder lookup = SymbolLookupBuilderUtil.lookup((OCSymbol)method, onlySendMessage, qualifier, obj, contextExpression, null, project2);
                                    lookup.putUserData(OCCompletionStatistician.STATISTICIAN_TYPENAME_CONTEXT, (Object)className);
                                    result.addElement((LookupElement)lookup);
                                }
                                return true;
                            }
                        };
                        Processor<OCMethodSymbol> factoryProcessor = new Processor<OCMethodSymbol>(){
                            private final Set<String> processed = new HashSet<String>();

                            public boolean process(OCMethodSymbol method) {
                                if (method.isFactoryMethod()) {
                                    this.checkAndAdd(method, false);
                                } else if (method.isStatic()) {
                                    this.checkAndAdd(method, true);
                                }
                                return true;
                            }

                            private void checkAndAdd(OCMethodSymbol method, boolean strict) {
                                OCType type = method.getReturnType(obj, project2).resolve(resolveContext);
                                if (strict && type.isPointerToID()) {
                                    return;
                                }
                                if (expectedType.isCompatible(type, resolveContext) && this.processed.add(method.getName())) {
                                    LookupElementBuilder lookup = SymbolLookupBuilderUtil.lookup((OCSymbol)method, onlySendMessage, "[" + className, obj, contextExpression, null, project2);
                                    lookup.putUserData(OCCompletionStatistician.STATISTICIAN_TYPENAME_CONTEXT, (Object)className);
                                    result.addElement((LookupElement)lookup);
                                }
                            }
                        };
                        OCInterfaceSymbol current = symbol2;
                        while (current != null) {
                            current.processMembersInAllCategories(null, OCMethodSymbol.class, constructorProcessor, project2);
                            current.processMembersInAllCategories(null, OCMethodSymbol.class, factoryProcessor, project2);
                            OCType superType = current.getSuperType().resolve(resolveContext);
                            if (superType instanceof OCObjectType) {
                                current = ((OCObjectType)superType).getInterface();
                                continue;
                            }
                            current = null;
                        }
                    }
                    if (!onlySendMessage && refElement instanceof OCReferenceElement) {
                        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName((OCReferenceElement)refElement).changeName(null);
                        OCSymbolReference.LocalReference ref = OCSymbolReference.getLocalReference(qualifiedName, refElement);
                        TypeMatchingCondition condition = new TypeMatchingCondition((OCFile)resolveContext.getFile(), refElement, expectedType, foundEnumConsts[0], ownSymbol, ifOrWhileCondition);
                        FilteringProcessor processor2 = new FilteringProcessor(condition, (Processor)builder);
                        OCThisSelfSuperSymbol.processThisSelfSuperInContext((OCReferenceElement)refElement, (Processor<OCSymbol>)processor2, false);
                        ref.processPossibleSymbols((Processor<OCSymbol>)processor2, resolveContext);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor$1", "addCompletions"));
            }
        };
        this.register(CompletionType.SMART, INSIDE_EXPRESSION, provider2);
        this.register(CompletionType.SMART, (ElementPattern<? extends PsiElement>)OCCompletionPatterns.REFERENCE_ELEMENT.andNot(OCCompletionPatterns.AFTER_DOT), provider2);
        this.register(CompletionType.SMART, IN_QUALIFIED_EXPRESSION, new OCCompletionProvider(){

            @Override
            protected void addCompletions(String prefix, @NotNull OCCompletionParameters parameters, ProcessingContext context, CompletionResultSet result) {
                OCQualifiedExpression qualifiedExpression;
                OCDeclarator declarator;
                if (parameters == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCSymbol ownSymbol = (declarator = (OCDeclarator)PsiTreeUtil.getParentOfType((PsiElement)(qualifiedExpression = (OCQualifiedExpression)parameters.getPosition().getParent()), OCDeclarator.class)) != null ? declarator.getSymbol() : null;
                OCType expectedType = OCExpectedTypeUtil.getExpectedType(qualifiedExpression).resolve(qualifiedExpression);
                if (expectedType != OCUnknownType.INSTANCE) {
                    for (OCPunctuatorElementType qt : qualifiedExpression.qualifyingTokensForCompletion()) {
                        OCSmartCompletionContributor.addCompletionsForQualifiedExpression(result, qualifiedExpression, expectedType, ownSymbol, qt);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor$2", "addCompletions"));
            }
        });
    }

    private static void addCompletionsForQualifiedExpression(@NotNull CompletionResultSet result, @NotNull OCQualifiedExpression expression, @NotNull OCType expectedType, OCSymbol excludeSymbol, final @NotNull OCPunctuatorElementType qualifyingToken) {
        if (result == null) {
            OCSmartCompletionContributor.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            OCSmartCompletionContributor.$$$reportNull$$$0(1);
        }
        if (expectedType == null) {
            OCSmartCompletionContributor.$$$reportNull$$$0(2);
        }
        if (qualifyingToken == null) {
            OCSmartCompletionContributor.$$$reportNull$$$0(3);
        }
        TypeMatchingCondition condition = new TypeMatchingCondition(expression.getContainingOCFile(), expression, expectedType, false, excludeSymbol);
        condition.setQualifierType(expression.getQualifier().getResolvedType());
        FilteringProcessor processor2 = new FilteringProcessor(condition, (Processor)new CompletionBuilder(result, expression, expression.getProject()){

            @Override
            protected void addLookup(@NotNull LookupElement lookup) {
                if (lookup == null) {
                    3.$$$reportNull$$$0(0);
                }
                OCQualifiedExpression.COMPLETION_QUALIFYING_TOKEN_KEY.set((UserDataHolder)lookup, (Object)qualifyingToken);
                super.addLookup(lookup);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor$3", "addLookup"));
            }
        });
        expression.processTargets(null, (Processor<OCSymbol>)processor2, false, qualifyingToken, false, true, null);
    }

    static void addSelectorCompletions(CompletionResultSet result, OCExpression selectorExpr) {
        OCClassSymbol classSymbol;
        result.addElement(OCSmartCompletionContributor.createTemplateElement("@selector", "@selector(<caret>)"));
        OCObjectTypeContext targetContext = OCSelectorAdHocResolver.getActionTargetContext(selectorExpr);
        if (targetContext != null && (classSymbol = targetContext.getType().getClassSymbol()) != null) {
            classSymbol.processMembers(OCMethodSymbol.class, symbol -> {
                LookupElementBuilder lookupElement = LookupElementBuilder.create((String)("@selector(" + symbol.getName() + ")"));
                result.addElement(OCCompletionPriority.elementWithPriority((LookupElement)lookupElement, OCCompletionPriority.HIGHEST_PRIORITY));
                return true;
            });
        }
    }

    static LookupElement createBlockTemplateElement(OCBlockPointerType expectedType, @NotNull PsiElement context) {
        String template;
        String value;
        if (context == null) {
            OCSmartCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((value = expectedType.getDefaultValue(OCResolveContext.forPsi(context))).contains("{\n}")) {
            template = StringUtil.replace((String)value, (String)"{\n}", (String)"{\n<caret>\n}");
            value = StringUtil.replace((String)value, (String)"{\n}", (String)"{}");
        } else {
            template = value.replaceFirst("\n", "\n<caret>");
        }
        LookupElement lookupElement = OCSmartCompletionContributor.createTemplateElement(value.replaceAll("\\n+", " "), template);
        return OCCompletionPriority.elementWithPriority(lookupElement, OCCompletionPriority.HIGHEST_PRIORITY);
    }

    private static LookupElement createTemplateElement(String value, String template) {
        LookupElementBuilder builder = TemplateInsertHandler.lookup(value, template);
        LookupElementBuilder answer = builder.bold();
        if (template.contains("<caret>")) {
            answer.putUserData(SymbolLookupBuilderUtil.DONT_GO_NEXT_TEMPLATE, (Object)Boolean.TRUE);
        }
        return answer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifyingToken";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletionsForQualifiedExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createBlockTemplateElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class TypeMatchingCondition<T extends OCSymbol>
    implements Condition<T> {
        private final OCFile myFile;
        @NotNull
        private final PsiElement myContext;
        private final OCType myExpectedType;
        private final boolean myStrictTypeMatch;
        private final OCSymbol myBannedSymbol;
        private final boolean myAllowPointersForBooleans;
        private boolean myAvoidNSObjectMethods;
        private boolean myAcceptTypeDeclarations;
        private OCObjectTypeContext myReceiverContext;
        private OCType myQualifierType;

        public TypeMatchingCondition(OCFile file, @NotNull PsiElement context, OCType expectedType) {
            if (context == null) {
                TypeMatchingCondition.$$$reportNull$$$0(0);
            }
            this(file, context, expectedType, false, null);
        }

        public TypeMatchingCondition(OCFile file, @NotNull PsiElement context, OCType expectedType, boolean strictTypeMatch, OCSymbol bannedSymbol) {
            if (context == null) {
                TypeMatchingCondition.$$$reportNull$$$0(1);
            }
            this(file, context, expectedType, strictTypeMatch, bannedSymbol, false);
        }

        public TypeMatchingCondition(OCFile file, @NotNull PsiElement context, OCType expectedType, boolean strictTypeMatch, OCSymbol bannedSymbol, boolean allowPointersForBooleans) {
            if (context == null) {
                TypeMatchingCondition.$$$reportNull$$$0(2);
            }
            this.myFile = file;
            this.myContext = context;
            this.myExpectedType = expectedType;
            this.myStrictTypeMatch = strictTypeMatch;
            this.myBannedSymbol = bannedSymbol;
            this.myAllowPointersForBooleans = allowPointersForBooleans;
            this.myAvoidNSObjectMethods = true;
        }

        public void acceptTypeDeclarations(boolean acceptTypeDeclarations) {
            this.myAcceptTypeDeclarations = acceptTypeDeclarations;
        }

        public void avoidNSObjectMethods(boolean avoidNSObjectMethods) {
            this.myAvoidNSObjectMethods = avoidNSObjectMethods;
        }

        public void setReceiverContext(OCObjectTypeContext context) {
            this.myReceiverContext = context;
        }

        public void setQualifierType(OCType qualifierType) {
            this.myQualifierType = qualifierType;
        }

        public boolean value(OCSymbol symbol) {
            if (Comparing.equal((Object)symbol, (Object)this.myBannedSymbol)) {
                return false;
            }
            OCType symbolType = this.getSymbolType(symbol, this.myContext);
            if (symbolType != null) {
                OCResolveContext context;
                if (symbolType.isUnknown()) {
                    return false;
                }
                if (symbolType.isPointerToID() && (!symbol.getKind().isLocal() || symbol instanceof OCThisSelfSuperSymbol)) {
                    if (!this.myExpectedType.isPointerToID()) {
                        return false;
                    }
                    OCType terminalType = this.myExpectedType.getTerminalType();
                    OCType symbolTerminalType = symbolType.getTerminalType();
                    if (terminalType instanceof OCObjectType && symbolTerminalType instanceof OCObjectType && ((OCObjectType)symbolTerminalType).getAllProtocols().isEmpty() && !((OCObjectType)terminalType).getAllProtocols().isEmpty()) {
                        return false;
                    }
                }
                if (this.myExpectedType.isCompatible(symbolType, context = OCResolveContext.forPsi(this.myContext))) {
                    OCClassSymbol owner2;
                    if (this.myAvoidNSObjectMethods && symbol instanceof OCMethodSymbol && "NSObject".equals((owner2 = (OCClassSymbol)((OCMethodSymbol)symbol).getParent()).getName()) && symbolType.equals(symbol.getEffectiveType().resolve(context), context)) {
                        return false;
                    }
                    if (symbolType.isPointerToVoid() && !this.myExpectedType.isPointerToVoid()) {
                        return false;
                    }
                    if (!this.myAllowPointersForBooleans && symbolType.isPointer() != this.myExpectedType.isPointer()) {
                        return false;
                    }
                    if (!OCVisibility.isVisible(symbol, this.myContext, this.myQualifierType, context.getProject())) {
                        return false;
                    }
                    return !this.myStrictTypeMatch || Comparing.equal((String)this.myExpectedType.getAliasName(), (String)symbolType.getAliasName());
                }
            }
            return false;
        }

        @Nullable
        protected OCType getSymbolType(OCSymbol symbol, PsiElement context) {
            OCType type;
            if (symbol instanceof OCMethodSymbol && this.myReceiverContext != null && (type = OCTypeGuesser.getMethodGuessedReturnType((OCMethodSymbol)symbol, this.myReceiverContext, null, context)) != null) {
                return type.resolve(this.myContext);
            }
            OCType symbolType = this.myAcceptTypeDeclarations ? (symbol instanceof OCStructSymbol ? symbol.getType() : symbol.getEffectiveType()) : (symbol instanceof OCDeclaratorSymbol && symbol.getKind() != OCSymbolKind.TYPEDEF || symbol instanceof OCMemberSymbol || symbol instanceof OCFunctionSymbol ? symbol.getEffectiveType() : null);
            return symbolType != null ? symbolType.resolve(this.myContext) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor$TypeMatchingCondition", "<init>"));
        }
    }

    private static class CompletionBuilder
    implements Processor<OCSymbol> {
        private PsiElement myContextExpression;
        private CompletionResultSet myResult;
        private HashSet<String> myNames;
        private final Project myProject;

        public CompletionBuilder(CompletionResultSet result, PsiElement contextExpression, Project project2) {
            this.myContextExpression = contextExpression;
            this.myResult = result;
            this.myProject = project2;
            this.myNames = new HashSet();
            this.myNames.add("_dispatch_data_destructor_free");
        }

        public boolean process(@NotNull OCSymbol symbol) {
            if (symbol == null) {
                CompletionBuilder.$$$reportNull$$$0(0);
            }
            this.tryAddLookup(symbol, (LookupElement)SymbolLookupBuilderUtil.lookup(symbol, false, null, null, this.myContextExpression, null, this.myProject));
            return true;
        }

        public void tryAddLookup(@NotNull OCSymbol symbol, @NotNull LookupElement lookup) {
            if (symbol == null) {
                CompletionBuilder.$$$reportNull$$$0(1);
            }
            if (lookup == null) {
                CompletionBuilder.$$$reportNull$$$0(2);
            }
            if (this.myNames.add(symbol.getSignature(this.myProject))) {
                this.addLookup(lookup);
            }
        }

        protected void addLookup(@NotNull LookupElement lookup) {
            if (lookup == null) {
                CompletionBuilder.$$$reportNull$$$0(3);
            }
            this.myResult.addElement(lookup);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "symbol";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookup";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/editor/completion/OCSmartCompletionContributor$CompletionBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryAddLookup";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addLookup";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

