/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.editor.completion.CallableInsertUtils;
import com.jetbrains.cidr.lang.editor.completion.FunctionInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.MacroInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.MethodInsertHandler;
import com.jetbrains.cidr.lang.editor.completion.OCCompletionPriority;
import com.jetbrains.cidr.lang.editor.completion.PropertyInsertHandler;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCBindUtil;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeParameterResolveVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SymbolLookupBuilderUtil {
    public static final Key<Boolean> DONT_GO_NEXT_TEMPLATE = Key.create((String)"TEMPLATE_LOOKUP");

    private SymbolLookupBuilderUtil() {
    }

    public static LookupElementBuilder lookup(OCSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(0);
        }
        return SymbolLookupBuilderUtil.lookup(symbol, false, null, null, null, null, project2);
    }

    public static LookupElement lookup(@NotNull OCSymbol symbol, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, boolean isFromCurrentType, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project2) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(2);
        }
        LookupElementBuilder result = SymbolLookupBuilderUtil.lookup(symbol, false, qualifier, receiverType, contextExpression, symbolContext, project2);
        OCCompletionPriority priority = isFromCurrentType ? OCCompletionPriority.HIGH_PRIORITY : null;
        return priority != null ? OCCompletionPriority.elementWithPriority((LookupElement)result, priority) : result;
    }

    public static LookupElementBuilder lookup(@NotNull OCSymbol symbol, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project2) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(4);
        }
        return SymbolLookupBuilderUtil.lookup(symbol.getName(), symbol, false, null, null, contextExpression, symbolContext, symbol.getIcon(project2), project2);
    }

    public static LookupElementBuilder lookup(@NotNull OCSymbol symbol, boolean insideSendMessage, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @NotNull Project project2) {
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(6);
        }
        return SymbolLookupBuilderUtil.lookup(symbol.getName(), symbol, insideSendMessage, qualifier, receiverType, contextExpression, symbolContext, symbol.getIcon(project2), project2);
    }

    public static LookupElementBuilder lookup(@NotNull String name2, @NotNull OCSymbol symbol, boolean insideSendMessage, @Nullable String qualifier, @Nullable OCObjectType receiverType, @Nullable PsiElement contextExpression, @Nullable OCSymbolGroupContext symbolContext, @Nullable Icon icon, @NotNull Project project2) {
        int spaceIndex;
        if (name2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(7);
        }
        if (symbol == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            SymbolLookupBuilderUtil.$$$reportNull$$$0(9);
        }
        if ((spaceIndex = name2.indexOf(32)) >= 0) {
            name2 = name2.substring(spaceIndex + 1);
        }
        boolean deprecated = symbol.isDeprecated() || !OCResolveUtil.isSymbolAvailable(symbol, contextExpression);
        LookupElementBuilder answer = LookupElementBuilder.create((Object)symbol, (String)name2).withIcon(icon).withStrikeoutness(deprecated);
        PsiFile ocFile = contextExpression == null ? null : contextExpression.getContainingFile();
        OCSymbolKind symbolKind = symbol.getKind();
        if (symbol instanceof OCClassSymbol) {
            VirtualFile file = symbol.getContainingFile();
            if (!(file == null || ocFile instanceof PsiFileImpl && ((PsiFileImpl)ocFile).getContentElementType() == OCElementTypes.TYPE_CODE_FRAGMENT)) {
                PsiElement parent;
                answer = answer.withTypeText(file.getName(), true);
                PsiElement psiElement = parent = contextExpression != null ? contextExpression.getContext() : null;
                if (contextExpression instanceof OCDeclarator) {
                    PsiElement possibleType = contextExpression.getPrevSibling();
                    if (possibleType instanceof OCTypeElement && possibleType.getText().isEmpty()) {
                        answer = answer.withInsertHandler((InsertHandler)new ClassInsertHandler(symbolContext));
                    }
                } else {
                    PsiElement superParent;
                    answer = parent instanceof OCTypeElement || parent instanceof OCReferenceExpression && (parent.getParent() instanceof OCParenthesizedExpression || parent.getParent() instanceof OCExpressionStatement) ? (!((superParent = parent.getContext()) instanceof OCSendMessageExpression || superParent instanceof OCProtocolExpression || superParent instanceof OCTemplateArgumentList) ? answer.withInsertHandler((InsertHandler)new ClassInsertHandler(symbolContext)) : answer.withInsertHandler((InsertHandler)new WithAutoImportFixHandler(symbolContext, symbolKind != OCSymbolKind.PROTOCOL))) : answer.withInsertHandler((InsertHandler)new WithAutoImportFixHandler(symbolContext, symbolKind != OCSymbolKind.PROTOCOL));
                }
            }
        } else if (symbolKind.isType()) {
            answer = answer.withInsertHandler((InsertHandler)new TypeInsertHandler(symbol, contextExpression));
        } else if (symbolKind == OCSymbolKind.NAMESPACE || symbolKind == OCSymbolKind.NAMESPACE_ALIAS) {
            answer = answer.withInsertHandler((InsertHandler)new NamespaceInsertHandler(contextExpression));
        } else if (symbol instanceof OCMacroSymbol) {
            IElementType type;
            OCDirective context = (OCDirective)PsiTreeUtil.getContextOfType((PsiElement)contextExpression, (Class[])new Class[]{OCDirective.class});
            IElementType iElementType = type = context != null ? context.getHeaderToken().getNode().getElementType() : null;
            if (type != OCTokenTypes.IFDEF_DIRECTIVE && type != OCTokenTypes.IFNDEF_DIRECTIVE && type != OCTokenTypes.UNDEF_DIRECTIVE) {
                OCMacroSymbol macroSymbol = (OCMacroSymbol)symbol;
                if (macroSymbol.hasParameterList()) {
                    answer = answer.withTailText(macroSymbol.getParametersSignature());
                }
                answer = answer.withInsertHandler((InsertHandler)new MacroInsertHandler(macroSymbol));
            }
        } else if (symbol instanceof OCMemberSymbol || symbol instanceof OCDeclaratorSymbol || symbol instanceof OCFunctionSymbol) {
            OCType resolved;
            OCType type;
            if (symbol instanceof OCMethodSymbol) {
                StringBuilder presentable;
                OCMethodSymbol method = (OCMethodSymbol)symbol;
                if (qualifier == null) {
                    qualifier = contextExpression instanceof OCReferenceExpression ? (method.isStatic() ? "[" + ((OCClassSymbol)method.getParent()).getName() : "[self") : "";
                }
                if ((presentable = new StringBuilder(qualifier)).length() > 0) {
                    presentable.append(' ');
                }
                presentable.append(method.getName());
                if (!qualifier.isEmpty()) {
                    presentable.append(']');
                }
                String insertQualifier = insideSendMessage && qualifier.startsWith("[") ? qualifier.substring(1) : qualifier;
                answer = answer.withInsertHandler((InsertHandler)new MethodInsertHandler(method, contextExpression, insideSendMessage, insertQualifier)).withPresentableText(presentable.toString()).withLookupString(presentable.toString());
                type = method.getReturnType(receiverType, project2);
            } else if (symbol instanceof OCFunctionSymbol) {
                OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
                type = functionSymbol.getType().getReturnType();
                answer = answer.withTailText(functionSymbol.getParametersSignature(project2));
                answer = answer.withInsertHandler(CallableInsertUtils.createHandler((OCFunctionSymbol)symbol, contextExpression));
            } else {
                Object parent;
                if (contextExpression instanceof OCQualifiedExpression && (symbolKind == OCSymbolKind.STRUCT_FIELD || symbolKind == OCSymbolKind.ENUM_CONST || symbolKind.isFunction())) {
                    answer = answer.withInsertHandler((InsertHandler)new StructFieldHandler(symbol, contextExpression));
                } else if (symbol instanceof OCPropertySymbol) {
                    answer = answer.withInsertHandler((InsertHandler)new PropertyInsertHandler(contextExpression, (OCPropertySymbol)symbol, symbolContext));
                } else {
                    answer = answer.withInsertHandler((InsertHandler)new WithAutoImportFixHandler(symbolContext, false));
                    if (symbol instanceof OCThisSelfSuperSymbol && ((OCThisSelfSuperSymbol)symbol).isKeywordLike()) {
                        answer = answer.bold();
                    }
                }
                type = symbol.getType();
                if (!(symbolKind != OCSymbolKind.ENUM_CONST || (parent = ((OCSymbolWithParent)symbol).getParent()) instanceof OCStructSymbol && ((OCStructSymbol)parent).isEnumClass())) {
                    type = OCUnknownType.INSTANCE;
                }
            }
            if (type != OCUnknownType.INSTANCE && (resolved = type.accept(new OCTypeParameterResolveVisitor(ocFile))) != null && contextExpression != null) {
                answer = answer.withTypeText(resolved.getName(contextExpression));
            }
        }
        return answer;
    }

    private static void fixImportsAtCaret(InsertionContext context, OCSymbolGroupContext symbolGroupContext) {
        OCImportSymbolFix.fixAtCaret(context.getEditor(), context.getFile(), symbolGroupContext);
        PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "symbol";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/completion/SymbolLookupBuilderUtil";
        objectArray[2] = "lookup";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class TypeInsertHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbol mySymbol;
        private final PsiElement myContext;

        private TypeInsertHandler(OCSymbol symbol, PsiElement context) {
            this.mySymbol = symbol;
            this.myContext = context;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            Document document = context.getDocument();
            Editor editor = context.getEditor();
            CharSequence text = document.getCharsSequence();
            int tailOffset = context.getTailOffset();
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
            if (!(this.myContext.getParent().getParent() instanceof OCCppNewExpression) && settings != null) {
                OCCodeStyleSettings customSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
                if (customSettings.SPACE_BEFORE_POINTER_IN_DECLARATION) {
                    OCType type;
                    boolean insert = true;
                    if (this.mySymbol.getKind() != OCSymbolKind.ENUM && this.mySymbol instanceof OCNamespaceSymbol || this.mySymbol instanceof OCTypeParameterSymbol) {
                        insert = false;
                    }
                    if (this.mySymbol.getKind() == OCSymbolKind.TYPEDEF && (type = this.mySymbol.getType().resolve(OCResolveContext.forSymbol(this.mySymbol, context.getProject()))) instanceof OCStructType) {
                        insert = false;
                    }
                    if (this.mySymbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL) {
                        insert = false;
                    }
                    if (insert && tailOffset < text.length()) {
                        char ch = text.charAt(tailOffset);
                        if (ch == ')' || ch == ']') {
                            return;
                        }
                        if (ch != ' ' && ch != '\t' && context.getCompletionChar() != ' ') {
                            document.insertString(tailOffset, (CharSequence)" ");
                        }
                        editor.getCaretModel().moveToOffset(tailOffset + 1);
                    }
                }
            }
            PsiElement parent = this.myContext.getParent();
            if (this.mySymbol.getKind().isStructLike() && this.myContext != null && OCCodeInsightUtil.isInPlainOldC(this.myContext) && parent != null && !(parent instanceof OCStructLike)) {
                document.insertString(context.getStartOffset(), (CharSequence)(this.mySymbol.getKind().getNameLowercase() + " "));
            }
            PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(document);
            OCImportSymbolFix.fixAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
            PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
        }
    }

    private static class ClassInsertHandler
    implements InsertHandler<LookupElement> {
        private OCSymbolGroupContext mySymbolContext;

        private ClassInsertHandler(OCSymbolGroupContext symbolContext) {
            this.mySymbolContext = symbolContext;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            OCCodeStyleSettings customSettings;
            int pos;
            char completionChar = context.getCompletionChar();
            if (completionChar == '.' || completionChar == ']') {
                SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
                return;
            }
            String text = context.getDocument().getText();
            for (pos = context.getTailOffset(); pos < text.length() && Character.isSpaceChar(text.charAt(pos)); ++pos) {
            }
            if (pos < text.length() && (text.charAt(pos) == '*' || text.charAt(pos) == '<')) {
                SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
                return;
            }
            StringBuilder insertion = new StringBuilder(completionChar == '*' ? "" : "*");
            CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)context.getProject());
            if (settings != null && (customSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class)) != null) {
                insertion.setLength(0);
                if (customSettings.SPACE_BEFORE_POINTER_IN_DECLARATION) {
                    insertion.append(' ');
                }
                if (completionChar != '*') {
                    insertion.append('*');
                    if (customSettings.SPACE_AFTER_POINTER_IN_DECLARATION) {
                        insertion.append(' ');
                    } else {
                        OCTypedHandlerDelegate.overTypeNextStar();
                    }
                }
            }
            if (completionChar == ' ') {
                context.setAddCompletionChar(false);
            }
            SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
            context.getDocument().insertString(context.getTailOffset(), (CharSequence)insertion.toString());
            context.getEditor().getCaretModel().moveCaretRelatively(insertion.length(), 0, false, false, true);
        }
    }

    private static class StructFieldHandler
    implements InsertHandler<LookupElement> {
        private final OCSymbol mySymbol;
        private final PsiElement myContextExpression;

        public StructFieldHandler(OCSymbol symbol, PsiElement contextExpression) {
            this.mySymbol = symbol;
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            FunctionInsertHandler.changeQualifyingTokenIfNeeded(context, this.myContextExpression, item);
            OCImportSymbolFix.fixAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
        }
    }

    public static class OCEnumConstInsertHandler
    implements InsertHandler<LookupElement> {
        private final OCDeclaratorSymbol mySymbol;
        private final PsiElement myContextExpression;

        public OCEnumConstInsertHandler(OCDeclaratorSymbol symbol, PsiElement contextExpression) {
            this.mySymbol = symbol;
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            if (this.myContextExpression instanceof OCReferenceExpression) {
                OCReferenceElement element = ((OCReferenceExpression)this.myContextExpression).getReferenceElement();
                OCResolveContext resolveContext = OCResolveContext.forPsi((PsiElement)context.getFile());
                OCQualifiedName name2 = OCBindUtil.getShortestPossibleName(this.mySymbol.getResolvedQualifiedName(resolveContext), element, this.mySymbol);
                if (name2 != null) {
                    Document document = context.getDocument();
                    document.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)name2.getFullName(resolveContext));
                    PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)context.getProject());
                    pdm.commitDocument(document);
                }
            }
            OCImportSymbolFix.fixAtCaret(context.getEditor(), context.getFile(), this.mySymbol);
        }
    }

    private static class WithAutoImportFixHandler
    implements InsertHandler<LookupElement> {
        private OCSymbolGroupContext mySymbolContext;
        private boolean myInsertSpace;

        private WithAutoImportFixHandler(OCSymbolGroupContext symbolContext, boolean insertSpace) {
            this.mySymbolContext = symbolContext;
            this.myInsertSpace = insertSpace;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            SymbolLookupBuilderUtil.fixImportsAtCaret(context, this.mySymbolContext);
            if (this.myInsertSpace && context.getCompletionChar() != ' ') {
                char ch;
                CharSequence text;
                int offset = context.getTailOffset();
                if (offset < (text = context.getDocument().getCharsSequence()).length() && (ch = text.charAt(offset)) != ' ' && ch != '>' && ch != '<') {
                    context.getDocument().insertString(offset, (CharSequence)" ");
                }
                context.getEditor().getCaretModel().moveCaretRelatively(1, 0, false, false, true);
            }
        }
    }

    private static class NamespaceInsertHandler
    implements InsertHandler<LookupElement> {
        private final PsiElement myContextExpression;

        private NamespaceInsertHandler(PsiElement contextExpression) {
            this.myContextExpression = contextExpression;
        }

        public void handleInsert(InsertionContext context, LookupElement item) {
            int pos;
            OCCppUsingStatement usingStatement = (OCCppUsingStatement)PsiTreeUtil.getContextOfType((PsiElement)this.myContextExpression, (Class[])new Class[]{OCCppUsingStatement.class});
            if (usingStatement != null && usingStatement.isNamespaceUsing()) {
                return;
            }
            PsiElement parent = this.myContextExpression.getParent();
            if (parent instanceof OCCppNamespace) {
                return;
            }
            if (parent instanceof OCCppNamespaceAlias) {
                return;
            }
            char completionChar = context.getCompletionChar();
            String text = context.getDocument().getText();
            for (pos = context.getTailOffset(); pos < text.length() && Character.isSpaceChar(text.charAt(pos)); ++pos) {
            }
            if (pos >= text.length() || text.charAt(pos) != ':') {
                String INSERTION = completionChar == ':' ? ":" : "::";
                context.getDocument().insertString(context.getTailOffset(), (CharSequence)INSERTION);
                context.getEditor().getCaretModel().moveCaretRelatively(INSERTION.length(), 0, false, false, true);
                OCTypedHandlerDelegate.overTypeNextColon();
            }
        }
    }
}

