/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSuggestIndexNameMacro
extends Macro {
    public String getName() {
        return "suggestIndexName";
    }

    public String getPresentableName() {
        return "suggestIndexName()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("i" == null) {
            OCSuggestIndexNameMacro.$$$reportNull$$$0(0);
        }
        return "i";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            OCSuggestIndexNameMacro.$$$reportNull$$$0(1);
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file = place.getContainingFile();
        assert (file != null);
        String[] candidates = new String[]{"i", "j", "k", "l", "m", "n"};
        int attempt = 0;
        while (true) {
            for (String candidate : candidates) {
                if (attempt > 0) {
                    candidate = candidate + attempt;
                }
                if (!OCSuggestIndexNameMacro.isNameAvailable(candidate, file, place)) continue;
                return new TextResult(candidate);
            }
            ++attempt;
        }
    }

    private static boolean isNameAvailable(@NotNull String candidate, @NotNull PsiFile file, @Nullable PsiElement context) {
        Project project2;
        OCSymbol symbol;
        if (candidate == null) {
            OCSuggestIndexNameMacro.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OCSuggestIndexNameMacro.$$$reportNull$$$0(3);
        }
        if ((symbol = OCCodeInsightUtil.resolveNameInScope(OCSymbolKind.LOCAL_VARIABLE, candidate, null, context, false, project2 = file.getProject())) == null) {
            return true;
        }
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        return parent instanceof OCDeclarator && parent.equals(symbol.locateDefinition(project2));
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestIndexNameMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isNameAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

