/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class OCSuggestVariableNameMacro
extends Macro {
    public String getName() {
        return "suggestVariableName";
    }

    public String getPresentableName() {
        return "suggestVariableName()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            OCSuggestVariableNameMacro.$$$reportNull$$$0(0);
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        Collection<String> names;
        if (params == null) {
            OCSuggestVariableNameMacro.$$$reportNull$$$0(1);
        }
        return (names = OCSuggestVariableNameMacro.getNames(context)).isEmpty() ? null : new TextResult(names.iterator().next());
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        Collection<String> names;
        if (params == null) {
            OCSuggestVariableNameMacro.$$$reportNull$$$0(2);
        }
        if ((names = OCSuggestVariableNameMacro.getNames(context)).size() < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[names.size()];
        int i = 0;
        for (String name2 : names) {
            items[i++] = LookupElementBuilder.create((Object)name2, (String)name2);
        }
        return items;
    }

    private static Collection<String> getNames(ExpressionContext context) {
        Collection<String> names = OCTemplatesUtil.getNames(context);
        if (names == null || names.isEmpty()) {
            return Collections.emptyList();
        }
        names = new LinkedHashSet<String>(names);
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        String safeName = place.getText();
        Iterator<String> it = names.iterator();
        String firstNotUnique = null;
        while (it.hasNext()) {
            String name2 = it.next();
            if (name2.equals(safeName) || OCCodeInsightUtil.isUniqueInScope(null, name2, place, context.getProject())) continue;
            it.remove();
            if (firstNotUnique != null) continue;
            firstNotUnique = name2;
        }
        if (names.isEmpty()) {
            return Collections.singleton(OCNameSuggester.suggestUniqueName(null, firstNotUnique, place));
        }
        return names;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCSuggestVariableNameMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

