/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.liveTemplates;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.editor.completion.OCCodeContextType;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCElementResult;
import com.jetbrains.cidr.lang.editor.liveTemplates.OCTemplatesUtil;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCVariableOfTypeMacro
extends Macro {
    public String getName() {
        return "variableOfType";
    }

    public String getPresentableName() {
        return "variableOfType()";
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            OCVariableOfTypeMacro.$$$reportNull$$$0(0);
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] variables;
        if (params == null) {
            OCVariableOfTypeMacro.$$$reportNull$$$0(1);
        }
        if ((variables = OCVariableOfTypeMacro.getVariables(params, context)) == null || variables.length == 0) {
            return null;
        }
        return new OCElementResult((OCElement)variables[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        PsiElement[] variables;
        if (params == null) {
            OCVariableOfTypeMacro.$$$reportNull$$$0(2);
        }
        if ((variables = OCVariableOfTypeMacro.getVariables(params, context)) == null || variables.length < 2) {
            return null;
        }
        LookupElement[] items = new LookupElement[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            PsiElement var = variables[i];
            items[i] = var instanceof PsiNamedElement ? LookupElementBuilder.create((PsiNamedElement)((PsiNamedElement)var)).withIcon(var.getIcon(0)) : LookupElementBuilder.create((String)var.getText()).withIcon(OCIcons.CodeAssistantMember);
        }
        return items;
    }

    @Nullable
    protected static PsiElement[] getVariables(Expression[] params, ExpressionContext context) {
        OCType type;
        String typeText;
        if (params.length != 1) {
            return null;
        }
        PsiElement place = OCTemplatesUtil.getInsertionPlace(context);
        PsiFile file = place.getContainingFile();
        assert (file != null);
        OCResolveContext resolveContext = OCResolveContext.forPsi(place);
        Result param = params[0].calculateResult(context);
        String string = typeText = param != null ? param.toString() : "";
        if (typeText.isEmpty()) {
            type = null;
        } else {
            OCDeclaration dcl = OCElementFactory.declarationFromText(typeText + "x;", (PsiElement)file);
            List<OCDeclarator> declarators = dcl.getDeclarators();
            if (declarators.size() == 1) {
                OCType unresolved = declarators.get(0).getType();
                type = unresolved.resolve(resolveContext);
            } else {
                type = null;
            }
        }
        ArrayList<PsiNameIdentifierOwner> result = new ArrayList<PsiNameIdentifierOwner>();
        List<OCDeclaratorSymbol> variables = OCTemplatesUtil.getVariablesVisibleAt(place, false);
        for (OCDeclaratorSymbol var : variables) {
            PsiElement parent;
            PsiNameIdentifierOwner def;
            OCType varResolvedType = var.getType().resolve(resolveContext);
            if (type != null && !type.isCompatible(varResolvedType, resolveContext) || (def = (PsiNameIdentifierOwner)var.locateDefinition(context.getProject())) == null || (parent = def.getContext().getContext()) instanceof OCForeachStatement) continue;
            result.add(def);
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof OCCodeContextType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCVariableOfTypeMacro";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/editor/liveTemplates/OCVariableOfTypeMacro";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "calculateResult";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "calculateLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

