/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.selectWord;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCMacroParameterList;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class OCSelectorWordSelectioner
extends ExtendWordSelectionHandlerBase {
    public boolean canSelect(@NotNull PsiElement e) {
        if (e == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(0);
        }
        return OCSelectorWordSelectioner.isCustomSelectionContext(e);
    }

    public static boolean isCustomSelectionContext(PsiElement e) {
        return OCSelectorWordSelectioner.selector(e) != null || e.getNode().getElementType() == OCTokenTypes.HEADER_PATH_LITERAL || e instanceof OCDefineDirective;
    }

    @Contract(value="null -> null")
    private static OCSelectorExpression selector(PsiElement e) {
        return (OCSelectorExpression)PsiTreeUtil.getParentOfType((PsiElement)e, OCSelectorExpression.class);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        OCSelectorExpression selector;
        if (e == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCSelectorWordSelectioner.$$$reportNull$$$0(3);
        }
        if ((selector = OCSelectorWordSelectioner.selector(e)) != null) {
            return Collections.singletonList(selector.getSelectorRange().shiftRight(selector.getTextRange().getStartOffset()));
        }
        if (e.getNode().getElementType() == OCTokenTypes.HEADER_PATH_LITERAL) {
            String text = e.getText();
            int nonws = CharArrayUtil.shiftForward((CharSequence)text, (int)0, (String)" \t\n");
            text = text.substring(nonws);
            ArrayList answer = ContainerUtil.newArrayList();
            TextRange baseRange = TextRange.from((int)(e.getTextRange().getStartOffset() + nonws), (int)(e.getTextLength() - nonws));
            answer.add(baseRange);
            SelectWordUtil.addWordSelection((boolean)editor.getSettings().isCamelWords(), (CharSequence)editorText, (int)cursorOffset, (List)answer);
            if (baseRange.getLength() > 1 && text.startsWith("\"") && text.endsWith("\"") || text.startsWith("<") && text.endsWith(">")) {
                answer.add(baseRange.shiftRight(1).grown(-2));
            }
            return answer;
        }
        if (e instanceof OCDefineDirective) {
            OCMacroParameterList params = ((OCDefineDirective)e).getMacroParameters();
            PsiElement name2 = ((OCDefineDirective)e).getNameIdentifier();
            if (name2 != null && params != null) {
                int definitionStart = CharArrayUtil.shiftForward((CharSequence)editorText, (int)params.getTextRange().getEndOffset(), (String)" \t");
                ArrayList answer = ContainerUtil.newArrayList();
                answer.add(TextRange.create((int)name2.getTextRange().getStartOffset(), (int)params.getTextRange().getEndOffset()));
                answer.add(TextRange.create((int)definitionStart, (int)e.getTextRange().getEndOffset()));
                return answer;
            }
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/selectWord/OCSelectorWordSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

