/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.NotNull;

public class IfConditionFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        if (editor == null) {
            IfConditionFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            IfConditionFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            IfConditionFixer.$$$reportNull$$$0(2);
        }
        if (psiElement instanceof OCIfStatement) {
            if (IfConditionFixer.hasMacroBasedStatement(psiElement, OCTokenTypes.IF_KEYWORD)) {
                return;
            }
            Document doc = editor.getDocument();
            OCIfStatement ifStatement = (OCIfStatement)psiElement;
            ASTNode rParenth = ifStatement.getRParenth();
            ASTNode lParenth = ifStatement.getLParenth();
            OCCondition condition = ifStatement.getCondition();
            if (lParenth == null) {
                int stopOffset = doc.getLineEndOffset(doc.getLineNumber(IfConditionFixer.getRangeWithMacros(ifStatement).getStartOffset()));
                OCStatement then = ifStatement.getThenBranch();
                if (then != null) {
                    stopOffset = Math.min(stopOffset, IfConditionFixer.getRangeWithMacros(then).getStartOffset());
                }
                stopOffset = Math.min(stopOffset, IfConditionFixer.getRangeWithMacros(ifStatement).getEndOffset());
                doc.replaceString(IfConditionFixer.getRangeWithMacros(ifStatement).getStartOffset(), stopOffset, (CharSequence)"if ()");
                processor2.registerUnresolvedError(IfConditionFixer.getRangeWithMacros(ifStatement).getStartOffset() + "if (".length());
            } else {
                IfConditionFixer.fixConditionIfNeed(editor, processor2, lParenth, condition, rParenth);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/smartEnter/IfConditionFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

