/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import org.jetbrains.annotations.NotNull;

public class MissingIfBranchesFixer
extends OCFixer {
    public void apply(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull PsiElement psiElement) throws IncorrectOperationException {
        ASTNode rParenth;
        if (editor == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(1);
        }
        if (psiElement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(2);
        }
        if (!(psiElement instanceof OCIfStatement)) {
            return;
        }
        OCIfStatement ifStatement = (OCIfStatement)psiElement;
        Document doc = editor.getDocument();
        OCStatement elseBranch = ifStatement.getElseBranch();
        ASTNode elseElement = ifStatement.getElseKeyword();
        if (elseElement != null && (elseBranch == null || !(elseBranch instanceof OCBlockStatement) && MissingIfBranchesFixer.startLine(doc, elseBranch) > MissingIfBranchesFixer.startLine(doc, elseElement.getPsi()))) {
            doc.insertString(MissingIfBranchesFixer.getRangeWithMacros(elseElement).getEndOffset(), (CharSequence)"{}");
            return;
        }
        OCStatement thenBranch = ifStatement.getThenBranch();
        if (MissingIfBranchesFixer.fixBlockIfNeed(editor, thenBranch, false)) {
            return;
        }
        boolean transformingOneLiner = false;
        if (thenBranch != null && MissingIfBranchesFixer.startLine(doc, thenBranch) == MissingIfBranchesFixer.startLine(doc, ifStatement)) {
            if (!MissingIfBranchesFixer.hasEmptyStatement(ifStatement.getCondition())) {
                return;
            }
            transformingOneLiner = true;
        }
        if ((rParenth = ifStatement.getRParenth()) == null) {
            return;
        }
        if (elseBranch == null && !transformingOneLiner || thenBranch == null) {
            doc.insertString(MissingIfBranchesFixer.getRangeWithMacros(rParenth).getEndOffset(), (CharSequence)"{}");
        } else if (!(thenBranch instanceof OCBlockStatement)) {
            doc.insertString(MissingIfBranchesFixer.getRangeWithMacros(rParenth).getEndOffset(), (CharSequence)"{");
            doc.insertString(MissingIfBranchesFixer.getRangeWithMacros(thenBranch).getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/editor/smartEnter/MissingIfBranchesFixer";
        objectArray[2] = "apply";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

