/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.codeInsight.editorActions.enter.EnterAfterUnmatchedBraceHandler;
import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.lexer.LexerBase;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.editor.smartEnter.OCSmartEnterProcessor;
import com.jetbrains.cidr.lang.lexer.OCHighlightingLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.lexer.OCPrefixStringLiteralLexer;
import com.jetbrains.cidr.lang.lexer.OCRawStringLexerBase;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBlockOwner;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCFixer
extends SmartEnterProcessorWithFixers.Fixer<OCSmartEnterProcessor> {
    public static final OCElementType RAW_PSEUDOTYPE = new OCElementType("raw");
    public static final Pattern OLD_END_PREFXIX = Pattern.compile("\\)\\S*\"");

    protected static int startLine(@NotNull Document doc, @NotNull PsiElement psiElement) {
        if (doc == null) {
            OCFixer.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            OCFixer.$$$reportNull$$$0(1);
        }
        return doc.getLineNumber(OCFixer.getRangeWithMacros(psiElement).getStartOffset());
    }

    @Nullable
    static PsiErrorElement getErrorElementOffset(@NotNull PsiElement elt) {
        if (elt == null) {
            OCFixer.$$$reportNull$$$0(2);
        }
        final PsiErrorElement[] result = new PsiErrorElement[]{null};
        elt.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitErrorElement(PsiErrorElement element) {
                result[0] = element;
                this.stopWalking();
            }
        });
        return result[0];
    }

    @Contract(value="null -> false")
    static boolean isCompleteBlockOwner(@Nullable PsiElement psiElement) {
        if (psiElement instanceof OCBlockOwner) {
            return ((OCBlockOwner)psiElement).getOpeningBrace() != null && ((OCBlockOwner)psiElement).getClosingBrace() != null;
        }
        return false;
    }

    static boolean hasNonSpaceChildren(@NotNull OCBlockOwner block) {
        if (block == null) {
            OCFixer.$$$reportNull$$$0(3);
        }
        PsiElement end = block.getClosingBrace();
        boolean skip = true;
        for (PsiElement el = block.getOpeningBrace(); el != null && el != end; el = el.getNextSibling()) {
            if (skip) {
                skip = false;
                continue;
            }
            if (el instanceof PsiWhiteSpace) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> true")
    static boolean hasEmptyStatement(@Nullable PsiElement condition) {
        return condition == null || condition.getTextLength() == 0 && (condition.getFirstChild() == null || condition.getFirstChild() == condition.getLastChild() && condition.getFirstChild() instanceof PsiErrorElement);
    }

    @Contract(value="_, null, _ -> false")
    static boolean fixBlockIfNeed(@NotNull Editor editor, @Nullable PsiElement psiElement, boolean atCaret) {
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(4);
        }
        if (psiElement instanceof OCBlockOwner) {
            OCBlockOwner block = (OCBlockOwner)psiElement;
            PsiElement lbrace = block.getOpeningBrace();
            int caretOffset = editor.getCaretModel().getOffset();
            if (OCFixer.isRealLeafElement(lbrace) && !OCFixer.isGoodEmpty(block) && EnterAfterUnmatchedBraceHandler.isAfterUnmatchedLBrace((Editor)editor, (int)(atCaret ? caretOffset : OCFixer.getRangeWithMacros(lbrace).getEndOffset()), (FileType)psiElement.getContainingFile().getFileType())) {
                List<OCStatement> statements;
                int stopOffset = block instanceof OCBlockStatement ? ((statements = ((OCBlockStatement)block).getStatements()).size() > 0 ? OCFixer.getRangeWithMacros(statements.get(0)).getEndOffset() : OCFixer.getRangeWithMacros(psiElement).getEndOffset()) : OCFixer.getRangeWithMacros(lbrace).getEndOffset();
                Document document = editor.getDocument();
                if (caretOffset > stopOffset && CharArrayUtil.shiftBackward((CharSequence)document.getText(), (int)(caretOffset - 1), (String)" \t") <= stopOffset) {
                    editor.getCaretModel().moveToOffset(stopOffset);
                }
                document.insertString(stopOffset, (CharSequence)"}");
                return true;
            }
        }
        return false;
    }

    public static boolean isGoodEmpty(@NotNull OCBlockOwner block) {
        if (block == null) {
            OCFixer.$$$reportNull$$$0(5);
        }
        PsiElement lbrace = block.getOpeningBrace();
        PsiElement rbrace = block.getClosingBrace();
        if (lbrace == null || rbrace == null) {
            return false;
        }
        PsiElement spaceOrRbrace = lbrace.getNextSibling();
        return spaceOrRbrace == rbrace || spaceOrRbrace instanceof PsiWhiteSpace && spaceOrRbrace.getNextSibling() == rbrace;
    }

    @Nullable
    static PsiElement getFirstBodyElement(@NotNull OCBlockOwner block) {
        PsiElement lBrace;
        if (block == null) {
            OCFixer.$$$reportNull$$$0(6);
        }
        if ((lBrace = block.getOpeningBrace()) == null) {
            return null;
        }
        PsiElement nextSibling = lBrace.getNextSibling();
        return nextSibling == block.getClosingBrace() ? null : nextSibling;
    }

    @Contract(value="_, null -> false")
    public static boolean fixSemicolonAtTheEnd(@NotNull Editor editor, @Nullable PsiElement psiElement) {
        int insertionOffset;
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(7);
        }
        if ((insertionOffset = OCFixer.getSemicolonInsertionOffset(editor, psiElement)) == -1) {
            return false;
        }
        editor.getDocument().insertString(insertionOffset, (CharSequence)";");
        return true;
    }

    public static int getSemicolonInsertionOffset(@Nullable Editor editor, @Nullable PsiElement psiElement) {
        return OCFixer.getInsertionOffset(editor, psiElement, OCTokenTypes.SEMICOLON);
    }

    public static int getInsertionOffset(@Nullable Editor editor, @Nullable PsiElement psiElement, IElementType elementType) {
        ASTNode leaf;
        if (psiElement == null) {
            return -1;
        }
        ASTNode aSTNode = leaf = psiElement instanceof PsiErrorElement ? psiElement.getNode() : TreeUtil.findLastLeaf((ASTNode)psiElement.getNode());
        if (leaf == null) {
            return -1;
        }
        if (OCElementUtil.getElementType(OCFixer.getNextEssentialLeaf(leaf)) == elementType) {
            return -1;
        }
        while (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(leaf.getElementType()) || leaf instanceof PsiErrorElement) {
            if ((leaf = TreeUtil.prevLeaf((ASTNode)leaf)) != null) continue;
            return -1;
        }
        IElementType leafElementType = leaf.getElementType();
        if (leafElementType == elementType || editor != null && OCFixer.needCorrectionLiteral(editor, leaf, false)) {
            return -1;
        }
        return OCFixer.getRangeWithMacros(leaf).getEndOffset();
    }

    @Nullable
    public static ASTNode getPrevEssentialLeaf(ASTNode leaf) {
        return OCFixer.getNeighborEssentialLeaf(leaf, false);
    }

    @Nullable
    public static ASTNode getNextEssentialLeaf(ASTNode leaf) {
        return OCFixer.getNeighborEssentialLeaf(leaf, true);
    }

    public static boolean isLikeStructVarDeclaration(@NotNull PsiElement structLike) {
        if (structLike == null) {
            OCFixer.$$$reportNull$$$0(8);
        }
        if (!(structLike instanceof OCStructLike) || ((OCStructLike)structLike).getBaseClausesList() != null) {
            return false;
        }
        ASTNode leaf = OCFixer.getNextEssentialLeaf(structLike.getNode());
        if (leaf == null) {
            return false;
        }
        return leaf.getElementType() == OCTokenTypes.IDENTIFIER && (OCFixer.endsTheLine(leaf) || OCElementUtil.getElementType(OCFixer.getNextEssentialLeaf(leaf)) == OCTokenTypes.SEMICOLON);
    }

    public static boolean endsTheLine(@NotNull ASTNode elem) {
        if (elem == null) {
            OCFixer.$$$reportNull$$$0(9);
        }
        ASTNode leaf = TreeUtil.nextLeaf((ASTNode)elem);
        while (leaf != null) {
            if (leaf instanceof PsiWhiteSpace) {
                if (leaf.textContains('\n')) {
                    return true;
                }
            } else if (!(leaf instanceof PsiComment)) {
                return false;
            }
            leaf = TreeUtil.nextLeaf((ASTNode)leaf);
        }
        return true;
    }

    @Nullable
    public static ASTNode getNeighborEssentialLeaf(ASTNode leaf, boolean next) {
        ASTNode nextLeaf;
        ASTNode aSTNode = nextLeaf = next ? TreeUtil.nextLeaf((ASTNode)leaf) : TreeUtil.prevLeaf((ASTNode)leaf);
        while (nextLeaf != null) {
            IElementType type = nextLeaf.getElementType();
            ASTNode macro = TreeUtil.findParent((ASTNode)nextLeaf, (IElementType)OCElementTypes.MACRO_CALL);
            if (macro != null) {
                nextLeaf = macro;
            } else if (!OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(type)) {
                return nextLeaf;
            }
            nextLeaf = next ? TreeUtil.nextLeaf((ASTNode)nextLeaf) : TreeUtil.prevLeaf((ASTNode)nextLeaf);
        }
        return null;
    }

    @Contract(value="null->false")
    static boolean isRealLeafElement(@Nullable PsiElement element) {
        assert (element == null || element instanceof LeafElement);
        return element != null && !(element instanceof OCMacroForeignLeafElement);
    }

    static boolean hasMacroBasedStatement(@NotNull PsiElement psiElement, @NotNull OCElementType keywordType) {
        ASTNode keyword;
        ASTNode dogNode;
        if (psiElement == null) {
            OCFixer.$$$reportNull$$$0(10);
        }
        if (keywordType == null) {
            OCFixer.$$$reportNull$$$0(11);
        }
        if (OCTokenTypes.KEYWORDS_WITH_DOGS.contains((IElementType)keywordType) && (dogNode = psiElement.getNode().findChildByType((IElementType)OCElementTypes.OBJC_KEYWORD)) != null) {
            psiElement = dogNode.getPsi();
        }
        return (keyword = psiElement.getNode().findChildByType((IElementType)keywordType)) == null || keyword instanceof OCMacroForeignLeafElement;
    }

    @Contract(value="_, null, _ -> false")
    public static boolean needCorrectionLiteral(@NotNull Editor editor, @Nullable ASTNode token, boolean fix) {
        IElementType nodeType;
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(12);
        }
        boolean ret = false;
        if (!(token == null || token instanceof OCMacroForeignLeafElement || (nodeType = token.getElementType()) != OCTokenTypes.STRING_LITERAL && nodeType != OCTokenTypes.CHARACTER_LITERAL && nodeType != OCTokenTypes.WRONG_RAW_STRING_LITERAL)) {
            int endPoint;
            char stopChar = nodeType == OCTokenTypes.CHARACTER_LITERAL ? (char)'\'' : '\"';
            boolean isRaw = OCTokenTypes.RAW_STRING_LITERALS.contains(nodeType);
            OCPrefixStringLiteralLexer lexer = new OCPrefixStringLiteralLexer(stopChar, OCHighlightingLexer.PREFIX_TYPE, (LexerBase)(!isRaw ? OCHighlightingLexer.createStringLiteralLexer(stopChar, OCTokenTypes.STRING_LITERAL) : new OCRawStringLexerBase(RAW_PSEUDOTYPE, OCTokenTypes.STRING_LITERAL)));
            CharSequence docText = editor.getDocument().getCharsSequence();
            int startPoint = token.getStartOffset();
            int removeOffset = -1;
            if (nodeType == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
                Matcher matcher;
                endPoint = docText.length();
                int endOfLine = StringUtil.indexOf((CharSequence)docText, (char)'\n', (int)startPoint);
                if (endOfLine >= 0) {
                    endPoint = Math.min(endPoint, endOfLine);
                }
                if ((matcher = OLD_END_PREFXIX.matcher(docText.subSequence(startPoint, endPoint))).find() && startPoint + matcher.end(0) <= endPoint) {
                    endPoint = startPoint + matcher.end(0);
                    removeOffset = startPoint + matcher.start(0);
                } else {
                    endPoint = OCFixer.getAdjustedEndPoint(stopChar, docText, startPoint, endPoint, true);
                }
            } else {
                endPoint = OCFixer.getAdjustedEndPoint(stopChar, docText, startPoint, OCFixer.getRangeWithMacros(token).getEndOffset(), false);
            }
            lexer.start(docText, startPoint, endPoint);
            String rawPrefix = null;
            int prefixCount = 0;
            int stringEnd = -1;
            int stringStart = -1;
            boolean badEnd = true;
            while (lexer.getTokenType() != null) {
                IElementType tt = lexer.getTokenType();
                if (tt == RAW_PSEUDOTYPE) {
                    if (prefixCount == 0 && docText.charAt(lexer.getTokenEnd() - 1) == '(' || prefixCount == 1 && docText.charAt(lexer.getTokenStart()) == ')') {
                        rawPrefix = docText.subSequence(lexer.getTokenStart(), lexer.getTokenEnd() - 1).toString();
                        ++prefixCount;
                    }
                } else if (tt == OCTokenTypes.STRING_LITERAL && stringStart == -1) {
                    stringStart = lexer.getTokenStart();
                }
                stringEnd = lexer.getTokenEnd();
                badEnd = tt != OCTokenTypes.STRING_LITERAL;
                lexer.advance();
            }
            if (stringStart != -1 && stringEnd != -1) {
                if (stringStart == stringEnd - 1 || badEnd || docText.charAt(stringEnd - 1) != stopChar) {
                    if (fix) {
                        editor.getDocument().insertString(stringEnd, (CharSequence)String.valueOf(stopChar));
                    }
                    ++stringEnd;
                    ret = true;
                }
                if (isRaw && rawPrefix == null) {
                    rawPrefix = "";
                    if (fix) {
                        editor.getDocument().insertString(stringStart + 1, (CharSequence)"(");
                    }
                    if (removeOffset >= 0) {
                        ++removeOffset;
                    }
                    ++prefixCount;
                    ++stringEnd;
                    ret = true;
                }
                if (prefixCount == 1) {
                    String postfix = ")" + rawPrefix;
                    if (fix) {
                        if (removeOffset >= 0) {
                            editor.getDocument().replaceString(removeOffset, endPoint - 1, (CharSequence)postfix);
                        } else {
                            editor.getDocument().insertString(stringEnd - 1, (CharSequence)postfix);
                        }
                    }
                    ret = true;
                }
            }
        }
        return ret;
    }

    public static int getCompletionPointAfterLPAR(@NotNull Editor editor, @NotNull PsiElement psiElement) {
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(13);
        }
        if (psiElement == null) {
            OCFixer.$$$reportNull$$$0(14);
        }
        int offset = -1;
        if (OCFixer.caretInVerticalRangeOfElement(editor, psiElement)) {
            offset = OCFixer.getCompletionPoint(editor);
        } else {
            ASTNode lpar = psiElement.getNode().findChildByType((IElementType)OCTokenTypes.LPAR);
            if (lpar != null) {
                editor.getCaretModel().moveToOffset(OCFixer.getRangeWithMacros(lpar).getEndOffset());
                offset = OCFixer.getCompletionPoint(editor);
            }
        }
        return Math.min(offset, OCFixer.getRangeWithMacros(psiElement).getEndOffset());
    }

    public static boolean caretInVerticalRangeOfElement(@NotNull Editor editor, @NotNull PsiElement element) {
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(15);
        }
        if (element == null) {
            OCFixer.$$$reportNull$$$0(16);
        }
        Document document = editor.getDocument();
        TextRange range = OCFixer.getRangeWithMacros(element);
        int startElementLine = document.getLineNumber(range.getStartOffset());
        int endElementLine = document.getLineNumber(range.getEndOffset());
        int caretOffset = document.getLineNumber(editor.getCaretModel().getOffset());
        return startElementLine <= caretOffset && caretOffset <= endElementLine;
    }

    public static int getCompletionPoint(@NotNull Editor editor) {
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(17);
        }
        int completionOffset = editor.getCaretModel().getOffset();
        OCLexerWithDirectives lexer = OCLexerWithDirectives.createDefault();
        CharSequence docText = editor.getDocument().getCharsSequence();
        completionOffset = CharArrayUtil.shiftBackward((CharSequence)docText, (int)completionOffset, (String)" \t");
        lexer.start(docText, completionOffset, docText.length());
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (lexer.getTokenText().contains("\n") || tt == OCTokenTypes.SEMICOLON || OCTokenTypes.COMMENTS.contains(tt)) break;
            completionOffset = lexer.getTokenEnd();
            lexer.advance();
        }
        return completionOffset;
    }

    private static int getAdjustedEndPoint(char stopChar, CharSequence docText, int startPoint, int endPoint, boolean checkQuote) {
        int quote = StringUtil.indexOf((CharSequence)docText, (char)stopChar, (int)startPoint, (int)endPoint);
        if (quote >= 0 && (quote = StringUtil.indexOf((CharSequence)docText, (char)stopChar, (int)(quote + 1), (int)endPoint)) >= 0) {
            return checkQuote ? quote + 1 : endPoint;
        }
        int semicolon = StringUtil.indexOf((CharSequence)docText, (char)';', (int)startPoint, (int)endPoint);
        if (semicolon >= 0) {
            return semicolon;
        }
        return endPoint;
    }

    static TextRange getRangeWithMacros(@NotNull ASTNode element) {
        if (element == null) {
            OCFixer.$$$reportNull$$$0(18);
        }
        return OCFixer.getRangeWithMacros(element.getPsi());
    }

    static TextRange getRangeWithMacros(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            OCFixer.$$$reportNull$$$0(19);
        }
        if (psiElement instanceof OCElement) {
            return ((OCElement)psiElement).getRangeWithMacros();
        }
        return psiElement.getTextRange();
    }

    static void fixConditionIfNeed(@NotNull Editor editor, @NotNull OCSmartEnterProcessor processor2, @NotNull ASTNode lParenth, @Nullable PsiElement condition, @Nullable ASTNode rParenth) {
        if (editor == null) {
            OCFixer.$$$reportNull$$$0(20);
        }
        if (processor2 == null) {
            OCFixer.$$$reportNull$$$0(21);
        }
        if (lParenth == null) {
            OCFixer.$$$reportNull$$$0(22);
        }
        int endLPar = OCFixer.getRangeWithMacros(lParenth).getEndOffset();
        if (rParenth != null) {
            if (OCFixer.hasEmptyStatement(condition)) {
                processor2.registerUnresolvedError(OCFixer.getRangeWithMacros(rParenth).getStartOffset());
            }
        } else {
            editor.getCaretModel().moveToOffset(endLPar);
            int offset = OCFixer.getCompletionPoint(editor);
            if (offset == endLPar) {
                processor2.registerUnresolvedError(endLPar);
            }
            editor.getDocument().insertString(offset, (CharSequence)")");
        }
    }

    @Nullable
    static PsiErrorElement getNextError(PsiElement atCaret) {
        int offset = OCFixer.getRangeWithMacros(atCaret).getEndOffset();
        PsiElement parent;
        while ((parent = atCaret.getParent()) != null && !(parent instanceof PsiFile) && OCFixer.getRangeWithMacros(parent).getEndOffset() == offset) {
            PsiElement lastChild = parent.getLastChild();
            if (lastChild instanceof PsiErrorElement) {
                return (PsiErrorElement)lastChild;
            }
            atCaret = parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 10: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 4: 
            case 7: 
            case 12: 
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structLike";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keywordType";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lParenth";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/smartEnter/OCFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorElementOffset";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonSpaceChildren";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fixBlockIfNeed";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isGoodEmpty";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstBodyElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fixSemicolonAtTheEnd";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isLikeStructVarDeclaration";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "endsTheLine";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "hasMacroBasedStatement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "needCorrectionLiteral";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionPointAfterLPAR";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "caretInVerticalRangeOfElement";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "getCompletionPoint";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeWithMacros";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "fixConditionIfNeed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

