/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.smartEnter;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.smartEnter.AfterSemicolonEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.BlockBraceFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.CaseColonFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.CommentBreakerEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.DefaultStatementWithExpressionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.DefaultStatementWithExpressionMissingBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.DoWhileConditionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.ForStatementFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.IfConditionFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.LiteralFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingCallableBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingClassNamespaceBodyFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.MissingIfBranchesFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.OCFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.ParameterListFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.ParenthesizedFixer;
import com.jetbrains.cidr.lang.editor.smartEnter.PlainEnterProcessor;
import com.jetbrains.cidr.lang.editor.smartEnter.SemicolonFixer;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockOwner;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppStaticAssert;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSmartEnterProcessor
extends SmartEnterProcessorWithFixers {
    private static final CommentBreakerEnterProcessor COMMENT_BREAKER_ENTER_PROCESSOR = new CommentBreakerEnterProcessor();
    private static final AfterSemicolonEnterProcessor SEMICOLON_ENTER_PROCESSOR = new AfterSemicolonEnterProcessor();
    private static Class[] goodCandidateForCorrection = new Class[]{OCStructLike.class, OCCppNamespace.class, OCCppNamespaceAlias.class, OCCppUsingStatement.class, OCCppStaticAssert.class, OCStatement.class, OCMethod.class, OCProperty.class, OCDeclaration.class, PsiComment.class};

    public OCSmartEnterProcessor() {
        this.addFixers(new SmartEnterProcessorWithFixers.Fixer[]{new LiteralFixer(), new IfConditionFixer(), new ForStatementFixer(), new DefaultStatementWithExpressionFixer(), new DoWhileConditionFixer(), new CaseColonFixer(), new BlockBraceFixer(), new MissingIfBranchesFixer(), new DefaultStatementWithExpressionMissingBodyFixer(), new ParameterListFixer(), new MissingCallableBodyFixer(), new MissingClassNamespaceBodyFixer(), new ParenthesizedFixer(), new SemicolonFixer()});
        this.addEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{COMMENT_BREAKER_ENTER_PROCESSOR, SEMICOLON_ENTER_PROCESSOR, new PlainEnterProcessor()});
        this.addAfterEnterProcessors(new SmartEnterProcessorWithFixers.FixEnterProcessor[]{SEMICOLON_ENTER_PROCESSOR, new SmartEnterProcessorWithFixers.FixEnterProcessor(){

            public boolean doEnter(PsiElement atCaret, PsiFile file, @NotNull Editor editor, boolean modified) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                return PlainEnterProcessor.expandCodeBlock(editor, atCaret);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor$1", "doEnter"));
            }
        }});
    }

    protected void reformat(PsiElement atCaret) throws IncorrectOperationException {
        if (atCaret == null) {
            return;
        }
        PsiElement parent = atCaret.getParent();
        if (parent instanceof OCBlockStatement) {
            PsiFile file;
            Document document;
            OCBlockStatement block = (OCBlockStatement)parent;
            if (block.getStatements().size() > 0 && block.getStatements().get(0) == atCaret && (document = (file = atCaret.getContainingFile()).getViewProvider().getDocument()) != null) {
                TextRange range = OCFixer.getRangeWithMacros(atCaret);
                int lineEnd = document.getLineEndOffset(document.getLineNumber(range.getEndOffset()));
                CodeStyleManager.getInstance((Project)atCaret.getProject()).reformatText(file, range.getStartOffset(), lineEnd);
                return;
            }
        } else {
            PsiFile file;
            Document document;
            if (atCaret instanceof OCBlockOwner && atCaret instanceof PsiNameIdentifierOwner) {
                PsiFile file2;
                Document document2;
                PsiElement lbrace = ((OCBlockOwner)atCaret).getOpeningBrace();
                PsiElement rbrace = ((OCBlockOwner)atCaret).getClosingBrace();
                if (OCFixer.isRealLeafElement(lbrace) && OCFixer.isRealLeafElement(rbrace) && (document2 = (file2 = atCaret.getContainingFile()).getViewProvider().getDocument()) != null) {
                    ArrayList<TextRange> ranges = new ArrayList<TextRange>(2);
                    PsiElement id = ((PsiNameIdentifierOwner)atCaret).getNameIdentifier();
                    if (OCFixer.isRealLeafElement(id)) {
                        ranges.add(TextRange.create((int)OCFixer.getRangeWithMacros(atCaret).getStartOffset(), (int)OCFixer.getRangeWithMacros(id).getEndOffset()));
                    }
                    ranges.add(TextRange.create((int)OCFixer.getRangeWithMacros(lbrace).getStartOffset(), (int)OCFixer.getRangeWithMacros(rbrace).getEndOffset()));
                    CodeStyleManager.getInstance((Project)atCaret.getProject()).reformatText(file2, ranges);
                }
                return;
            }
            if (parent instanceof OCForStatement) {
                atCaret = parent;
            } else if (parent instanceof OCIfStatement && atCaret == ((OCIfStatement)parent).getElseBranch() && (document = (file = atCaret.getContainingFile()).getViewProvider().getDocument()) != null) {
                TextRange elseIfRange = OCFixer.getRangeWithMacros(atCaret);
                int lineStart = document.getLineStartOffset(document.getLineNumber(elseIfRange.getStartOffset()));
                CodeStyleManager.getInstance((Project)atCaret.getProject()).reformatText(file, lineStart, elseIfRange.getEndOffset());
                return;
            }
        }
        super.reformat(atCaret);
    }

    public static void reformatBlockLike(@NotNull OCBlockOwner block) {
        if (block == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        PsiElement lbrace = block.getOpeningBrace();
        PsiElement rbrace = block.getClosingBrace();
        if (lbrace == null || rbrace == null) {
            return;
        }
        PsiFile file = block.getContainingFile();
        PsiFile baseFile = file.getViewProvider().getPsi(file.getViewProvider().getBaseLanguage());
        CodeStyleManager.getInstance((Project)block.getProject()).reformatText(baseFile, OCFixer.getRangeWithMacros(lbrace).getStartOffset(), OCFixer.getRangeWithMacros(rbrace).getEndOffset());
    }

    public boolean doNotStepInto(PsiElement element) {
        return element instanceof OCClassDeclaration || element instanceof OCStatement || element instanceof OCMethod || element instanceof OCStructLike || element instanceof OCCppNamespace || element instanceof OCFunctionDeclaration || element instanceof OCProperty || OCSmartEnterProcessor.isConditionOrExpressionInParent(element);
    }

    protected boolean collectChildrenRecursively(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        return (OCSmartEnterProcessor.goodForCorrection(atCaret) || !PsiTreeUtil.hasErrorElements((PsiElement)atCaret)) && !(atCaret instanceof OCStructLike) && !(atCaret instanceof OCCppNamespace) && !OCFixer.isCompleteBlockOwner(atCaret);
    }

    private static boolean isConditionOrExpressionInParent(PsiElement element) {
        PsiElement parent = element.getParent();
        return parent instanceof OCIfStatement && ((OCIfStatement)parent).getCondition() == element || parent instanceof OCStatementWithExpression && ((OCStatementWithExpression)parent).getExpression() == element;
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement elementAt = super.getStatementAtCaret(editor, psiFile);
        PsiElement statement2 = OCSmartEnterProcessor.getStatementParentOf(elementAt);
        if (OCFixer.isCompleteBlockOwner(statement2) && OCFixer.hasNonSpaceChildren((OCBlockOwner)statement2)) {
            if (statement2 instanceof OCStructLike && OCFixer.getSemicolonInsertionOffset(editor, statement2) != -1) {
                return statement2;
            }
            TextRange range = OCFixer.getRangeWithMacros(statement2);
            if (offset >= range.getEndOffset() || OCElementUtil.getElementType(elementAt) == OCTokenTypes.RBRACE) {
                editor.getCaretModel().moveToOffset(range.getEndOffset());
                PsiElement statementAtCaretParent = statement2.getParent();
                if (statementAtCaretParent instanceof OCLambdaExpression) {
                    return OCSmartEnterProcessor.getStatementParentOf(statementAtCaretParent);
                }
            }
            return null;
        }
        return statement2;
    }

    private static boolean goodForCorrection(PsiElement element) {
        for (Class cl : goodCandidateForCorrection) {
            if (!cl.isInstance(element)) continue;
            return cl != PsiComment.class;
        }
        return false;
    }

    @Nullable
    private static PsiElement getStatementParentOf(PsiElement atCaret) {
        PsiErrorElement nextError;
        PsiElement statementAtCaret;
        if (atCaret instanceof PsiWhiteSpace) {
            return null;
        }
        OCMacroCall macroCallAtCaret = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)atCaret, OCMacroCall.class);
        if (macroCallAtCaret != null) {
            if (!OCSmartEnterProcessor.isValidMacroCall(macroCallAtCaret)) {
                return null;
            }
            atCaret = macroCallAtCaret.getFirstExpansionLeaf();
        }
        if ((statementAtCaret = PsiTreeUtil.getNonStrictParentOfType((PsiElement)atCaret, (Class[])goodCandidateForCorrection)) == null) {
            return null;
        }
        PsiElement statementAtCaretParent = statementAtCaret.getParent();
        if (statementAtCaretParent instanceof OCCondition || statementAtCaretParent instanceof OCDeclarationStatement || statementAtCaretParent instanceof OCParameterDeclaration) {
            statementAtCaret = statementAtCaretParent;
        }
        if ((statementAtCaretParent = statementAtCaret.getParent()) instanceof OCParameterList) {
            statementAtCaret = statementAtCaretParent.getParent();
            if ((statementAtCaretParent = statementAtCaret.getParent()) instanceof OCFunctionDeclaration) {
                statementAtCaret = statementAtCaretParent;
            } else if (statementAtCaret instanceof OCTypeElement) {
                return OCSmartEnterProcessor.getStatementParentOf(statementAtCaretParent);
            }
        } else if (!OCSmartEnterProcessor.isStopElementForSmartEnter(statementAtCaret, statementAtCaretParent)) {
            statementAtCaret = statementAtCaretParent;
            statementAtCaretParent = statementAtCaret.getParent();
        } else if (statementAtCaret instanceof OCBlockStatement && macroCallAtCaret != null) {
            PsiElement lastExpansionLeaf = macroCallAtCaret.getLastExpansionLeaf();
            if (lastExpansionLeaf != null) {
                return OCSmartEnterProcessor.getStatementParentOf(lastExpansionLeaf);
            }
            return null;
        }
        if ((statementAtCaret instanceof OCDeclaration || statementAtCaret instanceof OCDeclarationStatement) && (OCElementUtil.isMissingRParError((PsiElement)(nextError = OCFixer.getNextError(statementAtCaret))) || OCElementUtil.isIncompleteExpressionError((PsiElement)nextError) || statementAtCaretParent instanceof OCCondition)) {
            return OCSmartEnterProcessor.getStatementParentOf(statementAtCaretParent);
        }
        if (statementAtCaret instanceof OCDeclarator) {
            return OCSmartEnterProcessor.getStatementParentOf(statementAtCaret);
        }
        if (statementAtCaret instanceof OCStructLike && (OCFixer.isLikeStructVarDeclaration(statementAtCaret) || statementAtCaretParent.getParent() instanceof OCParameterDeclaration)) {
            return OCSmartEnterProcessor.getStatementParentOf(statementAtCaretParent);
        }
        return OCSmartEnterProcessor.goodForCorrection(statementAtCaret) ? statementAtCaret : null;
    }

    private static boolean isValidMacroCall(@NotNull OCMacroCall macroCall) {
        ASTNode macroCallNode;
        if (macroCall == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        return (macroCallNode = macroCall.getNode()).findChildByType((IElementType)OCTokenTypes.LPAR) == null || macroCallNode.findChildByType((IElementType)OCTokenTypes.RPAR) != null;
    }

    private static boolean isStopElementForSmartEnter(PsiElement statementAtCaret, PsiElement statementAtCaretParent) {
        if (statementAtCaretParent instanceof OCStatementWithExpression && !(statementAtCaretParent instanceof OCDoWhileStatement) && ((OCStatementWithExpression)statementAtCaretParent).getRParenth() != null) {
            return ((OCStatementWithExpression)statementAtCaretParent).getBody() == statementAtCaret;
        }
        if (statementAtCaretParent instanceof OCIfStatement && ((OCIfStatement)statementAtCaretParent).getRParenth() != null) {
            return ((OCIfStatement)statementAtCaretParent).getThenBranch() == statementAtCaret || ((OCIfStatement)statementAtCaretParent).getElseBranch() == statementAtCaret;
        }
        return !(statementAtCaretParent instanceof OCStatementWithExpression) && !(statementAtCaretParent instanceof OCIfStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveCaretInsideBracesIfAny(@NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        if (editor == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (file == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        int caretOffset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{}") || CharArrayUtil.regionMatches((CharSequence)chars, (int)caretOffset, (CharSequence)"{\n}")) {
            this.commit(editor);
            CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)file);
            OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, OCCodeStyleSettings.class);
            boolean oldBlock = settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
            boolean oldLambda = settings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE;
            boolean oldClass = settings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE;
            boolean oldCppClass = ocSettings.KEEP_STRUCTURES_IN_ONE_LINE;
            try {
                settings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = false;
                settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = false;
                settings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = false;
                ocSettings.KEEP_STRUCTURES_IN_ONE_LINE = false;
                PsiElement atCaret = file.findElementAt(caretOffset);
                RangeMarker rangeMarker = this.createRangeMarker(atCaret);
                if (atCaret != null && OCFixer.isCompleteBlockOwner(atCaret.getParent())) {
                    OCSmartEnterProcessor.reformatBlockLike((OCBlockOwner)atCaret.getParent());
                } else {
                    this.reformat(PsiTreeUtil.getParentOfType((PsiElement)atCaret, OCBlockStatement.class));
                }
                this.commit(editor);
                PsiElement actualAtCaret = this.restoreElementAtCaret(file, atCaret, rangeMarker);
                rangeMarker.dispose();
                editor.getCaretModel().moveToOffset(OCFixer.getRangeWithMacros(actualAtCaret).getEndOffset());
            }
            finally {
                ocSettings.KEEP_STRUCTURES_IN_ONE_LINE = oldCppClass;
                settings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE = oldBlock;
                settings.KEEP_SIMPLE_LAMBDAS_IN_ONE_LINE = oldLambda;
                settings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE = oldClass;
            }
        }
    }

    protected boolean reformatBeforeEnter(@NotNull PsiElement atCaret) {
        if (atCaret == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(5);
        }
        return !PsiTreeUtil.hasErrorElements((PsiElement)atCaret);
    }

    protected void processDefaultEnter(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file) {
        PsiElement atCaret;
        OCMacroCall macroCall;
        if (project2 == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCSmartEnterProcessor.$$$reportNull$$$0(8);
        }
        if ((macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)(atCaret = super.getStatementAtCaret(editor, file)), OCMacroCall.class)) != null && !OCSmartEnterProcessor.isValidMacroCall(macroCall) || COMMENT_BREAKER_ENTER_PROCESSOR.doEnter(atCaret, file, editor, false)) {
            return;
        }
        OCSmartEnterProcessor.plainEnter((Editor)editor);
    }

    public boolean isFirstFixAttempt() {
        return this.myAttempt == 0;
    }

    protected PsiElement restoreElementAtCaret(PsiFile file, PsiElement origElement, RangeMarker marker) {
        return CodeInsightUtilCore.findElementInRange((PsiFile)file, (int)marker.getStartOffset(), (int)marker.getEndOffset(), origElement.getClass(), (Language)OCLanguage.getInstance());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "atCaret";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroCall";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/editor/smartEnter/OCSmartEnterProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatBlockLike";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectChildrenRecursively";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidMacroCall";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "moveCaretInsideBracesIfAny";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "reformatBeforeEnter";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processDefaultEnter";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

