/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.template.impl.editorActions.TypedActionHandlerBase;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProviderEP;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.editor.OCLineIndentProvider;
import com.jetbrains.cidr.lang.editor.OCTypedHandlerDelegate;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAutoFormatTypedHandler
extends TypedActionHandlerBase {
    private final Handler[] HANDLERS = new Handler[]{new MethodColonHandler(), new AdjustLabelCaseDefaultPublicHandler(), new AdjustLineWithAtHandler()};

    public OCAutoFormatTypedHandler(@Nullable TypedActionHandler originalHandler) {
        super(originalHandler);
    }

    public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
        if (editor == null) {
            OCAutoFormatTypedHandler.$$$reportNull$$$0(0);
        }
        if (dataContext == null) {
            OCAutoFormatTypedHandler.$$$reportNull$$$0(1);
        }
        if (this.myOriginalHandler != null) {
            this.myOriginalHandler.execute(editor, charTyped, dataContext);
        }
        if (charTyped != ':' && charTyped != '@') {
            return;
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Editor)editor);
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (editor == null) {
                OCAutoFormatTypedHandler.$$$reportNull$$$0(4);
            }
            if (project2.isDisposed() || editor.isDisposed()) {
                return;
            }
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project2);
            if (!(file instanceof OCFile)) {
                return;
            }
            for (Handler each : this.HANDLERS) {
                if (each.handle(charTyped, (OCFile)file, editor, settings)) break;
            }
        });
    }

    private static boolean adjustLineIndentUnderCaretNoCommit(@NotNull Language language, @NotNull Editor editor) {
        if (language == null) {
            OCAutoFormatTypedHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            OCAutoFormatTypedHandler.$$$reportNull$$$0(3);
        }
        Caret caret = editor.getCaretModel().getCurrentCaret();
        int offsetAfterIndentCorrection = EnterHandler.adjustLineIndentNoCommit((Language)language, (Document)editor.getDocument(), (Editor)editor, (int)caret.getOffset());
        if (offsetAfterIndentCorrection >= 0) {
            caret.moveToOffset(offsetAfterIndentCorrection);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCAutoFormatTypedHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustLineIndentUnderCaretNoCommit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class AdjustLineWithAtHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCFile file, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            ASTNode typedElement;
            ASTNode maybeVisibility;
            if (file == null) {
                AdjustLineWithAtHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                AdjustLineWithAtHandler.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                AdjustLineWithAtHandler.$$$reportNull$$$0(2);
            }
            if (charTyped != '@' || !file.getKind().isObjC()) {
                return false;
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            documentManager.commitDocument(editor.getDocument());
            PsiElement elementAt = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (elementAt != null && (maybeVisibility = (typedElement = elementAt.getNode()).getTreeParent()) != null && OCElementUtil.isVisibilityKeyword(maybeVisibility)) {
                CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent((PsiFile)file, typedElement.getStartOffset());
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/formatting/OCAutoFormatTypedHandler$AdjustLineWithAtHandler";
            objectArray[2] = "handle";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class AdjustLabelCaseDefaultPublicHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCFile file, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            if (file == null) {
                AdjustLabelCaseDefaultPublicHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                AdjustLabelCaseDefaultPublicHandler.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                AdjustLabelCaseDefaultPublicHandler.$$$reportNull$$$0(2);
            }
            if (charTyped != ':') {
                return false;
            }
            LineIndentProvider lineIndentProvider = LineIndentProviderEP.findLineIndentProvider((Language)OCLanguage.getInstance());
            if (lineIndentProvider instanceof OCLineIndentProvider) {
                SemanticEditorPosition.SyntaxElement element;
                SemanticEditorPosition position = ((OCLineIndentProvider)lineIndentProvider).getPosition(editor, editor.getCaretModel().getCurrentCaret().getOffset() - 1);
                Pair<SemanticEditorPosition, OCTypedHandlerDelegate.ContextType> context = OCLineIndentProvider.getColonAfterLabelCaseDefaultPublicContext(position);
                SemanticEditorPosition.SyntaxElement syntaxElement = element = context.first == null ? null : ((SemanticEditorPosition)context.first).getCurrElement();
                if (element == OCLineIndentProvider.OCSElement.Identifier && !file.getKind().isCpp() || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase || element == JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault || element == OCLineIndentProvider.OCSElement.PublicLike) {
                    return OCAutoFormatTypedHandler.adjustLineIndentUnderCaretNoCommit(file.getLanguage(), editor);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/formatting/OCAutoFormatTypedHandler$AdjustLabelCaseDefaultPublicHandler";
            objectArray[2] = "handle";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class MethodColonHandler
    implements Handler {
        @Override
        public boolean handle(char charTyped, @NotNull OCFile file, @NotNull Editor editor, @NotNull CodeStyleSettings settings) {
            if (file == null) {
                MethodColonHandler.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MethodColonHandler.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                MethodColonHandler.$$$reportNull$$$0(2);
            }
            if (charTyped != ':' || !file.getKind().isObjC()) {
                return false;
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)file.getProject());
            documentManager.commitDocument(editor.getDocument());
            PsiElement offsetElement = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (offsetElement == null || OCElementUtil.getElementType(offsetElement) != OCTokenTypes.COLON) {
                return false;
            }
            OCCodeStyleSettings customSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
            Pair<PsiElement, PsiElement> firstAndCurrent = MethodColonHandler.findFirstAndCurrentSelectors(offsetElement, customSettings);
            if (firstAndCurrent != null) {
                PsiElement firstSelector = (PsiElement)firstAndCurrent.first;
                PsiElement currSelector = (PsiElement)firstAndCurrent.second;
                ASTNode prevNode = FormatterUtil.getPreviousNonWhitespaceLeaf((ASTNode)currSelector.getNode());
                if (prevNode == null) {
                    return false;
                }
                Document document = editor.getDocument();
                int firstSelectorLine = document.getLineNumber(firstSelector.getTextOffset());
                int currSelectorLine = document.getLineNumber(currSelector.getTextOffset());
                int prevNodeLine = document.getLineNumber(prevNode.getTextRange().getEndOffset());
                if (prevNodeLine == currSelectorLine) {
                    return false;
                }
                int firstSelectorLineOffset = document.getLineStartOffset(firstSelectorLine);
                int currSelectorLineOffset = document.getLineStartOffset(currSelectorLine);
                int alignByOffset = firstSelector.getTextRange().getEndOffset() - firstSelectorLineOffset;
                int newLineOffset = Math.max(0, alignByOffset - currSelector.getTextLength());
                String spaces = new IndentInfo(0, newLineOffset, 0).generateNewWhiteSpace(settings.getIndentOptions(file.getFileType()));
                document.replaceString(currSelectorLineOffset, currSelector.getTextOffset(), (CharSequence)spaces);
                return true;
            }
            PsiElement currentArgument = offsetElement.getParent();
            if (currentArgument instanceof OCArgumentSelector && customSettings.METHOD_CALL_ARGUMENTS_ALIGN_MULTILINE || currentArgument instanceof OCMethodSelectorPart && customSettings.METHOD_PARAMETERS_ALIGN_MULTILINE) {
                CodeStyleManager.getInstance((Project)file.getProject()).adjustLineIndent((PsiFile)file, offsetElement.getTextOffset());
                return true;
            }
            return currentArgument instanceof OCArgumentSelector || currentArgument instanceof OCMethodSelectorPart;
        }

        @Contract(value="null, _ -> null")
        private static Pair<PsiElement, PsiElement> findFirstAndCurrentSelectors(@NotNull PsiElement offsetElement, @NotNull OCCodeStyleSettings settings) {
            if (offsetElement == null) {
                MethodColonHandler.$$$reportNull$$$0(3);
            }
            if (settings == null) {
                MethodColonHandler.$$$reportNull$$$0(4);
            }
            PsiElement currentArgument = offsetElement.getParent();
            PsiElement firstArgument = null;
            if (currentArgument instanceof OCArgumentSelector && settings.METHOD_CALL_ARGUMENTS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument.getParent();
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMessageArgument)) continue;
                    firstArgument = PsiTreeUtil.findChildOfType((PsiElement)prev, OCArgumentSelector.class);
                } while (prev != null);
            } else if (currentArgument instanceof OCMethodSelectorPart && settings.METHOD_PARAMETERS_ALIGN_BY_COLONS) {
                PsiElement prev = currentArgument;
                do {
                    if (!((prev = prev.getPrevSibling()) instanceof OCMethodSelectorPart)) continue;
                    firstArgument = prev;
                } while (prev != null);
                firstArgument = MethodColonHandler.getIdentifierFromParameter(firstArgument);
                currentArgument = MethodColonHandler.getIdentifierFromParameter(currentArgument);
            }
            return firstArgument == null || currentArgument == null ? null : Pair.create(firstArgument, (Object)currentArgument);
        }

        @Contract(value="null -> null")
        @Nullable
        private static PsiElement getIdentifierFromParameter(@Nullable PsiElement param) {
            if (param == null) {
                return null;
            }
            ASTNode identifier = param.getNode().findChildByType((IElementType)OCTokenTypes.IDENTIFIER);
            if (identifier == null || OCElementUtil.getElementType(identifier.getTreeNext()) != OCTokenTypes.COLON) {
                return null;
            }
            return identifier.getPsi();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "offsetElement";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCAutoFormatTypedHandler$MethodColonHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handle";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "findFirstAndCurrentSelectors";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static interface Handler {
        public boolean handle(char var1, @NotNull OCFile var2, @NotNull Editor var3, @NotNull CodeStyleSettings var4);
    }
}

