/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.formatting.OCFormatterUtil;
import com.jetbrains.cidr.lang.formatting.OCPreprocessorFormatterData;
import com.jetbrains.cidr.lang.lexer.OCLexerWithDirectives;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMultilineNodeFormatter {
    public static final Key<Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo>> PREPROCESSOR_INFO = Key.create((String)"PREPROCESSOR_INFO");
    public static final Key<Integer> CODE_INDENT = Key.create((String)"CODE_INDENT");
    public static final Key<Boolean> AT_FIRST_COL_HINT = Key.create((String)"AT_FIRST_COL_HINT");
    public static final int DIRTY_SPACE_COUNT = 120;
    @NotNull
    private CodeStyleSettings mySettings;

    public OCMultilineNodeFormatter(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(0);
        }
        this.mySettings = settings;
    }

    @NotNull
    public static OCMultilineNodeFormatter create(@NotNull Project project2) {
        if (project2 == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(1);
        }
        OCMultilineNodeFormatter oCMultilineNodeFormatter = new OCMultilineNodeFormatter(CodeStyleSettingsManager.getInstance((Project)project2).getCurrentSettings());
        if (oCMultilineNodeFormatter == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(2);
        }
        return oCMultilineNodeFormatter;
    }

    @NotNull
    public OCCodeStyleSettings getOCSettings() {
        OCCodeStyleSettings oCCodeStyleSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        if (oCCodeStyleSettings == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(3);
        }
        return oCCodeStyleSettings;
    }

    public TextRange shiftIndentInsideRangeInDocument(final @NotNull Document document, @NotNull ASTNode node, final @NotNull TextRange textRange, int shift) {
        if (document == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(4);
        }
        if (node == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(5);
        }
        if (textRange == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(6);
        }
        return this.shiftIndentInsideRangeEx(node, textRange, shift, new DocumentModifier(){

            @Override
            public TextRange change(boolean isNonCompiled, String newText, String oldText) {
                document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)newText);
                return new TextRange(textRange.getStartOffset(), textRange.getEndOffset() + newText.length() - oldText.length());
            }
        });
    }

    public TextRange shiftIndentInsideRangeInPsiTree(final @NotNull ASTNode node, final @NotNull TextRange textRange, int shift) {
        if (node == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(7);
        }
        if (textRange == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(8);
        }
        return this.shiftIndentInsideRangeEx(node, textRange, shift, new DocumentModifier(){

            @Override
            public TextRange change(boolean isNonCompiled, String newText, String oldText) {
                PsiElement newElement;
                ASTNode newASTNode;
                PsiElement element = node.getPsi();
                ASTNode actualASTParent = node.getTreeParent();
                if (actualASTParent != null && (newASTNode = (newElement = isNonCompiled ? OCElementFactory.codeFragment("\n#if 0\n" + newText + "\n#endif", element.getProject(), element, false, false).getFirstChild().getNextSibling().getNextSibling() : OCElementFactory.codeFragment(newText, element.getProject(), element, false, false).getFirstChild()).getNode()) != null) {
                    if (isNonCompiled) {
                        int shift;
                        Pair info = (Pair)PREPROCESSOR_INFO.get((UserDataHolder)node);
                        if (info != null && info.first != null) {
                            AT_FIRST_COL_HINT.set((UserDataHolder)newASTNode, info.first);
                        }
                        if ((shift = newText.length() - newASTNode.getTextLength()) != 0) {
                            CodeEditUtil.setOldIndentation((TreeElement)((TreeElement)newASTNode), (int)(-shift));
                        } else {
                            OCElementFactory.initIndentFromContext(element, newElement);
                        }
                    } else {
                        OCElementFactory.initIndentFromContext(element, newElement);
                    }
                    CodeEditUtil.replaceChild((ASTNode)actualASTParent, (ASTNode)node, (ASTNode)newASTNode);
                    return new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + newASTNode.getTextLength());
                }
                return textRange;
            }
        });
    }

    private TextRange shiftIndentInsideRangeEx(@NotNull ASTNode node, @NotNull TextRange textRange, int shift, @NotNull DocumentModifier modifier) {
        IElementType type;
        boolean isNonCompiled;
        if (node == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(10);
        }
        if (modifier == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(11);
        }
        boolean bl = isNonCompiled = (type = OCElementUtil.getElementType(node)) == OCTokenTypes.CONDITIONALLY_NON_COMPILED_COMMENT;
        if (type == OCTokenTypes.BLOCK_COMMENT || isNonCompiled) {
            if (isNonCompiled) {
                Pair info = (Pair)PREPROCESSOR_INFO.get((UserDataHolder)node);
                Integer codeIndent = (Integer)CODE_INDENT.get((UserDataHolder)node);
                if (info != null && codeIndent != null) {
                    String oldText = node.getText();
                    String newText = this.directiveIndentCorrection((Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo>)info, codeIndent, shift, false, oldText);
                    if (!newText.equals(oldText)) {
                        return modifier.change(true, newText, oldText);
                    }
                }
            } else {
                String oldText = node.getText();
                String newText = this.getShiftedLeafText(shift, oldText);
                if (!newText.equals(oldText)) {
                    return modifier.change(false, newText, oldText);
                }
            }
        }
        return textRange;
    }

    @NotNull
    private String getShiftedLeafText(int shift, @NotNull String leafText) {
        if (leafText == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(12);
        }
        int leafTextLength = leafText.length();
        int startOffset = 0;
        boolean firstLine = true;
        StringBuilder newCommentText = new StringBuilder();
        while (startOffset < leafTextLength) {
            int indent;
            char ch = ' ';
            StringBuilder originalIndent = new StringBuilder();
            while (startOffset < leafTextLength) {
                char c = leafText.charAt(startOffset);
                ch = c;
                if (!OCMultilineNodeFormatter.isSpaceChar(c)) break;
                ++startOffset;
                originalIndent.append(ch);
            }
            if (!(firstLine && originalIndent.length() <= 0 || (indent = this.normalizedTabLength(originalIndent.toString())) + shift <= 0)) {
                newCommentText.append(this.getStringIndent(indent + shift));
            }
            while (startOffset < leafTextLength && (ch = leafText.charAt(startOffset)) != '\n') {
                ++startOffset;
                newCommentText.append(ch);
            }
            if (ch != 10) continue;
            ++startOffset;
            newCommentText.append(ch);
            firstLine = false;
        }
        String string = newCommentText.toString();
        if (string == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(13);
        }
        return string;
    }

    public String directiveIndentCorrection(@NotNull Pair<Boolean, OCPreprocessorFormatterData.OCIndentInfo> info, int codeIndent, int shift, boolean replaceEmptyLinesByCodeIndent, @NotNull String leafText) {
        if (info == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(14);
        }
        if (leafText == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(15);
        }
        OCCodeStyleSettings ocCodeStyleSettings = this.getOCSettings();
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)leafText);
        shift -= 120;
        OCPreprocessorFormatterData preprocessorFormatterData = new OCPreprocessorFormatterData();
        preprocessorFormatterData.setIndentAtLevel((OCPreprocessorFormatterData.OCIndentInfo)info.second);
        ++preprocessorFormatterData.directiveNestLevel;
        StringBuilder code = new StringBuilder(leafText.length());
        Pair[] lineTypes = new Pair[lines.length];
        boolean inDirective = false;
        int endOfMultiline = -1;
        int endOfCodeSkip = -1;
        boolean needContinuation = false;
        boolean firstCodeLine = true;
        boolean firstLineIsDirective = false;
        boolean firstLineNeedIndentCorrection = false;
        int lineNo = 0;
        int offset = 0;
        for (String line : lines) {
            int length = line.length();
            if (offset >= endOfMultiline && OCMultilineNodeFormatter.dropStringIndent(line).startsWith("#")) {
                IElementType tokenType;
                OCLexerWithDirectives contentLexer = OCLexerWithDirectives.createDefault();
                contentLexer.start(line);
                while ((tokenType = contentLexer.getTokenType()) != null) {
                    if (OCFormatterUtil.FORMAT_DIRECTIVES.contains(tokenType)) {
                        inDirective = true;
                        lineTypes[lineNo] = preprocessorFormatterData.getIndents(tokenType, ocCodeStyleSettings, lineNo == 0 ? (Boolean)info.first : line.charAt(0) == '#');
                        break;
                    }
                    contentLexer.advance();
                }
            } else if (!needContinuation) {
                if (offset >= endOfCodeSkip) {
                    if (firstCodeLine && !OCMultilineNodeFormatter.isWhitespaceString(line)) {
                        if (firstLineIsDirective) {
                            int firstLineCodeIndent = this.indent(line);
                            firstLineNeedIndentCorrection = firstLineCodeIndent == 0;
                            shift = codeIndent - firstLineCodeIndent;
                            code.append(line);
                        } else {
                            code.append(OCMultilineNodeFormatter.dropStringIndent(line));
                        }
                        firstCodeLine = false;
                    } else {
                        code.append(line);
                    }
                    lineTypes[lineNo] = Pair.pair((Object)((Object)OCPreprocessorFormatterData.OffsetType.CODE_RELATIVE_PREV), (Object)0);
                } else {
                    lineTypes[lineNo] = Pair.pair((Object)((Object)OCPreprocessorFormatterData.OffsetType.CODE_AS_IS), (Object)0);
                }
                int endLineOffset = offset + length;
                if (endLineOffset > endOfMultiline) {
                    int lexerStartOffset = Math.max(offset, endOfMultiline);
                    OCLexerWithDirectives contentLexer = OCLexerWithDirectives.createDefault();
                    contentLexer.start(leafText.substring(lexerStartOffset));
                    while (true) {
                        IElementType tokenType = contentLexer.getTokenType();
                        int startTokenOffset = lexerStartOffset + contentLexer.getTokenStart();
                        if (tokenType != null && startTokenOffset < endLineOffset) {
                            if (OCFormatterUtil.FORMAT_PROBLEM_LEAFS_IN_NONCOMPILED.contains(tokenType)) {
                                endOfMultiline = lexerStartOffset + contentLexer.getTokenEnd();
                                endOfCodeSkip = tokenType == OCTokenTypes.BLOCK_COMMENT && OCMultilineNodeFormatter.dropStringIndent(leafText.substring(offset, startTokenOffset)).isEmpty() ? -1 : endOfMultiline;
                            }
                            contentLexer.advance();
                            continue;
                        }
                        break;
                    }
                }
            } else {
                lineTypes[lineNo] = Pair.pair((Object)((Object)OCPreprocessorFormatterData.OffsetType.DIRECTIVE_ABSOLUTE), (Object)this.indent(line));
            }
            if (lineNo == 0) {
                firstLineIsDirective = inDirective;
            }
            needContinuation = inDirective && line.endsWith("\\\n");
            ++lineNo;
            offset += length;
        }
        String newCode = this.getShiftedLeafText(shift, code.toString());
        if (firstLineNeedIndentCorrection) {
            newCode = this.getStringIndent(shift) + newCode;
        }
        String[] newLines = StringUtil.splitByLinesKeepSeparators((String)newCode);
        int newLineNo = 0;
        int prevCodeIndent = codeIndent;
        StringBuilder newText = new StringBuilder(leafText.length());
        block8: for (int i = 0; i < lines.length; ++i) {
            switch ((OCPreprocessorFormatterData.OffsetType)((Object)lineTypes[i].first)) {
                case DIRECTIVE_RELATIVE_CODE: {
                    newText.append(this.getStringIndent(prevCodeIndent + (Integer)lineTypes[i].second)).append(OCMultilineNodeFormatter.dropStringIndent(lines[i]));
                    continue block8;
                }
                case DIRECTIVE_ABSOLUTE: {
                    newText.append(this.getStringIndent((Integer)lineTypes[i].second)).append(OCMultilineNodeFormatter.dropStringIndent(lines[i]));
                    continue block8;
                }
                case CODE_RELATIVE_PREV: {
                    if (newLineNo >= newLines.length) continue block8;
                    boolean changeCodeIndent = newLineNo != 0 || newLineNo == 0 && firstLineIsDirective;
                    String formattedLine = newLines[newLineNo++];
                    boolean whitespaceString = OCMultilineNodeFormatter.isWhitespaceString(formattedLine);
                    if (changeCodeIndent && !whitespaceString) {
                        prevCodeIndent = this.indent(formattedLine);
                    }
                    if (changeCodeIndent && whitespaceString && replaceEmptyLinesByCodeIndent) {
                        newText.append(this.getStringIndent(prevCodeIndent)).append("\n");
                        continue block8;
                    }
                    newText.append(formattedLine);
                    continue block8;
                }
                default: {
                    newText.append(lines[i]);
                }
            }
        }
        return newText.toString();
    }

    private static boolean isWhitespaceString(String line) {
        return StringUtil.trim((String)line).isEmpty();
    }

    @Nullable
    public static String getIndentAtPosition(@NotNull HighlighterIterator it) {
        if (it == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(16);
        }
        it.retreat();
        if (it.atEnd()) {
            return "";
        }
        if (it.getTokenType() == TokenType.WHITE_SPACE) {
            String whiteSpace = it.getDocument().getText().substring(it.getStart(), it.getEnd());
            if (it.getStart() == 0 || whiteSpace.indexOf(10) >= 0) {
                return (String)OCMultilineNodeFormatter.splitIndent((String)whiteSpace).second;
            }
        }
        return null;
    }

    @Nullable
    public static String getDirectiveIndentFromAnchor(@NotNull HighlighterIterator it, @NotNull PsiFile file, boolean withIndentation) {
        if (it == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(17);
        }
        if (file == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(18);
        }
        int nestLevel = 0;
        while (!it.atEnd()) {
            if (OCFormatterUtil.FORMAT_DIRECTIVES_INCREASE_INDENT.contains(it.getTokenType())) {
                if (nestLevel == 0) break;
                if (OCTokenTypes.IF_DIRECTIVES.contains(it.getTokenType())) {
                    ++nestLevel;
                }
            } else if (OCTokenTypes.ENDIF_DIRECTIVE == it.getTokenType()) {
                --nestLevel;
            }
            it.retreat();
        }
        if (!it.atEnd()) {
            OCDirective guardIfndef;
            if (withIndentation && (guardIfndef = OCElementUtil.getGuardIfndef(file, true)) != null && guardIfndef.getTextOffset() == it.getStart()) {
                return null;
            }
            String directiveIndent = OCMultilineNodeFormatter.getIndentAtPosition(it);
            if (directiveIndent != null) {
                OCMultilineNodeFormatter multilineNodeFormatter = OCMultilineNodeFormatter.create(file.getProject());
                return multilineNodeFormatter.getStringIndent(multilineNodeFormatter.indent(directiveIndent) + (withIndentation ? multilineNodeFormatter.getOCSettings().INDENT_PREPROCESSOR_DIRECTIVE : 0));
            }
        }
        return null;
    }

    public int indent(@NotNull String line) {
        if (line == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(19);
        }
        return this.normalizedTabLength(OCMultilineNodeFormatter.getStringIndent(line));
    }

    private int normalizedTabLength(@NotNull String text) {
        if (text == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(20);
        }
        return text.replaceAll("\t", StringUtil.repeatSymbol((char)' ', (int)this.getTabSize())).length();
    }

    private int getTabSize() {
        CommonCodeStyleSettings.IndentOptions options = this.mySettings.getCommonSettings((Language)OCLanguage.getInstance()).getIndentOptions();
        return options == null ? 4 : options.TAB_SIZE;
    }

    @NotNull
    public String getStringIndent(int indent) {
        String indentStr = StringUtil.repeatSymbol((char)' ', (int)indent);
        CommonCodeStyleSettings.IndentOptions options = this.mySettings.getCommonSettings((Language)OCLanguage.getInstance()).getIndentOptions();
        String string = options == null || !options.USE_TAB_CHARACTER ? indentStr : indentStr.replaceAll(StringUtil.repeatSymbol((char)' ', (int)this.getTabSize()), "\t");
        if (string == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static String getStringIndent(@NotNull String line) {
        char ch;
        if (line == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(22);
        }
        int length = line.length();
        StringBuilder originalIndent = new StringBuilder();
        for (int startOffset = 0; startOffset < length && OCMultilineNodeFormatter.isSpaceChar(ch = line.charAt(startOffset)); ++startOffset) {
            originalIndent.append(ch);
        }
        String string = originalIndent.toString();
        if (string == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String dropStringIndent(@NotNull String string) {
        int index;
        if (string == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(24);
        }
        for (index = 0; index < string.length() && OCMultilineNodeFormatter.isSpaceChar(string.charAt(index)); ++index) {
        }
        String string2 = string.substring(index, string.length());
        if (string2 == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(25);
        }
        return string2;
    }

    private static boolean isSpaceChar(char ch) {
        return "\t ".indexOf(ch) >= 0;
    }

    @NotNull
    public static Pair<String, String> splitIndent(@NotNull String whiteSpace) {
        int lineStart;
        if (whiteSpace == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(26);
        }
        if ((lineStart = whiteSpace.lastIndexOf(10)) >= 0) {
            Pair pair2 = Pair.create((Object)whiteSpace.substring(0, lineStart + 1), (Object)whiteSpace.substring(lineStart + 1));
            if (pair2 == null) {
                OCMultilineNodeFormatter.$$$reportNull$$$0(27);
            }
            return pair2;
        }
        Pair pair3 = Pair.create((Object)"", (Object)whiteSpace);
        if (pair3 == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(28);
        }
        return pair3;
    }

    public static boolean isMultiline(@NotNull ASTNode node) {
        if (node == null) {
            OCMultilineNodeFormatter.$$$reportNull$$$0(29);
        }
        return node.getText().trim().indexOf(10) >= 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCMultilineNodeFormatter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leafText";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "it";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whiteSpace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCMultilineNodeFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOCSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getShiftedLeafText";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringIndent";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "dropStringIndent";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "splitIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shiftIndentInsideRangeInDocument";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shiftIndentInsideRangeInPsiTree";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shiftIndentInsideRangeEx";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getShiftedLeafText";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "directiveIndentCorrection";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndentAtPosition";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getDirectiveIndentFromAnchor";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "indent";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "normalizedTabLength";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStringIndent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "dropStringIndent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "splitIndent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "isMultiline";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 13: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface DocumentModifier {
        public TextRange change(boolean var1, String var2, String var3);
    }
}

