/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.util.SmartList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;

public class OCPostFormatVisitor
extends OCRecursiveVisitor {
    private final CommonCodeStyleSettings mySettings;
    private final PostFormatProcessorHelper myHelper;
    private boolean myReformat;

    public OCPostFormatVisitor(CodeStyleSettings settings) {
        this.mySettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        this.myHelper = new PostFormatProcessorHelper(settings);
    }

    @Override
    public void visitElement(PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        PsiElement child = element.getFirstChild();
        while (child != null) {
            PsiElement next = child.getNextSibling();
            if (this.myHelper.isElementPartlyInRange(child)) {
                child.accept((PsiElementVisitor)this);
            }
            child = next;
        }
    }

    public PsiElement process(PsiElement element) {
        element.accept((PsiElementVisitor)this);
        if (this.myReformat) {
            CodeStyleManager.getInstance((Project)element.getProject()).reformat(element, true);
        }
        return element;
    }

    public TextRange process(PsiFile element, TextRange range) {
        this.myHelper.setResultTextRange(range);
        element.accept((PsiElementVisitor)this);
        range = this.myHelper.getResultTextRange();
        if (this.myReformat) {
            CodeStyleManager.getInstance((Project)element.getProject()).reformatRange((PsiElement)element.getContainingFile(), range.getStartOffset(), range.getEndOffset(), true);
        }
        return range;
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        super.visitIfStatement(stmt);
        this.doProcess(stmt, stmt.getThenBranch(), this.mySettings.IF_BRACE_FORCE);
        OCStatement elseStmt = stmt.getElseBranch();
        if (!this.mySettings.SPECIAL_ELSE_IF_TREATMENT || !(elseStmt instanceof OCIfStatement)) {
            this.doProcess(stmt, elseStmt, this.mySettings.IF_BRACE_FORCE);
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        super.visitForStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.FOR_BRACE_FORCE);
    }

    @Override
    public void visitForeachStatement(OCForeachStatement stmt) {
        super.visitForeachStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.FOR_BRACE_FORCE);
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        super.visitWhileStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.WHILE_BRACE_FORCE);
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        super.visitDoWhileStatement(stmt);
        this.doProcess(stmt, stmt.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
    }

    private void doProcess(OCStatement parent, OCStatement statement2, int option) {
        if (statement2 == null || statement2 instanceof OCBlockStatement) {
            return;
        }
        if (!this.myHelper.isElementFullyInRange((PsiElement)statement2)) {
            return;
        }
        if (option == 3 || option == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)parent)) {
            this.replaceWithBlock(parent, statement2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceWithBlock(@NotNull OCStatement parent, @NotNull PsiElement statementToWrap) {
        LeafElement firstLeaf;
        if (parent == null) {
            OCPostFormatVisitor.$$$reportNull$$$0(0);
        }
        if (statementToWrap == null) {
            OCPostFormatVisitor.$$$reportNull$$$0(1);
        }
        if ((firstLeaf = TreeUtil.findFirstLeaf((ASTNode)statementToWrap.getNode())) instanceof ForeignLeafPsiElement) {
            return;
        }
        String oldText = statementToWrap instanceof OCEmptyStatement ? "" : statementToWrap.getText();
        SmartList toRemove = new SmartList();
        StringBuilder builder = StringBuilderSpinAllocator.alloc();
        builder.append('{');
        OCPostFormatVisitor.collectSiblings(true, statementToWrap, (SmartList<PsiElement>)toRemove, builder);
        builder.append(oldText);
        OCPostFormatVisitor.collectSiblings(false, statementToWrap, (SmartList<PsiElement>)toRemove, builder);
        builder.append("}");
        String text = builder.toString();
        StringBuilderSpinAllocator.dispose((StringBuilder)builder);
        PsiElement context = statementToWrap.getContext();
        if (context == null) {
            return;
        }
        OCStatement replacement = OCElementFactory.statementFromText(text, context);
        if (replacement == null) {
            return;
        }
        OCElementFactory.initIndentFromContext(context, replacement);
        int oldParentTextLength = parent.getTextLength();
        try {
            ASTNode parentNode = SourceTreeToPsiMap.psiElementToTree((PsiElement)parent);
            for (PsiElement each : toRemove) {
                parentNode.removeChild(SourceTreeToPsiMap.psiElementToTree((PsiElement)each));
            }
            CodeEditUtil.replaceChild((ASTNode)parentNode, (ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)statementToWrap), (ASTNode)SourceTreeToPsiMap.psiElementToTree((PsiElement)replacement));
            this.myReformat = true;
        }
        finally {
            this.myHelper.updateResultRange(oldParentTextLength, parent.getTextLength());
        }
    }

    private static void collectSiblings(boolean before, @NotNull PsiElement statement2, @NotNull SmartList<PsiElement> toRemove, @NotNull StringBuilder builder) {
        PsiElement sibling;
        if (statement2 == null) {
            OCPostFormatVisitor.$$$reportNull$$$0(2);
        }
        if (toRemove == null) {
            OCPostFormatVisitor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            OCPostFormatVisitor.$$$reportNull$$$0(4);
        }
        ArrayList<PsiElement> siblings = new ArrayList<PsiElement>();
        PsiElement psiElement = sibling = before ? statement2.getPrevSibling() : statement2.getNextSibling();
        while (sibling != null && OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(sibling))) {
            siblings.add(sibling);
            sibling = before ? sibling.getPrevSibling() : sibling.getNextSibling();
        }
        LinkedList<String> strings = new LinkedList<String>();
        boolean addAnyway = siblings.size() > 1 || before;
        for (PsiElement sibling2 : ContainerUtil.iterateBackward(siblings)) {
            if (sibling2 instanceof PsiWhiteSpace && !addAnyway) continue;
            String siblingText = sibling2.getText();
            toRemove.add((Object)sibling2);
            if (before) {
                strings.addLast(siblingText);
                continue;
            }
            strings.addFirst(siblingText);
        }
        for (String str : strings) {
            builder.append(str);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementToWrap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCPostFormatVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithBlock";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSiblings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

