/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCaretLocation {
    @NotNull
    private final PsiFile myFile;
    @Nullable
    private final PsiElement myElement;
    private final int myOffsetInElement;

    @NotNull
    public static OCCaretLocation byEditor(@NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(0);
        }
        PsiElement element = editor == null ? null : OCGenerateUtil.getElementAt(editor, file);
        int offset = editor == null ? -1 : Math.max(0, editor.getCaretModel().getOffset() - element.getTextRange().getStartOffset());
        OCCaretLocation oCCaretLocation = new OCCaretLocation(file, element, offset);
        if (oCCaretLocation == null) {
            OCCaretLocation.$$$reportNull$$$0(1);
        }
        return oCCaretLocation;
    }

    @NotNull
    public static OCCaretLocation byOffset(@NotNull PsiFile file, int offsetInFile) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(2);
        }
        PsiElement element = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(offsetInFile), (Object)file);
        OCCaretLocation oCCaretLocation = new OCCaretLocation(file, element, Math.min(element.getTextRange().getEndOffset(), Math.max(0, offsetInFile - element.getTextRange().getStartOffset())));
        if (oCCaretLocation == null) {
            OCCaretLocation.$$$reportNull$$$0(3);
        }
        return oCCaretLocation;
    }

    public static OCCaretLocation byFile(@NotNull PsiFile file) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(4);
        }
        return new OCCaretLocation(file, null, -1);
    }

    private OCCaretLocation(@NotNull PsiFile file, @Nullable PsiElement element, int offsetInElement) {
        if (file == null) {
            OCCaretLocation.$$$reportNull$$$0(5);
        }
        this.myFile = file;
        this.myElement = element;
        this.myOffsetInElement = offsetInElement;
    }

    @Nullable
    public PsiElement getElement() {
        return this.myElement;
    }

    @Nullable
    public Integer getOffsetInFile() {
        return this.myElement == null ? null : Integer.valueOf(this.myElement.getTextRange().getStartOffset() + this.myOffsetInElement);
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myFile;
        if (psiFile == null) {
            OCCaretLocation.$$$reportNull$$$0(6);
        }
        return psiFile;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myFile.getProject();
        if (project2 == null) {
            OCCaretLocation.$$$reportNull$$$0(7);
        }
        return project2;
    }

    @NotNull
    public OCResolveContext createContext() {
        OCResolveContext oCResolveContext = OCResolveContext.forPsi((PsiElement)ObjectUtils.notNull((Object)this.myElement, (Object)this.myFile));
        if (oCResolveContext == null) {
            OCCaretLocation.$$$reportNull$$$0(8);
        }
        return oCResolveContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCCaretLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCCaretLocation";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "byEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "byOffset";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "byEditor";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "byOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "byFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

