/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCNewCppFunctionsLocator;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCNoexceptSpecifier;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceLikeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCppDefinitionsUtil {
    @NotNull
    public static String functionSignature(@NotNull OCFunctionSymbol function, boolean isOutOfClassDefinition, @NotNull PsiElement context) {
        OCFunctionDeclaration funDefinition;
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(1);
        }
        StringBuilder answer = new StringBuilder();
        FunctionQualifiedNameInfo qualInfo = isOutOfClassDefinition ? OCCppGeneratedQualifiedFunctionKt.getQualifiedNameAndTemplateHeader(function, context) : new FunctionQualifiedNameInfo(function.getName(), "");
        answer.append(qualInfo.getTemplateHeader());
        if (function.isConstexpr()) {
            answer.append("constexpr ");
        }
        if (!isOutOfClassDefinition) {
            if (function.isVirtual()) {
                answer.append("virtual ");
            }
            if (function.isFriend()) {
                answer.append("friend ");
            }
            if (function.isStatic()) {
                answer.append("static ");
            }
            if (function.isExplicit()) {
                answer.append("explicit ");
            }
        }
        Project project2 = context.getProject();
        if (!(function.isCppConstructor() || function.isCppDestructor() || function.isCppConversionOperator())) {
            OCResolveContext resolveContext = OCResolveContext.forPsi(context);
            answer.append(function.getEffectiveResolvedType(resolveContext).getBestNameInContext(resolveContext, OCElementUtil.getReturnTypeTextWithModifiers(function, project2)));
            answer.append(' ');
        }
        answer.append(qualInfo.getQualifiedName());
        answer.append('(');
        boolean isFirstParam = true;
        for (OCDeclaratorSymbol param : function.getParameterSymbols()) {
            if (!isFirstParam) {
                answer.append(", ");
            }
            isFirstParam = false;
            answer.append(OCElementFactory.declarationText(param.getName(), param.getType(), OCElementUtil.getTypeTextWithModifiers(param, context.getProject()), context));
        }
        answer.append(')');
        function.getType().getCVQualifiers().appendCVQualifiers(answer);
        if (function.getType().isLValueRef()) {
            answer.append(" &");
        } else if (function.getType().isRValueRef()) {
            answer.append(" &&");
        }
        if (!isOutOfClassDefinition && function.isOverride()) {
            answer.append(" override");
        }
        if (!isOutOfClassDefinition && function.isFinal()) {
            answer.append(" final");
        }
        if (!isOutOfClassDefinition && function.isPureVirtual()) {
            answer.append(" = 0");
        }
        if (!isOutOfClassDefinition && function.isDefault()) {
            answer.append(" = default");
        }
        if (!isOutOfClassDefinition && function.isDelete()) {
            answer.append(" = delete");
        }
        if ((funDefinition = function.locateFunctionDefinition(project2)) != null) {
            OCTypeElement trailingType;
            OCNoexceptSpecifier noexceptSpecifier = funDefinition.getNoexceptSpecifier();
            if (noexceptSpecifier != null) {
                answer.append(" ");
                answer.append(noexceptSpecifier.getTextWithMacros());
            }
            if ((trailingType = funDefinition.getTrailingReturnTypeElement()) != null) {
                answer.append(" -> ").append(trailingType.getType().resolve(context).getBestNameInContext(context, trailingType.getTextWithMacros()));
            }
        }
        String string = answer.toString();
        if (string == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static SHOULD_GENERATE_DEFINITION shouldGenerateDefinitionsFor(@NotNull OCFunctionSymbol function, boolean checkNoncopyable, @NotNull Project project2) {
        OCType type;
        List<OCType> parameterTypes;
        PsiFile file;
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(3);
        }
        if (project2 == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(4);
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)(file = function.getContainingPsiFile(project2)))) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (function.isPureVirtual()) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!function.processSameSymbols((Processor<OCSymbol>)((Processor)s -> s.isPredeclaration() && (!(s instanceof OCFunctionSymbol) || !((OCFunctionSymbol)s).isDefault() && !((OCFunctionSymbol)s).isDelete())), project2)) {
            return SHOULD_GENERATE_DEFINITION.NO;
        }
        if (!(function.getParent() instanceof OCStructSymbol)) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        if (checkNoncopyable && function.getVisibility() == OCVisibility.PRIVATE && (function.isCppConstructor() || function.isCppOperator() && function.getName().equals("operator=")) && (parameterTypes = function.getType().getParameterTypes()).size() == 1 && (type = parameterTypes.get(0)) instanceof OCCppReferenceType && function.getParent().getType().cloneWithConstModifier(project2).equalsAfterResolving(((OCCppReferenceType)type).getRefType(), OCResolveContext.forSymbol(function, project2))) {
            return SHOULD_GENERATE_DEFINITION.POSSIBLE;
        }
        return SHOULD_GENERATE_DEFINITION.REQUIRED;
    }

    @NotNull
    public static OCMembersContainer getFunctionParent(@NotNull OCFunctionSymbol function, @NotNull Project project2) {
        if (function == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(5);
        }
        if (project2 == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(6);
        }
        OCNamespaceLikeSymbol oCNamespaceLikeSymbol = function.getParent() instanceof OCNamespaceLikeSymbol ? (OCNamespaceLikeSymbol)((Object)function.getParent()) : function.getContainingOCFile(project2).getMembersContainer(false);
        if (oCNamespaceLikeSymbol == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(7);
        }
        return oCNamespaceLikeSymbol;
    }

    public static boolean shouldInlineNewDefinitions(@NotNull OCMembersContainer parent, @NotNull OCCaretLocation location) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(8);
        }
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(9);
        }
        Project project2 = location.getProject();
        if (location.getElement() != null) {
            if (!(parent instanceof OCSymbol) && parent.getContainingOCFile(project2).equals(location.getFile()) && OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2)) {
                return false;
            }
            if (OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2))) {
                return false;
            }
        }
        return OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions((OCMembersContainer)parent, (Project)project2).shouldInline;
    }

    @Nullable
    public static OCGenerateUtil.ReplacePosition getOutsidePreferredPosition(@NotNull PsiFile file, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions) {
        OCFile sourceFile;
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(10);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(11);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(12);
        }
        if (functions.isEmpty() || !(file instanceof OCFile)) {
            return null;
        }
        Project project2 = file.getProject();
        BasedOnExistingResult basedOnExisting = OCCppDefinitionsUtil.getBestLocationBasedOnExistingDefinitions(parent, project2);
        if (basedOnExisting.outsideLocation != null) {
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby((Integer)basedOnExisting.outsideLocation.second, (PsiFile)basedOnExisting.outsideLocation.first);
        }
        if (OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2) && functions.stream().noneMatch(OCFunctionSymbol::isTemplateSymbol) && (sourceFile = ((OCFile)file).getAssociatedFile()) != null && !sourceFile.isHeader()) {
            PsiElement insertionParent = OCCppDefinitionsUtil.findInsertionParentInFile(sourceFile, (OCNamespaceSymbol)ObjectUtils.tryCast((Object)parent, OCNamespaceSymbol.class));
            ASTNode child = insertionParent.getNode().findChildByType((IElementType)OCTokenTypes.RBRACE);
            PsiElement rBrace = child != null ? child.getPsi() : null;
            int desiredOffset = rBrace != null ? rBrace.getTextRange().getStartOffset() : insertionParent.getTextRange().getEndOffset();
            return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(desiredOffset, sourceFile);
        }
        PsiElement fallbackLocation = OCCppDefinitionsUtil.defaultFallbackLocation(file, OCCppDefinitionsUtil.getParentDefinition(parent, project2), functions);
        return OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(fallbackLocation.getTextRange().getEndOffset(), fallbackLocation.getContainingFile());
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getGenerateDefinitionReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @NotNull List<? extends OCCallable> predefinitions, @NotNull InlinePolicy inlinePolicy) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(13);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(14);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(15);
        }
        if (predefinitions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(16);
        }
        if (inlinePolicy == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(17);
        }
        if (inlinePolicy.shouldInline(location, parent)) {
            ArrayList<OCGenerateUtil.Replacement> replacements = new ArrayList<OCGenerateUtil.Replacement>(functions.size());
            assert (functions.size() == predefinitions.size());
            for (int i = 0; i < functions.size(); ++i) {
                PsiElement semicolon;
                OCFunctionSymbol symbol = functions.get(i);
                OCCallable predefinition = predefinitions.get(i);
                if (predefinition == null) continue;
                PsiElement lastChild = predefinition.getLastChild();
                PsiElement psiElement = semicolon = !OCElementUtil.isElementSignificant(lastChild) ? OCElementUtil.getPrevSignificantSibling(lastChild) : lastChild;
                if (semicolon == null || OCElementUtil.getElementType(semicolon) != OCTokenTypes.SEMICOLON) continue;
                replacements.add(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(predefinition.getContainingOCFile(), semicolon.getTextRange(), predefinition, false), OCCallableUtil.defaultFunctionBody(symbol, OCCallableUtil.getDefaultBaseToCall(symbol, predefinition.getProject()), predefinition)));
            }
            ArrayList<OCGenerateUtil.Replacement> arrayList = replacements;
            if (arrayList == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getOutsideReplacements(location, parent, functions, null);
        if (list == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public static List<OCGenerateUtil.Replacement> getNewFunctionsReplacements(@NotNull OCCaretLocation location, @NotNull OCStructLike structDefinition, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> symbols, @Nullable List<String> bodies, @NotNull InlinePolicy inlinePolicy) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(20);
        }
        if (structDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(21);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(22);
        }
        if (symbols == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(23);
        }
        if (inlinePolicy == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(24);
        }
        if (symbols.isEmpty()) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(25);
            }
            return list;
        }
        StringBuilder insideClassText = new StringBuilder();
        boolean shouldInline = inlinePolicy.shouldInline(location, parent);
        OCStructLike contextToCalculateNames = structDefinition;
        int insertPositionInsideClass = OCCppDefinitionsUtil.getInsertPositionForFunctionsInsideClass(structDefinition, location, symbols.get(0));
        OCVisibility initialVisibility = OCVisibility.getVisibilityAtOffset(structDefinition, insertPositionInsideClass);
        assert (initialVisibility != null);
        OCVisibility curVisibility = initialVisibility;
        for (int i = 0; i < symbols.size(); ++i) {
            OCFunctionSymbol functionSymbol = symbols.get(i);
            OCVisibility visibility = functionSymbol.getVisibility();
            if (visibility != curVisibility) {
                insideClassText.append((Object)visibility).append(": ");
                curVisibility = visibility;
            }
            String afterSignature = shouldInline ? (bodies == null ? OCCallableUtil.defaultFunctionBody(functionSymbol, OCCallableUtil.getDefaultBaseToCall(functionSymbol, location.getProject()), contextToCalculateNames) : bodies.get(i)) : ";";
            insideClassText.append(OCCppDefinitionsUtil.functionSignature(functionSymbol, false, structDefinition)).append(afterSignature);
        }
        if (OCCppDefinitionsUtil.shouldRestoreVisibility(structDefinition, insertPositionInsideClass, initialVisibility, curVisibility)) {
            insideClassText.append((Object)initialVisibility).append(": ");
        }
        PsiFile structDefinitionFile = structDefinition.getContainingFile();
        Document structDefinitionDocument = PsiDocumentManager.getInstance((Project)location.getProject()).getDocument(structDefinitionFile);
        if (structDefinitionDocument == null) {
            OCLog.LOG.warn("No document for " + structDefinitionFile);
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(26);
            }
            return list;
        }
        List<OCGenerateUtil.Replacement> insideClassReplacements = Collections.singletonList(new OCGenerateUtil.Replacement(new OCGenerateUtil.ReplacePosition(structDefinitionFile, TextRange.from((int)insertPositionInsideClass, (int)0), contextToCalculateNames), insideClassText.toString()));
        List outsideClassReplacements = shouldInline ? Collections.emptyList() : OCCppDefinitionsUtil.getOutsideReplacements(location, parent, symbols, bodies);
        List list = ContainerUtil.concat(insideClassReplacements, outsideClassReplacements);
        if (list == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(27);
        }
        return list;
    }

    @Nullable
    public static PsiElement getParentDefinition(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(28);
        }
        if (project2 == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(29);
        }
        return parent instanceof OCSymbol ? ((OCSymbol)((Object)parent)).locateDefinition(project2) : parent.getContainingOCFile(project2);
    }

    @NotNull
    private static List<OCGenerateUtil.Replacement> getOutsideReplacements(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent, @NotNull List<OCFunctionSymbol> functions, @Nullable List<String> bodies) {
        OCGenerateUtil.ReplacePosition position;
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(30);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(31);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(32);
        }
        OCGenerateUtil.ReplacePosition replacePosition = position = OCCppDefinitionsUtil.shouldGenerateOutsideDefinitionAtCaret(location, parent) ? OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location) : OCCppDefinitionsUtil.getOutsidePreferredPosition(location.getFile(), parent, functions);
        if (position == null) {
            OCLog.LOG.warn("Can't find outside position for file '" + location.getFile() + "'");
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(33);
            }
            return list;
        }
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < functions.size(); ++i) {
            OCFunctionSymbol function = functions.get(i);
            text.append(OCCppDefinitionsUtil.functionSignature(function, true, position.context)).append(bodies != null ? bodies.get(i) : OCCallableUtil.defaultFunctionBody(function, OCCallableUtil.getDefaultBaseToCall(function, location.getProject()), position.context));
        }
        List<OCGenerateUtil.Replacement> list = Collections.singletonList(new OCGenerateUtil.Replacement(position, text.toString()));
        if (list == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    private static BasedOnExistingResult getBestLocationBasedOnExistingDefinitions(@NotNull OCMembersContainer parent, final @NotNull Project project2) {
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(35);
        }
        if (project2 == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(36);
        }
        final OCFile topLevelFile = parent instanceof OCSymbol ? null : parent.getContainingOCFile(project2);
        class OffsetProcessor
        implements Processor {
            public boolean hasInlineDefinition = false;
            public boolean hasOutsideDefinition = false;
            public int maxOffset = 0;
            public PsiFile file = null;

            OffsetProcessor() {
            }

            @Nullable
            Pair<PsiFile, Integer> location() {
                return this.file == null ? null : Pair.create((Object)this.file, (Object)this.maxOffset);
            }

            boolean shouldBeInlined(@NotNull OCMembersContainer parent) {
                if (parent == null) {
                    OffsetProcessor.$$$reportNull$$$0(0);
                }
                return !this.hasOutsideDefinition && (this.hasInlineDefinition || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2));
            }

            public boolean process(Object o) {
                ProgressManager.checkCanceled();
                if (!(o instanceof OCSymbol)) {
                    return true;
                }
                OCSymbol symbol = (OCSymbol)o;
                if (symbol.isPredeclaration()) {
                    PsiFile definitionFile;
                    Object definition;
                    if (topLevelFile != null && symbol.getContainingOCFile(project2) != topLevelFile) {
                        return true;
                    }
                    OCSymbol definitionSymbol = symbol.getDefinitionSymbol(project2);
                    if (definitionSymbol != null && (definition = definitionSymbol.locateDefinition(project2)) != null && (definitionFile = definition.getContainingFile()) != null) {
                        if (this.file == null && OCCodeInsightUtil.isValid((PsiElement)definitionFile)) {
                            this.file = definitionFile;
                            this.hasOutsideDefinition = true;
                        }
                        if (this.file != null && this.file.equals(definitionFile)) {
                            this.maxOffset = Math.max(this.maxOffset, definition.getTextRange().getEndOffset());
                        }
                    }
                } else if (symbol instanceof OCFunctionSymbol) {
                    this.hasInlineDefinition = true;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$1OffsetProcessor", "shouldBeInlined"));
            }
        }
        OffsetProcessor processor2 = new OffsetProcessor();
        parent.processMembers(null, processor2);
        BasedOnExistingResult basedOnExistingResult = new BasedOnExistingResult(processor2.shouldBeInlined(parent), processor2.location());
        if (basedOnExistingResult == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(37);
        }
        return basedOnExistingResult;
    }

    private static boolean canDefinitionsBePlacedToAssocFile(@NotNull OCMembersContainer parent, @NotNull Project project2) {
        OCFile file;
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(38);
        }
        if (project2 == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(39);
        }
        if ((file = parent.getContainingOCFile(project2)) == null || !file.isHeader()) {
            return false;
        }
        OCFile assoc = file.getAssociatedFile();
        if (assoc == null || assoc.isHeader()) {
            return false;
        }
        return !(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol();
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(@NotNull OCCaretLocation location) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(40);
        }
        return location.getOffsetInFile() == null ? null : OCCppDefinitionsUtil.getCorrectOutsideInsertPositionNearby(location.getOffsetInFile(), location.getFile());
    }

    @Nullable
    private static OCGenerateUtil.ReplacePosition getCorrectOutsideInsertPositionNearby(int originalOffset, @NotNull PsiFile file) {
        PsiElement atCaret;
        Document document;
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(41);
        }
        if ((document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file)) == null) {
            OCLog.LOG.warn("No document for " + file);
            return null;
        }
        PsiElement prev = null;
        for (PsiElement curr = atCaret = (PsiElement)ObjectUtils.notNull((Object)file.findElementAt(originalOffset), (Object)file); curr != null; curr = curr.getParent()) {
            if (curr instanceof OCCppNamespace || curr instanceof PsiFile) {
                int preferredOffset = -1;
                PsiElement context = null;
                if (curr instanceof OCCppNamespace && prev != null) {
                    boolean insideNamespaceHeader = false;
                    for (PsiElement nsChild = curr.getFirstChild(); nsChild != curr.getLastChild(); nsChild = nsChild.getNextSibling()) {
                        if (nsChild.equals(prev)) {
                            insideNamespaceHeader = true;
                        }
                        if (OCElementUtil.getElementType(nsChild) != OCTokenTypes.LBRACE) continue;
                        if (!insideNamespaceHeader) break;
                        preferredOffset = nsChild.getTextRange().getEndOffset();
                        context = curr;
                        break;
                    }
                }
                if (context == null) {
                    boolean isInsideComment = prev instanceof PsiComment && originalOffset > prev.getTextRange().getStartOffset();
                    preferredOffset = (prev == atCaret || prev == null) && !isInsideComment ? originalOffset : prev.getTextRange().getEndOffset();
                    context = curr;
                }
                return new OCGenerateUtil.ReplacePosition(file, TextRange.from((int)preferredOffset, (int)0), context);
            }
            prev = curr;
        }
        return null;
    }

    @NotNull
    private static PsiElement defaultFallbackLocation(@NotNull PsiFile file, @Nullable PsiElement parentDefinition, @NotNull List<OCFunctionSymbol> functions) {
        if (file == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(42);
        }
        if (functions == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(43);
        }
        int maxOffset = -1;
        OCFunctionDeclaration result = null;
        for (OCFunctionSymbol symbol : functions) {
            OCFunctionDeclaration definition = symbol.locateFunctionDefinition(file.getProject());
            if (definition == null) continue;
            int offset = definition.getTextRange().getEndOffset();
            if (!file.equals(definition.getContainingFile()) || offset <= maxOffset) continue;
            maxOffset = offset;
            result = definition;
        }
        if (result != null) {
            OCFunctionDeclaration oCFunctionDeclaration = result;
            if (oCFunctionDeclaration == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(44);
            }
            return oCFunctionDeclaration;
        }
        if (parentDefinition != null && file.equals(parentDefinition.getContainingFile())) {
            PsiElement psiElement = parentDefinition;
            if (psiElement == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(45);
            }
            return psiElement;
        }
        PsiFile psiFile = file;
        if (psiFile == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(46);
        }
        return psiFile;
    }

    private static int getInsertPositionForFunctionsInsideClass(@NotNull OCStructLike structDefinition, @NotNull OCCaretLocation location, @NotNull OCFunctionSymbol newFunction) {
        if (structDefinition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(47);
        }
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(48);
        }
        if (newFunction == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(49);
        }
        int defaultOffset = OCNewCppFunctionsLocator.locateNewFunction(structDefinition, newFunction);
        if (location.getOffsetInFile() == null || !location.getFile().equals(structDefinition.getContainingFile())) {
            return defaultOffset;
        }
        int offset = location.getOffsetInFile();
        if (!OCNewCppFunctionsLocator.getValidLocationRange(structDefinition).contains(offset)) {
            return defaultOffset;
        }
        if (OCCppDefinitionsUtil.isLocationOutsideParent(location, structDefinition)) {
            return defaultOffset;
        }
        PsiElement elementToInsertAfter = null;
        boolean betweenVisibilityAndColon = false;
        for (PsiElement child = structDefinition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (OCElementUtil.isVisibilityKeyword(child.getNode())) {
                betweenVisibilityAndColon = true;
            } else if (OCElementUtil.getElementType(child) == OCTokenTypes.COLON) {
                betweenVisibilityAndColon = false;
            }
            if (betweenVisibilityAndColon || child.getTextRange().getEndOffset() < offset) continue;
            elementToInsertAfter = child;
            break;
        }
        if (elementToInsertAfter instanceof PsiWhiteSpace && elementToInsertAfter.getTextRange().contains(offset)) {
            return offset;
        }
        if (elementToInsertAfter != null) {
            return elementToInsertAfter.getTextRange().getEndOffset();
        }
        return defaultOffset;
    }

    private static boolean shouldRestoreVisibility(@NotNull OCStructLike definition, int pos, @NotNull OCVisibility initial, @Nullable OCVisibility lastNew) {
        if (definition == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(50);
        }
        if (initial == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(51);
        }
        if (initial == lastNew) {
            return false;
        }
        for (PsiElement child = definition.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getTextRange().getStartOffset() < pos) continue;
            if (child instanceof OCDeclaration) {
                return true;
            }
            if (OCVisibility.getVisibilityFromElement(child) == null) continue;
            return false;
        }
        return false;
    }

    private static boolean isLocationOutsideParent(@NotNull OCCaretLocation location, @Nullable PsiElement parentDefinition) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(52);
        }
        assert (location.getElement() != null);
        return !PsiTreeUtil.isAncestor((PsiElement)parentDefinition, (PsiElement)location.getElement(), (boolean)false);
    }

    private static boolean shouldGenerateOutsideDefinitionAtCaret(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
        if (location == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(53);
        }
        if (parent == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(54);
        }
        if (location.getElement() == null) {
            return false;
        }
        Project project2 = location.getProject();
        if (!(parent instanceof OCSymbol)) {
            return !parent.getContainingOCFile(project2).equals(location.getFile()) || !OCCppDefinitionsUtil.canDefinitionsBePlacedToAssocFile(parent, project2);
        }
        return OCCppDefinitionsUtil.isLocationOutsideParent(location, OCCppDefinitionsUtil.getParentDefinition(parent, project2));
    }

    @NotNull
    private static PsiElement findInsertionParentInFile(OCFile file, OCNamespaceSymbol parent) {
        Object namespacePsi;
        ArrayList<OCNamespaceSymbol> parentsPath = new ArrayList<OCNamespaceSymbol>();
        while (parent != null) {
            if (!(parent instanceof OCStructSymbol)) {
                parentsPath.add(0, parent);
            }
            parent = (OCNamespaceSymbol)parent.getParent();
        }
        OCNamespaceLikeSymbol current = file.getMembersContainer(false);
        for (OCNamespaceSymbol symbol : parentsPath) {
            final VirtualFile virtualFile = file.getContainingFile().getVirtualFile();
            CommonProcessors.FindFirstProcessor<OCNamespaceSymbol> finder = new CommonProcessors.FindFirstProcessor<OCNamespaceSymbol>(){

                protected boolean accept(OCNamespaceSymbol symbol) {
                    ProgressManager.checkCanceled();
                    return virtualFile != null && virtualFile.equals(symbol.getContainingFile());
                }
            };
            current.processMembers(symbol.getName(), new OCCommonProcessors.TypeFilteredProcessor((Processor<OCNamespaceSymbol>)finder, OCNamespaceSymbol.class));
            if (!finder.isFound()) break;
            current = (OCNamespaceLikeSymbol)finder.getFoundValue();
        }
        if (current instanceof OCNamespaceSymbol && (namespacePsi = ((OCNamespaceSymbol)current).locateDefinition(file.getProject())) != null) {
            Object t = namespacePsi;
            if (t == null) {
                OCCppDefinitionsUtil.$$$reportNull$$$0(55);
            }
            return t;
        }
        OCFile oCFile = file;
        if (oCFile == null) {
            OCCppDefinitionsUtil.$$$reportNull$$$0(56);
        }
        return oCFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil";
                break;
            }
            case 4: 
            case 6: 
            case 29: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 14: 
            case 22: 
            case 28: 
            case 31: 
            case 35: 
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: 
            case 13: 
            case 20: 
            case 30: 
            case 40: 
            case 48: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 10: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 15: 
            case 32: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinitions";
                break;
            }
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inlinePolicy";
                break;
            }
            case 21: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structDefinition";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunction";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "functionSignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerateDefinitionReplacements";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFunctionsReplacements";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutsideReplacements";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getBestLocationBasedOnExistingDefinitions";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultFallbackLocation";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "findInsertionParentInFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "functionSignature";
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 56: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateDefinitionsFor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldInlineNewDefinitions";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOutsidePreferredPosition";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getGenerateDefinitionReplacements";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getNewFunctionsReplacements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getParentDefinition";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getOutsideReplacements";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getBestLocationBasedOnExistingDefinitions";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canDefinitionsBePlacedToAssocFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectOutsideInsertPositionNearby";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "defaultFallbackLocation";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPositionForFunctionsInsideClass";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "shouldRestoreVisibility";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isLocationOutsideParent";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "shouldGenerateOutsideDefinitionAtCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 18: 
            case 19: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 37: 
            case 44: 
            case 45: 
            case 46: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BasedOnExistingResult {
        public final boolean shouldInline;
        @Nullable
        public final Pair<PsiFile, Integer> outsideLocation;

        private BasedOnExistingResult(boolean inline, @Nullable Pair<PsiFile, Integer> location) {
            this.shouldInline = inline;
            this.outsideLocation = location;
            assert (this.outsideLocation == null || !this.shouldInline);
        }
    }

    public static enum InlinePolicy {
        INLINE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    1.$$$reportNull$$$0(1);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$1";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        OUTSIDE{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    2.$$$reportNull$$$0(1);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$2";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        ,
        PREFERRED{

            @Override
            public boolean shouldInline(@NotNull OCCaretLocation location, @NotNull OCMembersContainer parent) {
                if (location == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (parent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return OCCppDefinitionsUtil.shouldInlineNewDefinitions(parent, location);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "location";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parent";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/generate/OCCppDefinitionsUtil$InlinePolicy$3";
                objectArray[2] = "shouldInline";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };


        public abstract boolean shouldInline(@NotNull OCCaretLocation var1, @NotNull OCMembersContainer var2);

        public static InlinePolicy get(boolean inline) {
            return inline ? INLINE : OUTSIDE;
        }
    }

    public static enum SHOULD_GENERATE_DEFINITION {
        NO,
        POSSIBLE,
        REQUIRED;

    }
}

