/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.generate.FunctionQualifiedNameInfo;
import com.jetbrains.cidr.lang.generate.OCCppGeneratedQualifiedFunctionKt;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a\"\u0010\u0000\u001a\u00020\u00012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u000bH\u0002\u001a&\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0012\u001a\u00020\u00132\u0010\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0018\u001a\u00020\u00132\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u00132\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u0017\u001a>\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\u0010\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00032\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u001f\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006 "}, d2={"fromQualifiers", "Lcom/jetbrains/cidr/lang/generate/FunctionQualifiedNameInfo;", "quals", "", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCSymbolWithQualifiedName;", "context", "Lcom/jetbrains/cidr/lang/symbols/OCResolveContext;", "getQualifiedNameAndTemplateHeader", "function", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCFunctionSymbol;", "psiContext", "Lcom/intellij/psi/PsiElement;", "getScopeSymbol", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCNamespaceSymbol;", "isResolved", "", "target", "scope", "makeTemplateHeader", "", "s", "Lcom/jetbrains/cidr/lang/symbols/cpp/OCTemplateSymbol;", "symbols", "Lcom/jetbrains/cidr/lang/symbols/OCTypeParameterSymbol;", "makeTemplateParameters", "t", "nameOrEmpty", "symbol", "reduceQualifiers", "isFriend", "toParts", "typenameOrType", "intellij.c"})
public final class OCCppGeneratedQualifiedFunctionKt {
    @NotNull
    public static final FunctionQualifiedNameInfo getQualifiedNameAndTemplateHeader(@NotNull OCFunctionSymbol function, @NotNull PsiElement psiContext) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)psiContext, (String)"psiContext");
        OCResolveContext context = OCResolveContext.forPsi(psiContext);
        OCSymbolWithQualifiedName oCSymbolWithQualifiedName = function;
        OCResolveContext oCResolveContext = context;
        Intrinsics.checkExpressionValueIsNotNull((Object)oCResolveContext, (String)"context");
        List<OCSymbolWithQualifiedName<?>> result = OCCppGeneratedQualifiedFunctionKt.reduceQualifiers(OCCppGeneratedQualifiedFunctionKt.toParts(oCSymbolWithQualifiedName, oCResolveContext), OCCppGeneratedQualifiedFunctionKt.getScopeSymbol(psiContext), function.isFriend(), context);
        return OCCppGeneratedQualifiedFunctionKt.fromQualifiers(result, context);
    }

    private static final List<OCSymbolWithQualifiedName<?>> toParts(OCSymbolWithQualifiedName<?> symbol, OCResolveContext context) {
        List res = new ArrayList();
        for (OCSymbolWithQualifiedName cur = symbol; cur != null; cur = cur.getResolvedOwner(context, false)) {
            res.add(cur);
        }
        return CollectionsKt.reversed((Iterable)res);
    }

    private static final OCNamespaceSymbol getScopeSymbol(PsiElement context) {
        PsiElement scopePSI = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{OCStruct.class, OCCppNamespace.class, OCFile.class});
        PsiElement psiElement = scopePSI;
        return psiElement instanceof OCSymbolDeclarator ? (OCNamespaceSymbol)((OCSymbolDeclarator)scopePSI).getSymbol() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<OCSymbolWithQualifiedName<?>> reduceQualifiers(List<? extends OCSymbolWithQualifiedName<?>> target, OCNamespaceSymbol scope, boolean isFriend, OCResolveContext context) {
        int n = target.size() - 1;
        boolean bl = false;
        while (n >= 0) {
            void i;
            if (OCCppGeneratedQualifiedFunctionKt.isResolved(target.get((int)i), scope, context)) {
                return target.subList((int)(isFriend ? i + true : i), target.size());
            }
            --i;
        }
        return target;
    }

    private static final boolean isResolved(OCSymbolWithQualifiedName<?> target, OCNamespaceSymbol scope, OCResolveContext context) {
        List<OCSymbol> symbols;
        OCNamespaceSymbol oCNamespaceSymbol = scope;
        List<OCSymbol> list = symbols = OCSymbolReference.getGlobalReference(OCQualifiedName.with(target.getName()), scope, (VirtualFile)(oCNamespaceSymbol != null ? oCNamespaceSymbol.getContainingFile() : null), -1L).resolveToSymbols(context);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"symbols");
        Collection collection = list;
        return !collection.isEmpty() && target.isSameSymbol((OCSymbol)CollectionsKt.first(symbols), context.getProject());
    }

    private static final FunctionQualifiedNameInfo fromQualifiers(List<? extends OCSymbolWithQualifiedName<?>> quals, OCResolveContext context) {
        StringBuilder qualifiedName = new StringBuilder();
        StringBuilder templateHeader = new StringBuilder();
        for (OCSymbolWithQualifiedName<?> qual : quals) {
            boolean functionItself = qual instanceof OCFunctionSymbol;
            qualifiedName.append(qual.getName());
            if (qual instanceof OCTemplateSymbol) {
                qualifiedName.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateParameters((OCTemplateSymbol)((Object)qual), context));
                templateHeader.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader((OCTemplateSymbol)((Object)qual), context));
            }
            if (functionItself) continue;
            qualifiedName.append("::");
        }
        String string = qualifiedName.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"qualifiedName.toString()");
        String string2 = templateHeader.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"templateHeader.toString()");
        return new FunctionQualifiedNameInfo(string, string2);
    }

    private static final String makeTemplateParameters(OCTemplateSymbol<?> t, OCResolveContext context) {
        List<OCTypeArgument> spec = t.getTemplateSpecialization();
        List<OCTypeParameterSymbol> params = t.getTemplateParameters();
        if (spec != null) {
            return "<" + CollectionsKt.joinToString$default((Iterable)spec, (CharSequence)", ", null, null, (int)0, null, (Function1)((Function1)new Function1<OCTypeArgument, String>(context){
                final /* synthetic */ OCResolveContext $context;

                public final String invoke(OCTypeArgument it) {
                    String string = it.getNameForPresentation(OCType.Presentation.BEST, this.$context, false, 0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.getNameForPresentatio\u2026.BEST, context, false, 0)");
                    return string;
                }
                {
                    this.$context = oCResolveContext;
                    super(1);
                }
            }), (int)30, null) + ">";
        }
        if (!params.isEmpty() && !(t instanceof OCFunctionSymbol)) {
            StringBuilder stringBuilder = new StringBuilder().append("<");
            List<OCTypeParameterSymbol> list = params;
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"params");
            return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, (Function1)makeTemplateParameters.2.INSTANCE, (int)30, null)).append(">").toString();
        }
        return "";
    }

    private static final String makeTemplateHeader(OCTemplateSymbol<?> s, OCResolveContext context) {
        String string;
        if (!(!s.isTemplateSymbol() || s instanceof OCStructSymbol && ((OCStructSymbol)s).getTemplateParameters().isEmpty())) {
            StringBuilder stringBuilder = new StringBuilder();
            List<OCTypeParameterSymbol> list = s.getTemplateParameters();
            Intrinsics.checkExpressionValueIsNotNull(list, (String)"s.templateParameters");
            string = stringBuilder.append(OCCppGeneratedQualifiedFunctionKt.makeTemplateHeader(list, context)).append("\n").toString();
        } else {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String makeTemplateHeader(@NotNull List<? extends OCTypeParameterSymbol<?>> symbols, @NotNull OCResolveContext context) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(symbols, (String)"symbols");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Iterable iterable = symbols;
        StringBuilder stringBuilder = new StringBuilder().append("template<");
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            OCTypeParameterSymbol oCTypeParameterSymbol = (OCTypeParameterSymbol)item$iv$iv;
            collection = destination$iv$iv;
            String string = "" + OCCppGeneratedQualifiedFunctionKt.typenameOrType(it, context) + "" + OCCppGeneratedQualifiedFunctionKt.nameOrEmpty(it);
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return stringBuilder.append(CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(">").toString();
    }

    @NotNull
    public static final String nameOrEmpty(@NotNull OCTypeParameterSymbol<?> symbol) {
        Intrinsics.checkParameterIsNotNull(symbol, (String)"symbol");
        return Intrinsics.areEqual((Object)symbol.getName(), (Object)"<unnamed>") || Intrinsics.areEqual((Object)symbol.getName(), (Object)"") ? "" : ' ' + symbol.getName();
    }

    private static final String typenameOrType(OCTypeParameterSymbol<?> s, OCResolveContext context) {
        String string;
        OCTypeParameterSymbol<?> oCTypeParameterSymbol = s;
        if (oCTypeParameterSymbol instanceof OCTypeParameterTypeSymbol) {
            string = (((OCTypeParameterTypeSymbol)s).isSpelledWithTypenameKeyword() ? "typename" : "class") + (((OCTypeParameterTypeSymbol)s).isVariadic() ? "..." : "");
        } else if (oCTypeParameterSymbol instanceof OCTypeParameterValueSymbol) {
            String string2 = ((OCTypeParameterValueSymbol)s).getType().getBestNameInContext(context);
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"s.type.getBestNameInContext(context)");
        } else {
            OCLog.LOG.error("Template parameter is not a type nor value");
            string = "UNKNOWN";
        }
        return string;
    }
}

