/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCSymbolQuickFix;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCGenerateDefinitionQuickFix
extends OCSymbolQuickFix<OCFunctionSymbol> {
    private final boolean myInline;
    private final String myText;

    public OCGenerateDefinitionQuickFix(@NotNull OCFunctionSymbol symbol, boolean inline, @NotNull OCCompilationContext context) {
        if (symbol == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(0);
        }
        if (context == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(1);
        }
        super(symbol);
        this.myInline = inline;
        this.myText = this.myInline ? OCBundle.message("generate.definitions.quickfix.inlineText", ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context)) : OCBundle.message("generate.definitions.quickfix.outsideText", ((OCFunctionSymbol)this.mySymbol).getNameWithKindLowercase(context));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected String getTextInternal() {
        return this.myText;
    }

    @Override
    protected void invoke(@NotNull Project project2, Editor editor) {
        if (project2 == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(2);
        }
        final PsiFile file = ((OCFunctionSymbol)this.mySymbol).getContainingPsiFile(project2);
        assert (file != null);
        final Ref result = Ref.create();
        Task.Modal task = new Task.Modal(project2, OCBundle.message("generate.definitions.progress.text", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> result.set((Object)OCGenerateDefinitionQuickFix.this.getReplacements(file, (OCFunctionSymbol)OCGenerateDefinitionQuickFix.this.mySymbol)), (ProgressIndicator)indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionQuickFix$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
        if (result.isNull()) {
            throw new ProcessCanceledException();
        }
        List replacements = (List)result.get();
        WriteAction.run(() -> {
            if (FileModificationService.getInstance().preparePsiElementsForWrite(OCGenerateUtil.getAffectedFiles(replacements))) {
                OCGenerateUtil.applyReplacements(file.getProject(), replacements, true);
            }
        });
    }

    @NotNull
    private List<OCGenerateUtil.Replacement> getReplacements(@NotNull PsiFile file, @NotNull OCFunctionSymbol symbol) {
        if (file == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(3);
        }
        if (symbol == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(4);
        }
        if (OCCppDefinitionsUtil.shouldGenerateDefinitionsFor(symbol, true, file.getProject()) != OCCppDefinitionsUtil.SHOULD_GENERATE_DEFINITION.NO) {
            OCCaretLocation location = OCCaretLocation.byFile(file);
            OCMembersContainer container = OCCppDefinitionsUtil.getFunctionParent(symbol, file.getProject());
            List<OCFunctionSymbol> functionSymbols = Collections.singletonList(symbol);
            List<OCFunctionDeclaration> predefPSIs = Collections.singletonList(symbol.locateFunctionDefinition(location.getProject()));
            OCCppDefinitionsUtil.InlinePolicy inlinePolicy = OCCppDefinitionsUtil.InlinePolicy.get(this.myInline);
            List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getGenerateDefinitionReplacements(location, container, functionSymbols, predefPSIs, inlinePolicy);
            if (list == null) {
                OCGenerateDefinitionQuickFix.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<OCGenerateUtil.Replacement> list = Collections.emptyList();
        if (list == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(6);
        }
        return list;
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = OCBundle.message("generate.definitions.intention.familyName", new Object[0]);
        if (string == null) {
            OCGenerateDefinitionQuickFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/actions/OCGenerateDefinitionQuickFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

