/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

public class OCOverrideImplementActionContext
extends OCObjCActionContext<OCMethodSymbol> {
    protected Set<OCMethodSymbol> myAbstractMethods = new HashSet<OCMethodSymbol>();
    protected Set<OCPropertySymbol> myPropertiesWithUnavailableIvars = new HashSet<OCPropertySymbol>();

    public OCOverrideImplementActionContext(OCClassSymbol symbol, OCObjectType objectType, PsiElement context) {
        super(symbol, context, objectType);
    }

    @Override
    public List<? extends OCSymbol> getSymbolsToModify() {
        return Collections.singletonList(this.myImplementationSymbol);
    }

    @Override
    protected Class<OCMethodSymbol> getMemberSymbolClass() {
        return OCMethodSymbol.class;
    }

    public boolean isAbstract(OCMethodSymbol symbol) {
        return this.myAbstractMethods.contains(symbol);
    }

    public boolean evaluateAvailableIvars(PsiFile file, List<OCMethodSymbol> chosenCandidates, String actionTitle) {
        if (OCCompilerFeatures.supportsAutosynthesis(file) && file != null) {
            HashSet getters = new HashSet();
            HashSet setters = new HashSet();
            ArrayList<OCPropertySymbol> badProperties = new ArrayList<OCPropertySymbol>();
            for (OCMethodSymbol candidate : chosenCandidates) {
                OCPropertySymbol property = candidate.getGeneratedFromProperty();
                if (property == null) continue;
                Processor processor2 = symbol -> {
                    OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
                    if (symbol.isGetter(context)) {
                        getters.add(property);
                    } else if (symbol.isSetter(context)) {
                        setters.add(property);
                    }
                    return true;
                };
                property.processAccessorMethods((Processor<? super OCMethodSymbol>)processor2, false, this.getProject());
                processor2.process((Object)candidate);
            }
            for (OCPropertySymbol property : getters) {
                OCInstanceVariableSymbol ivar = property.getAssociatedIvar(this.getProject());
                if (ivar == null || !ivar.isClang4ImplicitIvar(file) || !property.isReadonly() && !setters.contains(property)) continue;
                this.myPropertiesWithUnavailableIvars.add(property);
                if (ReferencesSearch.search((PsiElement)new OCSymbolHolderVirtualPsiElement(ivar, this.getProject())).findFirst() == null) continue;
                badProperties.add(property);
            }
            if (!badProperties.isEmpty()) {
                String message = StringUtil.pluralize((String)"Instance variable", (int)badProperties.size()) + " for " + StringUtil.pluralize((String)"property", (int)badProperties.size()) + " " + StringUtil.join((Collection)ContainerUtil.map(badProperties, symbol -> "'" + symbol.getName() + "'"), (String)", ") + (badProperties.size() > 1 ? " are" : " is") + " used, but will not be available when " + (badProperties.size() > 1 ? "their" : "its") + " accessors are overridden. Do you want to proceed?";
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    throw new CommonRefactoringUtil.RefactoringErrorHintException(message);
                }
                if (Messages.showYesNoDialog((String)message, (String)actionTitle, (Icon)Messages.getQuestionIcon()) != 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isIvarAvailable(OCPropertySymbol property) {
        return !this.myPropertiesWithUnavailableIvars.contains(property);
    }
}

