/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.refactoring.move.OCMemberInfoStorage;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareActionContext
extends OCObjCActionContext<OCMemberSymbol> {
    private final OCClassDeclaration myClassDeclaration;
    protected final OCInterfaceSymbol myPrivateCategory;
    private Target myTarget;

    public OCDeclareActionContext(OCClassSymbol classSymbol, @NotNull OCClassDeclaration classDeclaration, @Nullable OCObjectType type) {
        if (classDeclaration == null) {
            OCDeclareActionContext.$$$reportNull$$$0(0);
        }
        super(classSymbol, classDeclaration, type);
        this.myClassDeclaration = classDeclaration;
        this.myInterfaceSymbol = this.myInterfaceSymbol != null && "".equals(this.myInterfaceSymbol.getCategoryName()) ? this.myInterfaceSymbol.getMainInterface(classDeclaration.getProject()) : this.myInterfaceSymbol;
        this.myPrivateCategory = type != null ? (OCInterfaceSymbol)ContainerUtil.find(type.getCategoryInterfaces(), symbol -> "".equals(symbol.getCategoryName())) : null;
    }

    @Override
    @NotNull
    public Collection<OCMemberSymbol> getMemberCandidates() {
        OCMemberInfoStorage storage = new OCMemberInfoStorage(this.myClassDeclaration);
        List list = ContainerUtil.mapNotNull((Collection)storage.getClassMemberInfos(this.getContext()), info -> info.getSymbol() instanceof OCMemberSymbol ? (OCMemberSymbol)info.getSymbol() : null);
        if (list == null) {
            OCDeclareActionContext.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    public Map<OCSymbol, OCSymbol> createParentsMap(Collection<OCMemberSymbol> members) {
        HashMap<OCSymbol, OCSymbol> map2 = new HashMap<OCSymbol, OCSymbol>();
        for (OCMemberSymbol member : members) {
            if (member instanceof OCMethodSymbol) {
                OCMemberSymbol declaration = member.getAssociatedSymbol(this.getProject());
                map2.put(member, (OCSymbol)(declaration != null && !declaration.isSynthetic() ? declaration.getParent() : member.getParent()));
                continue;
            }
            map2.put(member, (OCSymbol)member.getParent());
        }
        return map2;
    }

    public OCInterfaceSymbol getPrivateCategory() {
        return this.myPrivateCategory;
    }

    public Target getTarget() {
        return this.myTarget;
    }

    public Target[] getAvailableTargets() {
        if (this.myImplementationSymbol.getCategoryName() == null) {
            return new Target[]{Target.INTERFACE, Target.PRIVATE_CATEGORY, Target.IMPLEMENTATION};
        }
        return new Target[]{Target.INTERFACE, Target.IMPLEMENTATION};
    }

    public OCClassSymbol getTargetSymbol() {
        switch (this.myTarget) {
            case INTERFACE: {
                return this.myInterfaceSymbol;
            }
            case PRIVATE_CATEGORY: {
                return this.myPrivateCategory;
            }
            case IMPLEMENTATION: {
                return this.myImplementationSymbol;
            }
        }
        return null;
    }

    public void setTarget(Target target) {
        this.myTarget = target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDeclaration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareActionContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Target {
        INTERFACE("Interface", OCIcons.CodeAssistantClass),
        PRIVATE_CATEGORY("Private Category", OCIcons.CodeAssistantClassExtension),
        IMPLEMENTATION("Implementation (don't declare)", OCIcons.CodeAssistantClass);

        private final String myName;
        private Icon myIcon;

        private Target(String name2, Icon icon) {
            this.myName = name2;
            this.myIcon = icon;
        }

        public String getName() {
            return this.myName;
        }

        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

