/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCCheckboxMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.generate.handlers.OCDeclareActionContext;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.refactoring.util.OCNormalizeUtil;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDeclareMembersHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCMemberSymbol, OCDeclareActionContext> {
    @Override
    protected String getActionTitle() {
        return "Declare Members";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Members to Declare";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCDeclareActionContext context) {
        if (context == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(0);
        }
        return context.getParentNameUppercase() + " has no members to declare";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    @Nullable
    protected OCDeclareActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(1);
        }
        Project project2 = element.getProject();
        OCObjectType type = parent.getResolvedType(OCResolveContext.forPsi(element), true);
        OCClassDeclarationBase definition = (OCClassDeclarationBase)parent.locateDefinition(project2);
        if (!(definition instanceof OCClassDeclaration)) {
            return null;
        }
        OCClassDeclaration classDeclaration = (OCClassDeclaration)definition;
        OCDeclareActionContext actionContext = new OCDeclareActionContext(parent, classDeclaration, type);
        OCDeclareActionContext.Target defaultTarget = parent instanceof OCImplementationSymbol || "".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.INTERFACE : (parent.getCategoryName() != null ? OCDeclareActionContext.Target.IMPLEMENTATION : OCDeclareActionContext.Target.PRIVATE_CATEGORY);
        actionContext.setTarget(defaultTarget);
        return actionContext;
    }

    @Override
    protected OCMemberChooser createMemberChooser(Project project2, List<Pair<OCOption, Object>> options, final OCDeclareActionContext actionContext, List<OCMemberSymbol> candidates) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap((Collection<OCMemberSymbol>)candidates);
        MemberChooserHeaderPanel panel = new MemberChooserHeaderPanel(actionContext.getAvailableTargets(), actionContext.getTarget());
        OCCheckboxMemberChooser chooser = new OCCheckboxMemberChooser(new OCMemberChooserObject[0], options, project2, this.allowEmptySelection(actionContext), this.allowMultiSelection(actionContext), panel){

            @Override
            protected boolean isMemberEnabled(OCMemberChooserObject member) {
                OCDeclareActionContext.Target target = actionContext.getTarget();
                OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
                OCSymbol symbol = member.getSymbol();
                if (targetSymbol != null && (targetSymbol.equals(symbol) || targetSymbol.equals(parentsMap.get(symbol)))) {
                    return false;
                }
                if (target == OCDeclareActionContext.Target.IMPLEMENTATION && symbol instanceof OCPropertySymbol) {
                    return false;
                }
                return target != OCDeclareActionContext.Target.PRIVATE_CATEGORY || !(symbol instanceof OCInstanceVariableSymbol) || OCCompilerFeatures.supportsIvarsInCategories();
            }
        };
        panel.addTargetChangeListener((Processor<OCDeclareActionContext.Target>)((Processor)target -> {
            actionContext.setTarget((OCDeclareActionContext.Target)((Object)target));
            chooser.refreshChosenMembers();
            chooser.repaint();
            return true;
        }));
        chooser.refreshChosenMembers();
        return chooser;
    }

    @Override
    protected void performAction(final @NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file, final @NotNull OCDeclareActionContext actionContext, @NotNull List<OCMemberSymbol> chosenCandidates) {
        if (project2 == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(2);
        }
        if (file == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(3);
        }
        if (actionContext == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(4);
        }
        if (chosenCandidates == null) {
            OCDeclareMembersHandler.$$$reportNull$$$0(5);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        final ArrayList elementsToDelete = new ArrayList();
        final ArrayList membersToAdd = new ArrayList();
        final OCClassSymbol targetSymbol = actionContext.getTargetSymbol();
        final OCClassDeclaration targetDeclFinal = targetSymbol != null ? (OCClassDeclaration)targetSymbol.locateDefinition(project2) : null;
        OCInterfaceSymbol privateCategory = actionContext.getPrivateCategory();
        HashSet membersOfPrivateCategory = new HashSet();
        if (privateCategory != null) {
            privateCategory.processMembers(OCMemberSymbol.class, symbol -> {
                if (!symbol.isSynthetic()) {
                    membersOfPrivateCategory.add(symbol);
                }
                return true;
            });
        }
        boolean privateCategoryWasEmpty = membersOfPrivateCategory.isEmpty();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (chosenCandidates == null) {
                OCDeclareMembersHandler.$$$reportNull$$$0(6);
            }
            if (project2 == null) {
                OCDeclareMembersHandler.$$$reportNull$$$0(7);
            }
            if (actionContext == null) {
                OCDeclareMembersHandler.$$$reportNull$$$0(8);
            }
            for (OCMemberSymbol member : chosenCandidates) {
                OCMemberSymbol definitionSymbol = (OCMemberSymbol)member.getDefinitionSymbol(project2);
                if (definitionSymbol != null) {
                    member = definitionSymbol;
                }
                Object memberElement = member.locateDefinition(project2);
                OCMemberSymbol declaration = member instanceof OCMethodSymbol ? member.getAssociatedSymbol(project2) : member;
                declaration = declaration != null ? declaration : member;
                OCClassSymbol declarationParent = (OCClassSymbol)declaration.getParent();
                membersOfPrivateCategory.remove(declaration);
                if (declarationParent.equals(targetSymbol)) continue;
                if (member instanceof OCMethodSymbol && declarationParent instanceof OCInterfaceSymbol && ((OCClassSymbol)actionContext.getParent()).getName().equals(declarationParent.getName())) {
                    elementsToDelete.add(declaration.locateDefinition(project2));
                }
                if (targetSymbol != null && member instanceof OCPropertySymbol) {
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    targetSymbol.processMembers(member.getName(), OCPropertySymbol.class, finder);
                    elementsToDelete.add(finder.isFound() ? (Object)((OCPropertySymbol)finder.getFoundValue()).locateDefinition(project2) : null);
                }
                if (!(member instanceof OCInstanceVariableSymbol) && actionContext.getTarget() == OCDeclareActionContext.Target.IMPLEMENTATION) continue;
                PsiElement anchor = targetDeclFinal != null ? targetDeclFinal.getBestMemberPlace(member) : null;
                Object newElement = memberElement;
                if (member instanceof OCMethodSymbol) {
                    String signature = OCCallableUtil.methodSignature((OCMethodSymbol)member, actionContext.getContext(), actionContext.createResolveContext());
                    newElement = OCElementFactory.methodFromSignature(signature, actionContext.getContext(), false, true);
                }
                class AddMember {
                    PsiElement anchor;
                    PsiElement member;
                    OCMemberSymbol symbol;

                    AddMember(PsiElement anchor, PsiElement member, OCMemberSymbol symbol) {
                        this.anchor = anchor;
                        this.member = member;
                        this.symbol = symbol;
                    }
                }
                membersToAdd.add(new AddMember(anchor, (PsiElement)newElement, member));
            }
        });
        if (privateCategory != null && targetSymbol != privateCategory && membersOfPrivateCategory.isEmpty() && !privateCategoryWasEmpty) {
            int code;
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((String)"Do you want to remove empty Private Category?", (String)"Remove Private Category", (Icon)Messages.getQuestionIcon());
            if (code == 2) {
                return;
            }
            if (code == 0) {
                elementsToDelete.add(privateCategory.locateDefinition(project2));
            }
        }
        new WriteCommandAction(project2, this.getActionTitle(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                OCClassDeclarationBase implementation;
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCClassDeclaration targetDecl = targetDeclFinal;
                if (actionContext.getTarget() == OCDeclareActionContext.Target.PRIVATE_CATEGORY && targetSymbol == null && (implementation = (OCClassDeclarationBase)actionContext.getImplementationSymbol().locateDefinition(project2)) != null) {
                    targetDecl = OCElementFactory.interfaceByName(((OCClassSymbol)actionContext.getParent()).getName() + "()", implementation);
                    targetDecl = OCChangeUtil.addBefore(implementation.getParent(), targetDecl, implementation);
                }
                if (targetDecl == null) {
                    return;
                }
                for (AddMember add2 : membersToAdd) {
                    PsiElement newElement;
                    if (add2.symbol instanceof OCMethodSymbol) {
                        newElement = OCChangeUtil.addBefore(targetDecl, add2.member, add2.anchor != null && add2.anchor.isValid() ? add2.anchor : null);
                    } else {
                        OCDeclaration newDeclaration = OCNormalizeUtil.normalizeDeclarator((OCDeclarator)add2.member);
                        if (add2.symbol instanceof OCPropertySymbol) {
                            newDeclaration = newDeclaration.getParent();
                            assert (newDeclaration instanceof OCProperty);
                        }
                        newElement = OCDeclareMembersHandler.this.moveDeclaration(add2.symbol instanceof OCInstanceVariableSymbol ? targetDecl.getInstanceVariablesList() : targetDecl, newDeclaration);
                    }
                    OCImportSymbolFix.fixAllSymbolsRecursively(newElement);
                }
                for (PsiElement element : elementsToDelete) {
                    if (element == null || !element.isValid()) continue;
                    OCChangeUtil.delete(element);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/lang/generate/handlers/OCDeclareMembersHandler$2", "run"));
            }
        }.execute();
    }

    protected PsiElement moveDeclaration(PsiElement parent, PsiElement declaration) {
        PsiElement newDeclaration = OCChangeUtil.add(parent, declaration);
        OCChangeUtil.delete(declaration);
        return newDeclaration;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCMemberSymbol> candidates, OCDeclareActionContext actionContext, int moreNodesLevel) {
        final Map<OCSymbol, OCSymbol> parentsMap = actionContext.createParentsMap(candidates);
        return (OCMemberChooserObject[])ContainerUtil.map2Array(candidates, OCMemberChooserObject.class, symbol -> new OCMemberChooserObject((OCSymbol)symbol, parentsMap, actionContext.getProject(), (OCMemberSymbol)symbol, actionContext){
            final /* synthetic */ OCMemberSymbol val$symbol;
            final /* synthetic */ OCDeclareActionContext val$actionContext;
            {
                this.val$symbol = oCMemberSymbol;
                this.val$actionContext = oCDeclareActionContext;
                super(symbol, parentsMap2, project2);
            }

            @Override
            @Nullable
            public MemberChooserObject getParentNodeDelegate() {
                OCClassSymbol parent = (OCClassSymbol)parentsMap.get(this.val$symbol);
                OCDeclareActionContext.Target target = parent instanceof OCImplementationSymbol ? OCDeclareActionContext.Target.IMPLEMENTATION : ("".equals(parent.getCategoryName()) ? OCDeclareActionContext.Target.PRIVATE_CATEGORY : OCDeclareActionContext.Target.INTERFACE);
                String targetName = target == OCDeclareActionContext.Target.IMPLEMENTATION ? "Implementation (undeclared)" : target.getName();
                return new OCMemberChooserObject((OCSymbol)parent, targetName, parent.getIcon(this.val$actionContext.getProject()), this.val$actionContext.getProject());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCDeclareMembersHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getNoMembersMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateActionContext";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$performAction$2";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MemberChooserHeaderPanel
    extends JPanel {
        private final JComboBox comboBox;

        public MemberChooserHeaderPanel(OCDeclareActionContext.Target[] targets, OCDeclareActionContext.Target defaultTarget) {
            super(new BorderLayout());
            this.comboBox = new JComboBox<OCDeclareActionContext.Target>(targets);
            this.add((Component)this.comboBox, "Center");
            this.comboBox.setRenderer(new ListCellRendererWrapper<OCDeclareActionContext.Target>(){

                public void customize(JList list, OCDeclareActionContext.Target target, int index, boolean selected, boolean hasFocus) {
                    this.setText(target.getName());
                    this.setIcon(target.getIcon());
                }
            });
            this.comboBox.setSelectedItem((Object)defaultTarget);
            JLabel templatesLabel = new JLabel("Declare in: ");
            templatesLabel.setDisplayedMnemonic('T');
            templatesLabel.setLabelFor(this.comboBox);
            this.add((Component)templatesLabel, "West");
        }

        protected void addTargetChangeListener(final Processor<OCDeclareActionContext.Target> listener2) {
            this.comboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    listener2.process((Object)((OCDeclareActionContext.Target)((Object)comboBox.getSelectedItem())));
                }
            });
        }
    }
}

