/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateComparisonOperatorsContext;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateComparisonOperatorsHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateComparisonOperatorsContext> {
    private static final OCBooleanOption ADDITIONAL_EQ_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.eq.option", new Object[0]));
    private static final OCBooleanOption ADDITIONAL_REL_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.additional.rel.option", new Object[0]));
    private static final OCBooleanOption AS_MEMBER_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.as.member.option", new Object[0]));
    private static final OCBooleanOption USE_STD_TIE_OPTION = new OCBooleanOption(OCBundle.message("generate.comparison.operators.use.std.tie", new Object[0]));
    private final EnumSet<Type> myTypes;

    public OCGenerateComparisonOperatorsHandler(@NotNull EnumSet<Type> types) {
        if (types == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(0);
        }
        this.myTypes = types;
    }

    @Override
    @NotNull
    protected Collection<OCFunctionSymbol> checkExistingFunctions(@NotNull Project project2, @NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (project2 == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(1);
        }
        if (location == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(2);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(3);
        }
        ArrayList<String> operators = this.getOperatorsToGenerate(actionContext);
        OCStructType selfType = ((OCStructSymbol)actionContext.getParent()).getType();
        List<Pair<String, OCFunctionSymbol>> existing = OCResolveUtil.findExistingFunctions(project2, operators, ContainerUtil.list((Object[])new OCType[]{selfType, selfType}), (OCSymbol)actionContext.getParent(), OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), actionContext.getProject()));
        actionContext.setExistingOperators(existing.stream().map(p -> (String)p.getFirst()).distinct().collect(Collectors.toList()));
        actionContext.setOperatorsToGenerate(operators);
        Collection collection = existing.stream().map(p -> (OCFunctionSymbol)p.getSecond()).collect(Collectors.toList());
        if (collection == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @Override
    @NotNull
    protected String getSomeDefinedText() {
        String string = OCBundle.message("generate.comparison.operators.usages.some.defined", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getAllDefinedText() {
        String string = OCBundle.message("generate.comparison.operators.usages.all.defined", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getExistingTabName() {
        String string = OCBundle.message("generate.comparison.operators.usages.existing.text", new Object[0]);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private ArrayList<String> getOperatorsToGenerate(@NotNull OCGenerateComparisonOperatorsContext context) {
        if (context == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(8);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            result.add("operator==");
            if (this.getOption(context, ADDITIONAL_EQ_OPTION).booleanValue()) {
                result.add("operator!=");
            }
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            result.add("operator<");
            if (this.getOption(context, ADDITIONAL_REL_OPTION).booleanValue()) {
                result.add("operator>");
                result.add("operator<=");
                result.add("operator>=");
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        List<OCGenerateUtil.Replacement> replacements;
        if (location == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(10);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(11);
        }
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(12);
        }
        List<String> all = actionContext.getOperatorsToGenerate();
        List<String> ops = actionContext.isReplaceExisting() ? all : all.stream().filter(o -> {
            if (actionContext == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(60);
            }
            return !actionContext.getExistingOperators().contains(o);
        }).collect(Collectors.toList());
        List<OCFunctionSymbol> symbols = ops.stream().map(s -> {
            if (location == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(58);
            }
            if (actionContext == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(59);
            }
            return OCGenerateComparisonOperatorsHandler.createBinaryOperatorSymbol(location.getProject(), s, actionContext);
        }).collect(Collectors.toList());
        List<String> bodies = ops.stream().map(s -> {
            if (actionContext == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(56);
            }
            if (fields == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(57);
            }
            return this.getOperatorBody((String)s, actionContext, fields);
        }).collect(Collectors.toList());
        Object element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject());
        if (!(element instanceof OCStruct)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<OCGenerateUtil.Replacement> list = replacements = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, (OCStruct)element, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private String getOperatorBody(@NotNull String operator, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        if (operator == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(15);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(16);
        }
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(17);
        }
        switch (operator) {
            case "operator==": {
                String string = this.getEqOperatorBody(fields, actionContext);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(18);
                }
                return string;
            }
            case "operator!=": {
                String string = String.format("{\n return !(%s == %s);\n}", OCGenerateComparisonOperatorsHandler.getRhsName(), OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext));
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(19);
                }
                return string;
            }
            case "operator<": {
                String string = this.getLessOperatorBody(fields, actionContext);
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(20);
                }
                return string;
            }
            case "operator>": {
                String string = String.format("{\n return %s < %s;\n}", OCGenerateComparisonOperatorsHandler.getRhsName(), OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext));
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(21);
                }
                return string;
            }
            case "operator<=": {
                String string = String.format("{\n return !(%s < %s);\n}", OCGenerateComparisonOperatorsHandler.getRhsName(), OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext));
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(22);
                }
                return string;
            }
            case "operator>=": {
                String string = String.format("{\n return !(%s < %s);\n}", OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext), OCGenerateComparisonOperatorsHandler.getRhsName());
                if (string == null) {
                    OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(23);
                }
                return string;
            }
        }
        throw new IllegalArgumentException(operator + " should be a comparison operator");
    }

    @NotNull
    private static OCFunctionSymbol createBinaryOperatorSymbol(@NotNull Project project2, @NotNull String name2, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (project2 == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(24);
        }
        if (name2 == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(25);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(26);
        }
        boolean isMember = OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext);
        OCCppReferenceType selfCref = OCCppReferenceType.to(((OCStructSymbol)actionContext.getParent()).getType().cloneWithConstModifier(project2));
        OCFakeFunctionSymbolBuilder builder = new OCFakeFunctionSymbolBuilder(name2).setReturnType(OCIntType.BOOL_NATIVE).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setVisibility(OCVisibility.PUBLIC).setIsConst(isMember).setIsFriend(!isMember).setIsOperator(true);
        if (!isMember) {
            builder.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getLhsName());
        }
        builder.addParam(selfCref, OCGenerateComparisonOperatorsHandler.getRhsName());
        OCFunctionSymbol oCFunctionSymbol = builder.get(project2);
        if (oCFunctionSymbol == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(27);
        }
        return oCFunctionSymbol;
    }

    @Contract(pure=true)
    @NotNull
    public static String getRhsName() {
        if ("rhs" == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(28);
        }
        return "rhs";
    }

    @Contract(pure=true)
    @NotNull
    public static String getLhsName() {
        if ("lhs" == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(29);
        }
        return "lhs";
    }

    @NotNull
    public static String getLhsNameOrThis(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(30);
        }
        String string = OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "*this" : OCGenerateComparisonOperatorsHandler.getLhsName();
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(31);
        }
        return string;
    }

    public static boolean shouldBeMember(@NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(32);
        }
        return OCGenerateComparisonOperatorsHandler.getOption(actionContext.getOptionValues(), AS_MEMBER_OPTION);
    }

    private static void fillLeftsAndRights(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext, @NotNull List<String> lefts, @NotNull List<String> rights) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(33);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(34);
        }
        if (lefts == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(35);
        }
        if (rights == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(36);
        }
        OCResolveContext context = OCResolveContext.forSymbol((OCSymbol)actionContext.getParent(), actionContext.getProject());
        ((OCStructSymbol)actionContext.getParent()).processBaseClasses(context, (symbol, visibility) -> {
            if (lefts == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(53);
            }
            if (actionContext == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(54);
            }
            if (rights == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(55);
            }
            String name2 = symbol.getType().getBestNameInContext(context);
            lefts.add(String.format("static_cast<const %s &>(%s)", name2, OCGenerateComparisonOperatorsHandler.getLhsNameOrThis(actionContext)));
            rights.add(String.format("static_cast<const %s &>(%s)", name2, OCGenerateComparisonOperatorsHandler.getRhsName()));
            return true;
        });
        for (OCDeclaratorSymbol field : fields) {
            lefts.add((OCGenerateComparisonOperatorsHandler.shouldBeMember(actionContext) ? "" : OCGenerateComparisonOperatorsHandler.getLhsName() + ".") + field.getName());
            rights.add(OCGenerateComparisonOperatorsHandler.getRhsName() + "." + field.getName());
        }
    }

    @NotNull
    private String getEqOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(37);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(38);
        }
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        String retVal = this.getOption(actionContext, USE_STD_TIE_OPTION) != false && lefts.size() > 1 ? String.format("std::tie(%s) == std::tie(%s)", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", ")) : StringUtil.join((Iterable)ContainerUtil.zip(lefts, rights), pair2 -> (String)pair2.first + " == " + (String)pair2.second, (String)" && \n");
        String string = String.format("{\nreturn %s;\n}", retVal);
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private String getLessOperatorBody(@NotNull List<OCDeclaratorSymbol> fields, @NotNull OCGenerateComparisonOperatorsContext actionContext) {
        if (fields == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(40);
        }
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(41);
        }
        ArrayList<String> lefts = new ArrayList<String>();
        ArrayList<String> rights = new ArrayList<String>();
        OCGenerateComparisonOperatorsHandler.fillLeftsAndRights(fields, actionContext, lefts, rights);
        if (this.getOption(actionContext, USE_STD_TIE_OPTION).booleanValue() && lefts.size() > 1) {
            String string = String.format("{\nreturn std::tie(%s) < std::tie(%s);\n}", StringUtil.join(lefts, (String)", "), StringUtil.join(rights, (String)", "));
            if (string == null) {
                OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(42);
            }
            return string;
        }
        StringBuilder result = new StringBuilder("{\n");
        int idx = 0;
        for (Pair pair2 : ContainerUtil.zip(lefts, rights)) {
            if (idx != lefts.size() - 1) {
                result.append(String.format("if (%s < %s)\nreturn true;\nif (%s < %s)\nreturn false;\n", pair2.first, pair2.second, pair2.second, pair2.first));
            } else {
                result.append(String.format("return %s < %s;\n", pair2.first, pair2.second));
            }
            ++idx;
        }
        result.append("}");
        String string = result.toString();
        if (string == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(43);
        }
        return string;
    }

    @Override
    protected String getActionTitle() {
        if (this.myTypes.equals(EnumSet.of(Type.EQUALITY))) {
            return OCBundle.message("generate.comparison.operators.action.title.eq", new Object[0]);
        }
        if (this.myTypes.equals(EnumSet.of(Type.RELATIONAL))) {
            return OCBundle.message("generate.comparison.operators.action.title.rel", new Object[0]);
        }
        return OCBundle.message("generate.comparison.operators.action.title", new Object[0]);
    }

    @Override
    protected String getMembersChooserTitle() {
        return OCBundle.message("generate.comparison.operators.member.chooser.title", new Object[0]);
    }

    @Override
    @NotNull
    protected OCGenerateComparisonOperatorsContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        if (context == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(44);
        }
        OCGenerateComparisonOperatorsContext oCGenerateComparisonOperatorsContext = new OCGenerateComparisonOperatorsContext(parent, context);
        if (oCGenerateComparisonOperatorsContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(45);
        }
        return oCGenerateComparisonOperatorsContext;
    }

    @Override
    @NotNull
    protected Collection<OCDeclaratorSymbol> getSelectedCandidates(@NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable Editor editor, @NotNull PsiFile file, @NotNull List<OCDeclaratorSymbol> candidates) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(46);
        }
        if (file == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(47);
        }
        if (candidates == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(48);
        }
        List<OCDeclaratorSymbol> list = candidates;
        if (list == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(49);
        }
        return list;
    }

    @Override
    protected void saveOptions(PsiFile file, @NotNull OCCodeStyleSettings settings, Map<OCOption, Object> optionValues) {
        if (settings == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(50);
        }
        if (optionValues.containsKey(AS_MEMBER_OPTION)) {
            settings.GENERATE_OPERATORS_AS_MEMBERS = OCGenerateComparisonOperatorsHandler.getOption(optionValues, AS_MEMBER_OPTION);
        }
        if (optionValues.containsKey(USE_STD_TIE_OPTION)) {
            settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE = OCGenerateComparisonOperatorsHandler.getOption(optionValues, USE_STD_TIE_OPTION);
        }
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateComparisonOperatorsContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(51);
        }
        if (options == null) {
            OCGenerateComparisonOperatorsHandler.$$$reportNull$$$0(52);
        }
        if (this.myTypes.contains((Object)Type.EQUALITY)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_EQ_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_EQ_OPERATORS ? 1 : 0)));
        }
        if (this.myTypes.contains((Object)Type.RELATIONAL)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)ADDITIONAL_REL_OPTION, (Object)(settings == null || settings.GENERATE_ADDITIONAL_REL_OPERATORS ? 1 : 0)));
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)AS_MEMBER_OPTION, (Object)(settings == null || settings.GENERATE_OPERATORS_AS_MEMBERS ? 1 : 0)));
        options.add((Pair<OCOption, Object>)new Pair((Object)USE_STD_TIE_OPTION, (Object)(settings != null && settings.GENERATE_COMPARISON_OPERATORS_USE_STD_TIE ? 1 : 0)));
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 10: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: 
            case 11: 
            case 16: 
            case 26: 
            case 30: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 46: 
            case 51: 
            case 54: 
            case 56: 
            case 59: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateComparisonOperatorsHandler";
                break;
            }
            case 8: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 17: 
            case 33: 
            case 37: 
            case 40: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 35: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lefts";
                break;
            }
            case 36: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rights";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateComparisonOperatorsHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "checkExistingFunctions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSomeDefinedText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDefinedText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExistingTabName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorsToGenerate";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperatorBody";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createBinaryOperatorSymbol";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRhsName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getLhsName";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getLhsNameOrThis";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getEqOperatorBody";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getLessOperatorBody";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateActionContext";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkExistingFunctions";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorsToGenerate";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getOperatorBody";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryOperatorSymbol";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getLhsNameOrThis";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "shouldBeMember";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "fillLeftsAndRights";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getEqOperatorBody";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getLessOperatorBody";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedCandidates";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "saveOptions";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillLeftsAndRights$5";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReplacements$4";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReplacements$3";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getReplacements$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 39: 
            case 42: 
            case 43: 
            case 45: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Type {
        EQUALITY,
        RELATIONAL;

    }
}

