/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.codeInsight.generation.MemberChooserObject;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateConstructorContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateConstructorHandler
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateConstructorContext> {
    @Override
    protected String getActionTitle() {
        return "Generate Constructor";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to be Initialized";
    }

    @Override
    @NotNull
    protected OCGenerateConstructorContext evaluateActionContext(OCStructSymbol parent, @NotNull PsiElement context) {
        if (context == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(0);
        }
        OCGenerateConstructorContext oCGenerateConstructorContext = new OCGenerateConstructorContext(parent, context);
        if (oCGenerateConstructorContext == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(1);
        }
        return oCGenerateConstructorContext;
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(final @NotNull OCCaretLocation location, @NotNull OCGenerateConstructorContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        List<OCFunctionSymbol> chosenCtors;
        if (location == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(2);
        }
        if (actionContext == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(4);
        }
        ArrayList<Collection<OCFunctionSymbol>> baseConstructors = new ArrayList<Collection<OCFunctionSymbol>>();
        OCStructSymbol parent = (OCStructSymbol)actionContext.getParent();
        Object element = parent.locateDefinition(location.getProject());
        if (!(element instanceof OCStructLike)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateConstructorHandler.$$$reportNull$$$0(5);
            }
            return list;
        }
        OCStructLike structLike = (OCStructLike)element;
        final OCResolveContext context = location.createContext();
        if (this.addParametersForBaseClasses()) {
            parent.processBaseClasses(OCResolveContext.forSymbol(parent, location.getProject()), (symbol, visibility) -> {
                if (symbol instanceof OCStructSymbol) {
                    CommonProcessors.CollectProcessor collector = new CommonProcessors.CollectProcessor();
                    ((OCStructSymbol)symbol).processConstructors((Processor<? super OCFunctionSymbol>)collector, context);
                    if (!collector.getResults().isEmpty()) {
                        baseConstructors.add(collector.getResults());
                    }
                }
                return true;
            });
        }
        if ((chosenCtors = OCGenerateConstructorHandler.chooseBaseConstructors(baseConstructors, location.getProject())) == null) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateConstructorHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        ArrayList<OCType> paramTypes = new ArrayList<OCType>();
        HashSet<String> existingNames = new HashSet<String>();
        ArrayList<String> initList = new ArrayList<String>();
        for (OCFunctionSymbol baseConstructor : chosenCtors) {
            OCDeclaratorSymbol param;
            OCType type;
            if (baseConstructor.getType().hasNoParameters()) continue;
            StringBuilder callBase = new StringBuilder(baseConstructor.getName()).append("(");
            boolean first = true;
            Iterator<OCDeclaratorSymbol> iterator = baseConstructor.getParameterSymbols().iterator();
            while (iterator.hasNext() && !((type = (param = iterator.next()).getType()) instanceof OCEllipsisType) && !(type instanceof OCVoidType)) {
                String name2 = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, param.getName(), null, existingNames);
                existingNames.add(name2);
                paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
                paramNames.add(name2);
                if (!first) {
                    callBase.append(",");
                }
                callBase.append(name2);
                first = false;
            }
            callBase.append(")");
            initList.add(callBase.toString());
        }
        for (OCDeclaratorSymbol field : fields) {
            String name3 = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, actionContext.getProject());
            name3 = OCNameSuggester.suggestUniqueName(OCSymbolKind.PARAMETER, name3, null, existingNames);
            existingNames.add(name3);
            OCType type = field.getType();
            paramTypes.add(OCTypeUtils.getExtractExpressionType(type, structLike, type instanceof OCPointerType || type instanceof OCCppReferenceType));
            paramNames.add(name3);
            initList.add(field.getName() + "(" + name3 + ")");
        }
        OCFunctionType funcType = new OCFunctionType(OCVoidType.instance(), paramTypes, paramNames);
        final OCType resolved = funcType.resolve(context);
        CommonProcessors.FindFirstProcessor<OCSymbol> finder = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                OCType type;
                return symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor() && (type = symbol.getResolvedType(context)) instanceof OCFunctionType && new OCTypeEqualityVisitor(type, false, OCResolveContext.forPsi((PsiElement)location.getFile())).isFunctionSignatureEqual(resolved);
            }
        };
        parent.processMembers((String)null, (Processor<OCSymbol>)finder);
        if (finder.isFound()) {
            int code;
            String message = "Constructor " + ((OCFunctionSymbol)finder.getFoundValue()).getSignatureWithoutParamNames() + " is already defined.\nDo you wish to continue?";
            int n = code = ApplicationManager.getApplication().isUnitTestMode() ? 1 : Messages.showYesNoDialog((String)message, (String)this.getActionTitle(), (Icon)Messages.getQuestionIcon());
            if (code != 0) {
                List<OCGenerateUtil.Replacement> list = Collections.emptyList();
                if (list == null) {
                    OCGenerateConstructorHandler.$$$reportNull$$$0(7);
                }
                return list;
            }
        }
        OCFakeFunctionSymbolBuilder builder = new OCFakeFunctionSymbolBuilder(parent.getName()).setIsCtorOrDtor(true).setContainer(parent).setVisibility(OCVisibility.PUBLIC);
        for (OCDeclaratorSymbol param : ContainerUtil.zip(paramTypes, paramNames)) {
            builder.addParam((OCType)((Pair)param).first, (String)((Pair)param).second);
        }
        String body = (initList.isEmpty() ? "" : ":" + StringUtil.join(initList, (String)",")) + "{}";
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, parent, Collections.singletonList(builder.get(location.getProject())), Collections.singletonList(body), this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateConstructorHandler.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateConstructorContext context) {
        return true;
    }

    @Override
    protected boolean allowMultiSelection(OCGenerateConstructorContext context) {
        return ((OCStructSymbol)context.getParent()).getKind() == OCSymbolKind.STRUCT;
    }

    @Nullable
    public static List<OCFunctionSymbol> chooseBaseConstructors(List<Collection<OCFunctionSymbol>> allBaseConstructors, Project project2) {
        ArrayList<OCFunctionSymbol> chosenCtors = new ArrayList<OCFunctionSymbol>();
        for (Collection<OCFunctionSymbol> ctors : allBaseConstructors) {
            if (ctors.size() > 1) {
                OCFunctionSymbol ctr = OCGenerateConstructorHandler.chooseConstructor(ctors, project2);
                if (ctr != null) {
                    chosenCtors.add(ctr);
                    continue;
                }
                return null;
            }
            OCFunctionSymbol ctor = (OCFunctionSymbol)ContainerUtil.getFirstItem(ctors);
            if (ctor == null || ctor.canBeCalledWithoutArguments()) continue;
            chosenCtors.add(ctor);
        }
        return chosenCtors;
    }

    @Nullable
    private static OCFunctionSymbol chooseConstructor(Collection<OCFunctionSymbol> constructors, Project project2) {
        OCMemberChooser chooser = new OCMemberChooser((OCMemberChooserObject[])ContainerUtil.map2Array(constructors, OCMemberChooserObject.class, symbol -> new OCMemberChooserObject((OCSymbol)symbol, null, project2, (OCFunctionSymbol)symbol, project2){
            final /* synthetic */ OCFunctionSymbol val$symbol;
            final /* synthetic */ Project val$project;
            {
                this.val$symbol = oCFunctionSymbol;
                this.val$project = project3;
                super(symbol, parentsMap, project2);
            }

            @Override
            @Nullable
            public MemberChooserObject getParentNodeDelegate() {
                return new OCMemberChooserObject(this.val$symbol.getParent(), null, this.val$project);
            }
        }), false, false, Collections.emptyList(), null, project2);
        chooser.setTitle("Choose Base Class Constructor");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return null;
            }
        } else {
            Disposer.dispose((Disposable)chooser.getDisposable());
        }
        List<OCMemberChooserObject> chosenElements = chooser.getChosenElements();
        assert (chosenElements != null && chosenElements.size() == 1);
        return (OCFunctionSymbol)chosenElements.get(0).getSymbol();
    }

    protected boolean addParametersForBaseClasses() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateConstructorHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateConstructorHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateActionContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

