/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.jetbrains.cidr.lang.generate.OCCaretLocation;
import com.jetbrains.cidr.lang.generate.OCCppDefinitionsUtil;
import com.jetbrains.cidr.lang.generate.OCGenerateUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateGetterSetterContext;
import com.jetbrains.cidr.lang.generate.handlers.OCCCppGenerateHandlerBase;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCFakeFunctionSymbolBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class OCGenerateCppGetterSetterHandlerBase
extends OCCCppGenerateHandlerBase<OCStructSymbol, OCDeclaratorSymbol, OCGenerateGetterSetterContext> {
    @Override
    protected String getMembersChooserTitle() {
        return "Select Fields to " + this.getActionTitle();
    }

    @Override
    protected boolean allowUnions() {
        return true;
    }

    @Override
    @NotNull
    protected List<OCGenerateUtil.Replacement> getReplacements(@NotNull OCCaretLocation location, @NotNull OCGenerateGetterSetterContext actionContext, @NotNull List<OCDeclaratorSymbol> fields) {
        Object element;
        if (location == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(0);
        }
        if (actionContext == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(1);
        }
        if (fields == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(2);
        }
        if (!((element = ((OCStructSymbol)actionContext.getParent()).locateDefinition(location.getProject())) instanceof OCStructLike)) {
            List<OCGenerateUtil.Replacement> list = Collections.emptyList();
            if (list == null) {
                OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(3);
            }
            return list;
        }
        OCStructLike structLike = (OCStructLike)element;
        ArrayList<OCFunctionSymbol> symbols = new ArrayList<OCFunctionSymbol>();
        ArrayList<String> bodies = new ArrayList<String>();
        for (OCDeclaratorSymbol field : fields) {
            String paramName = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, actionContext.getProject());
            boolean disallowConst = field.getType() instanceof OCPointerType && (!(field.getType() instanceof OCArrayType) || field.isFriendOrStatic()) || field.getType() instanceof OCCppReferenceType;
            OCType paramType = OCTypeUtils.getExtractExpressionType(field.getType(), structLike, disallowConst);
            boolean isStatic = field.isStatic();
            if (actionContext.needGetter(field)) {
                symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getCppGetterName(field, actionContext.getProject())).setReturnType(paramType).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).setIsConst(!isStatic).get(structLike.getProject()));
                bodies.add("{\n return " + field.getName() + ";\n}");
            }
            if (!actionContext.needSetter(field)) continue;
            symbols.add(new OCFakeFunctionSymbolBuilder(OCNameSuggester.getCppSetterName(field, actionContext.getProject())).setVisibility(OCVisibility.PUBLIC).setContainer((OCSymbolWithQualifiedName)actionContext.getParent()).setIsStatic(isStatic).addParam(paramType, paramName).get(structLike.getProject()));
            StringBuilder body = new StringBuilder("{\n");
            if (paramName.equals(field.getName())) {
                body.append(((OCStructSymbol)actionContext.getParent()).getName()).append("::");
            }
            body.append(field.getName()).append(" = ").append(paramName).append(";\n}");
            bodies.add(body.toString());
        }
        List<OCGenerateUtil.Replacement> list = OCCppDefinitionsUtil.getNewFunctionsReplacements(location, structLike, actionContext.getParent(), symbols, bodies, this.getInlinePolicy(actionContext));
        if (list == null) {
            OCGenerateCppGetterSetterHandlerBase.$$$reportNull$$$0(4);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateCppGetterSetterHandlerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateCppGetterSetterHandlerBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReplacements";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

