/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateMethodActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCGenerateMethodHandler;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateIsEqualAndHashHandler
extends OCGenerateMethodHandler {
    @Override
    protected String getActionTitle() {
        return "Generate -isEqual: and -hash";
    }

    @Override
    protected String[] getMethodNames() {
        return new String[]{"isEqual:", "hash"};
    }

    @Override
    protected boolean allowEmptySelection(OCGenerateMethodActionContext context) {
        return true;
    }

    @Override
    protected boolean isExistingMethod(String selector) {
        return super.isExistingMethod(selector) || selector.startsWith("isEqualTo");
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCInstanceVariableSymbol> ivars, @NotNull OCGenerateMethodActionContext context) {
        if (element == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(0);
        }
        if (ivars == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(2);
        }
        StringBuilder builder = new StringBuilder();
        OCMethodSymbol isEqualMethod = context.getBaseMethods().get(0);
        OCMethodSymbol hashMethod = context.getBaseMethods().get(1);
        OCObjectType superType = context.getType().getSuperType();
        HashSet<String> superMethodNames = new HashSet<String>();
        if (superType != null) {
            superType.processMembers(OCMethodSymbol.class, symbol -> {
                String name2 = symbol.getName();
                if (name2.endsWith(":")) {
                    superMethodNames.add(name2.substring(0, name2.length() - 1));
                }
                return true;
            });
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(element);
        Collection<String> suggestions = OCNameSuggester.suggestForType((OCType)context.getType(), null, "", resolveContext);
        String customMethodName = "isEqualTo" + StringUtil.capitalize((String)(suggestions.isEmpty() ? "other" : suggestions.iterator().next()));
        customMethodName = OCNameSuggester.suggestUniqueName(null, customMethodName, null, superMethodNames);
        suggestions = OCNameSuggester.suggestForType(OCSymbolKind.PARAMETER, context.getType(), element.getLastChild(), "", resolveContext);
        String paramName = suggestions.isEmpty() ? "other" : suggestions.iterator().next();
        String customSignature = "-(BOOL)" + customMethodName + ":(" + context.getInterfaceSymbol().getName() + "*)" + paramName;
        if (element instanceof OCInterface) {
            builder.append(OCCallableUtil.methodSignature(isEqualMethod, element, resolveContext)).append(";");
            builder.append(customSignature).append(";");
            builder.append(OCCallableUtil.methodSignature(hashMethod, element, resolveContext)).append(";");
        } else {
            String isEqualBody = OCGenerateIsEqualAndHashHandler.getIsEqualBody(ivars, paramName, context, resolveContext);
            builder.append(OCCallableUtil.methodText(isEqualMethod, customMethodName, element));
            builder.append(OCCallableUtil.methodText(customSignature, isEqualBody, element));
            builder.append(OCGenerateIsEqualAndHashHandler.getHashMethod(ivars, element, context));
        }
        String string = builder.toString();
        if (string == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String getIsEqualBody(List<OCInstanceVariableSymbol> ivars, String paramName, OCGenerateMethodActionContext actionContext, @NotNull OCResolveContext context) {
        OCImplementationSymbol classSymbol;
        if (context == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(4);
        }
        StringBuilder body = new StringBuilder();
        body.append("if (self == ").append(paramName).append(")\nreturn YES;\n");
        body.append("if (").append(paramName).append(" == nil)\nreturn NO;\n");
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("isEqual:", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject())) {
            body.append("if (![super isEqual: ").append(paramName).append("])\nreturn NO;\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(context.getProject());
            OCType type = ivar.getType().resolve(context, true);
            if (property != null) {
                OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, "self." + property.getName(), paramName + "." + property.getName(), type, context);
                continue;
            }
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(body, ivar.getName(), paramName + "->" + ivar.getName(), type, context);
        }
        body.append("return YES;");
        return body.toString();
    }

    private static void appendIsEqualMember(StringBuilder builder, String selfName, String otherName, final OCType type, final @NotNull OCResolveContext context) {
        if (context == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(5);
        }
        if (OCGenerateIsEqualAndHashHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
            if (context == null) {
                OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(7);
            }
            OCGenerateIsEqualAndHashHandler.appendIsEqualMember(builder, selfName + "." + field.getName(), otherName + "." + field.getName(), field.getResolvedType(context), context);
            return true;
        }), context)) {
            return;
        }
        builder.append("if (").append(selfName).append("!=").append(otherName);
        if (type.isPointerToObject()) {
            OCObjectType objType = (OCObjectType)type.getTerminalType();
            CommonProcessors.FindFirstProcessor<OCMethodSymbol> finder = new CommonProcessors.FindFirstProcessor<OCMethodSymbol>(){

                protected boolean accept(OCMethodSymbol symbol) {
                    String prefix = "isEqualTo";
                    if (symbol.getName().startsWith(prefix) && symbol.getName().length() > prefix.length() + 2 && symbol.getSelectors().size() == 1) {
                        OCDeclaratorSymbol param = symbol.getSelectors().get(0).getParameter();
                        return param != null && param.getType().resolve(context).isCompatible(type, context);
                    }
                    return false;
                }
            };
            objType.processMembers((String)null, OCMethodSymbol.class, finder);
            OCMethodSymbol customMethod = (OCMethodSymbol)finder.getFoundValue();
            OCDeclaratorSymbol parameter = customMethod != null ? customMethod.getSelectors().get(0).getParameter() : null;
            String methodName = parameter != null && parameter.getResolvedType(context).isCompatible(type, context) ? customMethod.getName() : "isEqual:";
            builder.append("&&![").append(selfName).append(" ").append(methodName).append(otherName).append("]");
        }
        builder.append(")\nreturn NO;\n");
    }

    private static String getHashMethod(List<OCInstanceVariableSymbol> ivars, @NotNull PsiElement context, OCGenerateMethodActionContext actionContext) {
        OCImplementationSymbol classSymbol;
        if (context == null) {
            OCGenerateIsEqualAndHashHandler.$$$reportNull$$$0(6);
        }
        ArrayList<String> strings = new ArrayList<String>();
        OCObjectType superType = actionContext.getType().getSuperType();
        OCImplementationSymbol oCImplementationSymbol = classSymbol = superType != null ? superType.getImplementation() : null;
        if (classSymbol != null && !classSymbol.processMembersInAllCategories("hash", OCMethodSymbol.class, new CommonProcessors.FindFirstProcessor(), true, actionContext.getProject())) {
            strings.add("[super hash];\n");
        }
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCPropertySymbol property = ivar.getAssociatedProperty(actionContext.getProject());
            OCType type = ivar.getType().resolve(context, true);
            OCGenerateIsEqualAndHashHandler.appendHashMember(strings, property != null ? "self." + property.getName() : ivar.getName(), type, context);
        }
        StringBuilder function = new StringBuilder();
        function.append(OCCallableUtil.methodSignature(actionContext.getBaseMethods().get(1), context, actionContext.createResolveContext())).append("{\n");
        if (strings.size() > 1) {
            boolean isFirst = true;
            for (String string : strings) {
                if (isFirst) {
                    function.append("NSUInteger hash = ");
                } else {
                    function.append("hash = hash * 31u + ");
                }
                function.append(string);
                isFirst = false;
            }
            function.append("return hash;\n}\n");
        } else if (strings.size() == 1) {
            function.append("return ").append((String)strings.get(0)).append("}\n");
        } else {
            function.append("return [super hash];}\n");
        }
        return function.toString();
    }

    private static void appendHashMember(List<String> strings, String memberName, OCType type, PsiElement context) {
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        if (type.isPointerToObject()) {
            strings.add("[" + memberName + " hash];\n");
        } else if (type == OCRealType.FLOAT) {
            strings.add("[[NSNumber numberWithFloat:" + memberName + "] hash];\n");
        } else if (type instanceof OCRealType) {
            strings.add("[[NSNumber numberWithDouble:" + memberName + "] hash];\n");
        } else if (type instanceof OCIntType) {
            boolean convertToNSUInteger = strings.isEmpty() && (((OCIntType)type).isSigned() || ((OCIntType)type).getRank(resolveContext) > OCIntType.UINT.getRank(resolveContext));
            strings.add((convertToNSUInteger ? "(NSUInteger)" : "") + memberName + ";\n");
        } else if (type instanceof OCStructType && !type.isScalar()) {
            if (!OCGenerateIsEqualAndHashHandler.processStructFields(type, (Processor<OCDeclaratorSymbol>)((Processor)field -> {
                OCGenerateIsEqualAndHashHandler.appendHashMember(strings, memberName + "." + field.getName(), field.getResolvedType(resolveContext), context);
                return true;
            }), resolveContext)) {
                strings.add("(NSUInteger)" + memberName + ";\n");
            }
        } else {
            strings.add("(NSUInteger)" + memberName + ";\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIsEqualAndHashHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateIsEqualAndHashHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIsEqualBody";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendIsEqualMember";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHashMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendIsEqualMember$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

