/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.generate.OCMemberChooser;
import com.jetbrains.cidr.lang.generate.OCMemberChooserObject;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.inspections.OCNotReleasedIvarInspection;
import com.jetbrains.cidr.lang.intentions.OCMoveToPrivateCategoryIntentionAction;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCConvertMemberRefactoringProcessor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.settings.OCBooleanOption;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCOption;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGeneratePropertiesHandler
extends OCClassActionHandlerBase<OCClassSymbol, OCInstanceVariableSymbol, OCGenerateFromIvarsActionContext> {
    private static final OCBooleanOption SHOW_SYNTHESIZED = new OCBooleanOption("Show ivars with synthesized properties");
    private static final OCBooleanOption CONVERT_USAGES = new OCBooleanOption(UIUtil.removeMnemonic((String)OCBundle.message("refactoring.convertIvarUsagesToProperties", new Object[0])));

    @Override
    protected String getMembersChooserTitle() {
        return "Select Instance Variables to make Properties";
    }

    @Override
    protected String getActionTitle() {
        return "Generate Properties from Instance Variables";
    }

    @Override
    protected String getNoMembersMessage(@NotNull OCGenerateFromIvarsActionContext context) {
        if (context == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(0);
        }
        return context.getParentNameUppercase() + " has no instance variables to generate properties from";
    }

    @Override
    protected Class<? extends OCSymbolDeclarator> getParentClass() {
        return OCClassDeclaration.class;
    }

    @Override
    protected void loadOptions(PsiFile file, Editor editor, @NotNull OCGenerateFromIvarsActionContext actionContext, @Nullable OCCodeStyleSettings settings, @NotNull List<Pair<OCOption, Object>> options) {
        if (actionContext == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(1);
        }
        if (options == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(2);
        }
        options.add((Pair<OCOption, Object>)new Pair((Object)SHOW_SYNTHESIZED, (Object)true));
        if (OCCompilerFeatures.supportsAutosynthesis(file)) {
            options.add((Pair<OCOption, Object>)new Pair((Object)CONVERT_USAGES, (Object)true));
        }
        super.loadOptions(file, editor, actionContext, settings, options);
    }

    @Override
    @NotNull
    protected OCGenerateFromIvarsActionContext evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(3);
        }
        OCGenerateFromIvarsActionContext oCGenerateFromIvarsActionContext = new OCGenerateFromIvarsActionContext(parent, parent.getResolvedType(OCResolveContext.forPsi(element), true), element);
        if (oCGenerateFromIvarsActionContext == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(4);
        }
        return oCGenerateFromIvarsActionContext;
    }

    @Override
    @NotNull
    protected Condition<OCInstanceVariableSymbol> getCandidatesFilter(@NotNull OCGenerateFromIvarsActionContext actionContext) {
        if (actionContext == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(5);
        }
        Condition condition = symbol -> symbol.getGeneratedFromProperty() == null;
        if (condition == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(6);
        }
        return condition;
    }

    @Override
    protected void performAction(@NotNull Project project2, @Nullable Editor editor, @NotNull PsiFile file, @NotNull OCGenerateFromIvarsActionContext context, @NotNull List<OCInstanceVariableSymbol> ivars) {
        if (project2 == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(9);
        }
        if (ivars == null) {
            OCGeneratePropertiesHandler.$$$reportNull$$$0(10);
        }
        this.performAction(file, context, ivars, null, null, false, this.convertUsages(context), false);
    }

    protected boolean convertUsages(OCGenerateFromIvarsActionContext context) {
        Boolean value = this.getOption(context, CONVERT_USAGES);
        return value != null ? value : true;
    }

    protected void performAction(PsiFile file, OCGenerateFromIvarsActionContext context, List<OCInstanceVariableSymbol> ivars, @Nullable String customName, @Nullable OCPropertySymbol.PropertySemantics customSemantics, boolean isReadonly, boolean convertUsages, final boolean putToPrivateCategory) {
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.altInsert");
        OCInterfaceSymbol interfaceSymbol = (OCInterfaceSymbol)context.getInterfaceSymbol();
        HashMap newNames = new HashMap();
        HashMap newDeclarations = new HashMap();
        HashMap existingDeclarations = new HashMap();
        ArrayList synthesizes = new ArrayList();
        boolean replaceAllIvars = this.replaceAllIvars();
        PsiFile psiContext = context.getContext().isValid() ? context.getContext() : file;
        ArrayList nonReleasedIvars = new ArrayList();
        OCNotReleasedIvarInspection.IvarsInfo ivarsInfo = OCNotReleasedIvarInspection.startInspection(file);
        ApplicationManager.getApplication().runWriteAction(() -> OCGeneratePropertiesHandler.lambda$performAction$1(ivars, context, customName, newNames, convertUsages, interfaceSymbol, (PsiElement)psiContext, customSemantics, file, isReadonly, newDeclarations, existingDeclarations, replaceAllIvars, synthesizes, ivarsInfo, nonReleasedIvars));
        OCReleaseVariablesIntentionAction releaseAction = OCCompilerFeatures.isArcDisabled(file) && !nonReleasedIvars.isEmpty() ? new OCReleaseVariablesIntentionAction(nonReleasedIvars, context.getProject()) : null;
        OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol> processor2 = new OCConvertMemberRefactoringProcessor<OCInstanceVariableSymbol>((OCClassSymbol)interfaceSymbol, ivars, newNames, newDeclarations, existingDeclarations, replaceAllIvars ? null : synthesizes, releaseAction, (OCElementType)OCTokenTypes.DOT, this.getActionTitle(), convertUsages, context.getProject()){

            protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @Nullable UsageInfo[] usages) {
                if (conflicts == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    OCGeneratePropertiesHandler.this.passConflictsToTest(new ArrayList<String>(conflicts.values()));
                    this.prepareSuccessful();
                    return true;
                }
                return super.showConflicts(conflicts, usages);
            }

            @Override
            protected void performRefactoring(@NotNull UsageInfo[] usages) {
                OCMoveToPrivateCategoryIntentionAction action;
                PsiElement newDeclaration;
                if (usages == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.performRefactoring(usages);
                PsiElement psiElement = newDeclaration = this.myNewDeclarations.isEmpty() ? null : (PsiElement)this.myNewDeclarations.values().iterator().next();
                if (putToPrivateCategory && newDeclaration instanceof OCProperty && (action = new OCMoveToPrivateCategoryIntentionAction(){

                    @Override
                    protected OCMemberSymbol locateCandidate(@NotNull Project project2, Editor editor, PsiFile file) {
                        if (project2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return (OCMemberSymbol)((OCProperty)newDeclaration).getDeclaration().getDeclarators().get(0).getSymbol();
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler$1$1", "locateCandidate"));
                    }
                }).isAvailable(this.myProject, null, newDeclaration.getContainingFile())) {
                    action.invoke(this.myProject, null, newDeclaration.getContainingFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "conflicts";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "usages";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "showConflicts";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "performRefactoring";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        processor2.run();
    }

    protected void passConflictsToTest(List<String> conflicts) {
    }

    protected boolean replaceAllIvars() {
        return false;
    }

    @Override
    protected OCMemberChooserObject[] getChooserNodes(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCGenerateFromIvarsActionContext actionContext, int moreNodesLevel) {
        if (OCGeneratePropertiesHandler.getOption(chooser.getOptionSelections(), SHOW_SYNTHESIZED).booleanValue()) {
            return super.getChooserNodes(chooser, candidates, actionContext, moreNodesLevel);
        }
        HashSet synthesizedIvars = new HashSet();
        actionContext.getType().processMembers(OCSynthesizeSymbol.class, symbol -> {
            if (symbol.isSynthesize()) {
                synthesizedIvars.add(symbol.getIvarName());
            }
            return true;
        });
        if (OCCompilerFeatures.supportsAutosynthesis(actionContext.getContext().getContainingFile())) {
            actionContext.getInterfaceSymbol().processMembersInAllCategories(null, OCPropertySymbol.class, propertySymbol -> {
                OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(actionContext.getProject());
                if (ivar != null) {
                    synthesizedIvars.add(ivar.getName());
                }
                return true;
            }, false, actionContext.getProject());
        }
        return super.getChooserNodes(chooser, ContainerUtil.filter(candidates, ivar -> !synthesizedIvars.contains(ivar.getName())), actionContext, moreNodesLevel);
    }

    @Override
    protected void optionValueChanged(OCMemberChooser chooser, Collection<OCInstanceVariableSymbol> candidates, OCOption option, OCGenerateFromIvarsActionContext actionContext) {
        if (SHOW_SYNTHESIZED.equals(option)) {
            chooser.resetElements(this.getChooserNodes(chooser, candidates, actionContext, 0));
        }
    }

    private static /* synthetic */ void lambda$performAction$1(List ivars, OCGenerateFromIvarsActionContext context, @Nullable String customName, Map newNames, boolean convertUsages, OCInterfaceSymbol interfaceSymbol, PsiElement psiContext, @Nullable OCPropertySymbol.PropertySemantics customSemantics, PsiFile file, boolean isReadonly, Map newDeclarations, Map existingDeclarations, boolean replaceAllIvars, List synthesizes, OCNotReleasedIvarInspection.IvarsInfo ivarsInfo, List nonReleasedIvars) {
        for (OCInstanceVariableSymbol ivar : ivars) {
            OCType ivarType;
            OCPropertySymbol associatedProperty = ivar.getAssociatedProperty(context.getProject());
            String propName = customName != null ? customName : (associatedProperty != null ? associatedProperty.getName() : OCNameSuggester.getNonCollidingName(ivar, true, context.getProject()));
            newNames.put(ivar, convertUsages ? propName : OCNameSuggester.getClang4ImplicitIvarName(propName));
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            if (interfaceSymbol != null) {
                interfaceSymbol.processMembers(propName, OCPropertySymbol.class, finder);
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(psiContext);
            if (!finder.isFound()) {
                OCPropertySymbol.PropertySemantics semantics = null;
                OCType type = ivar.getResolvedType(resolveContext);
                if (customSemantics != null) {
                    semantics = customSemantics;
                } else if (OCCompilerFeatures.isArcEnabled(file) && type.isPointerToObjectCompatible()) {
                    semantics = ivar.getARCAttribute(psiContext, context.getProject()).getPropertyCompatibleSemantics(type, psiContext);
                }
                OCProperty property = OCElementFactory.propertyDeclaration(propName, type, psiContext, semantics, isReadonly);
                newDeclarations.put(ivar, property);
            } else {
                existingDeclarations.put(ivar, finder.getFoundValue());
            }
            if (!(replaceAllIvars || OCCompilerFeatures.supportsAutosynthesis(file) && OCNameSuggester.getClang4ImplicitIvarName(propName).equals(ivar.getName()))) {
                OCSynthesizePropertiesList synthesize = OCElementFactory.synthesizeList("@synthesize", propName, propName.equals(ivar.getName()) ? null : ivar.getName(), psiContext);
                synthesizes.add(synthesize);
            }
            if (!(ivarType = ivar.getResolvedType(resolveContext)).isPointerToObjectCompatible() || ivarsInfo == null || OCNotReleasedIvarInspection.isIvarReleased(ivar, file, ivarsInfo)) continue;
            nonReleasedIvars.add(ivar);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGeneratePropertiesHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateActionContext";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCandidatesFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNoMembersMessage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCandidatesFilter";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

