/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.handlers;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.generate.actions.OCObjCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCObjCClassTextActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.util.OCDeclarationKind;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGenerateSharedInstanceHandler
extends OCObjCClassTextActionHandlerBase<OCMethodSymbol, OCObjCActionContext<OCMethodSymbol>> {
    private static final String SHARED_INSTANCE_HEADER_TEMPLATE_NAME = "OC Shared Instance Header.h";
    private static final String SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME = "OC Shared Instance Implementation.m";
    private static final String CLASS_TYPE_TEMPLATE_PROPERTY = "CLASS_TYPE";

    @Override
    protected String getActionTitle() {
        return "Generate Shared Instance Method";
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    @NotNull
    protected OCObjCActionContext<OCMethodSymbol> evaluateActionContext(OCClassSymbol parent, @NotNull PsiElement element) {
        if (element == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(0);
        }
        OCObjCActionContext<OCMethodSymbol> oCObjCActionContext = new OCObjCActionContext<OCMethodSymbol>(parent, element, parent.getResolvedType(OCResolveContext.forPsi(element), true)){

            @Override
            protected Class<OCMethodSymbol> getMemberSymbolClass() {
                return OCMethodSymbol.class;
            }
        };
        if (oCObjCActionContext == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(1);
        }
        return oCObjCActionContext;
    }

    @Override
    protected boolean enableChooseDialog(Collection<OCMethodSymbol> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(OCObjCActionContext<OCMethodSymbol> context) {
        return true;
    }

    @Override
    protected int getInsertPosition(PsiElement element, int caretOffset, PsiElement at, List<OCMethodSymbol> members, OCObjCActionContext<OCMethodSymbol> actionContext) {
        if (at == null || caretOffset < ((OCClassDeclaration)element).getMethodsStartOffset(true)) {
            return OCDeclarationKind.StaticMethod.getChildrenEndOffset(element);
        }
        return ((OCClassDeclaration)element).getMethodsInsertPosition(true, at, caretOffset);
    }

    @Override
    @NotNull
    protected String getInsertText(@NotNull PsiElement element, @Nullable PsiElement at, @NotNull List<OCMethodSymbol> members, @NotNull OCObjCActionContext<OCMethodSymbol> context) {
        String templateName;
        if (element == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(2);
        }
        if (members == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(3);
        }
        if (context == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(4);
        }
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)element.getProject());
        if (element instanceof OCInterface) {
            templateName = SHARED_INSTANCE_HEADER_TEMPLATE_NAME;
        } else if (element instanceof OCImplementation) {
            templateName = SHARED_INSTANCE_IMPLEMENTATION_TEMPLATE_NAME;
        } else {
            if ("" == null) {
                OCGenerateSharedInstanceHandler.$$$reportNull$$$0(5);
            }
            return "";
        }
        FileTemplate template = fileTemplateManager.getCodeTemplate(templateName);
        if (template != null) {
            String string;
            Properties properties = new Properties(FileTemplateManager.getInstance((Project)element.getProject()).getDefaultProperties());
            properties.setProperty(CLASS_TYPE_TEMPLATE_PROPERTY, context.getType().getBestNameInContext(element));
            try {
                string = template.getText(properties);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(templateName)), e);
            }
            if (string == null) {
                OCGenerateSharedInstanceHandler.$$$reportNull$$$0(6);
            }
            return string;
        }
        if ("" == null) {
            OCGenerateSharedInstanceHandler.$$$reportNull$$$0(7);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/handlers/OCGenerateSharedInstanceHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateActionContext";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "evaluateActionContext";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInsertText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

