/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.hierarchy.OCClassHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.OCSubTypesHierarchyTreeStructure;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class OCTypeHierarchyTreeStructure
extends OCSubTypesHierarchyTreeStructure {
    public OCTypeHierarchyTreeStructure(Project project2, OCClassDeclaration aClass) {
        super(project2, OCTypeHierarchyTreeStructure.buildHierarchyElement(project2, aClass));
        this.setBaseElement(this.myBaseDescriptor);
    }

    private static HierarchyNodeDescriptor buildHierarchyElement(Project project2, OCClassDeclaration aClass) {
        OCClassHierarchyNodeDescriptor<OCClassDeclaration> descriptor2 = null;
        List<OCClassDeclaration> superClasses = OCTypeHierarchyTreeStructure.createSuperClasses(aClass);
        for (OCClassDeclaration superClass : superClasses) {
            OCClassHierarchyNodeDescriptor<OCClassDeclaration> newDescriptor = new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(project2, (NodeDescriptor)descriptor2, superClass, false);
            if (descriptor2 != null) {
                descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor2 = newDescriptor;
        }
        OCClassHierarchyNodeDescriptor<OCClassDeclaration> newDescriptor = new OCClassHierarchyNodeDescriptor<OCClassDeclaration>(project2, (NodeDescriptor)descriptor2, aClass, true);
        if (descriptor2 != null) {
            descriptor2.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
        }
        return newDescriptor;
    }

    private static List<OCClassDeclaration> createSuperClasses(OCClassDeclaration aClass) {
        OCInterface superType;
        if (!aClass.isValid()) {
            return Collections.emptyList();
        }
        if (aClass instanceof OCProtocol) {
            return Collections.emptyList();
        }
        ArrayList<OCClassDeclaration> answer = new ArrayList<OCClassDeclaration>();
        while (!"NSObject".equals(aClass.getName()) && (superType = aClass.getSuperClass()) != null && !answer.contains(superType)) {
            answer.add(0, superType);
            aClass = superType;
        }
        return answer;
    }
}

