/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hmap;

import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.hmap.MapsCache;
import com.jetbrains.cidr.lang.hmap.OCHeaderMap;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapFileType;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapManager;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapSerializer;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapWatcher;
import com.jetbrains.cidr.lang.hmap.OCHeaderMaps;
import com.jetbrains.cidr.lang.hmap.OCHeaderMapsHelpersKt;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeaderMapRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import gnu.trove.THashSet;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 _2\u00020\u0001:\u0001_B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\"\u001a\u00020#J!\u0010$\u001a\u0004\u0018\u00010%2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150'H\u0007\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u0004\u0018\u00010%2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150'H\u0007\u00a2\u0006\u0002\u0010(J!\u0010*\u001a\u0004\u0018\u00010%2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150'H\u0007\u00a2\u0006\u0002\u0010(J\u0016\u0010+\u001a\u00020%2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0'H\u0002J\u0016\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0014\u00104\u001a\u00020%2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060'J\u001d\u00107\u001a\u00020\u00142\u0006\u00108\u001a\u00020-2\u0006\u0010\"\u001a\u000209H\u0000\u00a2\u0006\u0002\b:J\b\u0010;\u001a\u00020%H\u0017J\b\u0010<\u001a\u00020%H\u0016J\u001a\u0010=\u001a\u00020%2\u0010\u0010&\u001a\f\u0012\b\u0012\u00060\u0014j\u0002`\u00150'H\u0007J \u0010>\u001a\u0004\u0018\u00010-2\u0006\u0010?\u001a\u00020\u001e2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020-0AH\u0007J>\u0010B\u001a\u0002HC\"\u0004\b\u0000\u0010C2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\b0E2\u0018\u0010F\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140'\u0012\u0004\u0012\u0002HC0GH\u0080\b\u00a2\u0006\u0004\bH\u0010IJ9\u0010J\u001a\u0002HK\"\u0004\b\u0000\u0010K2$\u0010L\u001a \u0012\u0016\u0012\u0014\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0013\u0012\u0004\u0012\u0002HK0GH\u0007\u00a2\u0006\u0002\u0010MJ\b\u0010N\u001a\u00020%H\u0007J\b\u0010O\u001a\u00020%H\u0007J.\u0010P\u001a\u00020%*\u00060\u0014j\u0002`\u00152\u0006\u0010Q\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u00062\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0SH\u0002J\u0016\u0010T\u001a\u0004\u0018\u00010\u0006*\u00020\f2\u0006\u0010U\u001a\u00020\bH\u0002JA\u0010V\u001a\u00020%*\u0004\u0018\u00010\u00062\u0014\b\u0002\u0010W\u001a\u000e\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0018\u00010'2\u001a\b\u0004\u0010X\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020%0YH\u0082\bJ\u0010\u0010Z\u001a\u00020\u0016*\u00060\u0014j\u0002`\u0015H\u0002J\u001c\u0010[\u001a\u00020%*\u00020\f2\u0006\u0010U\u001a\u00020\b2\u0006\u0010R\u001a\u00020\u0006H\u0002J!\u0010\\\u001a\u00020%*\u0002092\n\u0010]\u001a\u00060\u0014j\u0002`\u00152\u0006\u0010^\u001a\u00020\u0016H\u0082\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0012\u001a\u0014\u0012\b\u0012\u00060\u0014j\u0002`\u0015\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00138G\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapManager;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/jetbrains/cidr/lang/hmap/MapsCache;", "dataStoreFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getDataStoreFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "fileAttribute", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getFileAttribute", "()Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "filePointerManager", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointerManager;", "kotlin.jvm.PlatformType", "internalCache", "", "Lcom/intellij/openapi/vfs/pointers/VirtualFilePointer;", "Lcom/jetbrains/cidr/lang/hmap/MapsCacheKey;", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMap;", "getInternalCache", "()Ljava/util/Map;", "mapSerializer", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapSerializer;", "watcher", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapWatcher;", "createHeaderMapRoot", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeaderMapRoot;", "searchPath", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "virtualFile", "parent", "Lcom/intellij/openapi/Disposable;", "invalidate", "", "keys", "", "(Ljava/util/Set;)Lkotlin/Unit;", "invalidateAndResolve", "invalidateAndResolveExisting", "invalidateAndWait", "dirtyIncludes", "", "isSupported", "", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "load", "allHeaderRoots", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchRoot;", "newFilePointer", "url", "Lcom/jetbrains/cidr/lang/hmap/MapsCache$Builder;", "newFilePointer$intellij_c", "projectClosed", "projectOpened", "replaceAllAndResolve", "resolveInclude", "root", "include", "", "scopedFilePointers", "R", "files", "Lkotlin/sequences/Sequence;", "block", "Lkotlin/Function1;", "scopedFilePointers$intellij_c", "(Lkotlin/sequences/Sequence;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unsafeDeserialize", "T", "inspect", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unsafeDropCache", "unsafeDropSerializedData", "checkForDirtyIncludes", "oldMaps", "newMaps", "", "deserialize", "projectFile", "invalidateOrCreateCache", "restrictToKeys", "fill", "Lkotlin/Function2;", "readHeaderMap", "serialize", "set", "key", "value", "Companion", "intellij.c"})
public final class OCHeaderMapManager
implements ProjectComponent {
    private MapsCache cache;
    private final OCHeaderMapWatcher watcher;
    private final OCHeaderMapSerializer mapSerializer;
    private final VirtualFilePointerManager filePointerManager;
    private final Project project;
    private static final String ID = "clang_header_maps";
    private static final int Version = 0;
    private static final ConcurrentMap<String, FileAttribute> fileAttributeCache;
    private static boolean watcherDisabled;
    private static boolean skipInvalidation;
    public static final Companion Companion;

    public void projectOpened() {
        block0: {
            OCHeaderMapWatcher oCHeaderMapWatcher = this.watcher;
            if (oCHeaderMapWatcher == null) break block0;
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)messageBusConnection, (String)"project.messageBus.connect(project)");
            oCHeaderMapWatcher.start(messageBusConnection);
        }
    }

    public synchronized void projectClosed() {
        block1: {
            MapsCache mapsCache = this.cache;
            if (mapsCache != null) {
                MapsCache mapsCache2;
                MapsCache it = mapsCache2 = mapsCache;
                Disposer.dispose((Disposable)it);
            }
            this.cache = null;
            OCHeaderMapWatcher oCHeaderMapWatcher = this.watcher;
            if (oCHeaderMapWatcher == null) break block1;
            oCHeaderMapWatcher.stop();
        }
    }

    public final boolean isSupported(@NotNull OCResolveConfiguration configuration, @NotNull OCLanguageKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)kind, (String)"kind");
        return Intrinsics.areEqual((Object)((Object)configuration.getCompilerSettings().getCompiler(kind)), (Object)((Object)OCCompilerKind.CLANG));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final HeaderMapRoot createHeaderMapRoot(@NotNull HeadersSearchPath searchPath, @Nullable VirtualFile virtualFile, @NotNull Disposable parent) {
        VirtualFilePointer virtualFilePointer;
        Intrinsics.checkParameterIsNotNull((Object)searchPath, (String)"searchPath");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            if (!Companion.isHeaderMap(searchPath)) return null;
            File file = searchPath.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"searchPath.file");
            virtualFilePointer = this.filePointerManager.create(OCHeaderMapsHelpersKt.toVfsUrl(file), parent, (VirtualFilePointerListener)this.watcher);
        } else {
            if (!Companion.isHeaderMap(virtualFile)) return null;
            virtualFilePointer = this.filePointerManager.create(virtualFile, parent, (VirtualFilePointerListener)this.watcher);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"when (virtualFile) {\n   \u2026r) else return null\n    }");
        return new HeaderMapRoot(this.project, virtualFilePointer, searchPath.isUserHeaders());
    }

    /*
     * WARNING - void declaration
     */
    public final void load(@NotNull Set<? extends HeadersSearchRoot> allHeaderRoots) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(allHeaderRoots, (String)"allHeaderRoots");
        Iterable iterable = allHeaderRoots;
        Collection destination$iv = MapsCache.Companion.newKeySet$intellij_c();
        void $receiver$iv$iv = $receiver$iv;
        for (Object element$iv$iv : $receiver$iv$iv) {
            VirtualFilePointer virtualFilePointer;
            Object element$iv = element$iv$iv;
            HeadersSearchRoot it = (HeadersSearchRoot)((Object)element$iv);
            HeadersSearchRoot headersSearchRoot = it;
            if (!(headersSearchRoot instanceof HeaderMapRoot)) {
                headersSearchRoot = null;
            }
            HeaderMapRoot headerMapRoot = (HeaderMapRoot)headersSearchRoot;
            Object object = headerMapRoot != null ? headerMapRoot.getFilePointer() : null;
            if (object == null) continue;
            VirtualFilePointer it$iv = virtualFilePointer = object;
            destination$iv.add(it$iv);
        }
        Set cacheKeys = (Set)destination$iv;
        this.replaceAllAndResolve(cacheKeys);
    }

    @Nullable
    public final synchronized String resolveInclude(@NotNull HeaderMapRoot root, @NotNull List<String> include) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)root), (String)"root");
        Intrinsics.checkParameterIsNotNull(include, (String)"include");
        Map<VirtualFilePointer, OCHeaderMap> map2 = this.cache;
        return map2 != null && (map2 = (OCHeaderMap)map2.get(root.getFilePointer())) != null ? (String)((Object)map2.get(CollectionsKt.joinToString$default((Iterable)include, (CharSequence)String.valueOf('/'), null, null, (int)0, null, null, (int)62, null))) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized Unit invalidate(@NotNull Set<? extends VirtualFilePointer> keys) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        MapsCache mapsCache = this.cache;
        if (mapsCache != null) {
            MapsCache $receiver$iv = mapsCache;
            OCHeaderMapManager this_$iv = this;
            VirtualFile virtualFile = this_$iv.getDataStoreFile();
            if (virtualFile == null) {
            } else {
                MapsCache.Builder newMaps$iv;
                MapsCache mapsCache2;
                VirtualFile projectFile$iv = virtualFile;
                MapsCache mapsCache3 = $receiver$iv;
                if (mapsCache3 == null) {
                    mapsCache3 = mapsCache2 = this_$iv.deserialize(this_$iv.getFileAttribute(), projectFile$iv);
                }
                if (mapsCache3 == null) {
                    mapsCache2 = MapsCache.Companion.empty$intellij_c();
                }
                MapsCache oldMaps$iv = mapsCache2;
                Object this_$iv$iv = MapsCache.Companion;
                Object object = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv$iv);
                MapsCache.Builder builder = newMaps$iv = object;
                MapsCache oldMaps = oldMaps$iv;
                for (VirtualFilePointer key : oldMaps.keySet()) {
                    void newMaps;
                    if (keys.contains(key)) continue;
                    Object v = oldMaps.get(key);
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    this.set((MapsCache.Builder)newMaps, key, (OCHeaderMap)v);
                }
                Object it$iv = this_$iv$iv = (MapsCache)object;
                this_$iv.cache = (MapsCache)it$iv;
                Object newMaps$iv2 = this_$iv$iv;
                try {
                    Set dirtyIncludes$iv = new LinkedHashSet();
                    Iterator<? extends VirtualFilePointer> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        VirtualFilePointer key$iv;
                        VirtualFilePointer virtualFilePointer = key$iv = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                        this_$iv.checkForDirtyIncludes(virtualFilePointer, oldMaps$iv, (MapsCache)newMaps$iv2, dirtyIncludes$iv);
                    }
                    object = dirtyIncludes$iv;
                    if (!object.isEmpty() || oldMaps$iv.isEmpty() && !(object = (Map)newMaps$iv2).isEmpty()) {
                        if (!Companion.getSkipInvalidation()) {
                            this_$iv.invalidateAndWait(dirtyIncludes$iv);
                        }
                        this_$iv.serialize(this_$iv.getFileAttribute(), projectFile$iv, (MapsCache)newMaps$iv2);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)oldMaps$iv);
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized Unit invalidateAndResolve(@NotNull Set<? extends VirtualFilePointer> keys) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        MapsCache mapsCache = this.cache;
        if (mapsCache != null) {
            MapsCache $receiver$iv = mapsCache;
            OCHeaderMapManager this_$iv = this;
            VirtualFile virtualFile = this_$iv.getDataStoreFile();
            if (virtualFile == null) {
            } else {
                MapsCache.Builder newMaps$iv;
                MapsCache mapsCache2;
                VirtualFile projectFile$iv = virtualFile;
                MapsCache mapsCache3 = $receiver$iv;
                if (mapsCache3 == null) {
                    mapsCache3 = mapsCache2 = this_$iv.deserialize(this_$iv.getFileAttribute(), projectFile$iv);
                }
                if (mapsCache3 == null) {
                    mapsCache2 = MapsCache.Companion.empty$intellij_c();
                }
                MapsCache oldMaps$iv = mapsCache2;
                Object this_$iv$iv = MapsCache.Companion;
                Object object = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv$iv);
                MapsCache.Builder builder = newMaps$iv = object;
                MapsCache oldMaps = oldMaps$iv;
                Iterator iterator = ContainerUtil.union(oldMaps.keySet(), keys).iterator();
                while (iterator.hasNext()) {
                    void newMaps;
                    OCHeaderMap oCHeaderMap;
                    VirtualFilePointer key;
                    VirtualFilePointer virtualFilePointer = key = (VirtualFilePointer)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                    if (keys.contains(key)) {
                        oCHeaderMap = this.readHeaderMap(key);
                    } else {
                        Object v = oldMaps.get(key);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        oCHeaderMap = (OCHeaderMap)v;
                    }
                    this.set((MapsCache.Builder)newMaps, virtualFilePointer, oCHeaderMap);
                }
                Object it$iv = this_$iv$iv = (MapsCache)object;
                this_$iv.cache = (MapsCache)it$iv;
                Object newMaps$iv2 = this_$iv$iv;
                try {
                    Set dirtyIncludes$iv = new LinkedHashSet();
                    Iterator<? extends VirtualFilePointer> iterator2 = keys.iterator();
                    while (iterator2.hasNext()) {
                        VirtualFilePointer key$iv;
                        VirtualFilePointer virtualFilePointer = key$iv = iterator2.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                        this_$iv.checkForDirtyIncludes(virtualFilePointer, oldMaps$iv, (MapsCache)newMaps$iv2, dirtyIncludes$iv);
                    }
                    object = dirtyIncludes$iv;
                    if (!object.isEmpty() || oldMaps$iv.isEmpty() && !(object = (Map)newMaps$iv2).isEmpty()) {
                        if (!Companion.getSkipInvalidation()) {
                            this_$iv.invalidateAndWait(dirtyIncludes$iv);
                        }
                        this_$iv.serialize(this_$iv.getFileAttribute(), projectFile$iv, (MapsCache)newMaps$iv2);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)oldMaps$iv);
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final synchronized Unit invalidateAndResolveExisting(@NotNull Set<? extends VirtualFilePointer> keys) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        MapsCache mapsCache = this.cache;
        if (mapsCache != null) {
            MapsCache $receiver$iv = mapsCache;
            OCHeaderMapManager this_$iv = this;
            VirtualFile virtualFile = this_$iv.getDataStoreFile();
            if (virtualFile == null) {
            } else {
                MapsCache.Builder newMaps$iv;
                MapsCache mapsCache2;
                VirtualFile projectFile$iv = virtualFile;
                MapsCache mapsCache3 = $receiver$iv;
                if (mapsCache3 == null) {
                    mapsCache3 = mapsCache2 = this_$iv.deserialize(this_$iv.getFileAttribute(), projectFile$iv);
                }
                if (mapsCache3 == null) {
                    mapsCache2 = MapsCache.Companion.empty$intellij_c();
                }
                MapsCache oldMaps$iv = mapsCache2;
                Object this_$iv$iv = MapsCache.Companion;
                Object object = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv$iv);
                MapsCache.Builder builder = newMaps$iv = object;
                MapsCache oldMaps = oldMaps$iv;
                for (VirtualFilePointer key : oldMaps.keySet()) {
                    void newMaps;
                    OCHeaderMap oCHeaderMap;
                    if (keys.contains(key)) {
                        oCHeaderMap = this.readHeaderMap(key);
                    } else {
                        Object v = oldMaps.get(key);
                        if (v == null) {
                            Intrinsics.throwNpe();
                        }
                        oCHeaderMap = (OCHeaderMap)v;
                    }
                    this.set((MapsCache.Builder)newMaps, key, oCHeaderMap);
                }
                Object it$iv = this_$iv$iv = (MapsCache)object;
                this_$iv.cache = (MapsCache)it$iv;
                Object newMaps$iv2 = this_$iv$iv;
                try {
                    Set dirtyIncludes$iv = new LinkedHashSet();
                    Iterator<? extends VirtualFilePointer> iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        VirtualFilePointer key$iv;
                        VirtualFilePointer virtualFilePointer = key$iv = iterator.next();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                        this_$iv.checkForDirtyIncludes(virtualFilePointer, oldMaps$iv, (MapsCache)newMaps$iv2, dirtyIncludes$iv);
                    }
                    object = dirtyIncludes$iv;
                    if (!object.isEmpty() || oldMaps$iv.isEmpty() && !(object = (Map)newMaps$iv2).isEmpty()) {
                        if (!Companion.getSkipInvalidation()) {
                            this_$iv.invalidateAndWait(dirtyIncludes$iv);
                        }
                        this_$iv.serialize(this_$iv.getFileAttribute(), projectFile$iv, (MapsCache)newMaps$iv2);
                    }
                }
                finally {
                    Disposer.dispose((Disposable)oldMaps$iv);
                }
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final synchronized void replaceAllAndResolve(@NotNull Set<? extends VirtualFilePointer> keys) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        MapsCache $receiver$iv = this.cache;
        OCHeaderMapManager this_$iv = this;
        Set restrictToKeys$iv = null;
        VirtualFile virtualFile = this_$iv.getDataStoreFile();
        if (virtualFile == null) {
        } else {
            MapsCache.Builder newMaps$iv;
            MapsCache mapsCache;
            VirtualFile projectFile$iv = virtualFile;
            MapsCache mapsCache2 = $receiver$iv;
            if (mapsCache2 == null) {
                mapsCache2 = mapsCache = this_$iv.deserialize(this_$iv.getFileAttribute(), projectFile$iv);
            }
            if (mapsCache2 == null) {
                mapsCache = MapsCache.Companion.empty$intellij_c();
            }
            MapsCache oldMaps$iv = mapsCache;
            Object this_$iv$iv = MapsCache.Companion;
            Object object = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv$iv);
            MapsCache.Builder builder = newMaps$iv = object;
            MapsCache $noName_0 = oldMaps$iv;
            for (VirtualFilePointer virtualFilePointer : keys) {
                void newMaps;
                this.set((MapsCache.Builder)newMaps, virtualFilePointer, this.readHeaderMap(virtualFilePointer));
            }
            Object it$iv = this_$iv$iv = (MapsCache)object;
            this_$iv.cache = (MapsCache)it$iv;
            Object newMaps$iv2 = this_$iv$iv;
            try {
                Set dirtyIncludes$iv = new LinkedHashSet();
                Set set = ContainerUtil.union(oldMaps$iv.keySet(), newMaps$iv2.keySet());
                Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.union(oldMaps.keys, newMaps.keys)");
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    VirtualFilePointer key$iv;
                    VirtualFilePointer virtualFilePointer = key$iv = (VirtualFilePointer)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                    this_$iv.checkForDirtyIncludes(virtualFilePointer, oldMaps$iv, (MapsCache)newMaps$iv2, dirtyIncludes$iv);
                }
                object = dirtyIncludes$iv;
                if (!object.isEmpty() || oldMaps$iv.isEmpty() && !(object = (Map)newMaps$iv2).isEmpty()) {
                    if (!Companion.getSkipInvalidation()) {
                        this_$iv.invalidateAndWait(dirtyIncludes$iv);
                    }
                    this_$iv.serialize(this_$iv.getFileAttribute(), projectFile$iv, (MapsCache)newMaps$iv2);
                }
            }
            finally {
                Disposer.dispose((Disposable)oldMaps$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void invalidateOrCreateCache(@Nullable MapsCache $receiver, Set<? extends VirtualFilePointer> restrictToKeys, Function2<? super MapsCache, ? super MapsCache.Builder, Unit> fill) {
        MapsCache mapsCache;
        VirtualFile virtualFile = this.getDataStoreFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile projectFile = virtualFile;
        MapsCache mapsCache2 = $receiver;
        if (mapsCache2 == null) {
            mapsCache2 = mapsCache = this.deserialize(this.getFileAttribute(), projectFile);
        }
        if (mapsCache2 == null) {
            mapsCache = MapsCache.Companion.empty$intellij_c();
        }
        MapsCache oldMaps = mapsCache;
        Object this_$iv = MapsCache.Companion;
        Object object = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv);
        MapsCache.Builder newMaps = object;
        fill.invoke((Object)oldMaps, (Object)newMaps);
        Object it = this_$iv = (MapsCache)object;
        this.cache = (MapsCache)it;
        Object newMaps2 = this_$iv;
        try {
            Set dirtyIncludes = new LinkedHashSet();
            Set set = restrictToKeys;
            if (set == null) {
                Set set2 = ContainerUtil.union(oldMaps.keySet(), newMaps2.keySet());
                set = set2;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"ContainerUtil.union(oldMaps.keys, newMaps.keys)");
            }
            Iterator<? extends VirtualFilePointer> iterator = set.iterator();
            while (iterator.hasNext()) {
                VirtualFilePointer key;
                VirtualFilePointer virtualFilePointer = key = iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                this.checkForDirtyIncludes(virtualFilePointer, oldMaps, (MapsCache)newMaps2, dirtyIncludes);
            }
            object = dirtyIncludes;
            if (!object.isEmpty() || oldMaps.isEmpty() && !(object = (Map)newMaps2).isEmpty()) {
                if (!Companion.getSkipInvalidation()) {
                    this.invalidateAndWait(dirtyIncludes);
                }
                this.serialize(this.getFileAttribute(), projectFile, (MapsCache)newMaps2);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Disposer.dispose((Disposable)oldMaps);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static /* bridge */ /* synthetic */ void invalidateOrCreateCache$default(OCHeaderMapManager this_, MapsCache $receiver, Set restrictToKeys, Function2 fill, int n, Object object) {
        MapsCache mapsCache;
        if ((n & 1) != 0) {
            restrictToKeys = null;
        }
        VirtualFile virtualFile = this_.getDataStoreFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile projectFile = virtualFile;
        MapsCache mapsCache2 = $receiver;
        if (mapsCache2 == null) {
            mapsCache2 = mapsCache = this_.deserialize(this_.getFileAttribute(), projectFile);
        }
        if (mapsCache2 == null) {
            mapsCache = MapsCache.Companion.empty$intellij_c();
        }
        MapsCache oldMaps = mapsCache;
        Object this_$iv = MapsCache.Companion;
        Object object2 = MapsCache.Companion.access$createMapsCache((MapsCache.Companion)this_$iv);
        MapsCache.Builder newMaps = object2;
        fill.invoke((Object)oldMaps, (Object)newMaps);
        Object it = this_$iv = (MapsCache)object2;
        this_.cache = (MapsCache)it;
        Object newMaps2 = this_$iv;
        try {
            Set dirtyIncludes = new LinkedHashSet();
            Set set = restrictToKeys;
            if (set == null) {
                Set set2 = ContainerUtil.union(oldMaps.keySet(), newMaps2.keySet());
                set = set2;
                Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"ContainerUtil.union(oldMaps.keys, newMaps.keys)");
            }
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                VirtualFilePointer key;
                VirtualFilePointer virtualFilePointer = key = (VirtualFilePointer)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"key");
                this_.checkForDirtyIncludes(virtualFilePointer, oldMaps, (MapsCache)newMaps2, dirtyIncludes);
            }
            object2 = dirtyIncludes;
            if (!object2.isEmpty() || oldMaps.isEmpty() && !(object2 = (Map)newMaps2).isEmpty()) {
                if (!Companion.getSkipInvalidation()) {
                    this_.invalidateAndWait(dirtyIncludes);
                }
                this_.serialize(this_.getFileAttribute(), projectFile, (MapsCache)newMaps2);
            }
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Disposer.dispose((Disposable)oldMaps);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final void invalidateAndWait(Set<String> dirtyIncludes) {
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this, dirtyIncludes){
            final /* synthetic */ OCHeaderMapManager this$0;
            final /* synthetic */ Set $dirtyIncludes$inlined;
            {
                this.this$0 = oCHeaderMapManager;
                this.$dirtyIncludes$inlined = set;
            }

            public final T compute() {
                if (!OCHeaderMapManager.access$getProject$p(this.this$0).isDisposed()) {
                    FileSymbolTablesCache.getInstance(OCHeaderMapManager.access$getProject$p(this.this$0)).invalidateDirtyIncludes(this.$dirtyIncludes$inlined, true);
                }
                return (T)Unit.INSTANCE;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkForDirtyIncludes(@NotNull VirtualFilePointer $receiver, MapsCache oldMaps, MapsCache newMaps, Set<String> dirtyIncludes) {
        OCHeaderMap oldMap = (OCHeaderMap)oldMaps.get($receiver);
        OCHeaderMap newMap = (OCHeaderMap)newMaps.get($receiver);
        if (oldMap == null || newMap == null) {
            OCHeaderMap oCHeaderMap = oldMap;
            if (oCHeaderMap == null) {
                oCHeaderMap = newMap;
            }
            if (oCHeaderMap == null) {
                return;
            }
            dirtyIncludes.addAll(oCHeaderMap.keySet());
        } else {
            void $receiver$iv;
            Set set = ContainerUtil.union(oldMap.keySet(), newMap.keySet());
            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"ContainerUtil.union(oldMap.keys, newMap.keys)");
            Iterable iterable = set;
            for (Object element$iv : $receiver$iv) {
                String it = (String)element$iv;
                if (Objects.equals(oldMap.get(it), newMap.get(it))) continue;
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                if (!dirtyIncludes.add(string)) continue;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final OCHeaderMap readHeaderMap(@NotNull VirtualFilePointer $receiver) {
        OCHeaderMap oCHeaderMap;
        Object object = $receiver.getFile();
        if (object != null) {
            VirtualFile virtualFile;
            VirtualFile it;
            VirtualFile virtualFile2 = it = (virtualFile = object);
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"it");
            object = OCHeaderMaps.readFromFile(virtualFile2);
            if (object != null) {
                oCHeaderMap = (OCHeaderMap)object;
                return oCHeaderMap;
            }
        }
        oCHeaderMap = OCHeaderMap.Companion.emptyMap();
        return oCHeaderMap;
    }

    private final VirtualFile getDataStoreFile() {
        VirtualFile virtualFile;
        VirtualFile it;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(ProjectKt.getStateStore((Project)this.project).getProjectBasePath());
        return virtualFile2 != null ? ((it = (virtualFile = virtualFile2)) instanceof VirtualFileWithId ? virtualFile : null) : null;
    }

    private final FileAttribute getFileAttribute() {
        Object v = OCHeaderMapManager.Companion.getFileAttributeCache().computeIfAbsent(this.project.getLocationHash(), fileAttribute.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull(v, (String)"fileAttributeCache.compu\u2026it, Version, false)\n    }");
        return (FileAttribute)v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void serialize(@NotNull FileAttribute $receiver, VirtualFile projectFile, MapsCache newMaps) {
        block7: {
            OCHeaderMapSerializer this_$iv = this.mapSerializer;
            try {
                Closeable closeable;
                DataOutputStream dataOutputStream = $receiver.writeAttribute(projectFile);
                if (dataOutputStream == null) break block7;
                DataOutputStream it$iv = closeable = dataOutputStream;
                closeable = (Closeable)new Output((OutputStream)it$iv);
                Throwable throwable = null;
                try {
                    Output it$iv2 = (Output)closeable;
                    this_$iv.getKryo().writeObjectOrNull(it$iv2, (Object)newMaps, (Serializer)OCHeaderMapSerializer.access$getMapsSerializer$p(this_$iv));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e$iv) {
                this_$iv.getAccess$LOG().error((Throwable)e$iv);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MapsCache deserialize(@NotNull FileAttribute $receiver, VirtualFile projectFile) {
        Closeable closeable;
        OCHeaderMapSerializer this_$iv = this.mapSerializer;
        try {
            MapsCache mapsCache;
            DataInputStream dataInputStream = $receiver.readAttribute(projectFile);
            if (dataInputStream != null) {
                closeable = dataInputStream;
                Object it$iv = closeable;
                closeable = (Closeable)new Input((InputStream)it$iv);
                it$iv = null;
                try {
                    Input it$iv2 = (Input)closeable;
                    Object object = this_$iv.getKryo().readObjectOrNull(it$iv2, Map.class, (Serializer)OCHeaderMapSerializer.access$getMapsSerializer$p(this_$iv));
                    if (!(object instanceof MapsCache)) {
                        object = null;
                    }
                    MapsCache mapsCache2 = (MapsCache)object;
                    mapsCache = mapsCache2;
                }
                catch (Throwable throwable) {
                    it$iv = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)it$iv);
                }
            } else {
                mapsCache = null;
            }
            closeable = mapsCache;
        }
        catch (IOException e$iv) {
            this_$iv.getAccess$LOG().error((Throwable)e$iv);
            closeable = null;
        }
        return closeable;
    }

    @NotNull
    public final VirtualFilePointer newFilePointer$intellij_c(@NotNull String url, @NotNull MapsCache.Builder parent) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        return this.filePointerManager.create(url, (Disposable)parent, (VirtualFilePointerListener)this.watcher);
    }

    private final void set(@NotNull MapsCache.Builder $receiver, VirtualFilePointer key, OCHeaderMap value) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        VirtualFilePointer virtualFilePointer = this.filePointerManager.duplicate(key, (Disposable)$receiver, (VirtualFilePointerListener)this.watcher);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFilePointer, (String)"filePointerManager.duplicate(key, this, watcher)");
        $receiver.put(virtualFilePointer, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final <R> R scopedFilePointers$intellij_c(@NotNull Sequence<? extends VirtualFile> files, @NotNull Function1<? super Set<? extends VirtualFilePointer>, ? extends R> block) {
        Object object;
        Intrinsics.checkParameterIsNotNull(files, (String)"files");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Disposable $receiver$iv = Disposer.newDisposable();
        try {
            THashSet pointers;
            void $receiver$iv2;
            Disposable it = $receiver$iv;
            Sequence<? extends VirtualFile> sequence = files;
            Collection destination$iv = (Collection)ContainerUtil.newTroveSet();
            for (Object item$iv : $receiver$iv2) {
                void file;
                VirtualFile virtualFile = (VirtualFile)item$iv;
                Collection collection = destination$iv;
                VirtualFilePointer virtualFilePointer = this.filePointerManager.create((VirtualFile)file, it, (VirtualFilePointerListener)this.watcher);
                collection.add(virtualFilePointer);
            }
            THashSet tHashSet = pointers = (THashSet)destination$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)tHashSet, (String)"pointers");
            object = block.invoke((Object)tHashSet);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            Disposer.dispose((Disposable)$receiver$iv);
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @Nullable
    public final Map<VirtualFilePointer, OCHeaderMap> getInternalCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T unsafeDeserialize(@NotNull Function1<? super Map<VirtualFilePointer, ? extends OCHeaderMap>, ? extends T> inspect) {
        Intrinsics.checkParameterIsNotNull(inspect, (String)"inspect");
        FileAttribute fileAttribute2 = this.getFileAttribute();
        VirtualFile virtualFile = this.getDataStoreFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        MapsCache deserialized = this.deserialize(fileAttribute2, virtualFile);
        try {
            Object object = inspect.invoke((Object)deserialized);
            return (T)object;
        }
        finally {
            block4: {
                MapsCache mapsCache;
                MapsCache mapsCache2 = deserialized;
                if (mapsCache2 == null) break block4;
                MapsCache it = mapsCache = mapsCache2;
                Disposer.dispose((Disposable)it);
            }
        }
    }

    public final synchronized void unsafeDropCache() {
        MapsCache mapsCache = this.cache;
        if (mapsCache != null) {
            MapsCache mapsCache2;
            MapsCache it = mapsCache2 = mapsCache;
            Disposer.dispose((Disposable)it);
        }
        this.cache = null;
    }

    public final synchronized void unsafeDropSerializedData() {
        FileAttribute fileAttribute2 = this.getFileAttribute();
        VirtualFile virtualFile = this.getDataStoreFile();
        if (virtualFile == null) {
            Intrinsics.throwNpe();
        }
        fileAttribute2.writeAttributeBytes(virtualFile, new byte[0]);
    }

    public OCHeaderMapManager(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.watcher = !Companion.getWatcherDisabled() ? new OCHeaderMapWatcher(this) : null;
        this.mapSerializer = new OCHeaderMapSerializer(this);
        this.filePointerManager = VirtualFilePointerManager.getInstance();
    }

    static {
        Companion = new Companion(null);
        fileAttributeCache = ContainerUtil.newConcurrentMap();
    }

    @Nullable
    public static final /* synthetic */ MapsCache access$getCache$p(OCHeaderMapManager $this) {
        return $this.cache;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(OCHeaderMapManager $this) {
        return $this.project;
    }

    @JvmStatic
    @NotNull
    public static final OCHeaderMapManager getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\n\u0010\u001a\u001a\u00020\u000e*\u00020\u001bJ\n\u0010\u001a\u001a\u00020\u000e*\u00020\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R0\u0010\u0007\u001a\u001e\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \t*\u0004\u0018\u00010\n0\n0\bX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u00020\u000e@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u00020\u000e@\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapManager$Companion;", "", "()V", "ID", "", "Version", "", "fileAttributeCache", "Ljava/util/concurrent/ConcurrentMap;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vfs/newvfs/FileAttribute;", "getFileAttributeCache", "()Ljava/util/concurrent/ConcurrentMap;", "skipInvalidation", "", "getSkipInvalidation", "()Z", "setSkipInvalidation", "(Z)V", "watcherDisabled", "getWatcherDisabled", "setWatcherDisabled", "getInstance", "Lcom/jetbrains/cidr/lang/hmap/OCHeaderMapManager;", "project", "Lcom/intellij/openapi/project/Project;", "isHeaderMap", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/jetbrains/cidr/lang/workspace/headerRoots/HeadersSearchPath;", "intellij.c"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final OCHeaderMapManager getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = project2.getComponent(OCHeaderMapManager.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"project.getComponent(OCH\u2026erMapManager::class.java)");
            return (OCHeaderMapManager)object;
        }

        private final ConcurrentMap<String, FileAttribute> getFileAttributeCache() {
            return fileAttributeCache;
        }

        public final boolean isHeaderMap(@NotNull HeadersSearchPath $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
            File file = $receiver.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"file");
            return fileTypeRegistry.getFileTypeByFileName(file.getName()) == OCHeaderMapFileType.INSTANCE;
        }

        public final boolean isHeaderMap(@NotNull VirtualFile $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getFileType() == OCHeaderMapFileType.INSTANCE;
        }

        public final boolean getWatcherDisabled() {
            return watcherDisabled;
        }

        public final void setWatcherDisabled(boolean bl) {
            watcherDisabled = bl;
        }

        public final boolean getSkipInvalidation() {
            return skipInvalidation;
        }

        public final void setSkipInvalidation(boolean bl) {
            skipInvalidation = bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

