/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends OCInspections.GeneralCpp {
    public static final String INSPECTION_SHORT_NAME = "ClangTidyInspection";
    public static final String DISPLAY_NAME = "Clang-Tidy";
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    @NotNull
    private List<ClangTidyCheckOption> myClangTidyCheckOptions = new ArrayList<ClangTidyCheckOption>();
    private boolean myUseCustomListOfClangTidyChecks = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    @Override
    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @Override
    @NotNull
    public String getShortName() {
        if (INSPECTION_SHORT_NAME == null) {
            ClangTidyInspection.$$$reportNull$$$0(0);
        }
        return INSPECTION_SHORT_NAME;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if (DISPLAY_NAME == null) {
            ClangTidyInspection.$$$reportNull$$$0(1);
        }
        return DISPLAY_NAME;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        builder.addComponent(this.createCheckbox(childPanel));
        int indent = 20;
        ClangTidyInspection.addComponent(this.createChecksField(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsLeft((int)indent));
        ClangTidyInspection.addComponent((Component)new JBLabel("Comma-separated list of enabled and disabled checks. ", UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), childPanel, 0, 1, 1, 0, 0, (Insets)JBUI.insetsLeft((int)indent));
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 1, 1, 0, 0, (Insets)JBUI.emptyInsets());
        ClangTidyInspection.addComponent(this.createOptionsButton(childPanel), childPanel, 0, 2, 2, 1, 1, (Insets)JBUI.insetsLeft((int)indent));
        builder.addComponent((JComponent)childPanel);
        builder.addComponent((JComponent)ClangTidyInspection.createClangTidyExecutableLink(), 10);
        UIUtil.setEnabled((Component)childPanel, (boolean)this.myUseCustomListOfClangTidyChecks, (boolean)true);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(2);
        }
        if (panel == null) {
            ClangTidyInspection.$$$reportNull$$$0(3);
        }
        if (insets == null) {
            ClangTidyInspection.$$$reportNull$$$0(4);
        }
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel("Example");
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        HyperlinkLabel hyperlinkLabel = hint;
        if (hyperlinkLabel == null) {
            ClangTidyInspection.$$$reportNull$$$0(5);
        }
        return hyperlinkLabel;
    }

    @NotNull
    private JComponent createCheckbox(final @NotNull Component childComponent) {
        if (childComponent == null) {
            ClangTidyInspection.$$$reportNull$$$0(6);
        }
        final JBCheckBox checkbox = new JBCheckBox("Use IDE settings (skip existing .clang-tidy files):", this.myUseCustomListOfClangTidyChecks);
        checkbox.getInsets().set(0, 0, 0, 0);
        checkbox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myUseCustomListOfClangTidyChecks = checkbox.isSelected();
                UIUtil.setEnabled((Component)childComponent, (boolean)checkbox.isSelected(), (boolean)true);
            }
        });
        JBCheckBox jBCheckBox = checkbox;
        if (jBCheckBox == null) {
            ClangTidyInspection.$$$reportNull$$$0(7);
        }
        return jBCheckBox;
    }

    @NotNull
    private JComponent createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.setText(this.myClangTidyChecks);
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ClangTidyInspection.this.myClangTidyChecks = checksEditor.getText();
            }
        });
        RawCommandLineEditor rawCommandLineEditor = checksEditor;
        if (rawCommandLineEditor == null) {
            ClangTidyInspection.$$$reportNull$$$0(8);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        if (component == null) {
            ClangTidyInspection.$$$reportNull$$$0(9);
        }
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton("Configure Clang-Tidy Checks Options...");
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List checkOptions = ClangTidyInspection.this.myClangTidyCheckOptions;
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, checkOptions);
                optionsDialog.showAndGet();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(checkOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = checkOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            ClangTidyInspection.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @NotNull
    private static HyperlinkLabel createClangTidyExecutableLink() {
        final HyperlinkLabel hyperlinkLabel = new HyperlinkLabel("Specify Clang-Tidy executable");
        hyperlinkLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                DataContext dataContext = DataManager.getInstance().getDataContext((Component)hyperlinkLabel);
                Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project2 != null) {
                    ShowSettingsUtil.getInstance().showSettingsDialog(project2, ClangTidyConfigurable.class);
                }
            }
        });
        HyperlinkLabel hyperlinkLabel2 = hyperlinkLabel;
        if (hyperlinkLabel2 == null) {
            ClangTidyInspection.$$$reportNull$$$0(11);
        }
        return hyperlinkLabel2;
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            ClangTidyInspection.$$$reportNull$$$0(12);
        }
        if (manager == null) {
            ClangTidyInspection.$$$reportNull$$$0(13);
        }
        ClangTidyAnnotator annotator = new ClangTidyAnnotator();
        return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)isOnTheFly, (ExternalAnnotator)annotator);
    }

    public boolean isUseCustomListOfClangTidyChecks() {
        return this.myUseCustomListOfClangTidyChecks;
    }

    public void setUseCustomListOfClangTidyChecks(boolean useCustomListOfClangTidyChecks) {
        this.myUseCustomListOfClangTidyChecks = useCustomListOfClangTidyChecks;
    }

    @NotNull
    public String getClangTidyChecks() {
        String string = !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(14);
        }
        return string;
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        if (clangTidyChecks == null) {
            ClangTidyInspection.$$$reportNull$$$0(15);
        }
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        String string = StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
        if (string == null) {
            ClangTidyInspection.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public List<ClangTidyCheckOption> getClangTidyCheckOptions() {
        List<ClangTidyCheckOption> list = this.myClangTidyCheckOptions;
        if (list == null) {
            ClangTidyInspection.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void setClangTidyCheckOptions(@NotNull List<ClangTidyCheckOption> clangTidyCheckOptions) {
        if (clangTidyCheckOptions == null) {
            ClangTidyInspection.$$$reportNull$$$0(18);
        }
        this.myClangTidyCheckOptions = clangTidyCheckOptions;
    }

    @NotNull
    public static String getAllEnabledChecks() {
        if ("*" == null) {
            ClangTidyInspection.$$$reportNull$$$0(19);
        }
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        if ("*,-clang-analyzer-*" == null) {
            ClangTidyInspection.$$$reportNull$$$0(20);
        }
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        if ("-*" == null) {
            ClangTidyInspection.$$$reportNull$$$0(21);
        }
        return "-*";
    }

    private static List<String> getDefaultChecksConfiguration() {
        List<String> configuration = Arrays.asList("*", "-android-*", "-bugprone-bool-pointer-implicit-conversion", "-cert-env33-c", "-cert-dcl50-cpp", "-cert-dcl59-cpp", "-cppcoreguidelines-no-malloc", "-cppcoreguidelines-owning-memory", "-cppcoreguidelines-pro-bounds-array-to-pointer-decay", "-cppcoreguidelines-pro-bounds-constant-array-index", "-cppcoreguidelines-pro-bounds-pointer-arithmetic", "-cppcoreguidelines-pro-type-const-cast", "-cppcoreguidelines-pro-type-cstyle-cast", "-cppcoreguidelines-pro-type-reinterpret-cast", "-cppcoreguidelines-pro-type-union-access", "-cppcoreguidelines-pro-type-vararg", "-cppcoreguidelines-special-member-functions", "-fuchsia-*", "-google-*", "google-default-arguments", "google-explicit-constructor", "google-runtime-member-string-references", "google-runtime-operator", "-hicpp-braces-around-statements", "-hicpp-named-parameter", "-hicpp-no-array-decay", "-hicpp-no-assembler", "-hicpp-no-malloc", "-hicpp-function-size", "-hicpp-special-member-functions", "-hicpp-vararg", "-llvm-*", "-objc-*", "-readability-else-after-return", "-readability-implicit-bool-conversion", "-readability-named-parameter", "-readability-simplify-boolean-expr", "-readability-braces-around-statements", "-readability-identifier-naming", "-readability-function-size", "-readability-redundant-member-init", "-misc-bool-pointer-implicit-conversion", "-misc-definitions-in-headers", "-misc-unused-alias-decls", "-misc-unused-parameters", "-misc-unused-using-decls", "-modernize-use-using", "-modernize-use-default-member-init", "-clang-diagnostic-*", "-clang-analyzer-*");
        return ContainerUtil.newUnmodifiableList(configuration);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childComponent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyChecks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangTidyCheckOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/ClangTidyInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksExampleLink";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createCheckbox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createChecksField";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createOptionsButton";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangTidyExecutableLink";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyChecks";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultChecks";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyCheckOptions";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnabledChecks";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEnabledChecksExceptClangAnalyzer";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDisabledChecks";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCheckbox";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createOptionsButton";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyChecks";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setClangTidyCheckOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 15: 
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

