/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCLocalDefinitionsSearcher;
import com.jetbrains.cidr.lang.dfa.OCUnreachableCodeFinder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCContextSensitiveControlFlowBuilder;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCDFAUtils;
import com.jetbrains.cidr.lang.dfa.contextSensitive.OCSourceGliderComponent;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.inspections.OCSimplifyInspection;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.impl.OCLazyBlockStatementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCChangeElementIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.sourceglider.ManagerInstancesProvider;
import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.bdd.BDDMemoryOverflowException;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.ui.DummyThreadCallback;
import com.jetbrains.sourceglider.ui.Task;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDFAInspection
extends OCInspections.DataFlowAnalysis {
    private static final Boolean ENABLE_RML_PROFILING = false;
    private static final Boolean ENABLE_BDD_PROFILING = false;
    private static final Boolean ENABLE_RELATIONS_PROFILING = false;
    public static final int TIME_LIMIT = 5000;
    public static final Key<Long> DFA_TIME_LIMIT = Key.create((String)"DFA_TIME_LIMIT");
    private ProblemsHolder myProblemsHolder;
    private Map<Object, Object> myTestOptions;
    private Set<OCCallable> myCallables = new HashSet<OCCallable>();
    private Ref<Boolean> myActive = Ref.create((Object)false);
    public boolean enableConstantCondition = true;
    public boolean enableIncompatibleCast = true;
    public boolean enableNullDereference = true;
    public boolean enableUnrecognizedSelector = true;
    public boolean enableUnreachableCode = true;
    private static final String INACTIVE = "Inactive";

    public OCDFAInspection() {
    }

    public OCDFAInspection(ProblemsHolder problemsHolder, Map<Object, Object> testOptions) {
        this.myProblemsHolder = problemsHolder;
        this.myTestOptions = testOptions;
    }

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new CheckBox("Constant conditions", (InspectionProfileEntry)this, "enableConstantCondition"));
        panel.add((Component)new CheckBox("Incompatible casts", (InspectionProfileEntry)this, "enableIncompatibleCast"));
        panel.add((Component)new CheckBox("Null dereferences", (InspectionProfileEntry)this, "enableNullDereference"));
        panel.add((Component)new CheckBox("Unrecognized selectors", (InspectionProfileEntry)this, "enableUnrecognizedSelector"));
        panel.add((Component)new CheckBox("Unreachable code", (InspectionProfileEntry)this, "enableUnreachableCode"));
        return panel;
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Context-sensitive analysis" == null) {
            OCDFAInspection.$$$reportNull$$$0(0);
        }
        return "Context-sensitive analysis";
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            OCDFAInspection.$$$reportNull$$$0(1);
        }
        super.inspectionStarted(session, isOnTheFly);
        this.myCallables.clear();
        this.myActive.set((Object)false);
        this.myActive = Ref.create((Object)true);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OCDFAInspection.$$$reportNull$$$0(2);
        }
        OCVisitor oCVisitor = new OCVisitor(){

            @Override
            public void visitBlockStatement(OCBlockStatement stmt) {
                OCCallable callable;
                if (stmt instanceof OCLazyBlockStatementImpl && (callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)stmt, OCCallable.class)) != null) {
                    OCDFAInspection.this.myCallables.add(callable);
                }
            }
        };
        if (oCVisitor == null) {
            OCDFAInspection.$$$reportNull$$$0(3);
        }
        return oCVisitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder problemsHolder) {
        if (session == null) {
            OCDFAInspection.$$$reportNull$$$0(4);
        }
        if (problemsHolder == null) {
            OCDFAInspection.$$$reportNull$$$0(5);
        }
        if (!(session.getFile() instanceof OCFile)) {
            return;
        }
        OCFile file = (OCFile)session.getFile();
        HashMap<Object, Object> options = new HashMap<Object, Object>();
        if (this.myTestOptions != null) {
            options.putAll(this.myTestOptions);
        }
        if (ENABLE_RML_PROFILING.booleanValue()) {
            options.put(ProfileManager.class, true);
        }
        if (this.myProblemsHolder != null) {
            problemsHolder = this.myProblemsHolder;
        }
        Class<OCDFAInspection> clazz = OCDFAInspection.class;
        synchronized (OCDFAInspection.class) {
            try {
                file.pushAnnotationSession(new AnnotationSession((PsiFile)file));
                Ref contextSensitiveResult = Ref.create();
                Ref contextInsensitiveResult = Ref.create();
                Long timeLimit = (Long)file.getUserData(DFA_TIME_LIMIT);
                OCDFAUtils.WorkingTimeMeasurer measurer = new OCDFAUtils.WorkingTimeMeasurer(timeLimit != null ? timeLimit : 5000L);
                try {
                    OCFile root;
                    OCFile oCFile = root = this.myCallables.size() == 1 ? (PsiElement)this.myCallables.iterator().next() : file;
                    if (root.getContainingFile() != session.getFile()) {
                        root = file;
                    }
                    OCDFAInspection.runAnalysisInParallel(root, new HashMap<Object, Object>(options), true, measurer, (Ref<Result>)contextSensitiveResult, this.myActive);
                    OCDFAInspection.runAnalysisInParallel(root, new HashMap<Object, Object>(options), false, measurer, (Ref<Result>)contextInsensitiveResult, this.myActive);
                    try {
                        Class<Result> clazz2 = Result.class;
                        synchronized (Result.class) {
                            while (contextSensitiveResult.isNull() || contextInsensitiveResult.isNull()) {
                                Result.class.wait();
                            }
                            // ** MonitorExit[var11_11] (shouldn't be in output)
                        }
                    }
                    catch (InterruptedException ignored) {
                        Thread.currentThread().interrupt();
                        Disposer.dispose((Disposable)measurer);
                        OCSourceGliderComponent.getInstance().clearVisitorRunners();
                        file.popAnnotationSession();
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                }
                finally {
                    Disposer.dispose((Disposable)measurer);
                }
                {
                    OCContextSensitiveControlFlowBuilder flowBuilder;
                    ManagerInstancesProvider provider2;
                    if (((Result)contextSensitiveResult.get()).isFinishedSuccessfully()) {
                        provider2 = ((Result)contextSensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextSensitiveResult.get()).getFlowBuilder();
                    } else if (((Result)contextInsensitiveResult.get()).isFinishedSuccessfully()) {
                        provider2 = ((Result)contextInsensitiveResult.get()).getProvider();
                        flowBuilder = ((Result)contextInsensitiveResult.get()).getFlowBuilder();
                        this.reportTimeOverWarning(problemsHolder, file, "File is too complex to perform context-sensitive data-flow analysis");
                    } else {
                        this.reportTimeOverWarning(problemsHolder, file, "File is too complex to perform data-flow analysis");
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return;
                    }
                    if (this.enableConstantCondition) {
                        HashSet<PsiElement> elements = new HashSet<PsiElement>();
                        OCDFAInspection.getElements(elements, provider2, file, "AlwaysTrueStatement");
                        OCDFAInspection.getElements(elements, provider2, file, "AlwaysFalseStatement");
                        OCDFAInspection.getElements(elements, provider2, file, "AlwaysTrueWhenReachedStatement");
                        OCDFAInspection.getElements(elements, provider2, file, "AlwaysFalseWhenReachedStatement");
                        Set<PsiElement> parents = OCDFAInspection.getParents(elements);
                        this.registerWarnings(problemsHolder, provider2, file, parents, "AlwaysTrueStatement", "Condition is always true", OCDFAInspection.getSimplifyFixes(file, true));
                        this.registerWarnings(problemsHolder, provider2, file, parents, "AlwaysFalseStatement", "Condition is always false", OCDFAInspection.getSimplifyFixes(file, false));
                        this.registerWarnings(problemsHolder, provider2, file, parents, "AlwaysTrueWhenReachedStatement", "Condition is always true when reached", OCDFAInspection.getSimplifyFixes(file, true));
                        this.registerWarnings(problemsHolder, provider2, file, parents, "AlwaysFalseWhenReachedStatement", "Condition is always false when reached", OCDFAInspection.getSimplifyFixes(file, false));
                    }
                    if (this.enableIncompatibleCast) {
                        this.registerWarnings(problemsHolder, provider2, file, null, "IllegalCastExpression", "Casting to probably incompatible type", null);
                    }
                    if (this.enableNullDereference) {
                        this.registerWarnings(problemsHolder, provider2, file, null, "NullDereference", "Reference may be " + (file.getKind().isObjC() ? "nil" : "null"), OCDFAInspection.getInitializeFix(flowBuilder));
                    }
                    if (this.enableNullDereference) {
                        this.registerWarnings(problemsHolder, provider2, file, null, "NullReceiver", "Receiver is always " + (file.getKind().isObjC() ? "nil" : "null"), OCDFAInspection.getInitializeFix(flowBuilder));
                    }
                    if (this.enableUnrecognizedSelector) {
                        this.registerWarnings(problemsHolder, provider2, file, null, "NoResponder", "Statement may fail with \"unrecognized selector\"", null);
                    }
                    if (this.enableUnreachableCode && file.getProject().getUserData(OCFile.DFA_UNREACHABLE_CODE) != Boolean.FALSE) {
                        this.registerUnreachableWarnings(problemsHolder, provider2, file, flowBuilder, "UnreachableNode", "Unreachable code");
                    }
                    if (ENABLE_BDD_PROFILING.booleanValue()) {
                        provider2.getUIInstancesProvider().getConsoleCommandProcessor().run(8, new String[0], null);
                    }
                    if (ENABLE_RELATIONS_PROFILING.booleanValue()) {
                        provider2.getUIInstancesProvider().getConsoleCommandProcessor().run(9, new String[0], null);
                    }
                }
            }
            finally {
                OCSourceGliderComponent.getInstance().clearVisitorRunners();
                file.popAnnotationSession();
            }
            {
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
            return;
        }
    }

    private static void runAnalysisInParallel(PsiElement root, Map<Object, Object> options, boolean contextSensitive, OCDFAUtils.WorkingTimeMeasurer measurer, Ref<Result> result, Ref<Boolean> isActive) {
        PsiFile file = root.getContainingFile();
        OCSourceGliderComponent sourceGliderComponent = OCSourceGliderComponent.getInstance();
        int index = contextSensitive ? 0 : 1;
        ManagerInstancesProvider provider2 = sourceGliderComponent.getProvider(index);
        final Ref flowBuilder = Ref.create();
        sourceGliderComponent.addVisitorRunner(index, (options1, threadCallback) -> {
            flowBuilder.set((Object)new OCContextSensitiveControlFlowBuilder(provider2.getSymbolTable(), (signature, attributes) -> sourceGliderComponent.getVisitor(index).addTuple(signature, attributes)));
            root.accept((PsiElementVisitor)new OCRecursiveVisitor(){

                @Override
                public void visitCallable(OCCallable callable) {
                    ((OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get())).processCallable(callable, options1, threadCallback);
                }
            });
        });
        provider2.init();
        options.put("CONTEXT_SENSITIVITY", contextSensitive);
        List<Task> plan = provider2.getHypoteticRepository().getRelationBuildPlan("AlwaysTrueStatement", options);
        if (plan != null) {
            for (Task task : plan) {
                if (task.getName().startsWith("Running")) {
                    ProgressIndicator indicator = OCDFAInspection.createIndicator();
                    Runnable runnable2 = () -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
                        boolean success = false;
                        try {
                            success = OCDFAInspection.runTask(file, measurer, contextSensitive, task, isActive);
                            Class<Result> clazz = Result.class;
                        }
                        catch (Throwable throwable) {
                            Class<Result> clazz = Result.class;
                            synchronized (Result.class) {
                                result.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)((Object)((Object)flowBuilder.get()))), success && (Boolean)isActive.get() != false));
                                Result.class.notifyAll();
                                // ** MonitorExit[var12_12] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        synchronized (Result.class) {
                            result.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)((Object)((Object)flowBuilder.get()))), success && (Boolean)isActive.get() != false));
                            Result.class.notifyAll();
                            // ** MonitorExit[var9_9] (shouldn't be in output)
                            return;
                        }
                    }, indicator);
                    if (contextSensitive) {
                        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
                    } else {
                        runnable2.run();
                    }
                    return;
                }
                if (OCDFAInspection.runTask(file, measurer, contextSensitive, task, isActive)) continue;
                result.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
                return;
            }
        }
        result.set((Object)new Result(provider2, (OCContextSensitiveControlFlowBuilder)((Object)flowBuilder.get()), false));
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    private static boolean runTask(PsiFile file, final OCDFAUtils.WorkingTimeMeasurer measurer, final boolean contextSensitive, Task task, final Ref<Boolean> isActive) {
        try {
            task.run(new DummyThreadCallback(){

                @Override
                public boolean checkCancelled() {
                    ProgressManager.checkCanceled();
                    if (!((Boolean)isActive.get()).booleanValue()) {
                        throw new OCDFAUtils.DFAException(OCDFAInspection.INACTIVE);
                    }
                    if (measurer.isTimeOver()) {
                        throw new OCDFAUtils.DFAException("DFA time is over" + (contextSensitive ? " (context-sensitive)" : ""));
                    }
                    return false;
                }
            });
        }
        catch (BDDMemoryOverflowException e) {
            OCLog.LOG.warn(file.getName() + ": " + e.getMessage());
            return false;
        }
        catch (OCDFAUtils.DFAException e) {
            if (e.getMessage().equals(INACTIVE)) {
                return false;
            }
            String message = file.getName() + ": " + e.getMessage();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isInternal()) {
                OCLog.LOG.warn(message);
            } else {
                OCLog.LOG.info(message);
            }
            return false;
        }
        return true;
    }

    private void reportTimeOverWarning(ProblemsHolder problemsHolder, OCFile file, String message) {
        final Ref elementRef = new Ref();
        file.accept(new OCRecursiveVisitor(){

            @Override
            public void visitClassDeclaration(OCClassDeclaration dcl) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)dcl.getNameIdentifier());
                }
            }

            @Override
            public void visitStruct(OCStruct struct) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)struct.getNameIdentifier());
                }
            }

            @Override
            public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
                if (elementRef.isNull()) {
                    elementRef.set((Object)functionDefinition.getNameIdentifier());
                }
            }
        });
        if (!elementRef.isNull()) {
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), (PsiElement)elementRef.get(), message, "CIDR", ProblemHighlightType.WEAK_WARNING, new IntentionAction[0]);
        }
    }

    private void registerWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file, @Nullable Set<PsiElement> excludeElements, String relationName, String message, @Nullable ElementFix fixes) {
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        if (!OCDFAInspection.getElements(elements, provider2, file, relationName)) {
            return;
        }
        if (excludeElements != null) {
            elements.removeAll(excludeElements);
        }
        for (PsiElement element : elements) {
            List<IntentionAction> fixesList = fixes != null ? fixes.getFixes(element) : Collections.emptyList();
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), element, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixesList.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static boolean getElements(Set<PsiElement> elements, ManagerInstancesProvider provider2, PsiFile file, String relationName) {
        if (!provider2.getRelationsRepository().containsRelation(relationName)) {
            return false;
        }
        IRelation relation = provider2.getRelationsRepository().getRelation(relationName);
        for (Attribute[] attributes : relation.getAttributes(provider2.getSymbolTable())) {
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCElement element = OCCodeInsightUtil.findElementAtRange(file, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCElement.class, true);
            if (element == null) continue;
            elements.add(element);
        }
        return true;
    }

    private static Set<PsiElement> getParents(Set<PsiElement> elements) {
        HashSet<PsiElement> parents = new HashSet<PsiElement>();
        for (PsiElement element : elements) {
            for (PsiElement parent = element.getParent(); parent != null; parent = parent.getParent()) {
                parents.add(parent);
            }
        }
        return parents;
    }

    private void registerUnreachableWarnings(ProblemsHolder problemsHolder, ManagerInstancesProvider provider2, PsiFile file, OCContextSensitiveControlFlowBuilder flowBuilder, String relationName, String message) {
        if (!provider2.getRelationsRepository().containsRelation(relationName)) {
            return;
        }
        IRelation relation = provider2.getRelationsRepository().getRelation(relationName);
        ArrayList<OCElementsRange> ranges = new ArrayList<OCElementsRange>();
        for (OCControlFlowGraph graph : flowBuilder.getAllControlFlowGraphs()) {
            OCUnreachableCodeFinder finder = new OCUnreachableCodeFinder(graph);
            finder.process();
            ranges.addAll(finder.getUnreachableRanges(false));
        }
        for (Attribute[] attributes : relation.getAttributes(provider2.getSymbolTable())) {
            OCElementsRange range;
            int endOffset;
            int startOffset = attributes[0].getSrcPos();
            OCCallable callable = OCCodeInsightUtil.findElementAtRange(file, startOffset, endOffset = startOffset + attributes[0].getSrcLength(), OCCallable.class, true);
            if (callable == null || (range = flowBuilder.getRange(callable, Integer.decode(attributes[1].getKey()))) == null) continue;
            ranges.add(range);
        }
        for (OCElementsRange range : OCElementsRange.mergeRanges(ranges)) {
            PsiElement startElement = range.getFirstElement();
            PsiElement endElement = range.getLastElement();
            while (startElement instanceof OCMacroForeignLeafElement) {
                startElement = startElement.getParent();
            }
            while (endElement instanceof OCMacroForeignLeafElement) {
                endElement = endElement.getParent();
            }
            range = new OCElementsRange(startElement, endElement);
            OCElementsRange trimmedRange = range.trim(TokenSet.orSet((TokenSet[])new TokenSet[]{OCElementsRange.NON_IMPORTANT_TOKENS, TokenSet.create((IElementType[])new IElementType[]{OCTokenTypes.SEMICOLON})}));
            if (trimmedRange == null || trimmedRange.isEmpty()) continue;
            this.registerProblem(problemsHolder, null, null, problemsHolder.isOnTheFly(), range, message, "CIDR", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new IntentionAction[0]);
        }
    }

    private static ElementFix getSimplifyFixes(final OCFile file, final boolean constantCondition) {
        return new ElementFix(){

            public List<IntentionAction> getFixes(@NotNull PsiElement element) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                ArrayList<IntentionAction> fixes = new ArrayList<IntentionAction>();
                String constant = OCIntType.getAppropriateBool(file).getValue(constantCondition, OCResolveContext.forPsi(element));
                OCExpression newElement = OCElementFactory.expressionFromText(constant, element, false);
                fixes.add(new OCChangeElementIntentionAction(element, (PsiElement)newElement, "Simplify condition to '" + constant + "'"));
                OCElement parent = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCIfStatement.class, OCLoopStatement.class, OCBinaryExpression.class});
                OCElement simplified = null;
                if (parent instanceof OCStatement) {
                    simplified = OCSimplifyInspection.simplifyStatementWithConstCondition(constantCondition, (OCStatement)parent);
                } else if (parent instanceof OCBinaryExpression) {
                    simplified = OCSimplifyInspection.simplifyLogicExpression(constantCondition, (OCBinaryExpression)parent, element);
                }
                if (simplified != null) {
                    fixes.add(OCSimplifyInspection.getSimplifyFix(parent, simplified));
                }
                return fixes;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/inspections/OCDFAInspection$5", "getFixes"));
            }
        };
    }

    private static ElementFix getInitializeFix(final OCContextSensitiveControlFlowBuilder flowBuilder) {
        return new ElementFix(){

            @Override
            public List<? extends IntentionAction> getFixes(PsiElement element) {
                OCSymbol symbol;
                OCSymbol oCSymbol = symbol = element instanceof OCReferenceElement ? ((OCReferenceElement)element).resolveToSymbol() : null;
                if (symbol != null) {
                    OCControlFlowGraph graph;
                    OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
                    OCControlFlowGraph oCControlFlowGraph = graph = callable != null ? flowBuilder.getControlFlowGraph(callable) : null;
                    if (graph != null) {
                        OCInstruction instruction;
                        OCLocalDefinitionsSearcher defSearcher = new OCLocalDefinitionsSearcher(graph, symbol, element.getParent(), false, true, true);
                        defSearcher.process();
                        Collection<OCInstruction> declarators = defSearcher.getInstructionsOfKind(OCInstruction.InstructionKind.DECLARATOR);
                        if (!declarators.isEmpty() && (instruction = declarators.iterator().next()).getRValue() instanceof OCDeclarator) {
                            return Collections.singletonList(new OCAddInitializerIntentionAction((OCDeclarator)instruction.getRValue(), symbol));
                        }
                    }
                }
                return Collections.emptyList();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCDFAInspection";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemsHolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCDFAInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface ElementFix {
        public List<? extends IntentionAction> getFixes(PsiElement var1);
    }

    private static class Result {
        private ManagerInstancesProvider myProvider;
        private OCContextSensitiveControlFlowBuilder myFlowBuilder;
        private boolean myFinishedSuccessfully;

        public Result(ManagerInstancesProvider myProvider, OCContextSensitiveControlFlowBuilder flowBuilder, boolean finishedSuccessfully) {
            this.myProvider = myProvider;
            this.myFlowBuilder = flowBuilder;
            this.myFinishedSuccessfully = finishedSuccessfully;
        }

        public ManagerInstancesProvider getProvider() {
            return this.myProvider;
        }

        public OCContextSensitiveControlFlowBuilder getFlowBuilder() {
            return this.myFlowBuilder;
        }

        public boolean isFinishedSuccessfully() {
            return this.myFinishedSuccessfully;
        }
    }
}

