/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightVisitorBasedInspection;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.ex.GlobalInspectionContextUtil;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.preprocessor.OCMacroForeignLeafElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCInspection
extends LocalInspectionTool {
    public static final Key<ProblemDescriptionsProcessor> TEST_PROBLEMS_PROCESSOR_KEY = Key.create((String)"TEST_PROBLEMS_PROCESSOR_KEY");

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass().getSuperclass());
        if (string == null) {
            OCInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCCodeInsightUtil.getPrettyNameFromClassName(((Object)((Object)this)).getClass());
        if (string == null) {
            OCInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            OCInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = this instanceof OCInspections.Hidden ? HighlightDisplayLevel.NON_SWITCHABLE_ERROR : super.getDefaultLevel();
        if (highlightDisplayLevel == null) {
            OCInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    protected void registerProblems(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, List<? extends PsiElement> elements, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        for (PsiElement psiElement : elements) {
            if (psiElement.getTextLength() <= 0) continue;
            this.registerProblem(holder, processor2, globalContext, isOnTheFly, psiElement, message, clangID, highlightType, quickFixes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable PsiElement element, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        OCMacroRange range;
        if (element == null) {
            return;
        }
        if (element.getTextLength() == 0) {
            range = OCElementUtil.getRangeInMacroCall(element);
            if (range == null) return;
            OCMacroCall macroCall = range.getMacroCall();
            if (macroCall != element.getPrevSibling()) return;
            element = macroCall;
        }
        range = OCElementUtil.getRangeWithMacros(element);
        this.registerProblem(holder, processor2, globalContext, isOnTheFly, element, null, message, clangID, highlightType, (TextRange)range, quickFixes);
    }

    protected void registerProblem(@Nullable ProblemsHolder holder, @Nullable ProblemDescriptionsProcessor processor2, @Nullable GlobalInspectionContext globalContext, boolean isOnTheFly, @Nullable OCElementsRange elementsRange, String message, @Nullable String clangID, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
        if (elementsRange == null) {
            return;
        }
        TextRange textRange = elementsRange.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        this.registerProblem(holder, processor2, globalContext, isOnTheFly, elementsRange.getFirstElement(), elementsRange.getLastElement(), message, clangID, highlightType, textRange, quickFixes);
    }

    private void registerProblem(ProblemsHolder holder, ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, boolean isOnTheFly, PsiElement startElement, @Nullable PsiElement endElement, String message, String clangID, ProblemHighlightType highlightType, TextRange range, IntentionAction[] quickFixes) {
        while (startElement instanceof OCMacroForeignLeafElement) {
            startElement = startElement.getParent();
        }
        while (endElement instanceof OCMacroForeignLeafElement) {
            endElement = endElement.getParent();
        }
        if (endElement != null && startElement.getTextOffset() >= endElement.getTextRange().getEndOffset()) {
            return;
        }
        OCFile file = (OCFile)startElement.getContainingFile();
        List wrappers = ContainerUtil.mapNotNull((Object[])quickFixes, action -> action instanceof SuppressIntentionAction ? null : new IntentionWrapper(action, (PsiFile)file));
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, ((Object)((Object)this)).getClass(), clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        InspectionManager manager = InspectionManager.getInstance((Project)startElement.getProject());
        ProblemDescriptor problem = endElement == null ? manager.createProblemDescriptor(startElement, message, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]), highlightType, isOnTheFly, false) : manager.createProblemDescriptor(startElement, endElement, message, highlightType, isOnTheFly, (LocalQuickFix[])wrappers.toArray(new IntentionWrapper[0]));
        if (problemGroup != null) {
            problem.setProblemGroup((ProblemGroup)problemGroup);
            for (IntentionAction fix : quickFixes) {
                if (!(fix instanceof SuppressIntentionAction)) continue;
                problemGroup.addSuppressAction((SuppressIntentionAction)fix);
            }
        }
        if (processor2 == null) {
            ProblemDescriptionsProcessor problemDescriptionsProcessor = processor2 = file != null ? (ProblemDescriptionsProcessor)file.getProject().getUserData(TEST_PROBLEMS_PROCESSOR_KEY) : null;
        }
        if (processor2 != null) {
            processor2.addProblemElement((RefEntity)(globalContext != null ? GlobalInspectionContextUtil.retrieveRefElement((PsiElement)startElement, (GlobalInspectionContext)globalContext) : null), new CommonProblemDescriptor[]{problem});
        }
        if (holder != null) {
            holder.registerProblem(problem);
        }
    }

    public String getMainToolId() {
        if (OCInspections.class.equals(((Object)((Object)this)).getClass().getDeclaringClass())) {
            return new DefaultHighlightVisitorBasedInspection.AnnotatorBasedInspection().getShortName();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/lang/inspections/OCInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static abstract class Cpp
    extends OCInspection {
        @NotNull
        public String[] getGroupPath() {
            String[] stringArray = new String[]{"C/C++", this.getGroupDisplayName()};
            if (stringArray == null) {
                Cpp.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCInspection$Cpp", "getGroupPath"));
        }
    }

    public static abstract class ObjC
    extends OCInspection {
        @NotNull
        public String[] getGroupPath() {
            String[] stringArray = new String[]{"Objective-C", this.getGroupDisplayName()};
            if (stringArray == null) {
                ObjC.$$$reportNull$$$0(0);
            }
            return stringArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCInspection$ObjC", "getGroupPath"));
        }
    }
}

