/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCControlFlowUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLoopDoesntUseConditionVariableInspection
extends OCInspections.GeneralCpp {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Loop condition isn't updated inside the loop" == null) {
            OCLoopDoesntUseConditionVariableInspection.$$$reportNull$$$0(0);
        }
        return "Loop condition isn't updated inside the loop";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OCLoopDoesntUseConditionVariableInspection.$$$reportNull$$$0(1);
        }
        ForLoopThatDoesntUseLoopVariableVisitor forLoopThatDoesntUseLoopVariableVisitor = new ForLoopThatDoesntUseLoopVariableVisitor(holder);
        if (forLoopThatDoesntUseLoopVariableVisitor == null) {
            OCLoopDoesntUseConditionVariableInspection.$$$reportNull$$$0(2);
        }
        return forLoopThatDoesntUseLoopVariableVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCLoopDoesntUseConditionVariableInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCLoopDoesntUseConditionVariableInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ForLoopThatDoesntUseLoopVariableVisitor
    extends OCVisitor {
        private final ProblemsHolder myHolder;
        private final HashMap<OCCallable, OCControlFlowGraph> myGraphs;

        public ForLoopThatDoesntUseLoopVariableVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
            this.myGraphs = new HashMap();
        }

        @Override
        public void visitForStatement(@NotNull OCForStatement statement2) {
            if (statement2 == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(0);
            }
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), statement2.getIncrement());
        }

        @Override
        public void visitWhileStatement(OCWhileStatement statement2) {
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), null);
        }

        @Override
        public void visitDoWhileStatement(OCDoWhileStatement statement2) {
            this.processLoop(statement2, statement2.getCondition(), statement2.getBody(), null);
        }

        private void processLoop(@NotNull OCLoopStatement loop, @Nullable OCElement condition, @Nullable OCStatement body, @Nullable OCStatement increment) {
            if (loop == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(1);
            }
            if (condition == null) {
                return;
            }
            Ref declaratorUsed = new Ref((Object)false);
            HashSet<OCSymbolDeclarator> usedSymbols = new HashSet<OCSymbolDeclarator>();
            if (OCCodeInsightUtil.hasSideEffects(condition)) {
                return;
            }
            OCCallable callable = this.getTopmostCallable(loop);
            if (callable == null) {
                return;
            }
            OCControlFlowGraph graph = this.getCFG(callable);
            this.processAllUsedSymbol(condition, (PairProcessor<OCSymbolDeclarator, OCElement>)((PairProcessor)(declarator, element) -> {
                Object symbol = declarator.getSymbol();
                if (symbol == null || !symbol.getKind().isLocal() || symbol instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isBlockModifiable()) {
                    declaratorUsed.set((Object)true);
                    return false;
                }
                usedSymbols.add((OCSymbolDeclarator)declarator);
                return true;
            }));
            if (((Boolean)declaratorUsed.get()).booleanValue() || usedSymbols.isEmpty()) {
                return;
            }
            for (OCSymbolDeclarator declarator2 : usedSymbols) {
                if (!this.declaratorIsUsed(declarator2, graph, body, increment)) continue;
                declaratorUsed.set((Object)true);
                break;
            }
            if (!((Boolean)declaratorUsed.get()).booleanValue()) {
                OCLoopDoesntUseConditionVariableInspection.this.registerProblem(this.myHolder, null, null, this.myHolder.isOnTheFly(), condition, this.getMessage(usedSymbols), "warn_variables_not_in_loop_body", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[0]);
            }
        }

        private void processAllUsedSymbol(@NotNull OCElement condition, final @NotNull PairProcessor<OCSymbolDeclarator, OCElement> processor2) {
            if (condition == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(2);
            }
            if (processor2 == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(3);
            }
            condition.accept(new OCRecursiveVisitor(){
                public boolean myStopped = false;

                @Override
                public void visitReferenceElement(OCReferenceElement element) {
                    this.checkReferences(element);
                    super.visitReferenceElement(element);
                }

                @Override
                public void visitQualifiedExpression(OCQualifiedExpression expression) {
                    this.checkReferences(expression);
                    super.visitQualifiedExpression(expression);
                }

                @Override
                public void visitSendMessageExpression(OCSendMessageExpression expression) {
                    this.checkReferences(expression);
                    super.visitSendMessageExpression(expression);
                }

                @Override
                public void visitExpression(OCExpression expression) {
                    this.checkReferences(expression);
                    super.visitExpression(expression);
                }

                private void checkReferences(OCElement element) {
                    PsiElement resolved;
                    PsiReference ref;
                    if (!(this.myStopped || (ref = element.getReference()) == null || !((resolved = ref.resolve()) instanceof OCSymbolDeclarator) || resolved instanceof OCDefineDirective || resolved instanceof OCMacroReferenceElementImpl || processor2.process((Object)((OCSymbolDeclarator)resolved), (Object)element))) {
                        this.myStopped = true;
                    }
                }
            });
        }

        private boolean declaratorIsUsed(@NotNull OCSymbolDeclarator declarator, @NotNull OCControlFlowGraph graph, @Nullable OCStatement body, @Nullable OCStatement increment) {
            Object symbol;
            if (declarator == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(4);
            }
            if (graph == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(5);
            }
            if ((symbol = declarator.getSymbol()) == null) {
                return true;
            }
            OCResolveContext resolveContext = OCResolveContext.forPsi(declarator);
            OCType declaratorType = symbol.getType().resolve(resolveContext);
            if (declaratorType.isVolatile() || declaratorType.isUnknown() || OCTypeUtils.isInstanceOfType(declaratorType, OCStructType.class, OCMagicType.class)) {
                return true;
            }
            MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = graph.getInstructions((OCSymbol)symbol);
            if (instructions == null) {
                return false;
            }
            for (OCInstruction instruction : instructions.values()) {
                switch (instruction.getKind()) {
                    case REFERENCE: {
                        return true;
                    }
                    case WRITE_IN_BLOCK: {
                        return true;
                    }
                    case WRITE: {
                        if (!this.inLoopScope(body, increment, instruction.getLValue())) break;
                        return true;
                    }
                    case READ_IN_BLOCK: {
                        if (!OCTypeUtils.isInstanceOfType(declaratorType, OCPointerType.class)) break;
                        return true;
                    }
                    case READ: {
                        if (!OCTypeUtils.isInstanceOfType(declaratorType, OCPointerType.class) || !this.inLoopScope(body, increment, instruction.getRValue())) break;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean inLoopScope(@Nullable OCStatement body, @Nullable OCStatement increment, @Nullable PsiElement element) {
            if (element == null) {
                return false;
            }
            return PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)increment, (PsiElement)element, (boolean)false);
        }

        @NotNull
        private OCControlFlowGraph getCFG(@NotNull OCCallable callable) {
            if (callable == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(6);
            }
            if (this.myGraphs.containsKey((Object)callable)) {
                OCControlFlowGraph oCControlFlowGraph = (OCControlFlowGraph)this.myGraphs.get((Object)callable);
                if (oCControlFlowGraph == null) {
                    ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(7);
                }
                return oCControlFlowGraph;
            }
            OCControlFlowGraph graph = OCControlFlowUtil.buildControlFlowGraph(callable);
            this.myGraphs.put((Object)callable, (Object)graph);
            OCControlFlowGraph oCControlFlowGraph = graph;
            if (oCControlFlowGraph == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(8);
            }
            return oCControlFlowGraph;
        }

        @Nullable
        private OCCallable getTopmostCallable(@NotNull PsiElement element) {
            if (element == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(9);
            }
            OCCallable callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
            while (callable instanceof OCLambdaExpression) {
                callable = (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)callable, OCCallable.class);
            }
            return callable;
        }

        @NotNull
        private String getMessage(@NotNull Collection<OCSymbolDeclarator> declarators) {
            if (declarators == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(10);
            }
            List declaratorNames = declarators.stream().map(declarator -> declarator.getSymbol()).filter(symbol -> symbol != null).map(symbol -> symbol.getName()).sorted().collect(Collectors.toList());
            StringJoiner declaratorNamesJoiner = new StringJoiner(", ");
            if (declaratorNames.size() == declarators.size()) {
                for (String declaratorName : declaratorNames) {
                    declaratorNamesJoiner.add("'" + declaratorName + "'");
                }
            }
            String string = StringUtil.pluralize((String)"Variable", (int)declarators.size()) + " " + declaratorNamesJoiner.toString() + " used in loop condition " + (declarators.size() == 1 ? "is" : "are") + " not updated in the loop";
            if (string == null) {
                ForLoopThatDoesntUseLoopVariableVisitor.$$$reportNull$$$0(11);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loop";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declarator";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "graph";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCLoopDoesntUseConditionVariableInspection$ForLoopThatDoesntUseLoopVariableVisitor";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declarators";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCLoopDoesntUseConditionVariableInspection$ForLoopThatDoesntUseLoopVariableVisitor";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCFG";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitForStatement";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "processLoop";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processAllUsedSymbol";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "declaratorIsUsed";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getCFG";
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "getTopmostCallable";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getMessage";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

