/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressClangDiagnosticIntentionAction;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotLocalizedStringInspection
extends OCInspections.GeneralObjC {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non-localized string" == null) {
            OCNotLocalizedStringInspection.$$$reportNull$$$0(0);
        }
        return "Non-localized string";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            OCNotLocalizedStringInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                OCNotLocalizedStringInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        OCVisitor oCVisitor = new OCVisitor(){

            @Override
            public void visitLiteralExpression(OCLiteralExpression expression) {
                String literalText;
                OCMacroCall macroCall;
                if (!(!expression.getUnescapedLiteralText().equals("NLS") || expression.getReferences().length != 0 || OCElementUtil.isPartOfMacroSubstitution(expression) || !expression.getResolvedType().isPointerToStringCompatible() || (macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)expression, OCMacroCall.class)) != null && macroCall.getMacroReferenceElement() != null && macroCall.getMacroReferenceElement().getName().startsWith("NSLocalizedString") || (literalText = expression.getUnescapedLiteralText()).isEmpty())) {
                    OCNotLocalizedStringInspection.this.registerProblem(holder, null, null, true, expression, "Non-localized string: " + expression.getRawLiteralText(), "CIDR", ProblemHighlightType.INFORMATION, new IntentionAction[0]);
                }
            }
        };
        if (oCVisitor == null) {
            OCNotLocalizedStringInspection.$$$reportNull$$$0(3);
        }
        return oCVisitor;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element) {
        if (element == null) {
            OCNotLocalizedStringInspection.$$$reportNull$$$0(4);
        }
        return false;
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        OCSuppressionGroup suppressionGroup = new OCSuppressionGroup("ide", ((Object)((Object)this)).getClass().getSimpleName());
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new OCSuppressClangDiagnosticIntentionAction.SuppressFixForStatement(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForCallable(suppressionGroup), new OCSuppressClangDiagnosticIntentionAction.SuppressFixForFile(suppressionGroup)};
        if (suppressQuickFixArray == null) {
            OCNotLocalizedStringInspection.$$$reportNull$$$0(5);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCNotLocalizedStringInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCNotLocalizedStringInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBatchSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

