/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.ui.CheckBox;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.OCNullAnnotatorSink;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.dfa.OCNotReleasedVariablesChecker;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentSelector;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCReleaseVariablesIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNotReleasedIvarInspection
extends OCInspections.GeneralObjC {
    private static Key<IvarsInfo> IVARS_INFO_KEY = Key.create((String)"IVARS_INFO_KEY");
    public boolean releaseInDealloc = true;

    public JComponent createOptionsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        CheckBox checkBox = new CheckBox("Release should be in dealloc or any of its callees", (InspectionProfileEntry)this, "releaseInDealloc");
        panel.add((Component)checkBox);
        return panel;
    }

    public void inspectionStarted(@NotNull LocalInspectionToolSession session, boolean isOnTheFly) {
        if (session == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(0);
        }
        if (!OCCompilerFeatures.isArcDisabled(session.getFile())) {
            return;
        }
        IvarsInfo ivarsInfo = new IvarsInfo();
        session.putUserData(IVARS_INFO_KEY, (Object)ivarsInfo);
        session.getFile().accept((PsiElementVisitor)new InitialVisitor(ivarsInfo));
    }

    public static IvarsInfo startInspection(@NotNull PsiFile file) {
        if (file == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(1);
        }
        OCNotReleasedIvarInspection inspection = new OCNotReleasedIvarInspection();
        LocalInspectionToolSession session = new LocalInspectionToolSession(file, 0, file.getTextLength());
        inspection.inspectionStarted(session, true);
        return (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(3);
        }
        final IvarsInfo ivarsInfo = (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerFeatures.isArcDisabled(holder.getFile()) || ivarsInfo == null) {
            OCVisitor oCVisitor = new OCVisitor();
            if (oCVisitor == null) {
                OCNotReleasedIvarInspection.$$$reportNull$$$0(4);
            }
            return oCVisitor;
        }
        final OCRecursiveVisitor visitor = new OCRecursiveVisitor(){
            private OCMethodSymbol curMethod;

            @Override
            public void visitSendMessageExpression(OCSendMessageExpression expression) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression());
                if ("retain".equals(expression.getMessageSelector()) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression, this.curMethod, holder.getFile(), ivarsInfo) && !(expression.getParent() instanceof OCAssignmentExpression)) {
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitAssignmentExpression(OCAssignmentExpression expression) {
                OCInstanceVariableSymbol symbol = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression());
                OCExpression sourceExpression = expression.getSourceExpression();
                if (OCElementUtil.isRetainCall(sourceExpression, true) && symbol != null && !OCNotReleasedIvarInspection.isIvarReleased(symbol, expression, this.curMethod, holder.getFile(), ivarsInfo)) {
                    if (sourceExpression instanceof OCSendMessageExpression) {
                        OCSendMessageExpression call = (OCSendMessageExpression)sourceExpression;
                        OCInstanceVariableSymbol receiver = OCNotReleasedIvarInspection.getReceiverIvar(call.getReceiverExpression());
                        if ("retain".equals(call.getMessageSelector()) && receiver != null && OCNotReleasedIvarInspection.isIvarReleased(receiver, call, this.curMethod, holder.getFile(), ivarsInfo)) {
                            return;
                        }
                    }
                    OCNotReleasedIvarInspection.this.reportWarning(symbol, expression.getReceiverExpression(), holder);
                }
            }

            @Override
            public void visitSynthesizeProperty(OCSynthesizeProperty statement2) {
                OCInstanceVariableSymbol ivar;
                OCReferenceElement propertyRef = statement2.getPropertyRef();
                OCReferenceElement ivarRef = statement2.getInstanceVariableRef();
                if (propertyRef == null) {
                    return;
                }
                OCPropertySymbol property = (OCPropertySymbol)propertyRef.resolveToSymbol();
                Project project2 = statement2.getProject();
                if (property != null && !property.isRetained()) {
                    property = property.getAssociatedPropertyInPrivateCategory(project2);
                }
                OCInstanceVariableSymbol oCInstanceVariableSymbol = ivar = property != null ? property.getAssociatedIvar(project2) : null;
                if (ivar == null) {
                    OCSynthesizeSymbol synthesizeSymbol = (OCSynthesizeSymbol)statement2.getSymbol();
                    OCInstanceVariableSymbol oCInstanceVariableSymbol2 = ivar = synthesizeSymbol != null ? synthesizeSymbol.getIvarSymbol(project2) : null;
                }
                if (property != null && ivar != null && property.isRetained() && !OCNotReleasedIvarInspection.isIvarReleased(ivar, holder.getFile(), ivarsInfo)) {
                    OCNotReleasedIvarInspection.this.reportWarning(ivar, ivarRef != null ? ivarRef : propertyRef, holder);
                }
            }

            @Override
            public void visitMethod(OCMethod method) {
                this.curMethod = (OCMethodSymbol)method.getSymbol();
                super.visitMethod(method);
                this.curMethod = null;
            }
        };
        final Ref isProcessed = Ref.create((Object)false);
        OCVisitor oCVisitor = new OCVisitor(){

            public void visitElement(PsiElement element) {
                if (!((Boolean)isProcessed.get()).booleanValue()) {
                    element.getContainingFile().accept((PsiElementVisitor)visitor);
                    isProcessed.set((Object)true);
                }
            }
        };
        if (oCVisitor == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(5);
        }
        return oCVisitor;
    }

    public void reportWarning(OCInstanceVariableSymbol ivar, PsiElement element, ProblemsHolder holder) {
        String message = ivar.getNameWithKindUppercase(OCCompilationContext.create((PsiElement)holder.getFile())) + " is not released in 'dealloc' method";
        IntentionWrapper fix = new IntentionWrapper((IntentionAction)new OCReleaseVariablesIntentionAction(Collections.singletonList(ivar), holder.getProject()), holder.getFile());
        this.registerProblem(holder, null, null, holder.isOnTheFly(), element, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new IntentionAction[]{fix});
    }

    public static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @NotNull PsiFile file, @NotNull IvarsInfo ivarsInfo) {
        if (file == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(6);
        }
        if (ivarsInfo == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(7);
        }
        return OCNotReleasedIvarInspection.isIvarReleased(ivar, null, null, file, ivarsInfo);
    }

    private static boolean isIvarReleased(OCInstanceVariableSymbol ivar, @Nullable PsiElement element, @Nullable OCMethodSymbol outerMethod, @NotNull PsiFile file, @NotNull IvarsInfo ivarsInfo) {
        if (file == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(8);
        }
        if (ivarsInfo == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(9);
        }
        if (!ivar.getType().resolve((PsiElement)file).isPointerToObjectCompatible() || ivarsInfo.myReleasedIvars.contains(ivar)) {
            return true;
        }
        Map map2 = (Map)ivarsInfo.myLocalReleases.get(ivar);
        if (outerMethod != null && element != null && map2 != null) {
            PsiElement localRelease = (PsiElement)map2.get(outerMethod);
            return localRelease != null && element.getTextOffset() < localRelease.getTextOffset();
        }
        return false;
    }

    public void inspectionFinished(@NotNull LocalInspectionToolSession session, @NotNull ProblemsHolder holder) {
        if (session == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            OCNotReleasedIvarInspection.$$$reportNull$$$0(11);
        }
        IvarsInfo ivarsInfo = (IvarsInfo)session.getUserData(IVARS_INFO_KEY);
        if (!OCCompilerFeatures.isArcDisabled(session.getFile()) || ivarsInfo == null) {
            return;
        }
        for (Pair pair2 : ivarsInfo.myLocalRetainedIvars) {
            if (OCNotReleasedIvarInspection.isIvarReleased((OCInstanceVariableSymbol)pair2.getFirst(), holder.getFile(), ivarsInfo)) continue;
            this.reportWarning((OCInstanceVariableSymbol)pair2.getFirst(), (PsiElement)pair2.getSecond(), holder);
        }
        for (OCMethodSymbol method : ivarsInfo.myDeallocs.keySet()) {
            PsiFile file;
            PsiElement closingBrace = (PsiElement)ivarsInfo.myDeallocs.get(method);
            if (closingBrace == null || !(file = closingBrace.getContainingFile()).equals(holder.getFile())) continue;
            String message = method.getNameWithKindUppercase(OCCompilationContext.create((PsiElement)file)) + " misses the call to [super dealloc] at the last statement";
            OCChangeTextIntentionAction fix = new OCChangeTextIntentionAction(file, closingBrace.getTextOffset(), 0, "[super dealloc];\n", "Add call to [super dealloc]");
            this.registerProblem(holder, null, null, holder.isOnTheFly(), closingBrace, message, "CIDR", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
        }
    }

    @Nullable
    public static OCSendMessageExpression getCallToSuper(OCStatement stmt) {
        if (!(stmt instanceof OCExpressionStatement)) {
            return null;
        }
        OCExpression expression = ((OCExpressionStatement)stmt).getExpression();
        if (!(expression instanceof OCSendMessageExpression)) {
            return null;
        }
        OCSendMessageExpression call = (OCSendMessageExpression)expression;
        OCExpression receiver = call.getReceiverExpression();
        return call.getMessageSelector().equals("dealloc") && receiver instanceof OCReferenceExpression && ((OCReferenceExpression)receiver).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SUPER ? call : null;
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver) {
        return OCNotReleasedIvarInspection.getReceiverIvar(receiver, true);
    }

    @Nullable
    public static OCInstanceVariableSymbol getReceiverIvar(@Nullable OCExpression receiver, boolean onlySelf) {
        if (receiver == null) {
            return null;
        }
        OCSymbol symbol = OCNotReleasedIvarInspection.getReceiverSymbol(receiver, onlySelf);
        if (symbol instanceof OCInstanceVariableSymbol) {
            return (OCInstanceVariableSymbol)symbol;
        }
        if (symbol instanceof OCPropertySymbol && !((OCPropertySymbol)symbol).isRetained()) {
            return ((OCPropertySymbol)symbol).getAssociatedIvar(receiver.getProject());
        }
        return null;
    }

    @Nullable
    public static OCSymbol getReceiverSymbol(@Nullable OCExpression receiver, boolean onlySelf) {
        OCSymbol symbol = null;
        if (receiver instanceof OCReferenceExpression) {
            symbol = ((OCReferenceExpression)receiver).resolveToSymbol();
        } else if (receiver instanceof OCQualifiedExpression) {
            OCExpression qualifier = ((OCQualifiedExpression)receiver).getQualifier();
            if (!onlySelf || qualifier instanceof OCReferenceExpression && ((OCReferenceExpression)qualifier).getSelfSuperToken() == OCElementTypes.SelfSuperToken.SELF) {
                symbol = ((OCQualifiedExpression)receiver).resolveToSymbol();
            }
        }
        return symbol;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ivarsInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "inspectionStarted";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isIvarReleased";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "inspectionFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class InitialVisitor
    extends OCRecursiveVisitor {
        private IvarsInfo myIvarsInfo;
        private OCMethodSymbol curMethod;

        public InitialVisitor(IvarsInfo ivarsInfo) {
            if (ivarsInfo == null) {
                InitialVisitor.$$$reportNull$$$0(0);
            }
            this.myIvarsInfo = ivarsInfo;
        }

        public void visitFile(PsiFile file) {
            for (PsiElement element : file.getChildren()) {
                if (!(element instanceof OCImplementation)) continue;
                this.myIvarsInfo.myTraversedCallables.clear();
                this.visitImplementation((OCImplementation)element);
            }
        }

        @Override
        public void visitImplementation(OCImplementation implementation) {
            OCImplementationSymbol originalClass;
            super.visitImplementation(implementation);
            VirtualFile virtualFile = implementation.getContainingFile().getVirtualFile();
            if (virtualFile == null) {
                return;
            }
            OCObjectType type = implementation.getType();
            OCImplementationSymbol oCImplementationSymbol = originalClass = type != null ? type.getImplementation() : null;
            while (type != null) {
                OCImplementationSymbol symbol = type.getImplementation();
                Project project2 = implementation.getProject();
                if (symbol == null) {
                    OCInterfaceSymbol anInterface = type.getInterface();
                    OCImplementationSymbol oCImplementationSymbol2 = symbol = anInterface != null ? anInterface.getImplementation(project2) : null;
                    if (symbol == null) break;
                }
                Processor processor2 = symbol1 -> {
                    Object method = symbol1.locateDefinition(project2);
                    if (method instanceof OCMethod) {
                        OCBlockStatement body;
                        boolean isDealloc = "dealloc".equals(symbol1.getName());
                        if (!this.myIvarsInfo.myTraversedCallables.contains(symbol1)) {
                            this.myIvarsInfo.myTraversedCallables.add(symbol1);
                            method.accept((PsiElementVisitor)new CallableVisitor(virtualFile, (OCClassSymbol)symbol1.getParent(), originalClass, isDealloc, this.myIvarsInfo));
                        }
                        if (isDealloc && (body = ((OCMethod)method).getBody()) != null) {
                            PsiElement element;
                            int statementsCnt = body.getStatements().size();
                            PsiElement psiElement = element = statementsCnt > 0 ? OCNotReleasedIvarInspection.getCallToSuper(body.getStatements().get(statementsCnt - 1)) : null;
                            if (element == null) {
                                element = body.getClosingBrace();
                                this.myIvarsInfo.myDeallocs.put(symbol1, element);
                            } else {
                                this.myIvarsInfo.myDeallocs.put(symbol1, null);
                            }
                        }
                    }
                    return true;
                };
                if (OCNotReleasedIvarInspection.this.releaseInDealloc) {
                    symbol.processMembers("dealloc", OCMethodSymbol.class, processor2);
                    OCResolveContext context = OCResolveContext.forPsi(implementation);
                    OCType appDelegate = OCReferenceType.resolvedFromText("NSObject", "UIApplicationDelegate", context);
                    OCType senTest = OCReferenceType.resolvedFromText("SenTest", context);
                    OCType managedObject = OCReferenceType.resolvedFromText("NSManagedObject", context);
                    if (appDelegate instanceof OCObjectType && appDelegate.isCompatible(type, context)) {
                        symbol.processMembers("applicationWillTerminate:", OCMethodSymbol.class, processor2);
                    }
                    if (managedObject instanceof OCObjectType && managedObject.isCompatible(type, context)) {
                        symbol.processMembers("didTurnIntoFault", OCMethodSymbol.class, processor2);
                    }
                    if (senTest instanceof OCObjectType && senTest.isCompatible(type, context)) {
                        symbol.processMembers("tearDown", OCMethodSymbol.class, processor2);
                    }
                } else {
                    symbol.processMembers(null, OCMethodSymbol.class, processor2);
                }
                type = type.getSuperType();
            }
        }

        @Override
        public void visitMethod(OCMethod method) {
            this.curMethod = (OCMethodSymbol)method.getSymbol();
            super.visitMethod(method);
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(method, OCNullAnnotatorSink.INSTANCE, null);
            analyzer.buildControlFlowGraph();
            for (OCSymbol symbol : analyzer.getGraph().getLocalSymbols()) {
                if (symbol.isUnnamed()) continue;
                analyzer.analyzeNotReleased(symbol, new OCNotReleasedVariablesChecker(analyzer.getGraph(), symbol){

                    @Override
                    protected void handleAssignedIvar(@NotNull Pair<OCInstanceVariableSymbol, PsiElement> pair2) {
                        if (pair2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        InitialVisitor.this.myIvarsInfo.myLocalRetainedIvars.add(pair2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pair", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$InitialVisitor$1", "handleAssignedIvar"));
                    }
                }, false);
            }
            this.curMethod = null;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression) {
            OCInstanceVariableSymbol ivar;
            super.visitSendMessageExpression(expression);
            if (this.curMethod != null && OCElementUtil.isReleaseCall(expression) && (ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression(), false)) != null) {
                HashMap<OCMethodSymbol, OCArgumentSelector> map2 = (HashMap<OCMethodSymbol, OCArgumentSelector>)this.myIvarsInfo.myLocalReleases.get(ivar);
                if (map2 == null) {
                    map2 = new HashMap<OCMethodSymbol, OCArgumentSelector>();
                    this.myIvarsInfo.myLocalReleases.put(ivar, map2);
                }
                map2.put(this.curMethod, expression.getArgumentSelectors().get(0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$InitialVisitor", "<init>"));
        }
    }

    private static class CallableVisitor
    extends OCRecursiveVisitor {
        private VirtualFile myContainingFile;
        private boolean isDealloc;
        private OCClassSymbol myClass;
        private IvarsInfo myIvarsInfo;
        private OCClassSymbol myOriginalClass;

        private CallableVisitor(VirtualFile containingFile, OCClassSymbol clazz, OCClassSymbol originalClass, boolean isDealloc, @NotNull IvarsInfo ivarsInfo) {
            if (ivarsInfo == null) {
                CallableVisitor.$$$reportNull$$$0(0);
            }
            this.myContainingFile = containingFile;
            this.myOriginalClass = originalClass;
            this.isDealloc = isDealloc;
            this.myClass = clazz;
            this.myIvarsInfo = ivarsInfo;
        }

        @Override
        public void visitSendMessageExpression(OCSendMessageExpression expression) {
            super.visitSendMessageExpression(expression);
            if (OCElementUtil.isReleaseCall(expression)) {
                OCInstanceVariableSymbol ivar = OCNotReleasedIvarInspection.getReceiverIvar(expression.getReceiverExpression(), false);
                if (ivar != null) {
                    this.myIvarsInfo.myReleasedIvars.add(ivar);
                }
                return;
            }
            for (OCMethodSymbol method : expression.getProbableResponders().getFilteredByStaticnessResponders()) {
                OCPropertySymbol property = method.getGeneratedFromProperty();
                if (property != null) {
                    if (!method.isSetter(OCResolveContext.forPsi(expression))) continue;
                    this.processSetter(property, expression.getProject());
                    continue;
                }
                this.processCallable(method, expression.getProject());
            }
        }

        @Override
        public void visitQualifiedExpression(OCQualifiedExpression expression) {
            OCClassSymbol symbolParent;
            super.visitQualifiedExpression(expression);
            PsiElement parent = expression.getParent();
            OCSymbol symbol = expression.resolveToSymbol();
            if (symbol instanceof OCMemberSymbol && (symbolParent = (OCClassSymbol)((OCMemberSymbol)symbol).getParent()) != null && Comparing.equal((String)symbolParent.getName(), (String)this.myClass.getName())) {
                if (this.isDealloc && symbol instanceof OCInstanceVariableSymbol) {
                    this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)symbol);
                } else if (symbol instanceof OCPropertySymbol && parent instanceof OCAssignmentExpression && ((OCAssignmentExpression)parent).getReceiverExpression() == expression) {
                    this.processSetter((OCPropertySymbol)symbol, expression.getProject());
                } else if (symbol instanceof OCMethodSymbol) {
                    this.processCallable(symbol, expression.getProject());
                }
            }
        }

        @Override
        public void visitReferenceElement(OCReferenceElement referenceElement) {
            OCSymbol ivar;
            super.visitReferenceElement(referenceElement);
            if (this.isDealloc && (ivar = referenceElement.resolveToSymbol()) instanceof OCInstanceVariableSymbol) {
                this.myIvarsInfo.myReleasedIvars.add((OCInstanceVariableSymbol)ivar);
            }
        }

        @Override
        public void visitCallExpression(OCCallExpression expression) {
            super.visitCallExpression(expression);
            OCExpression function = expression.getFunctionReferenceExpression();
            OCGetSymbolVisitor visitor = new OCGetSymbolVisitor();
            function.accept(visitor);
            OCSymbol functionSymbol = visitor.getSymbol();
            if (functionSymbol instanceof OCFunctionSymbol) {
                this.processCallable(functionSymbol, expression.getProject());
            }
        }

        private void processSetter(OCPropertySymbol property, Project project2) {
            OCInstanceVariableSymbol ivar;
            OCResolveContext context = OCResolveContext.forSymbol(property, project2);
            if (property.processAccessorMethods((Processor<? super OCMethodSymbol>)((Processor)method -> {
                if (method.isSetter(context)) {
                    this.processCallable((OCSymbol)method, project2);
                    return false;
                }
                return true;
            }), false, project2) && property.isRetained() && (ivar = property.getAssociatedIvar(project2)) != null) {
                this.myIvarsInfo.myReleasedIvars.add(ivar);
            }
        }

        private void processCallable(OCSymbol callable, Project project2) {
            OCSymbol targetCallable = callable;
            if (!targetCallable.isDefinition()) {
                targetCallable = targetCallable.getAssociatedSymbol(project2);
            }
            if (callable instanceof OCMethodSymbol) {
                OCClassSymbol callableParent = (OCClassSymbol)((OCMethodSymbol)callable).getParent();
                if (this.myOriginalClass != null && (targetCallable == null || !Comparing.equal((String)callableParent.getName(), (String)this.myOriginalClass.getName())) && this.myOriginalClass.isSubclass(callableParent, project2)) {
                    CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
                    this.myOriginalClass.processMembers(callable.getName(), OCMethodSymbol.class, finder);
                    targetCallable = (OCSymbol)finder.getFoundValue();
                }
            }
            if (targetCallable != null && !this.myIvarsInfo.myTraversedCallables.contains(targetCallable) && this.myContainingFile.equals(targetCallable.getContainingFile())) {
                this.myIvarsInfo.myTraversedCallables.add(targetCallable);
                Object definition = targetCallable.locateDefinition(project2);
                if (definition instanceof OCDeclarator) {
                    definition = definition.getParent();
                }
                if (definition instanceof OCCallable) {
                    boolean curDealloc = this.isDealloc;
                    this.isDealloc = false;
                    definition.accept((PsiElementVisitor)this);
                    this.isDealloc = curDealloc;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ivarsInfo", "com/jetbrains/cidr/lang/inspections/OCNotReleasedIvarInspection$CallableVisitor", "<init>"));
        }
    }

    public static class IvarsInfo {
        private Set<OCInstanceVariableSymbol> myReleasedIvars = new HashSet<OCInstanceVariableSymbol>();
        private Map<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>> myLocalReleases = new HashMap<OCInstanceVariableSymbol, Map<OCMethodSymbol, PsiElement>>();
        private Set<OCSymbol> myTraversedCallables = new HashSet<OCSymbol>();
        private Map<OCMethodSymbol, PsiElement> myDeallocs = new HashMap<OCMethodSymbol, PsiElement>();
        private List<Pair<OCInstanceVariableSymbol, PsiElement>> myLocalRetainedIvars = new ArrayList<Pair<OCInstanceVariableSymbol, PsiElement>>();
    }
}

