/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ExecutorsQuery;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.inspections.OCGlobalSearchScopeForUnusedCode;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.psi.OCClassDeclarationBase;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDefineDirective;
import com.jetbrains.cidr.lang.psi.OCExternalReference;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSuppressGCCAttributeFix;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.refactoring.OCSafeDeleteProcessorDelegate;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.OCPropertyReferencesSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCUnusedCodeInspection
extends OCInspection.Cpp {
    @Nullable
    public UnusedVisitor buildVisitor() {
        return null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        UnusedVisitor visitor;
        if (holder == null) {
            OCUnusedCodeInspection.$$$reportNull$$$0(0);
        }
        if (isOnTheFly && (visitor = this.buildVisitor()) != null) {
            visitor.setHolder(holder);
            visitor.setOnTheFly(isOnTheFly);
            UnusedVisitor unusedVisitor = visitor;
            if (unusedVisitor == null) {
                OCUnusedCodeInspection.$$$reportNull$$$0(1);
            }
            return unusedVisitor;
        }
        OCVisitor oCVisitor = new OCVisitor();
        if (oCVisitor == null) {
            OCUnusedCodeInspection.$$$reportNull$$$0(2);
        }
        return oCVisitor;
    }

    public static boolean isWritableSymbol(OCSymbol symbol) {
        return symbol instanceof OCDeclaratorSymbol || symbol instanceof OCPropertySymbol || symbol instanceof OCInstanceVariableSymbol;
    }

    @Override
    public String getMainToolId() {
        String toolId = super.getMainToolId();
        return toolId != null ? toolId : new OCGlobalUnusedInspection().getShortName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/inspections/OCUnusedCodeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/inspections/OCUnusedCodeInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class UnusedVisitor
    extends OCVisitor {
        private OCSymbol mySymbol;
        protected boolean myOnTheFly;
        protected boolean myHasWrites;
        @Nullable
        private ProblemsHolder myHolder;
        @Nullable
        private ProblemDescriptionsProcessor myProcessor;
        @Nullable
        private GlobalInspectionContext myGlobalContext;
        @Nullable
        protected SearchScope myScope;

        public void setUpForBatchMode(ProblemDescriptionsProcessor processor2, GlobalInspectionContext globalContext, SearchScope scope) {
            this.myProcessor = processor2;
            this.myGlobalContext = globalContext;
            this.myScope = scope;
            this.myOnTheFly = false;
        }

        public void checkFromBatchMode(@NotNull OCSymbol symbol, @NotNull PsiElement declarator, boolean hasWrites) {
            if (symbol == null) {
                UnusedVisitor.$$$reportNull$$$0(0);
            }
            if (declarator == null) {
                UnusedVisitor.$$$reportNull$$$0(1);
            }
            this.mySymbol = symbol;
            this.myHasWrites = hasWrites;
            declarator.accept((PsiElementVisitor)this);
        }

        public void setHolder(@Nullable ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void setOnTheFly(boolean onTheFly) {
            this.myOnTheFly = onTheFly;
        }

        @Nullable
        protected OCSymbol getSymbol(OCSymbolDeclarator declarator) {
            return this.mySymbol != null ? this.mySymbol : declarator.getSymbol();
        }

        protected void registerProblem(@Nullable PsiElement element, String message, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
            OCUnusedCodeInspection.this.registerProblem(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, element, message, "CIDR", highlightType, quickFixes);
        }

        protected void registerProblems(@Nullable List<PsiElement> elements, String message, ProblemHighlightType highlightType, IntentionAction ... quickFixes) {
            OCUnusedCodeInspection.this.registerProblems(this.myHolder, this.myProcessor, this.myGlobalContext, this.myOnTheFly, elements, message, "CIDR", highlightType, quickFixes);
        }

        protected void checkSymbolUsed(PsiElement element, OCSymbol symbol) {
            this.checkSymbolUsed(element, element, symbol, false);
        }

        protected void checkSymbolUsed(PsiElement element, OCSymbol symbol, boolean hasWrites) {
            this.checkSymbolUsed(element, element, symbol, hasWrites);
        }

        protected void checkSymbolUsed(PsiElement element, PsiElement navigationElement, OCSymbol symbol, boolean hasWrites) {
            if (element == null || navigationElement == null) {
                return;
            }
            Project project2 = element.getProject();
            OCFile.UnusedChecksMode checksMode = (OCFile.UnusedChecksMode)((Object)project2.getUserData(OCFile.UNUSED_CHECKS));
            if (symbol == null || checksMode == OCFile.UnusedChecksMode.DISABLED || symbol.hasAttribute("unused") || symbol.hasAttribute("used")) {
                return;
            }
            if (!OCSearchScope.isInProjectSources(symbol, project2)) {
                return;
            }
            for (ImplicitUsageProvider usageProvider : (ImplicitUsageProvider[])Extensions.getExtensions((ExtensionPointName)ImplicitUsageProvider.EP_NAME)) {
                if (usageProvider.isImplicitUsage(element) || usageProvider.isImplicitRead(element)) {
                    return;
                }
                hasWrites |= usageProvider.isImplicitWrite(element);
            }
            PsiFile containingFile = element.getContainingFile();
            SearchScope scope = this.myScope;
            if (scope == null) {
                scope = checksMode == OCFile.UnusedChecksMode.IN_LOCAL_FILE ? new LocalSearchScope((PsiElement)containingFile) : new OCGlobalSearchScopeForUnusedCode(OCSearchScope.getProjectSourcesScope(project2));
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            String subject = symbol.getNameWithKindUppercase(OCCompilationContext.create(element));
            OCRemoveElementsIntentionAction quickFix = new OCSafeDeleteIntentionAction((PsiElement)element, StringUtil.decapitalize((String)subject));
            boolean isAccessorMethod = false;
            if (symbol.getKind() == OCSymbolKind.INSTANCE_VARIABLE) {
                scope = this.getIvarScope((OCInstanceVariableSymbol)symbol, scope, project2);
            } else if (symbol.getKind() == OCSymbolKind.PROPERTY) {
                final PsiElement accessor = element;
                finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                    protected boolean accept(PsiReference reference) {
                        PsiElement element = reference.getElement();
                        if (element != null && element.getParent() instanceof OCSynthesizeProperty) {
                            return false;
                        }
                        if (reference instanceof OCExternalReference) {
                            return true;
                        }
                        return !(accessor instanceof OCMethod) || reference.isReferenceTo(accessor);
                    }
                };
                if (element instanceof OCMethod) {
                    subject = (OCNameSuggester.isObjCSetter(((OCMethod)element).getSelector()) ? "Setter" : "Getter") + " method for " + symbol.getNameWithKindLowercase(OCCompilationContext.create(element));
                    quickFix = new OCRemoveElementsIntentionAction((PsiElement)element, "Delete " + StringUtil.decapitalize((String)subject), "Delete method");
                    element = symbol.locateDefinition(project2);
                    isAccessorMethod = true;
                    if (element == null) {
                        return;
                    }
                }
            } else {
                if ((symbol instanceof OCClassSymbol || symbol instanceof OCStructSymbol) && OCTestFrameworks.isTestClassOrStruct(symbol, navigationElement, project2)) {
                    return;
                }
                if (symbol.getKind().isStructOrUnion()) {
                    final PsiElement struct = element;
                    finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                        protected boolean accept(PsiReference reference) {
                            return !OCSafeDeleteProcessorDelegate.isSafeToDelete(reference.getElement(), struct);
                        }
                    };
                    if (element.getParent().getParent() instanceof OCDeclaration && ((OCDeclaration)element.getParent().getParent()).isTypedef()) {
                        return;
                    }
                } else {
                    if (symbol.getKind() == OCSymbolKind.ENUM) {
                        return;
                    }
                    if (symbol.getKind() == OCSymbolKind.TYPEDEF && symbol.getType() instanceof OCStructType && ((OCStructType)symbol.getType()).getKind() == OCSymbolKind.ENUM) {
                        return;
                    }
                }
            }
            if (scope instanceof GlobalSearchScope && PsiSearchHelper.SERVICE.getInstance((Project)project2).isCheapEnoughToSearch(symbol.getName(), (GlobalSearchScope)scope, containingFile, null) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                return;
            }
            Ref hasWritesRef = new Ref((Object)hasWrites);
            if (scope != null) {
                ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
                if (this.findReferences(symbol, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), (CommonProcessors.FindFirstProcessor<PsiReference>)finder, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
                if (symbol.getKind() == OCSymbolKind.PROPERTY && this.performAuxPropertySearches((OCPropertySymbol)symbol, scope, (CommonProcessors.FindFirstProcessor<PsiReference>)finder, searchParameters, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
                if (symbol.getKind().isStructOrUnion() && this.performAuxStructSearches((OCStructSymbol)symbol, scope, project2, (CommonProcessors.FindFirstProcessor<PsiReference>)finder, (Ref<Boolean>)hasWritesRef)) {
                    return;
                }
                CommonProcessors.FindFirstProcessor macroFinder = new CommonProcessors.FindFirstProcessor();
                ReferencesSearch.SearchParameters macroParameters = new ReferencesSearch.SearchParameters(element, (SearchScope)OCSearchScope.getProjectSourcesScope(project2), false);
                new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(macroParameters, (Processor<OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)macroFinder);
                if (macroFinder.isFound()) {
                    return;
                }
            }
            if (isAccessorMethod && ((Boolean)hasWritesRef.get()).booleanValue()) {
                return;
            }
            if (navigationElement instanceof PsiNameIdentifierOwner && !(navigationElement instanceof OCDefineDirective)) {
                navigationElement = ((PsiNameIdentifierOwner)navigationElement).getNameIdentifier();
            }
            if (navigationElement != null) {
                boolean canSuppress;
                String message = subject + ((Boolean)hasWritesRef.get() != false ? " is assigned but never accessed" : " is never used");
                ArrayList<OCSafeDeleteIntentionAction> fixes = new ArrayList<OCSafeDeleteIntentionAction>(Collections.singletonList(quickFix));
                boolean bl = canSuppress = !(symbol instanceof OCClassSymbol) && !(symbol instanceof OCPropertySymbol) && !(symbol instanceof OCMacroSymbol) && symbol.getKind() != OCSymbolKind.ENUM_CONST;
                if (canSuppress) {
                    fixes.add((OCSafeDeleteIntentionAction)((Object)new OCSuppressGCCAttributeFix(symbol, "unused", "__unused", true, OCCompilationContext.create(element))));
                }
                this.registerProblem(navigationElement, message, ProblemHighlightType.LIKE_UNUSED_SYMBOL, fixes.toArray(IntentionAction.EMPTY_ARRAY));
            }
        }

        private boolean findReferences(OCSymbol symbol, Query<PsiReference> search, CommonProcessors.FindFirstProcessor<PsiReference> finder, Ref<Boolean> hasWrites) {
            if (OCUnusedCodeInspection.isWritableSymbol(symbol)) {
                Condition isAccess = reference -> new OCReadWriteAccessDetector().getExpressionAccess(reference.getElement()) != ReadWriteAccessDetector.Access.Write;
                OCCommonProcessors.OrderedProcessor<PsiReference> processor2 = new OCCommonProcessors.OrderedProcessor<PsiReference>((Processor<PsiReference>)finder, (Condition<T>[])new Condition[]{isAccess, Conditions.alwaysTrue()});
                search.forEach(processor2);
                processor2.finish();
                if (finder.isFound()) {
                    if (isAccess.value(finder.getFoundValue())) {
                        return true;
                    }
                    hasWrites.set((Object)true);
                }
            } else {
                search.forEach(finder);
                if (finder.isFound()) {
                    return true;
                }
            }
            return false;
        }

        private boolean performAuxStructSearches(OCStructSymbol symbol, SearchScope scope, Project project2, CommonProcessors.FindFirstProcessor<PsiReference> finder, Ref<Boolean> hasWrites) {
            return !symbol.processConstructors((Processor<? super OCFunctionSymbol>)((Processor)constructor -> {
                OCFunctionDeclaration element = constructor.locateFunctionDefinition(project2);
                if (element != null) {
                    ReferencesSearch.SearchParameters searchParameters = new ReferencesSearch.SearchParameters((PsiElement)element, scope, false);
                    return !this.findReferences((OCSymbol)constructor, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), finder, hasWrites);
                }
                return true;
            }));
        }

        private boolean performAuxPropertySearches(OCPropertySymbol symbol, SearchScope scope, CommonProcessors.FindFirstProcessor<PsiReference> finder, ReferencesSearch.SearchParameters searchParameters, Ref<Boolean> hasWrites) {
            ExecutorsQuery query = new ExecutorsQuery((Object)searchParameters, Collections.singletonList(new OCPropertyReferencesSearch()));
            if (this.findReferences(symbol, (Query<PsiReference>)query, finder, hasWrites)) {
                return true;
            }
            Project project2 = searchParameters.getProject();
            OCInstanceVariableSymbol ivar = symbol.getAssociatedIvar(project2);
            if (ivar != null) {
                if (ivar.getGeneratedFromProperty() == null) {
                    return false;
                }
                if ((scope = this.getIvarScope(ivar, scope, project2)) == null) {
                    return false;
                }
                Object element = ivar.locateDefinition(project2);
                if (element == null) {
                    element = new OCSymbolHolderVirtualPsiElement(ivar, project2);
                }
                searchParameters = new ReferencesSearch.SearchParameters(element, scope, false);
                finder = new CommonProcessors.FindFirstProcessor<PsiReference>(){

                    protected boolean accept(PsiReference reference) {
                        return !(reference.getElement().getParent() instanceof OCSynthesizeProperty);
                    }
                };
                if (this.findReferences(ivar, (Query<PsiReference>)ReferencesSearch.search((ReferencesSearch.SearchParameters)searchParameters), finder, hasWrites)) {
                    return true;
                }
            }
            return false;
        }

        @Nullable
        private SearchScope getIvarScope(OCInstanceVariableSymbol symbol, SearchScope scope, Project project2) {
            if (symbol.getVisibility() == OCVisibility.PRIVATE) {
                OCClassDeclarationBase implementation;
                OCImplementationSymbol implementationSymbol = ((OCClassSymbol)symbol.getParent()).getImplementation(project2);
                OCClassDeclarationBase oCClassDeclarationBase = implementation = implementationSymbol != null ? (OCClassDeclarationBase)implementationSymbol.locateDefinition(project2) : null;
                if (implementation != null) {
                    if (this.myScope instanceof GlobalSearchScope && !((GlobalSearchScope)this.myScope).accept(implementationSymbol.getContainingFile())) {
                        return null;
                    }
                    return new LocalSearchScope((PsiElement)implementation);
                }
                return null;
            }
            return scope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "symbol";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "declarator";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/inspections/OCUnusedCodeInspection$UnusedVisitor";
            objectArray[2] = "checkFromBatchMode";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

